/*
 *  pqlist.c
 *
 *  List all print queues on a server
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <ncp/nwcalls.h>

#include <libintl.h>
#define _(X) gettext(X)

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	struct ncp_bindery_object q;
	int found = 0;

	char default_pattern[] = "*";
	char *pattern = default_pattern;
	char *p;
	long err;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("when initializing"));
		return 1;
	}
	if (argc > 2)
	{
		fprintf(stderr, _("usage: %s [options] [pattern]\n"), argv[0]);
		return 1;
	}
	if (argc == 2)
	{
		pattern = argv[1];
	}
	for (p = pattern; *p != '\0'; p++)
	{
		*p = toupper(*p);
	}

	if (isatty(1))
	{
		char server[NW_MAX_SERVER_NAME_LEN];
		NWCCODE err;

		err = NWCCGetConnInfo(conn, NWCC_INFO_SERVER_NAME,
			sizeof(server), server);
		if (err)
			printf(_("\nServer: Unknown (%s)\n"), strnwerror(err));
		else
			printf(_("\nServer: %s\n"), server);
		printf("%-52s%-10s\n"
		       "-----------------------------------------------"
		       "-------------\n",
		       _("Print queue name"),
		       _("Queue ID"));
	}
	q.object_id = 0xffffffff;

	while (ncp_scan_bindery_object(conn, q.object_id,
				       NCP_BINDERY_PQUEUE, pattern, &q) == 0)
	{
		found = 1;
		printf("%-52s", q.object_name);
		printf("%08X\n", (unsigned int) q.object_id);
	}

	if ((found == 0) && (isatty(1)))
	{
		printf(_("No queues found\n"));
	}
	ncp_close(conn);
	return 0;
}
