/*
 *  ncptest.c
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <ncp/ext/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <ncp/kernel/ipx.h>

#include <ncp/kernel/fs.h>
#include <ncp/kernel/ncp.h>
#include <ncp/kernel/ncp_fs.h>
#include <ncp/ncplib.h>

#include <libintl.h>
#define _(X) gettext(X)

void
test_connlist(struct ncp_conn *conn)
{
	u_int8_t conn_list[256] =
	{0,};
	int no;

	ncp_get_connlist(conn, NCP_BINDERY_USER, "SUPERVISOR", &no,
			 conn_list);
	return;
}

void
test_send(struct ncp_conn *conn)
{
	u_int8_t conn_list[256] =
	{0,};
	int no;

	if (ncp_get_connlist(conn, NCP_BINDERY_USER, "ME", &no,
			     conn_list) != 0)
	{
		no = 0;
	}
	if (no > 0)
	{
		ncp_send_broadcast(conn, no, conn_list, "Hallo");
	}
	return;
}
void
test_create(struct ncp_conn *conn)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	u_int8_t dir_handle;
	struct ncp_file_info new_file;

	if (ncp_do_lookup(conn, NULL, "SYS", &sys) != 0)
	{
		printf(_("lookup error\n"));
		return;
	}
	if (ncp_do_lookup(conn, &sys, "ME", &me) != 0)
	{
		printf(_("lookup public error\n"));
		return;
	}
	if (ncp_alloc_short_dir_handle(conn, &me, NCP_ALLOC_TEMPORARY,
				       &dir_handle) != 0)
	{
		printf(_("alloc_dir_handle error\n"));
		return;
	}
	if (ncp_create_file(conn, dir_handle, "BLUB.TXT", 0,
			    &new_file) != 0)
	{
		printf(_("create error\n"));
		return;
	}
	if (ncp_dealloc_dir_handle(conn, dir_handle) != 0)
	{
		printf(_("dealloc error\n"));
		return;
	}
}

int
test_change(struct ncp_conn *conn)
{
	long result;
	unsigned char ncp_key[8];
	struct ncp_bindery_object user;

	if ((result = ncp_get_encryption_key(conn, ncp_key)) != 0)
	{
		return result;
	}
	if ((result = ncp_get_bindery_object_id(conn, 1,
						"ME", &user)) != 0)
	{
		return result;
	}
	if ((result = ncp_change_login_passwd(conn, &user, ncp_key,
					      "MEE", "ME")) != 0)
	{
		return result;
	}
	return 0;
}

void
test_readdir(struct ncp_conn *conn)
{
	struct nw_info_struct sys;
	struct nw_info_struct blub;
	struct ncp_search_seq seq;
	struct nw_info_struct entry;

	if (ncp_do_lookup(conn, NULL, "SYS", &sys) != 0)
	{
		printf(_("lookup error\n"));
		return;
	}
	if (ncp_do_lookup(conn, &sys, "BLUB", &blub) != 0)
	{
		printf(_("lookup blub error\n"));
		return;
	}
	if (ncp_initialize_search(conn, &sys, 0, &seq) != 0)
	{
		printf(_("init error\n"));
		return;
	}
	while (ncp_search_for_file_or_subdir(conn, &seq, &entry) == 0)
	{
		struct nw_info_struct nfs;
		printf(_("found: %s\n"), entry.entryName);
		if (ncp_obtain_file_or_subdir_info(conn, NW_NS_DOS, NW_NS_NFS,
						   0x8006, RIM_ALL,
						   entry.volNumber,
						   entry.DosDirNum,
						   NULL,
						   &nfs) == 0)
		{
			printf(_("nfs name: %s\n"), nfs.entryName);
		}
		if (ncp_obtain_file_or_subdir_info(conn, NW_NS_DOS, NW_NS_OS2,
						   0x8006, RIM_ALL,
						   entry.volNumber,
						   entry.DosDirNum,
						   NULL,
						   &nfs) == 0)
		{
			printf(_("os2 name: %s\n"), nfs.entryName);
		}
	}

}

void
test_rights(struct ncp_conn *conn)
{
	struct nw_info_struct sys;
	struct nw_info_struct me;
	u_int16_t rights;

	if (ncp_do_lookup(conn, NULL, "SYS", &sys) != 0)
	{
		printf(_("lookup error\n"));
		return;
	}
	if (ncp_do_lookup(conn, &sys, "ME", &me) != 0)
	{
		printf(_("lookup me error\n"));
		return;
	}
	if (ncp_get_eff_directory_rights(conn, 0, 0, 0x8006,
					 sys.volNumber, sys.DosDirNum, NULL,
					 &rights) != 0)
	{
		printf(_("get sys rights error\n"));
		return;
	}
	printf(_("sys right: %4.4x\n"), rights);

	if (ncp_get_eff_directory_rights(conn, 0, 0, 0x8006,
					 me.volNumber, me.DosDirNum, NULL,
					 &rights) != 0)
	{
		printf(_("get me rights error\n"));
		return;
	}
	printf(_("me right: %4.4x\n"), rights);
	return;
}

int
main(int argc, char *argv[])
{
	struct ncp_conn *conn;
	long err;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("in ncp_initialize"));
		return 1;
	}
	test_rights(conn);
	ncp_close(conn);
	return 0;
}
