/**************** history	************
*
*	COMPONENT: JRD	MODULE: SUN_FTN.C
*	generated by Marion V2.5     2/6/90
*	from dev              db	on 7-MAR-1995
*****************************************************************
*
*	19332	rkumar	7-MAR-1995
*	Calling convention error in ISC_MODIFY, ISC_ATTACH and ISC_FREE
*
*	19325	rkumar	7-MAR-1995 
*	Add entry point for ISC_FREE
*
*	19323	rkumar	7-MAR-1995 
*	A typo in the previous change
*
*	19322	rkumar	7-MAR-1995 
*	Add an entry point for ISC_MODIFY_DPB
*
*	19170	rkumar	9-FEB-1995 
*	change __ to _$
*
*	19054	rkumar	30-JAN-1995
*	One more mode on the ftn calling conventions problem
*
*	19034	rkumar	26-JAN-1995
*	to fix ftn calling convention problem for 4.0 isc_ calls
*
*	19015	rkumar	25-JAN-1995
*	parameter passing bug fix
*
*	19014	rkumar	25-JAN-1995
*	Further changes to 4.0 calling convention
*
*	18998	rkumar	24-JAN-1995
*	Fix bugs in fortran ISC_ calling convention
*
*	15607	katz	24-FEB-1994
*	Use STATUS to declare status vectors instead of SLONG
*
*	15078	daves	27-JAN-1994
*	ANSI compile error: fixed return result of isc_print_sqlerror
*
*	13615	katz	28-OCT-1993
*	Parameterize use of va_start
*
*	13380	katz	16-OCT-1993
*	Move away from C language datatypes
*
*	12467	katz	16-AUG-1993
*	Change exec_procedure to transact_request
*
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http:////www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 *
 * Copyright (C) 2000 Inprise Corporation
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
*/

/*
 *	PROGRAM:	JRD Access Method
 *	MODULE:		sun_ftn.c
 *	DESCRIPTION:	"Wrapper" module which compensates for the
 *			Sun Fortran compiler appending an underscore
 *			to external entrypoints.  (Each function in
 *			this module is an InterBase entrypoint with
 *			an underscore appended to it which calls the
 *			real InterBase function).
 *
 * copyright (c) 1990, 1995 by Borland International
 */

#include "../jrd/common.h"
#include <stdarg.h>
#include "../jrd/gds.h"
#include "../jrd/perf.h"
#undef GDS_VAL
#define GDS_VAL(val)	(*val)

extern UCHAR *gds__alloc();

typedef STATUS	(*PTR)();

typedef struct handle {
    struct handle **user_handle;
} *HANDLE, *REQ, *DBB, *TRA, *BLB, *ATT, *OBJ, *BLK, *MAP, *WIN, *MENU, *STMT;

typedef struct {
    short	array_bound_lower;
    short	array_bound_upper;
} ARRAY_BOUND;

typedef struct {
    unsigned char	array_desc_dtype;
    char		array_desc_scale;
    unsigned short	array_desc_length;
    char		array_desc_field_name [32];
    char		array_desc_relation_name [32];
    short		array_desc_dimensions;
    short		array_desc_flags;
    ARRAY_BOUND		array_desc_bounds [16];
} ARRAY_DESC;

/* Transaction element block */

typedef struct teb {
    ATT		*teb_database;
    int		teb_tpb_length;
    UCHAR	*teb_tpb;
} TEB;

#ifdef APOLLO
#define SQLDA_PROTOTYPE		sqlda, sqlda_flag
#define SQLDA_ARG		(*sqlda_flag ? sqlda : NULL)
#endif

#ifndef SQLDA_PROTOTYPE
#define SQLDA_PROTOTYPE		sqlda
#define SQLDA_ARG		SQLDA_PROTOTYPE
#endif

#define BLOB_DISPLAY		blob__display_
#define BLOB_DUMP		blob__dump_
#define BLOB_EDIT		blob__edit_
#define BLOB_LOAD		blob__load_

#define GDS_ALLOC		gds__alloc_
#define GDS_ATTACH_DATABASE	gds__attach_database_
#define GDS_BLOB_INFO		gds__blob_info_
#define GDS_BLOB_SIZE		gds__blob_size_
#define GDS_CANCEL_BLOB		gds__cancel_blob_
#define GDS_CANCEL_EVENTS	gds__cancel_events_
#define GDS_CLOSE		gds__close_
#define GDS_CLOSE_BLOB		gds__close_blob_
#define GDS_COMMIT		gds__commit_transaction_
#define GDS_COMMIT_RETAINING	gds__commit_retaining_
#define GDS_COMPILE		gds__compile_request_
#define GDS_COMPILE2		gds__compile_request2_
#define GDS_CREATE_BLOB		gds__create_blob_
#define GDS_CREATE_BLOB2	gds__create_blob2_
#define GDS_CREATE_DATABASE	gds__create_database_
#define GDS_DATABASE_INFO	gds__database_info_
#define GDS_DDL			gds__ddl_
#define GDS_DETACH		gds__detach_database_
#define GDS_DECLARE		gds__declare_
#define GDS_DECODE_DATE		gds__decode_date_
#define GDS_DESCRIBE		gds__describe_
#define GDS_DESCRIBE_BIND	gds__describe_bind_
#define GDS_DSQL_FINISH		gds__dsql_finish_
#define GDS_ENCODE_DATE		gds__encode_date_
#define GDS_EVENT_WAIT		gds__event_wait_
#define GDS_EXECUTE		gds__execute_
#define GDS_EXECUTE_IMMEDIATE	gds__execute_immediate_
#define GDS_EVENT_BLOCK_A	gds__event_block_a_
#define GDS_EVENT_COUNTS	gds__event_counts_
#define GDS_FREE		gds__free_
#define GDS_GET_SEGMENT		gds__get_segment_
#define GDS_GET_SLICE		gds__get_slice_
#define GDS_FETCH		gds__fetch_
#define GDS_FTOF		gds__ftof_
#define GDS_OPEN		gds__open_
#define GDS_OPEN_BLOB		gds__open_blob_
#define GDS_OPEN_BLOB2		gds__open_blob2_
#define GDS_PREPARE		gds__prepare_
#define GDS_PREPARE_TRANS	gds__prepare_transaction_ 
#define GDS_PREPARE2		gds__prepare_transaction2_
#define GDS_PRINT_STATUS	gds__print_status_
#define GDS_PUT_SEGMENT		gds__put_segment_
#define GDS_PUT_SLICE		gds__put_slice_
#define GDS_QTOQ		gds__qtoq_
#define GDS_QUE_EVENTS		gds__que_events_
#define GDS_RECONNECT		gds__reconnect_transaction_
#define GDS_RECEIVE		gds__receive_
#define GDS_RELEASE_REQUEST	gds__release_request_
#define GDS_REQUEST_INFO	gds__request_info_
#define GDS_ROLLBACK		gds__rollback_transaction_
#define GDS_SEEK_BLOB		gds__seek_blob_
#define GDS_SEND		gds__send_
#define GDS_SQLCODE		gds__sqlcode_
#define GDS_START		gds__start_request_
#define GDS_START_AND_SEND	gds__start_and_send_
#define GDS_START_MULTIPLE	gds__start_multiple_
#define GDS_START_TRANSACTION	gds__start_transaction_
#define GDS_TRANSACTION_INFO	gds__transaction_info_
#define GDS_UNWIND_REQUEST	gds__unwind_request_
#define GDS_VAX_INTEGER		gds__vax_integer_
#define GDS_VERSION		gds__version_

#define ISC_ARRAY_GEN_SDL	isc_array_gen_sdl_
#define ISC_ARRAY_GET_SLICE	isc_array_get_slice_
#define ISC_ARRAY_LOOKUP_BOUNDS	isc_array_lookup_bounds_
#define ISC_ARRAY_LOOKUP_DESC	isc_array_lookup_desc_
#define ISC_ARRAY_PUT_SLICE	isc_array_put_slice_
#define ISC_ARRAY_SET_DESC	isc_array_set_desc_
#define ISC_ATTACH_DATABASE	isc_attach_database_
#define ISC_MODIFY_DPB		isc_modify_dpb_
#define ISC_FREE		isc_free_
#define ISC_BADDRESS		isc_baddress_
#define ISC_BLOB_INFO		isc_blob_info_
#define ISC_CANCEL_BLOB		isc_cancel_blob_
#define ISC_CANCEL_EVENTS	isc_cancel_events_
#define ISC_CLOSE		isc_close_
#define ISC_CLOSE_BLOB		isc_close_blob_
#define ISC_COMMIT		isc_commit_transaction_
#define ISC_COMMIT_RETAINING	isc_commit_retaining_
#define ISC_COMPILE		isc_compile_request_
#define ISC_COMPILE2		isc_compile_request2_
#define ISC_CREATE_BLOB		isc_create_blob_
#define ISC_CREATE_BLOB2	isc_create_blob2_
#define ISC_CREATE_DATABASE	isc_create_database_
#define ISC_DATABASE_INFO	isc_database_info_
#define ISC_DDL			isc_ddl_
#define ISC_DECODE_DATE		isc_decode_date_
#define ISC_DECLARE		isc_declare_
#define ISC_DESCRIBE		isc_describe_
#define ISC_DESCRIBE_BIND	isc_describe_bind_
#define ISC_DETACH		isc_detach_database_
#define ISC_DROP_DATABASE	isc_drop_database_
#define ISC_DSQL_ALLOCATE	isc_dsql_allocate_statement_
#define ISC_DSQL_ALLOCATE2	isc_dsql_alloc_statement2_
#define ISC_DSQL_DESCRIBE	isc_dsql_describe_
#define ISC_DSQL_DESCRIBE_BIND	isc_dsql_describe_bind_
#define ISC_DSQL_EXEC_IMMED2	isc_dsql_exec_immed2_
#define ISC_DSQL_EXEC_IMMED2_M	isc_dsql_exec_immed2_m_
#define ISC_DSQL_EXECUTE	isc_dsql_execute_
#define ISC_DSQL_EXECUTE2	isc_dsql_execute2_
#define ISC_DSQL_EXECUTE_M	isc_dsql_execute_m_
#define ISC_DSQL_EXECUTE2_M	isc_dsql_execute2_m_
#define ISC_DSQL_EXECUTE_IMMED	isc_dsql_execute_immediate_
#define ISC_DSQL_EXECUTE_IMM_M	isc_dsql_execute_immediate_m_
#define ISC_DSQL_FETCH		isc_dsql_fetch_
#define ISC_DSQL_FETCH2		isc_dsql_fetch2_
#define ISC_DSQL_FETCH_M	isc_dsql_fetch_m_
#define ISC_DSQL_FETCH2_M	isc_dsql_fetch2_m_
#define ISC_DSQL_FINISH		isc_dsql_finish_
#define ISC_DSQL_FREE		isc_dsql_free_statement_
#define ISC_DSQL_INSERT		isc_dsql_insert_
#define ISC_DSQL_INSERT_M	isc_dsql_insert_m_
#define ISC_DSQL_PREPARE	isc_dsql_prepare_
#define ISC_DSQL_PREPARE_M	isc_dsql_prepare_m_
#define ISC_DSQL_RELEASE	isc_dsql_release_
#define ISC_DSQL_SET_CURSOR	isc_dsql_set_cursor_name_
#define ISC_DSQL_SQL_INFO	isc_dsql_sql_info_
#define ISC_EMBED_DSQL_CLOSE	isc_embed_dsql_close_
#define ISC_EMBED_DSQL_DECLARE	isc_embed_dsql_declare_
#define ISC_EMBED_DSQL_DESCR	isc_embed_dsql_describe_
#define ISC_EMBED_DSQL_DESCR_B	isc_embed_dsql_describe_bind_
#define ISC_EMBED_DSQL_EXEC_IM2	isc_embed_dsql_exec_immed2_
#define ISC_EMBED_DSQL_EXECUTE	isc_embed_dsql_execute_
#define ISC_EMBED_DSQL_EXECUTE2	isc_embed_dsql_execute2_
#define ISC_EMBED_DSQL_EXEC_IMM	isc_embed_dsql_execute_immed_
#define ISC_EMBED_DSQL_FETCH	isc_embed_dsql_fetch_
#define ISC_EMBED_DSQL_FETCH2	isc_embed_dsql_fetch2_
#define ISC_EMBED_DSQL_INSERT	isc_embed_dsql_insert_
#define ISC_EMBED_DSQL_LENGTH	isc_embed_dsql_length_
#define ISC_EMBED_DSQL_OPEN	isc_embed_dsql_open_
#define ISC_EMBED_DSQL_OPEN2	isc_embed_dsql_open2_
#define ISC_EMBED_DSQL_PREPARE	isc_embed_dsql_prepare_
#define ISC_EMBED_DSQL_RELEASE	isc_embed_dsql_release_
#define ISC_ENCODE_DATE		isc_encode_date_
#define ISC_EVENT_BLOCK_A	isc_event_block_a_
#define ISC_EVENT_COUNTS	isc_event_counts_
#define ISC_EXECUTE		isc_execute_
#define ISC_EXECUTE_IMMEDIATE	isc_execute_immediate_
#define ISC_FETCH		isc_fetch_
#define ISC_FTOF		isc_ftof_
#define ISC_GET_SEGMENT		isc_get_segment_
#define ISC_GET_SLICE		isc_get_slice_
#define ISC_OPEN		isc_open_
#define ISC_OPEN_BLOB		isc_open_blob_
#define ISC_OPEN_BLOB2		isc_open_blob2_
#define ISC_PREPARE		isc_prepare_
#define ISC_PREPARE_TRANS	isc_prepare_transaction_ 
#define ISC_PREPARE2		isc_prepare_transaction2_
#define ISC_PRINT_SQLERROR	isc_print_sqlerror_
#define ISC_PRINT_STATUS	isc_print_status_
#define ISC_PUT_SEGMENT		isc_put_segment_
#define ISC_PUT_SLICE		isc_put_slice_
#define ISC_QTOQ		isc_qtoq_
#define ISC_QUE_EVENTS		isc_que_events_
#define ISC_RECEIVE		isc_receive_
#define ISC_RECONNECT		isc_reconnect_transaction_
#define ISC_RELEASE_REQUEST	isc_release_request_
#define ISC_REQUEST_INFO	isc_request_info_
#define ISC_ROLLBACK		isc_rollback_transaction_
#define ISC_SEEK_BLOB		isc_seek_blob_
#define ISC_SEND		isc_send_
#define ISC_SQLCODE		isc_sqlcode_
#define ISC_START		isc_start_request_
#define ISC_START_AND_SEND	isc_start_and_send_
#define ISC_START_MULTIPLE	isc_start_multiple_
#define ISC_START_TRANSACTION	isc_start_transaction_
#define ISC_TRANSACT_REQUEST	isc_transact_request_
#define ISC_TRANSACTION_INFO	isc_transaction_info_
#define ISC_UNWIND_REQUEST	isc_unwind_request_
#define ISC_VAX_INTEGER		isc__vax_integer_
#define ISC_VERSION		isc_version_
#define ISC_WAIT_FOR_EVENT	isc_wait_for_event_

#define PERF_FORMAT		perf_format_
#define PERF_GET_INFO		perf_get_info_
#define PERF_REPORT		perf_report_

#ifndef APOLLO
BLOB_EDIT (blob_id, database, transaction, field_name, name_length) 
    SLONG	*blob_id;
    int		**database, *transaction;
    SCHAR	*field_name;
    SLONG	*name_length;
{
/**************************************
 *
 *	b l o b _ $ e d i t
 *
 **************************************
 *
 * Functional description
 *	Translate a pascal callable edit
 *	into an internal edit call.
 *
 **************************************/
USHORT    length;

length = *name_length;
return blob__edit (blob_id, database, transaction,
                   field_name, &length);
}

BLOB_DISPLAY (blob_id, database, transaction, field_name, name_length)
    SLONG	*blob_id;
    int		**database, *transaction;
    SCHAR	*field_name;
    SLONG	*name_length;
{
/**************************************
 *
 *	b l o b _ $ d i s p l a y
 *
 **************************************
 *
 * Functional description
 *	just dump a blob to the screen
 *
 **************************************/
USHORT    length;

length = *name_length;

return blob__display (blob_id, database, transaction, field_name, &length);
}

BLOB_DUMP (blob_id, database, transaction, file_name, length)
    SLONG	*blob_id;
    int		**database, *transaction;
    SCHAR	*file_name;
    SLONG        GDS_VAL(length);
{
/**************************************
 *
 *	B L O B _ d u m p
 *
 **************************************
 *
 * Functional description
 *	Dump a blob into a file.
 *
 **************************************/
USHORT    len;

len = *length;

return blob__dump (blob_id, database, transaction, file_name, &len);
}

BLOB_LOAD (blob_id, database, transaction, file_name, name_length)
    SLONG	*blob_id;
    int		**database, *transaction;
    SCHAR	*file_name;
    SLONG        GDS_VAL(name_length);
{
/**************************************
 *
 *	b l o b _ $ l o a d
 *
 **************************************
 *
 * Functional description
 *	Translate a Fortran callable load
 *	into an internal load call.
 *
 **************************************/
USHORT   length;

length = *name_length;

return blob__load (blob_id, database, 
                    transaction, file_name, &length);
}

UCHAR *GDS_ALLOC (size)
    SLONG	GDS_VAL (size);
{
/**************************************
 *
 *	g d s _ $ a l l o c
 *
 **************************************
 *
 * Functional description
 *	Allocate a block of memory.
 *
 **************************************/

return gds__alloc (size);
}

STATUS GDS_ATTACH_DATABASE (user_status, file_length, file_name, handle, 
			dpb_length, dpb)
    STATUS	*user_status;
    SLONG	GDS_VAL (file_length);
    SCHAR	*file_name;
    ATT		*handle;
    SLONG	GDS_VAL (dpb_length);
    SCHAR	*dpb;
{
/**************************************
 *
 *	g d s _ $ a t t a c h _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Attach a database through the first subsystem
 *	that recognizes it.
 *
 **************************************/

return gds__attach_database (user_status, 
	(SSHORT) *file_length, file_name, handle, 
	(SSHORT) *dpb_length, dpb);
}

STATUS GDS_BLOB_INFO (user_status, blob_handle, item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	g d s _ $ b l o b _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return gds__blob_info (user_status, blob_handle, (SSHORT) *item_length,
                       items, (SSHORT) *buffer_length, buffer);
}

int GDS_BLOB_SIZE (b, size, seg_count, max_seg)
    SLONG	*b, *size, *seg_count, *max_seg;
{
/**************************************
 *
 *	g d s _ $ b l o b _ s i z e 
 *
 **************************************
 *
 * Functional description
 *	Get the size, number of segments, and max
 *	segment length of a blob.  Return true
 *	if it happens to succeed.
 *
 **************************************/

return gds__blob_size (b, size, seg_count, max_seg);
}

STATUS GDS_CANCEL_BLOB (user_status, blob_handle)
    STATUS	*user_status;
    BLB		*blob_handle;
{
/**************************************
 *
 *	g d s _ $ c a n c e l _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/

return gds__cancel_blob (user_status, blob_handle);
}

STATUS GDS_CANCEL_EVENTS (user_status, handle, id)
    STATUS	*user_status;
    ATT		*handle;
    SLONG	*id;
{
/**************************************
 *
 *	g d s _ $ c a n c e l _ e v e n t s
 *
 **************************************
 *
 * Functional description
 *	Try to cancel an event.
 *
 **************************************/

return gds__cancel_events (user_status, handle, id);
}

GDS_CLOSE (user_status, name)
    STATUS	*user_status;
    TEXT	*name;
{
/**************************************
 *
 *	g d s _ $ c l o s e
 *
 **************************************
 *
 * Functional description
 *	Close a dynamic SQL cursor.
 *
 **************************************/

return gds__close (user_status, name);
}

STATUS GDS_CLOSE_BLOB (user_status, blob_handle)
    STATUS	*user_status;
    BLB		*blob_handle;
{
/**************************************
 *
 *	g d s _ $ c l o s e _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/

return gds__close_blob (user_status, blob_handle);
}

STATUS GDS_COMMIT (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	g d s _ $ c o m m i t
 *
 **************************************
 *
 * Functional description
 *	Commit a transaction.
 *
 **************************************/

return gds__commit_transaction (user_status, tra_handle);
}

STATUS GDS_COMMIT_RETAINING (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	g d s _ $ c o m m i t _ r e t a i n i n g
 *
 **************************************
 *
 * Functional description
 *	Do a commit retaining.
 *
 **************************************/

return gds__commit_retaining (user_status, tra_handle);
}

STATUS GDS_COMPILE (user_status, db_handle, req_handle, blr_length, blr)
    STATUS	*user_status;
    ATT		*db_handle;
    REQ		*req_handle;
    SLONG	GDS_VAL (blr_length);
    SCHAR	*blr;
{
/**************************************
 *
 *	g d s _ $ c o m p i l e
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return gds__compile_request (user_status, db_handle, req_handle,
                             (SSHORT) *blr_length, blr);
}

STATUS GDS_COMPILE2 (user_status, db_handle, req_handle, blr_length, blr)
    STATUS	*user_status;
    ATT		*db_handle;
    REQ		*req_handle;
    SLONG	GDS_VAL (blr_length);
    SCHAR	*blr;
{
/**************************************
 *
 *	g d s _ $ c o m p i l e 2
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return gds__compile_request2 (user_status, db_handle, req_handle,
                              (SSHORT) *blr_length, blr);
}

STATUS GDS_CREATE_BLOB (user_status, db_handle, tra_handle, blob_handle, blob_id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
{
/**************************************
 *
 *	g d s _ $ c r e a t e _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return gds__create_blob (user_status, db_handle, tra_handle, blob_handle, blob_id);
}

STATUS GDS_CREATE_BLOB2 (user_status, db_handle, tra_handle, blob_handle, blob_id, bpb_length, bpb)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
    SLONG	GDS_VAL (bpb_length);
    UCHAR	*bpb;
{
/**************************************
 *
 *	g d s _ $ c r e a t e _ b l o b 2
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return gds__create_blob2 (user_status, db_handle, tra_handle, blob_handle, 
	blob_id,  (SSHORT) *bpb_length, bpb);
}

STATUS GDS_CREATE_DATABASE (user_status, file_length, file_name, handle, 
			dpb_length, dpb, db_type)
    STATUS	*user_status;
    SLONG	GDS_VAL (file_length);
    UCHAR	*file_name;
    ATT		*handle;
    SLONG	GDS_VAL (dpb_length);
    UCHAR	*dpb;
    SLONG	GDS_VAL (db_type);
{
/**************************************
 *
 *	g d s _ $ c r e a t e _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Create a nice, squeaky clean database, uncorrupted by user data.
 *
 **************************************/

return gds__create_database (user_status,  (SSHORT) *file_length, file_name, 
	handle,  (SSHORT) *dpb_length, dpb,  (SSHORT) *db_type);
}

STATUS GDS_DATABASE_INFO (user_status, handle, item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    ATT		*handle;
    SLONG 	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	g d s _ $ d a t a b a s e _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on database object.
 *
 **************************************/

return gds__database_info (user_status, handle, (SSHORT) *item_length,
                           items, (SSHORT) *buffer_length, buffer);
}

STATUS GDS_DDL (user_status, db_handle, tra_handle, length, ddl)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    UCHAR	*ddl;
{
/**************************************
 *
 *	g d s _ $ d d l
 *
 **************************************
 *
 * Functional description
 *	Do meta-data update.
 *
 **************************************/

return gds__ddl (user_status, db_handle, tra_handle, (SSHORT) *length, ddl);
}

GDS_DECLARE (user_status, statement, cursor)
    STATUS	*user_status;
    TEXT	*statement, *cursor;
{
/**************************************
 *
 *	g d s _ $ d e c l a r e
 *
 **************************************
 *
 * Functional description
 *	Declare a cursor for a dynamic request.
 *
 **************************************/

return gds__declare (user_status, statement, cursor);
}

void GDS_DECODE_DATE (date, times)
    SLONG	date [2];
    struct tm	*times;
{
/**************************************
 *
 *	g d s _ $ d e c o d e
 *
 **************************************
 *
 * Functional description
 *	Convert from internal date format to UNIX time structure.
 *
 **************************************/

gds__decode_date (date, times);
}

GDS_DESCRIBE (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ d e s c r i b e
 *
 **************************************
 *
 * Functional description
 *	Describe output parameters for a prepared statement.
 *
 **************************************/

return gds__describe (user_status, name, sqlda);
}

GDS_DESCRIBE_BIND (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ d e s c r i b e _ b i n d
 *
 **************************************
 *
 * Functional description
 *	Describe input parameters for a prepared statement.
 *
 **************************************/

return gds__describe_bind (user_status, name, sqlda);
}

STATUS GDS_DETACH (user_status, handle)
    STATUS	*user_status;
    ATT		*handle;
{
/**************************************
 *
 *	g d s _ $ d e t a c h
 *
 **************************************
 *
 * Functional description
 *	Close down a database.
 *
 **************************************/

return gds__detach_database (user_status, handle);
}


GDS_DSQL_FINISH (db_handle)
    SLONG		**db_handle;
{
/**************************************
 *
 *	g d s _ $ d s q l _ f i n i s h
 *
 **************************************
 *
 * Functional description
 *	Clean up DSQL globals
 *
 **************************************/

return gds__dsql_finish (db_handle);
}


void GDS_ENCODE_DATE (times, date)
    struct tm	*times;
    SLONG	date [2];
{
/**************************************
 *
 *	g d s _ $ e n c o d e
 *
 **************************************
 *
 * Functional description
 *	Convert from UNIX time structure to internal date format.
 *
 **************************************/

gds__encode_date (times, date);
}

USHORT GDS_EVENT_BLOCK_A (event_buffer, result_buffer, count, name_buffer)
    UCHAR	**event_buffer, **result_buffer;
    SLONG	GDS_VAL (count);
    UCHAR	**name_buffer;
{
/**************************************
 *
 *	g d s _ $ e v e n t _ b l o c k _ a 
 *
 **************************************
 *
 * Functional description
 *	Create an initialized event parameter block from a
 *	vector of input arguments. (Ada needs this)
 *	Assume all strings are 31 characters long.
 *	Return the size of the block.
 *
 **************************************/

return gds__event_block_a (event_buffer, result_buffer, (USHORT) *count, name_buffer);
}
#endif

void GDS_EVENT_COUNTS (result_vector, buffer_length, event_buffer, result_buffer)
    ULONG	*result_vector;
    USHORT	GDS_VAL (buffer_length);
    UCHAR	**event_buffer, **result_buffer;
{
/**************************************
 *
 *	g d s _ $ e v e n t _ c o u n t s
 *
 **************************************
 *
 * Functional description
 *	Get the delta between two events in an event
 *	parameter block.  Used to update gds__events
 *	for GPRE support of events.
 *
 **************************************/

#ifndef APOLLO
gds__event_counts (result_vector, (USHORT) *buffer_length, *event_buffer, *result_buffer);
#else
gds__event_counts (*result_vector, *buffer_length, **event_buffer, **result_buffer);
#endif
}

STATUS GDS_EVENT_WAIT (user_status, handle, length, events, buffer)
    ULONG	*user_status;
    ATT		*handle;
    USHORT	GDS_VAL (length);
    UCHAR	**events, **buffer;
{
/**************************************
 *
 *	g d s _ $ e v e n t _ w a i t
 *
 **************************************
 *
 * Functional description
 *	Que request for event notification.
 *
 **************************************/

#ifndef APOLLO
return gds__event_wait (user_status, handle, (USHORT) *length, *events, *buffer);
#else
return gds__event_wait (*user_status, *handle, *length, **events, **buffer);
#endif
}

#ifndef APOLLO
GDS_EXECUTE (user_status, trans_handle, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    TRA		*trans_handle;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ e x e c u t e
 *
 **************************************
 *
 * Functional description
 *	Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return gds__execute (user_status, trans_handle, name, sqlda);
}


GDS_EXECUTE_IMMEDIATE (user_status, db_handle, trans_handle, length, string)
    STATUS	*user_status;
    int		**db_handle, **trans_handle;
    SLONG	*length;
    TEXT	*string;
{
/**************************************
 *
 *	g d s _ $ e x e c u t e _ i m m e d i a t e
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/
USHORT	len;  

len = *length;
return gds__execute_immediate (user_status, db_handle, 
                               trans_handle, &len, string);
}

GDS_FETCH (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ f e t c h
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/
return gds__fetch (user_status, name, sqlda);
}

SLONG GDS_FREE (blk)
    SLONG		*blk;
{
/**************************************
 *
 *	g d s _ $ f r e e
 *
 **************************************
 *
 * Functional description
 *	Release a block allocated by gds__alloc.  Return number
 *	of bytes released.
 *
 **************************************/

return gds__free (blk);
}

GDS_FTOF (string, length1, field, length2)
    SCHAR	*string, *field;
    SLONG	GDS_VAL (length1), GDS_VAL (length2);
{
/**************************************
 *
 *	G D S _ f t o f
 *
 **************************************
 *
 * Functional description
 *	Move a fixed length string to a fixed length string.
 *	This is typically generated by the preprocessor to
 *	move strings around.
 *
 **************************************/

gds__ftof (string, (SSHORT) *length1, field, (SSHORT) *length2);
}

STATUS GDS_GET_SEGMENT (user_status, blob_handle, length, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SSHORT	*length; 
    SLONG        GDS_VAL (buffer_length);
    SCHAR	*buffer;
{
/**************************************
 *
 *	g d s _ $ g e t _ s e g m e n t
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/
STATUS	status;
SSHORT	return_length;

status = gds__get_segment (user_status, blob_handle,
	       &return_length,  (SSHORT) *buffer_length, buffer);
*length = return_length;

return status;
}

STATUS GDS_GET_SLICE (user_status, db_handle, tra_handle, array_id, 
			sdl_length, sdl, param_length, param, slice_length, slice, return_length)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA         *tra_handle;
    SLONG	*array_id;
    SLONG	GDS_VAL (sdl_length);
    UCHAR	*sdl;
    SLONG	GDS_VAL (param_length);
    UCHAR	*param;
    SLONG	GDS_VAL (slice_length);
    UCHAR	*slice;
    SLONG	*return_length;
{
/**************************************
 *
 *	g d s _ $ g e t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *	Snatch a slice of an array.
 *
 **************************************/

return gds__get_slice (user_status, db_handle, tra_handle, array_id, 
	(SSHORT) *sdl_length, sdl, 
	(SSHORT) *param_length, param, 
	*slice_length, slice, 
	return_length);
}

GDS_OPEN (user_status, trans_handle, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    TRA		*trans_handle;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ o p e n
 *
 **************************************
 *
 * Functional description
 *	Open a dynamic SQL cursor.
 *
 **************************************/

return gds__open (user_status, trans_handle, name, sqlda);
}

STATUS GDS_OPEN_BLOB (user_status, db_handle, tra_handle, blob_handle, blob_id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
{
/**************************************
 *
 *	g d s _ $ o p e n _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return gds__open_blob (user_status, db_handle, tra_handle, blob_handle, blob_id);
}

STATUS GDS_OPEN_BLOB2 (user_status, db_handle, tra_handle, blob_handle, blob_id, bpb_length, bpb)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
    SLONG	GDS_VAL (bpb_length);
    UCHAR	*bpb;
{
/**************************************
 *
 *	g d s _ $ o p e n _ b l o b 2
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob (extended edition).
 *
 **************************************/

return gds__open_blob2 (user_status, db_handle, tra_handle, blob_handle,
         blob_id, (SSHORT) *bpb_length, bpb);
}

GDS_PREPARE (user_status, db_handle, trans_handle, name, length, string, sqlda)
    STATUS	*user_status;
    int		**db_handle, **trans_handle;
    TEXT	*name;
    SLONG	*length;
    TEXT	*string;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	g d s _ $ p r e p a r e
 *
 **************************************
 *
 * Functional description
 *	Prepare a dsql statement for execution.
 *
 **************************************/ 
USHORT len;

len = *length;

return gds__prepare (user_status, db_handle, trans_handle, name, 
                              &len, string, sqlda);
}

STATUS GDS_PREPARE_TRANS (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	g d s _ $ p r e p a r e _ t r a n s a c t i o n
 *
 **************************************
 *
 * Functional description
 *	Prepare a transaction for commit.  First 
 *	phase of a two phase commit.
 *
 **************************************/

return gds__prepare_transaction (user_status, tra_handle);
}

STATUS GDS_PREPARE2 (user_status, tra_handle, msg_length, msg)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	GDS_VAL (msg_length);
    UCHAR	*msg;
{
/**************************************
 *
 *	g d s _ $ p r e p a r e 2
 *
 **************************************
 *
 * Functional description
 *	Prepare a transaction for commit.  First phase of a two
 *	phase commit.
 *
 **************************************/

return gds__prepare_transaction2 (user_status, tra_handle, 
	 (SSHORT) *msg_length, msg);
}

GDS_PRINT_STATUS (status_vector)
    STATUS	*status_vector;
{
/**************************************
 *
 *	g d s _ $ p r i n t _ s t a t u s
 *
 **************************************
 *
 * Functional description
 *	Print status vector.
 *
 **************************************/

return gds__print_status (status_vector);
}

STATUS GDS_PUT_SEGMENT (user_status, blob_handle, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SSHORT	GDS_VAL (buffer_length);
    SCHAR	*buffer;
{
/**************************************
 *
 *	g d s _ $ p u t _ s e g m e n t
 *
 **************************************
 *
 * Functional description
 *	Store one piece of a blob
 *
 **************************************/

return gds__put_segment (user_status, blob_handle, *buffer_length, buffer);
}

STATUS GDS_PUT_SLICE (user_status, db_handle, tra_handle, array_id, 
			sdl_length, sdl, param_length, param, slice_length, slice)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	*array_id;
    SLONG	GDS_VAL (sdl_length);
    UCHAR	*sdl;
    SLONG	GDS_VAL (param_length);
    UCHAR	*param;
    SLONG	GDS_VAL (slice_length);
    UCHAR	*slice;
{
/**************************************
 *
 *	g d s _ $ p u t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *	Snatch a slice of an array.
 *
 **************************************/

return gds__put_slice (user_status, db_handle, tra_handle, array_id, 
	(SSHORT) *sdl_length, sdl, 
	(SSHORT) *param_length, param, 
	*slice_length, slice);
}

void GDS_QTOQ (quad_in, quad_out)
    GDS__QUAD		*quad_in, *quad_out;
{
/**************************************
 *
 *	G D S _ q t o q
 *
 **************************************
 *
 * Functional description
 *	Move a quad value to another quad value.  This
 *      call is generated by the preprocessor when assigning
 *      quad values in FORTRAN.
 *
 **************************************/

gds__qtoq (quad_in, quad_out);
}

STATUS GDS_QUE_EVENTS (user_status, handle, id, length, events, ast, arg)
    STATUS	*user_status;
    ATT		*handle;
    SLONG	*id;
    USHORT	GDS_VAL (length);
    UCHAR	*events;
    int		(*ast)();
    SLONG	arg;
{
/**************************************
 *
 *	g d s _ $ q u e _ e v e n t s
 *
 **************************************
 *
 * Functional description
 *	Que request for event notification.
 *
 **************************************/

return gds__que_events (user_status, handle, id, 
	(USHORT) *length, events, ast, arg);
}

STATUS GDS_RECEIVE (user_status, req_handle, msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*msg;
    SLONG	GDS_VAL (level);
{
/**************************************
 *
 *	g d s _ $ r e c e i v e
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return gds__receive (user_status, req_handle, 
	(SSHORT) *msg_type, (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS GDS_RECONNECT (user_status, db_handle, tra_handle, length, id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    UCHAR	*id;
{
/**************************************
 *
 *	g d s _ $ r e c o n n e c t
 *
 **************************************
 *
 * Functional description
 *	Connect to a transaction in limbo.
 *
 **************************************/

return gds__reconnect_transaction (user_status, db_handle, 
                       tra_handle, (SSHORT) *length, id);
}

STATUS GDS_RELEASE_REQUEST (user_status, req_handle)
    STATUS	*user_status;
    REQ		*req_handle;
{
/**************************************
 *
 *	g d s _ $ r e l e a s e _ r e q u e s t
 *
 **************************************
 *
 * Functional description
 *	Release a request.
 *
 **************************************/

return gds__release_request (user_status, req_handle);
}

STATUS GDS_REQUEST_INFO (user_status, req_handle, level, item_length, items, 
	          buffer_length, buffer)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
    SLONG	GDS_VAL (level);
{
/**************************************
 *
 *	g d s _ $ r e q u e s t _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return gds__request_info (user_status, req_handle, 
	(SSHORT) *level, (SSHORT) *item_length, items, 
	(SSHORT) *buffer_length, buffer);
}

STATUS GDS_ROLLBACK (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	g d s _ $ r o l l b a c k
 *
 **************************************
 *
 * Functional description
 *	Abort a transaction.
 *
 **************************************/

return gds__rollback_transaction (user_status, tra_handle);
}

STATUS GDS_SEEK_BLOB (user_status, blob_handle, mode, offset, result)
    STATUS	*user_status;
    BLB		*blob_handle;
    SLONG	GDS_VAL (mode);
    SLONG	GDS_VAL (offset);
    SLONG	*result;
{
/**************************************
 *
 *	g d s _ $ s e e k _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Seek a blob.
 *
 **************************************/

return gds__seek_blob (user_status, blob_handle, (SSHORT) *mode, *offset, result);
}

STATUS GDS_SEND (user_status, req_handle, msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*msg;
    SLONG	GDS_VAL (level);
{
/**************************************
 *
 *	g d s _ $ s e n d
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return gds__send (user_status, req_handle, (SSHORT) *msg_type,
                  (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS GDS_SQLCODE (user_status)
    STATUS 	*user_status;
{
/**************************************
 *
 *	g d s _  s q l c o d e
 *
 **************************************
 *
 * Functional description
 *	Translate the GDS error code to SQL error code.
 *
 **************************************/
return gds__sqlcode (user_status);
}

STATUS GDS_START (user_status, req_handle, tra_handle, level)
    STATUS		*user_status;
    register REQ	*req_handle;
    register TRA	*tra_handle;
    SLONG		GDS_VAL (level);
{
/**************************************
 *
 *	g d s _ $ s t a r t
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return gds__start_request (user_status, req_handle, tra_handle, (SSHORT) *level);
}

STATUS GDS_START_AND_SEND (user_status, req_handle, tra_handle, 
		    msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*msg;
    SLONG	GDS_VAL (level);
{
/**************************************
 *
 *	g d s _ $ s t a r t _ a n d _ s e n d
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return gds__start_and_send (user_status, req_handle, tra_handle, 
		    (SSHORT) *msg_type, (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS GDS_START_MULTIPLE (user_status, tra_handle, count, vector)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	GDS_VAL (count);
    TEB		*vector;
{
/**************************************
 *
 *	g d s _ $ s t a r t _ m u l t i p l e
 *
 **************************************
 *
 * Functional description
 *	Start a transaction.
 *
 **************************************/

return gds__start_multiple (user_status, tra_handle, (SSHORT) *count, vector);
}

STATUS GDS_START_TRANSACTION (
    STATUS	*user_status,
    TRA		*tra_handle,
    SLONG	GDS_VAL (count), 
    ...)
{
/**************************************
 *
 *	g d s _ $ s t a r t _ t r a n s a c t i o n
 *
 **************************************
 *
 * Functional description
 *	Start a transaction.
 *
 **************************************/
TEB	tebs [16], *teb, *end;
va_list	ptr;

teb = tebs;
end = teb + *count;
VA_START (ptr, count);

for (; teb < end; teb++)
    {
    teb->teb_database = va_arg (ptr, ATT*);
    teb->teb_tpb_length = *(va_arg (ptr, int*));
    teb->teb_tpb = va_arg (ptr, UCHAR*);
    }

return gds__start_multiple (user_status, tra_handle,
                (SSHORT) *count, tebs);
}

STATUS GDS_TRANSACTION_INFO (user_status, tra_handle, 
			item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	g d s _ $ t r a n s a c t i o n _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return gds__transaction_info (user_status, tra_handle, 
	(SSHORT) *item_length, items, 
	(SSHORT) *buffer_length, buffer);
}

STATUS GDS_UNWIND_REQUEST (user_status, req_handle, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	GDS_VAL(level);
{
/**************************************
 *
 *	g d s _ $ u n w i n d
 *
 **************************************
 *
 * Functional description
 *	Unwind a running request.  This is potentially nasty since it can be called
 *	asynchronously.
 *
 **************************************/

gds__unwind_request (user_status, req_handle, (SSHORT) GDS_VAL(level));
return;
}

SLONG GDS_VAX_INTEGER (ptr, length)
    UCHAR	*ptr;
    SLONG	length;
{
/**************************************
 *
 *	g d s _ $ v a x _ i n t e g e r
 *
 **************************************
 *
 * Functional description
 *	Pick up (and convert) a VAX style integer of length 1, 2, or 4
 *	bytes.
 *
 **************************************/

return gds__vax_integer (ptr, (SSHORT) length);
}

GDS_VERSION (handle, routine, user_arg)
    int		*handle;
    int		(*routine)();
    SCHAR	*user_arg;
{
/**************************************
 *
 *	g d s _ $ v e r s i o n
 *
 **************************************
 *
 * Functional description
 *	Obtain and print information about a database.
 *
 **************************************/

gds__version (handle, routine, user_arg);
}
#endif

#ifndef APOLLO
SLONG ISC_BADDRESS (object)
    SCHAR	*object;
{
/**************************************
 *
 *        i s c _ b a d d r e s s
 *
 **************************************
 *
 * Functional description
 *      Return the address of whatever is passed in
 *
 **************************************/

return (SLONG) object;  
}

STATUS ISC_ARRAY_GEN_SDL (status, desc, sdl_buffer_length, sdl_buffer, sdl_length)
    STATUS	*status;
    ARRAY_DESC	*desc;
    SSHORT	*sdl_buffer_length;
    SCHAR	*sdl_buffer;
    SSHORT	*sdl_length;
{
/**************************************
 *
 *	i s c _ a r r a y _ g e n _ s d l
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_gen_sdl (status, desc, sdl_buffer_length, sdl_buffer, sdl_length);
}

STATUS ISC_ARRAY_GET_SLICE (status, db_handle, trans_handle, array_id, 
			    desc, array, slice_length)
    STATUS	*status;
    SLONG	*db_handle;
    SLONG	*trans_handle;
    GDS__QUAD	*array_id;
    ARRAY_DESC	*desc;
    void	*array;
    SLONG	*slice_length;
{
/**************************************
 *
 *	i s c _ a r r a y _ g e t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_get_slice (status, db_handle, trans_handle, array_id, 
			    desc, array, slice_length);
}

STATUS ISC_ARRAY_LOOKUP_BOUNDS (status, db_handle, trans_handle, 
				relation_name, field_name, desc)
    STATUS	*status;
    SLONG	*db_handle;
    SLONG	*trans_handle;
    SCHAR	*relation_name;
    SCHAR	*field_name;
    ARRAY_DESC	*desc;
{
/**************************************
 *
 *	i s c _ a r r a y _ l o o k u p _ b o u n d s
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_lookup_bounds (status, db_handle, trans_handle, 
				relation_name, field_name, desc);
}

STATUS ISC_ARRAY_LOOKUP_DESC (status, db_handle, trans_handle, 
			      relation_name, field_name, desc)
    STATUS	*status;
    SLONG	*db_handle;
    SLONG	*trans_handle;
    SCHAR	*relation_name;
    SCHAR	*field_name;
    ARRAY_DESC	*desc;
{
/**************************************
 *
 *	i s c _ a r r a y _ l o o k u p _ d e s c
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_lookup_desc (status, db_handle, trans_handle, 
			      relation_name, field_name, desc);
}

STATUS ISC_ARRAY_PUT_SLICE (status, db_handle, trans_handle, array_id, 
			    desc, array, slice_length)
    STATUS	*status;
    SLONG	*db_handle;
    SLONG	*trans_handle;
    GDS__QUAD	*array_id;
    ARRAY_DESC	*desc;
    void	*array;
    SLONG	*slice_length;
{
/**************************************
 *
 *	i s c _ a r r a y _ p u t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_put_slice (status, db_handle, trans_handle, array_id, 
			    desc, array, slice_length);
}

STATUS ISC_ARRAY_SET_DESC (status, relation_name, field_name, sql_dtype, 
			   sql_length, dimensions, desc)
    STATUS	*status;
    SCHAR	*relation_name;
    SCHAR	*field_name;
    SSHORT	*sql_dtype;
    SSHORT	*sql_length;
    SSHORT	*dimensions;
    ARRAY_DESC	*desc;
{
/**************************************
 *
 *	i s c _ a r r a y _ s e t _ d e s c
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_array_set_desc (status, relation_name, field_name, sql_dtype, 
			   sql_length, dimensions, desc);
}

STATUS ISC_ATTACH_DATABASE (user_status, file_length, file_name, handle, 
			dpb_length, dpb)
    STATUS	*user_status;
    SLONG	GDS_VAL (file_length);
    SCHAR	*file_name;
    ATT		*handle;
    SSHORT	GDS_VAL (dpb_length);
    SCHAR	**dpb;
{
/**************************************
 *
 *	i s c _ a t t a c h _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Attach a database through the first subsystem
 *	that recognizes it.
 *
 **************************************/
return isc_attach_database (user_status, 
	(SSHORT) *file_length, file_name, handle, 
	*dpb_length, *dpb);
}

ISC_MODIFY_DPB ( dpb, dpb_length, type, str, str_len)
    SCHAR	**dpb;
    SSHORT	GDS_VAL (dpb_length);
    SSHORT	GDS_VAL (type);
    SCHAR	*str;
    SLONG	GDS_VAL (str_len);
{
/**************************************
 *
 *	i s c _ m o d i f y  _ d p b
 *
 **************************************
 *
 * Functional description
 *	expand data base parameter block with 
 *	user, password and character set info
 *
 **************************************/
return isc_modify_dpb ( dpb, dpb_length, *type, str, (SSHORT)*str_len);
}

SLONG ISC_FREE (blk)
    SLONG		**blk;
{
/**************************************
 *
 *	g d s _ $ f r e e
 *
 **************************************
 *
 * Functional description
 *	Release a block allocated by gds__alloc.  Return number
 *	of bytes released.
 *
 **************************************/

return gds__free (*blk);
}

STATUS ISC_BLOB_INFO (user_status, blob_handle, item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	i s c _ b l o b _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return isc_blob_info (user_status, blob_handle, (SSHORT) *item_length,
                       items, (SSHORT) *buffer_length, buffer);
}

STATUS ISC_CANCEL_BLOB (user_status, blob_handle)
    STATUS	*user_status;
    BLB		*blob_handle;
{
/**************************************
 *
 *	i s c _ c a n c e l _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/

return isc_cancel_blob (user_status, blob_handle);
}

STATUS ISC_CANCEL_EVENTS (user_status, handle, id)
    STATUS	*user_status;
    ATT		*handle;
    SLONG	*id;
{
/**************************************
 *
 *	i s c _ c a n c e l _ e v e n t s
 *
 **************************************
 *
 * Functional description
 *	Try to cancel an event.
 *
 **************************************/

return isc_cancel_events (user_status, handle, id);
}
 
STATUS ISC_CLOSE (user_status, name)
    STATUS	*user_status;
    TEXT	*name;
{
/**************************************
 *
 *	i s c _ c l o s e
 *
 **************************************
 *
 * Functional description
 *	Close a dynamic SQL cursor.
 *
 **************************************/

return isc_close (user_status, name);
}

STATUS ISC_CLOSE_BLOB (user_status, blob_handle)
    STATUS	*user_status;
    BLB		*blob_handle;
{
/**************************************
 *
 *	i s c _ c l o s e _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/

return isc_close_blob (user_status, blob_handle);
}

STATUS ISC_COMMIT (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	i s c _ c o m m i t
 *
 **************************************
 *
 * Functional description
 *	Commit a transaction.
 *
 **************************************/

return isc_commit_transaction (user_status, tra_handle);
}

STATUS ISC_COMMIT_RETAINING (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	i s c _ c o m m i t _ r e t a i n i n g
 *
 **************************************
 *
 * Functional description
 *	Do a commit retaining.
 *
 **************************************/

return isc_commit_retaining (user_status, tra_handle);
}

STATUS ISC_COMPILE (user_status, db_handle, req_handle, blr_length, blr)
    STATUS	*user_status;
    ATT		*db_handle;
    REQ		*req_handle;
    SLONG	GDS_VAL (blr_length);
    SCHAR	*blr;
{
/**************************************
 *
 *	i s c _ c o m p i l e
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_compile_request (user_status, db_handle, req_handle,
                             (SSHORT) *blr_length, blr);
}

STATUS ISC_COMPILE2 (user_status, db_handle, req_handle, blr_length, blr)
    STATUS	*user_status;
    ATT		*db_handle;
    REQ		*req_handle;
    SLONG	GDS_VAL (blr_length);
    SCHAR	*blr;
{
/**************************************
 *
 *	i s c _ c o m p i l e 2
 *
 **************************************
 *
 * Functional description
 *
 **************************************/

return isc_compile_request2 (user_status, db_handle, req_handle,
                              (SSHORT) *blr_length, blr);
}

STATUS ISC_CREATE_BLOB (user_status, db_handle, tra_handle, blob_handle, blob_id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
{
/**************************************
 *
 *	i s c _ c r e a t e _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return isc_create_blob (user_status, db_handle, tra_handle, blob_handle, blob_id);
}

STATUS ISC_CREATE_BLOB2 (user_status, db_handle, tra_handle, blob_handle, blob_id, bpb_length, bpb)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
    SLONG	GDS_VAL (bpb_length);
    UCHAR	*bpb;
{
/**************************************
 *
 *	i s c _ c r e a t e _ b l o b 2
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return isc_create_blob2 (user_status, db_handle, tra_handle, blob_handle, 
	blob_id,  (SSHORT) *bpb_length, bpb);
}

STATUS ISC_CREATE_DATABASE (user_status, file_length, file_name, handle, 
			dpb_length, dpb, db_type)
    STATUS	*user_status;
    SLONG	GDS_VAL (file_length);
    UCHAR	*file_name;
    ATT		*handle;
    SSHORT	GDS_VAL (dpb_length);
    UCHAR	*dpb;
    SLONG	GDS_VAL (db_type);
{
/**************************************
 *
 *	i s c _ c r e a t e _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Create a nice, squeaky clean database, uncorrupted by user data.
 *
 **************************************/

return isc_create_database (user_status,  (SSHORT) *file_length, file_name, 
	handle,  (SSHORT) *dpb_length, dpb,  (SSHORT) *db_type);
}

STATUS ISC_DATABASE_INFO (user_status, handle, item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    ATT		*handle;
    SLONG 	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	i s c _ d a t a b a s e _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on database object.
 *
 **************************************/

return isc_database_info (user_status, handle, (SSHORT) *item_length,
                           items, (SSHORT) *buffer_length, buffer);
}

STATUS ISC_DDL (user_status, db_handle, tra_handle, length, ddl)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    UCHAR	*ddl;
{
/**************************************
 *
 *	i s c _ d d l
 *
 **************************************
 *
 * Functional description
 *	Do meta-data update.
 *
 **************************************/

return isc_ddl (user_status, db_handle, tra_handle, (SSHORT) *length, ddl);
}

ISC_DECLARE (user_status, statement, cursor)
    STATUS	*user_status;
    TEXT	*statement, *cursor;
{
/**************************************
 *
 *	i s c _ d e c l a r e
 *
 **************************************
 *
 * Functional description
 *	Declare a cursor for a dynamic request.
 *
 **************************************/

return isc_declare (user_status, statement, cursor);
}

void ISC_DECODE_DATE (date, times)
    SLONG	date [2];
    struct tm	*times;
{
/**************************************
 *
 *	i s c _ d e c o d e
 *
 **************************************
 *
 * Functional description
 *	Convert from internal date format to UNIX time structure.
 *
 **************************************/

isc_decode_date (date, times);
}

ISC_DESCRIBE (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d e s c r i b e
 *
 **************************************
 *
 * Functional description
 *	Describe output parameters for a prepared statement.
 *
 **************************************/

return isc_describe (user_status, name, sqlda);
}

ISC_DESCRIBE_BIND (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d e s c r i b e _ b i n d
 *
 **************************************
 *
 * Functional description
 *	Describe input parameters for a prepared statement.
 *
 **************************************/

return isc_describe_bind (user_status, name, sqlda);
}

STATUS ISC_DETACH (user_status, handle)
    STATUS	*user_status;
    ATT		*handle;
{
/**************************************
 *
 *	i s c _ d e t a c h
 *
 **************************************
 *
 * Functional description
 *	Close down a database.
 *
 **************************************/

return isc_detach_database (user_status, handle);
}

STATUS ISC_DROP_DATABASE (user_status, handle)
    STATUS	*user_status;
    ATT		*handle;
{
/**************************************
 *
 *	i s c _ d r o p _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Close down a database.
 *
 **************************************/

return isc_drop_database (user_status, handle);
}
#endif

ISC_DSQL_ALLOCATE (user_status, db_handle, stmt_handle)
    STATUS	*user_status;
    ATT		*db_handle;
    STMT	*stmt_handle;
{
/**************************************
 *
 *	i s c _ d s q l _ a l l o c a t e _ s t a t e m e n t
 *
 **************************************
 *
 * Functional description
 *	Allocate a statement handle.
 *
 **************************************/

return isc_dsql_allocate_statement (user_status, db_handle, stmt_handle);
}

ISC_DSQL_ALLOCATE2 (user_status, db_handle, stmt_handle)
    STATUS	*user_status;
    ATT		*db_handle;
    STMT	*stmt_handle;
{
/**************************************
 *
 *	i s c _ d s q l _ a l l o c _ s t a t e m e n t 2
 *
 **************************************
 *
 * Functional description
 *	Allocate a statement handle.
 *
 **************************************/

return isc_dsql_alloc_statement2 (user_status, db_handle, stmt_handle);
}

ISC_DSQL_DESCRIBE (user_status, stmt_handle, dialect, sqlda)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ d e s c r i b e
 *
 **************************************
 *
 * Functional description
 *	Describe output parameters for a prepared statement.
 *
 **************************************/

return isc_dsql_describe (user_status, stmt_handle, (USHORT) *dialect, sqlda);
}

ISC_DSQL_DESCRIBE_BIND (user_status, stmt_handle, dialect, sqlda)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ d e s c r i b e _ b i n d
 *
 **************************************
 *
 * Functional description
 *	Describe input parameters for a prepared statement.
 *
 **************************************/

return isc_dsql_describe_bind (user_status, stmt_handle, (USHORT) *dialect, sqlda);
}

ISC_DSQL_EXECUTE (user_status, tra_handle, stmt_handle, dialect, sqlda)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ e x e c u t e
 *
 **************************************
 *
 * Functional description
 *	Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_dsql_execute (user_status, tra_handle, stmt_handle, (USHORT) *dialect,
	sqlda);
}

ISC_DSQL_EXECUTE2 (user_status, tra_handle, stmt_handle, dialect, 
	in_sqlda, out_sqlda, sqlda)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*in_sqlda, *out_sqlda;
{
/**************************************
 *
 *      i s c _ d s q l _ e x e c u t e 2
 *
 **************************************
 *
 * Functional description
 *      Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_dsql_execute2 (user_status, tra_handle, stmt_handle, (USHORT) *dialect, in_sqlda, out_sqlda);
}

ISC_DSQL_EXECUTE_M (user_status,
	tra_handle, stmt_handle, blr_length, blr, msg_type, msg_length, msg)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (blr_length), GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*blr, *msg;
{
/**************************************
 *
 *	i s c _ d s q l _ e x e c u t e _ m
 *
 **************************************
 *
 * Functional description
 *	Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_dsql_execute_m (user_status, tra_handle, stmt_handle,
	(USHORT) *blr_length, blr, (USHORT) *msg_type, (USHORT) *msg_length, msg);
}

ISC_DSQL_EXECUTE2_M (user_status, tra_handle, stmt_handle,
	in_blr_length, in_blr, in_msg_type, in_msg_length, in_msg,
	out_blr_length, out_blr, out_msg_type, out_msg_length, out_msg)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (in_blr_length), GDS_VAL (in_msg_type);
    SLONG	GDS_VAL (in_msg_length), GDS_VAL (out_blr_length);
    SLONG	GDS_VAL (out_msg_type), GDS_VAL (out_msg_length);
    SCHAR	*in_blr, *in_msg, *out_blr, *out_msg;
{
/**************************************
 *
 *      i s c _ d s q l _ e x e c u t e 2 _ m
 *
 **************************************
 *
 * Functional description
 *      Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_dsql_execute2_m (user_status, tra_handle, stmt_handle,
	(USHORT) *in_blr_length, in_blr, (USHORT) *in_msg_type,
	(USHORT) *in_msg_length, in_msg, (USHORT) *out_blr_length,
	out_blr, (USHORT) *out_msg_type, (USHORT) *out_msg_length, out_msg);
}

ISC_DSQL_EXECUTE_IMMED (user_status,
	db_handle, tra_handle, length, string, dialect, sqlda)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ e x e c u t e _ i m m e d i a t e
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_execute_immediate (user_status, db_handle, tra_handle,
	(USHORT) *length, string, (USHORT) *dialect, sqlda);
}

ISC_DSQL_EXEC_IMMED2 (user_status,
	db_handle, tra_handle, length, string, dialect, in_sqlda, out_sqlda)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*in_sqlda, *out_sqlda;
{
/**************************************
 *
 *      i s c _ d s q l _ e x e c _ i m m e d 2
 *
 **************************************
 *
 * Functional description
 *      Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_exec_immed2 (user_status, db_handle, tra_handle,
	(USHORT) *length, string, (USHORT) *dialect, in_sqlda, out_sqlda);
}

ISC_DSQL_EXECUTE_IMM_M (user_status, db_handle, tra_handle,
	length, string, dialect, blr_length, blr, msg_type, msg_length, msg)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    SLONG	GDS_VAL (blr_length), GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*blr, *msg;
{
/**************************************
 *
 *	i s c _ d s q l _ e x e c u t e _ i m m e d i a t e _ m
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_execute_immediate_m (user_status, db_handle, tra_handle,
	(USHORT) *length, string, (USHORT) *dialect, (USHORT) *blr_length, blr,
	(USHORT) *msg_type, (USHORT) *msg_length, msg);
}

ISC_DSQL_EXEC_IMMED2_M (user_status, db_handle, tra_handle,
	length, string, dialect,
	in_blr_length, in_blr, in_msg_type, in_msg_length, in_msg,
	out_blr_length, out_blr, out_msg_type, out_msg_length, out_msg)
    STATUS      *user_status;
    ATT         *db_handle;
    TRA         *tra_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    SLONG	GDS_VAL (in_blr_length), GDS_VAL (in_msg_type);
    SLONG	GDS_VAL(in_msg_length), GDS_VAL (out_blr_length);
    SLONG	GDS_VAL (out_msg_type), GDS_VAL (out_msg_length);
    SCHAR        *in_blr, *in_msg, *out_blr, *out_msg;
{
/**************************************
 *
 *      i s c _ d s q l _ e x e c _ i m m e d 2 _ m
 *
 **************************************
 *
 * Functional description
 *      Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_exec_immed2_m (user_status, db_handle, tra_handle,
	(USHORT) *length, string, (USHORT) *dialect, (USHORT) *in_blr_length,
	in_blr, (USHORT) *in_msg_type, (USHORT) *in_msg_length, in_msg,
	(USHORT) *out_blr_length, out_blr, (USHORT) *out_msg_type,
	(USHORT) *out_msg_length, out_msg);
}

ISC_DSQL_FETCH (user_status, stmt_handle, dialect, sqlda)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ f e t c h
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_fetch (user_status, stmt_handle, (USHORT) *dialect, sqlda);
}

#ifdef SCROLLABLE_CURSORS
ISC_DSQL_FETCH2 (user_status, stmt_handle, dialect, sqlda, direction, offset)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
    USHORT	direction;
    SLONG	offset;
{
/**************************************
 *
 *	i s c _ d s q l _ f e t c h 2
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_fetch2 (user_status, stmt_handle, (USHORT) *dialect, sqlda, direction, offset);
}
#endif

ISC_DSQL_FETCH_M (user_status,
	stmt_handle, blr_length, blr, msg_type, msg_length, msg)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (blr_length), GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*blr, *msg;
{
/**************************************
 *
 *	i s c _ d s q l _ f e t c h _ m
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_fetch_m (user_status, stmt_handle, (USHORT) *blr_length, blr,
	(USHORT) *msg_type, (USHORT) *msg_length, msg);
}

#ifdef SCROLLABLE_CURSORS
ISC_DSQL_FETCH2_M (user_status,
	stmt_handle, blr_length, blr, msg_type, msg_length, msg, direction, offset)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (blr_length), GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*blr, *msg;
    USHORT	direction;
    SLONG	offset;
{
/**************************************
 *
 *	i s c _ d s q l _ f e t c h 2 _ m
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_fetch2_m (user_status, stmt_handle, (USHORT) *blr_length, blr,
	(USHORT) *msg_type, (USHORT) *msg_length, msg, direction, offset);
}
#endif

#ifndef APOLLO
ISC_DSQL_FINISH (db_handle)
    SLONG		**db_handle;
{
/**************************************
 *
 *	i s c _ d s q l _ f i n i s h
 *
 **************************************
 *
 * Functional description
 *	Clean up DSQL globals
 *
 **************************************/

return isc_dsql_finish (db_handle);
}
#endif

ISC_DSQL_FREE (user_status, stmt_handle, option)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (option);
{
/*****************************************
 *
 *	i s c _ d s q l _ f r e e _ s t a t e m e n t
 *
 *****************************************
 *
 * Functional Description
 *	release request for an sql statement
 *
 *****************************************/

return isc_dsql_free_statement (user_status, stmt_handle, (USHORT) *option);
}

ISC_DSQL_INSERT (user_status, stmt_handle, dialect, sqlda)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *      i s c _ d s q l _ i n s e r t
 *
 **************************************
 *
 * Functional description
 *      Insert next record into a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_insert (user_status, stmt_handle, (USHORT) *dialect, sqlda);
}

ISC_DSQL_INSERT_M (user_status,
        stmt_handle, blr_length, blr, msg_type, msg_length, msg)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (blr_length), GDS_VAL (msg_type), GDS_VAL (msg_length);
    SCHAR	*blr, *msg;
{
/**************************************
 *
 *      i s c _ d s q l _ i n s e r t _ m
 *
 **************************************
 *
 * Functional description
 *      Insert next record into a dynamic SQL cursor
 *
 **************************************/

return isc_dsql_insert_m (user_status, stmt_handle, (USHORT) *blr_length,
	(USHORT) *msg_type, (USHORT) *msg_length, blr, msg);
}

ISC_DSQL_PREPARE (user_status,
	tra_handle, stmt_handle, length, string, dialect, sqlda)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ d s q l _ p r e p a r e
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_prepare (user_status, tra_handle, stmt_handle, (USHORT) *length,
	string, (USHORT) *dialect, sqlda);
}

ISC_DSQL_PREPARE_M (user_status, tra_handle, stmt_handle,
	length, string, dialect, item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    TRA		*tra_handle;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	i s c _ d s q l _ p r e p a r e _ m
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_dsql_prepare_m (user_status, tra_handle, stmt_handle,
	(USHORT) *length, string, (USHORT) *dialect, (USHORT) *item_length,
	items, (USHORT) *buffer_length, buffer);
}

#ifndef APOLLO
ISC_DSQL_RELEASE (user_status, name)
    STATUS	*user_status;
    TEXT	*name;
{
/**************************************
 *
 *	i s c _ d s q l _ r e l e a s e
 *
 **************************************
 *
 * Functional description
 *	Release request for a dsql statement
 *
 **************************************/

return isc_dsql_release (user_status, name);
}
#endif

ISC_DSQL_SET_CURSOR (user_status, stmt_handle, cursor, type)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SCHAR	*cursor;
    SLONG	GDS_VAL (type);
{
/**************************************
 *
 *	i s c _ d s q l _ s e t _ c u r s o r
 *
 **************************************
 *
 * Functional description
 *	Set a cursor name for a dynamic request.
 *
 **************************************/

return isc_dsql_set_cursor_name (user_status, stmt_handle, cursor, (USHORT) *type);
}

ISC_DSQL_SQL_INFO (user_status, stmt_handle, item_length, items, 
	          buffer_length, buffer)
    STATUS	*user_status;
    STMT	*stmt_handle;
    SLONG	GDS_VAL (item_length), GDS_VAL (buffer_length);
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	i s c _ d s q l _ s q l _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on sql statement.
 *
 **************************************/

return isc_dsql_sql_info (user_status, stmt_handle, (USHORT) *item_length, items,
	(USHORT) *buffer_length, buffer);
}

ISC_EMBED_DSQL_CLOSE (user_status, name)
    STATUS	*user_status;
    SCHAR	*name;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ c l o s e
 *
 **************************************
 *
 * Functional description
 *	Close a dynamic SQL cursor.
 *
 **************************************/

return isc_embed_dsql_close (user_status, name);
}

ISC_EMBED_DSQL_DECLARE (user_status, stmt_name, cursor)
    STATUS	*user_status;
    SCHAR	*stmt_name;
    SCHAR	*cursor;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ d e c l a r e
 *
 **************************************
 *
 * Functional description
 *	Declare a cursor for a dynamic request.
 *
 **************************************/

return isc_embed_dsql_declare (user_status, stmt_name, cursor);
}

ISC_EMBED_DSQL_DESCR (user_status, stmt_name, dialect, sqlda)
    STATUS	*user_status;
    SCHAR	*stmt_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ d e s c r i b e
 *
 **************************************
 *
 * Functional description
 *	Describe output parameters for a prepared statement.
 *
 **************************************/

return isc_embed_dsql_describe (user_status, stmt_name, (USHORT) *dialect, sqlda);
}

ISC_EMBED_DSQL_DESCR_B (user_status, stmt_name, dialect, sqlda)
    STATUS	*user_status;
    SCHAR	*stmt_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ d e s c r i b e _ b i n d
 *
 **************************************
 *
 * Functional description
 *	Describe input parameters for a prepared statement.
 *
 **************************************/

return isc_embed_dsql_describe_bind (user_status, stmt_name, (USHORT) *dialect,
	sqlda);
}

ISC_EMBED_DSQL_EXECUTE (user_status, trans_handle, stmt_name, dialect, SQLDA_PROTOTYPE)
    STATUS	*user_status;
    SLONG	**trans_handle;
    SCHAR	*stmt_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ e x e c u t e
 *
 **************************************
 *
 * Functional description
 *	Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_embed_dsql_execute (user_status, trans_handle, stmt_name,
	(USHORT) *dialect, SQLDA_ARG);
}

ISC_EMBED_DSQL_EXECUTE2 (user_status, trans_handle, stmt_name, dialect,
	in_sqlda, out_sqlda)
    STATUS	*user_status;
    SLONG	**trans_handle;
    SCHAR	*stmt_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*in_sqlda, *out_sqlda;
{
/**************************************
 *
 *      i s c _ e m b e d _ d s q l _ e x e c u t e 2
 *
 **************************************
 *
 * Functional description
 *      Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_embed_dsql_execute2 (user_status, trans_handle, stmt_name,
	(USHORT) *dialect, in_sqlda, out_sqlda);
}

ISC_EMBED_DSQL_EXEC_IMM (user_status, db_handle, trans_handle, length, string, dialect, SQLDA_PROTOTYPE)
    STATUS	*user_status;
    SLONG	**db_handle;
    SLONG	**trans_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ e x e c u t e _ i m m e d
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_embed_dsql_execute_immed (user_status, db_handle, trans_handle,
	(USHORT) *length, string, (USHORT) *dialect, SQLDA_ARG);
}

ISC_EMBED_DSQL_EXEC_IM2 (user_status, db_handle, trans_handle, length,
	string, dialect, in_sqlda, out_sqlda)
    STATUS	*user_status;
    SLONG	**db_handle;
    SLONG	**trans_handle;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*in_sqlda, *out_sqlda;
{
/**************************************
 *
 *      i s c _ e m b e d _ d s q l _ e x e c _ i m m e d 2
 *
 **************************************
 *
 * Functional description
 *      Prepare a statement for execution.
 *
 **************************************/

return isc_embed_dsql_exec_immed2 (user_status, db_handle, trans_handle,
	(USHORT) *length, string, (USHORT) *dialect, in_sqlda, out_sqlda);
}

ISC_EMBED_DSQL_FETCH (user_status, cursor_name, dialect, SQLDA_PROTOTYPE)
    STATUS	*user_status;
    SCHAR	*cursor_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ f e t c h
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_embed_dsql_fetch (user_status, cursor_name, (USHORT) *dialect, SQLDA_ARG);
}

#ifdef SCROLLABLE_CURSORS
ISC_EMBED_DSQL_FETCH2 (user_status, cursor_name, dialect, SQLDA_PROTOTYPE, direction, offset)
    STATUS	*user_status;
    SCHAR	*cursor_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
    USHORT	direction;
    SLONG	offset;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ f e t c h 2
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/

return isc_embed_dsql_fetch2 (user_status, cursor_name, (USHORT) *dialect, SQLDA_ARG, direction, offset);
}
#endif

ISC_EMBED_DSQL_INSERT (user_status, cursor_name, dialect, sqlda)
    STATUS	*user_status;
    SCHAR	*cursor_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
{
/**************************************
 *
 *      i s c _ e m b e d _ d s q l _ i n s e r t
 *
 **************************************
 *
 * Functional description
 *      Insert next record into a dynamic SQL cursor
 *
 **************************************/

return isc_embed_dsql_insert (user_status, cursor_name, (USHORT) *dialect,
	sqlda);
}

ISC_EMBED_DSQL_LENGTH (string, length)
    SCHAR	*string;
    USHORT	*length;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ l e n g t h
 *
 **************************************
 *
 * Functional description
 *	Determine length of a ';' or null terminated string
 *
 **************************************/

return isc_embed_dsql_length (string, length);
}

ISC_EMBED_DSQL_OPEN (user_status, trans_handle, cursor_name, dialect, SQLDA_PROTOTYPE)
    STATUS	*user_status;
    SLONG	**trans_handle;
    SCHAR	*cursor_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ o p e n
 *
 **************************************
 *
 * Functional description
 *	Open a dynamic SQL cursor.
 *
 **************************************/

return isc_embed_dsql_open (user_status, trans_handle, cursor_name,
	(USHORT) *dialect, SQLDA_ARG);
}

ISC_EMBED_DSQL_OPEN2 (user_status, trans_handle, cursor_name, dialect,
	in_sqlda, out_sqlda)
    STATUS	*user_status;
    SLONG	**trans_handle;
    SCHAR	*cursor_name;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*in_sqlda, *out_sqlda;
{
/**************************************
 *
 *      i s c _ e m b e d _ d s q l _ o p e n 2
 *
 **************************************
 *
 * Functional description
 *      Open a dynamic SQL cursor.
 *
 **************************************/

return isc_embed_dsql_open2 (user_status, trans_handle, cursor_name,
	(USHORT) *dialect, in_sqlda, out_sqlda);
}

ISC_EMBED_DSQL_PREPARE (user_status, db_handle, trans_handle, stmt_name, length, string, dialect, SQLDA_PROTOTYPE)
    STATUS	*user_status;
    SLONG	**db_handle;
    SLONG	**trans_handle;
    SCHAR	*stmt_name;
    SLONG	GDS_VAL (length);
    SCHAR	*string;
    SLONG	GDS_VAL (dialect);
    XSQLDA	*sqlda;
#ifdef APOLLO
    SLONG	*sqlda_flag;
#endif
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ p r e p a r e
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/

return isc_embed_dsql_prepare (user_status, db_handle, trans_handle, stmt_name,
	(USHORT) *length, string, (USHORT) *dialect, SQLDA_ARG);
}

ISC_EMBED_DSQL_RELEASE (user_status, stmt_name)
    STATUS	*user_status;
    SCHAR	*stmt_name;
{
/**************************************
 *
 *	i s c _ e m b e d _ d s q l _ r e l e a s e
 *
 **************************************
 *
 * Functional description
 *	Release request for a dsql statement
 *
 **************************************/

return isc_embed_dsql_release (user_status, stmt_name);
}

#ifndef APOLLO
void ISC_ENCODE_DATE (times, date)
    struct tm	*times;
    SLONG	date [2];
{
/**************************************
 *
 *	i s c _ e n c o d e
 *
 **************************************
 *
 * Functional description
 *	Convert from UNIX time structure to internal date format.
 *
 **************************************/

isc_encode_date (times, date);
}

 USHORT ISC_EVENT_BLOCK_A (event_buffer, result_buffer, count, name_buffer)
    UCHAR	**event_buffer, **result_buffer;
    SLONG	GDS_VAL (count);
    UCHAR	**name_buffer;
{
/**************************************
 *
 *	i s c _ e v e n t _ b l o c k _ a 
 *
 **************************************
 *
 * Functional description
 *	Create an initialized event parameter block from a
 *	vector of input arguments. (Ada needs this)
 *	Assume all strings are 31 characters long.
 *	Return the size of the block.
 *
 **************************************/

return isc_event_block_a (event_buffer, result_buffer, (USHORT) *count, name_buffer);
}
#endif

void ISC_EVENT_COUNTS (result_vector, buffer_length, event_buffer, result_buffer)
    ULONG	*result_vector;
    SLONG	GDS_VAL (buffer_length);
    UCHAR	**event_buffer, **result_buffer;
{
/**************************************
 *
 *	i s c _ e v e n t _ c o u n t s
 *
 **************************************
 *
 * Functional description
 *	Get the delta between two events in an event
 *	parameter block.  Used to update isc_events
 *	for GPRE support of events.
 *
 **************************************/

isc_event_counts (result_vector, (SSHORT) *buffer_length, *event_buffer, *result_buffer);
}

#ifndef APOLLO
ISC_EXECUTE (user_status, trans_handle, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    TRA		*trans_handle;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ e x e c u t e
 *
 **************************************
 *
 * Functional description
 *	Execute a non-SELECT dynamic SQL statement.
 *
 **************************************/

return isc_execute (user_status, trans_handle, name, sqlda);
}

ISC_EXECUTE_IMMEDIATE (user_status, db_handle, trans_handle, length, string)
    STATUS	*user_status;
    int		**db_handle, **trans_handle;
    SLONG	*length;
    TEXT	*string;
{
/**************************************
 *
 *	i s c _ e x e c u t e _ i m m e d i a t e
 *
 **************************************
 *
 * Functional description
 *	Prepare a statement for execution.
 *
 **************************************/
USHORT	len;  

len = *length;
return isc_execute_immediate (user_status, db_handle, 
                               trans_handle, &len, string);
}
 
ISC_FETCH (user_status, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ f e t c h
 *
 **************************************
 *
 * Functional description
 *	Fetch next record from a dynamic SQL cursor
 *
 **************************************/
return isc_fetch (user_status, name, sqlda);
}

ISC_FTOF (string, length1, field, length2)
    SCHAR	*string, *field;
    SLONG	GDS_VAL (length1), GDS_VAL (length2);
{
/**************************************
 *
 *	G D S _ f t o f
 *
 **************************************
 *
 * Functional description
 *	Move a fixed length string to a fixed length string.
 *	This is typically generated by the preprocessor to
 *	move strings around.
 *
 **************************************/

isc_ftof (string, (SSHORT) *length1, field, (SSHORT) *length2);
}

STATUS ISC_GET_SEGMENT (user_status, blob_handle, length, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SSHORT	*length; 
    SLONG       GDS_VAL (buffer_length);
    SCHAR	*buffer;
{
/**************************************
 *
 *	i s c _ g e t _ s e g m e n t
 *
 **************************************
 *
 * Functional description
 *	Abort a partially completed blob.
 *
 **************************************/
STATUS	status;
SSHORT	return_length;

status = isc_get_segment (user_status, blob_handle,
	       &return_length,  (SSHORT) *buffer_length, buffer);
*length = return_length;

return status;
}

STATUS ISC_GET_SLICE (user_status, db_handle, tra_handle, array_id, 
			sdl_length, sdl, param_length, param, slice_length, slice, return_length)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA         *tra_handle;
    SLONG	*array_id;
    SLONG	GDS_VAL (sdl_length);
    UCHAR	*sdl;
    SLONG	GDS_VAL (param_length);
    UCHAR	*param;
    SLONG	GDS_VAL (slice_length);
    UCHAR	*slice;
    SLONG	*return_length;
{
/**************************************
 *
 *	i s c _ g e t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *	Snatch a slice of an array.
 *
 **************************************/

return isc_get_slice (user_status, db_handle, tra_handle, array_id, 
	(SSHORT) *sdl_length, sdl, 
	(SSHORT) *param_length, param, 
	*slice_length, slice, 
	return_length);
}

ISC_OPEN (user_status, trans_handle, name, sqlda)
    STATUS	*user_status;
    TEXT	*name;
    TRA		*trans_handle;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ o p e n
 *
 **************************************
 *
 * Functional description
 *	Open a dynamic SQL cursor.
 *
 **************************************/

return isc_open (user_status, trans_handle, name, sqlda);
}

STATUS ISC_OPEN_BLOB (user_status, db_handle, tra_handle, blob_handle, blob_id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
{
/**************************************
 *
 *	i s c _ o p e n _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob.
 *
 **************************************/

return isc_open_blob (user_status, db_handle, tra_handle, blob_handle, blob_id);
}

STATUS ISC_OPEN_BLOB2 (user_status, db_handle, tra_handle, blob_handle, blob_id, bpb_length, bpb)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    BLB		*blob_handle;
    SLONG	*blob_id;
    SLONG	GDS_VAL (bpb_length);
    UCHAR	*bpb;
{
/**************************************
 *
 *	i s c _ o p e n _ b l o b 2
 *
 **************************************
 *
 * Functional description
 *	Open an existing blob (extended edition).
 *
 **************************************/

return isc_open_blob2 (user_status, db_handle, tra_handle, blob_handle,
         blob_id, (SSHORT) *bpb_length, bpb);
}

ISC_PREPARE (user_status, db_handle, trans_handle, name, length, string, sqlda)
    STATUS	*user_status;
    int		**db_handle, **trans_handle;
    TEXT	*name;
    SLONG	*length;
    TEXT	*string;
    XSQLDA	*sqlda;
{
/**************************************
 *
 *	i s c _ p r e p a r e
 *
 **************************************
 *
 * Functional description
 *	Prepare a dsql statement for execution.
 *
 **************************************/ 
USHORT len;

len = *length;

return isc_prepare (user_status, db_handle, trans_handle, name, 
                              &len, string, sqlda);
}

STATUS ISC_PREPARE_TRANS (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	i s c _ p r e p a r e _ t r a n s a c t i o n
 *
 **************************************
 *
 * Functional description
 *	Prepare a transaction for commit.  First 
 *	phase of a two phase commit.
 *
 **************************************/

return isc_prepare_transaction (user_status, tra_handle);
}

STATUS ISC_PREPARE2 (user_status, tra_handle, msg_length, msg)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	GDS_VAL (msg_length);
    UCHAR	*msg;
{
/**************************************
 *
 *	i s c _ p r e p a r e 2
 *
 **************************************
 *
 * Functional description
 *	Prepare a transaction for commit.  First phase of a two
 *	phase commit.
 *
 **************************************/

return isc_prepare_transaction2 (user_status, tra_handle, 
	 (SSHORT) *msg_length, msg);
}

void ISC_PRINT_SQLERROR (sqlcode, status_vector)
    SLONG	GDS_VAL (sqlcode);
    STATUS	*status_vector;
{
/**************************************
 *
 *	i s c _ p r i n t _ s q l _ e r r o r
 *
 **************************************
 *
 * Functional description
 *	Given an sqlcode, give as much info as possible.
 *      Decide whether status is worth mentioning.
 *
 **************************************/

isc_print_sqlerror ((SSHORT) *sqlcode, status_vector);
}

ISC_PRINT_STATUS (status_vector)
    STATUS	*status_vector;
{
/**************************************
 *
 *	i s c _ p r i n t _ s t a t u s
 *
 **************************************
 *
 * Functional description
 *	Print status vector.
 *
 **************************************/

return isc_print_status (status_vector);
}

STATUS ISC_PUT_SEGMENT (user_status, blob_handle, buffer_length, buffer)
    STATUS	*user_status;
    BLB		*blob_handle;
    SSHORT	GDS_VAL (buffer_length);
    SCHAR	*buffer;
{
/**************************************
 *
 *	i s c _ p u t _ s e g m e n t
 *
 **************************************
 *
 * Functional description
 *	Store one piece of a blob
 *
 **************************************/

return isc_put_segment (user_status, blob_handle, *buffer_length, buffer);
}

STATUS ISC_PUT_SLICE (user_status, db_handle, tra_handle, array_id, 
			sdl_length, sdl, param_length, param, slice_length, slice)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	*array_id;
    SLONG	GDS_VAL (sdl_length);
    UCHAR	*sdl;
    SLONG	GDS_VAL (param_length);
    UCHAR	*param;
    SLONG	GDS_VAL (slice_length);
    UCHAR	*slice;
{
/**************************************
 *
 *	i s c _ p u t _ s l i c e
 *
 **************************************
 *
 * Functional description
 *	Snatch a slice of an array.
 *
 **************************************/

return isc_put_slice (user_status, db_handle, tra_handle, array_id, 
	(SSHORT) *sdl_length, sdl, 
	(SSHORT) *param_length, param, 
	*slice_length, slice);
}

void ISC_QTOQ (quad_in, quad_out)
    GDS__QUAD		*quad_in, *quad_out;
{
/**************************************
 *
 *	i s c _ q t o q
 *
 **************************************
 *
 * Functional description
 *	Move a quad value to another quad value.  This
 *      call is generated by the preprocessor when assigning
 *      quad values in FORTRAN.
 *
 **************************************/

isc_qtoq (quad_in, quad_out);
}

STATUS ISC_QUE_EVENTS (user_status, handle, id, length, events, ast, arg)
    STATUS	*user_status;
    ATT		*handle;
    SLONG	*id;
    USHORT	GDS_VAL (length);
    UCHAR	*events;
    int		(*ast)();
    SLONG	arg;
{
/**************************************
 *
 *	i s c _ q u e _ e v e n t s
 *
 **************************************
 *
 * Functional description
 *	Que request for event notification.
 *
 **************************************/

return isc_que_events (user_status, handle, id, 
	(USHORT) *length, events, ast, arg);
}

STATUS ISC_RECEIVE (user_status, req_handle, msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	*msg_type, *msg_length;
    SCHAR	*msg;
    SLONG	*level;
{
/**************************************
 *
 *	i s c _ r e c e i v e
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return isc_receive (user_status, req_handle, 
	(SSHORT) *msg_type, (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS ISC_RECONNECT (user_status, db_handle, tra_handle, length, id)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SLONG	*length;
    UCHAR	*id;
{
/**************************************
 *
 *	i s c _ r e c o n n e c t
 *
 **************************************
 *
 * Functional description
 *	Connect to a transaction in limbo.
 *
 **************************************/

return isc_reconnect_transaction (user_status, db_handle, 
                       tra_handle, (SSHORT) *length, id);
}

STATUS ISC_RELEASE_REQUEST (user_status, req_handle)
    STATUS	*user_status;
    REQ		*req_handle;
{
/**************************************
 *
 *	i s c _ r e l e a s e _ r e q u e s t
 *
 **************************************
 *
 * Functional description
 *	Release a request.
 *
 **************************************/

return isc_release_request (user_status, req_handle);
}

STATUS ISC_REQUEST_INFO (user_status, req_handle, level, item_length, items, 
	          buffer_length, buffer)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	*item_length, *buffer_length;
    SCHAR	*items, *buffer;
    SLONG	*level;
{
/**************************************
 *
 *	i s c _ r e q u e s t _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return isc_request_info (user_status, req_handle, 
	(SSHORT) *level, (SSHORT) *item_length, items, 
	(SSHORT) *buffer_length, buffer);
}

STATUS ISC_ROLLBACK (user_status, tra_handle)
    STATUS	*user_status;
    TRA		*tra_handle;
{
/**************************************
 *
 *	i s c _ r o l l b a c k
 *
 **************************************
 *
 * Functional description
 *	Abort a transaction.
 *
 **************************************/

return isc_rollback_transaction (user_status, tra_handle);
}

STATUS ISC_SEEK_BLOB (user_status, blob_handle, mode, offset, result)
    STATUS	*user_status;
    BLB		*blob_handle;
    SLONG	*mode;
    SLONG	*offset;
    SLONG	*result;
{
/**************************************
 *
 *	i s c _ s e e k _ b l o b
 *
 **************************************
 *
 * Functional description
 *	Seek a blob.
 *
 **************************************/

return isc_seek_blob (user_status, blob_handle, (SSHORT) *mode, *offset, result);
}

STATUS ISC_SEND (user_status, req_handle, msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	*msg_type, *msg_length;
    SCHAR	*msg;
    SLONG	*level;
{
/**************************************
 *
 *	i s c _ s e n d
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return isc_send (user_status, req_handle, (SSHORT) *msg_type,
                  (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS ISC_SQLCODE (user_status)
    STATUS 	*user_status;
{
/**************************************
 *
 *	g d s _  s q l c o d e
 *
 **************************************
 *
 * Functional description
 *	Translate the GDS error code to SQL error code.
 *
 **************************************/
return isc_sqlcode (user_status);
}

STATUS ISC_START_AND_SEND (user_status, req_handle, tra_handle, 
		    msg_type, msg_length, msg, level)
    STATUS	*user_status;
    REQ		*req_handle;
    TRA		*tra_handle;
    SLONG	*msg_type, *msg_length;
    SCHAR	*msg;
    SLONG	*level;
{
/**************************************
 *
 *	i s c _ s t a r t _ a n d _ s e n d
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return isc_start_and_send (user_status, req_handle, tra_handle, 
		    (SSHORT) *msg_type, (SSHORT) *msg_length, msg, (SSHORT) *level);
}

STATUS ISC_START (user_status, req_handle, tra_handle, level)
    STATUS		*user_status;
    register REQ	*req_handle;
    register TRA	*tra_handle;
    SLONG		*level;
{
/**************************************
 *
 *	i s c _ s t a r t
 *
 **************************************
 *
 * Functional description
 *	Get a record from the host program.
 *
 **************************************/

return isc_start_request (user_status, req_handle, tra_handle, (SSHORT) *level);
}

STATUS ISC_START_MULTIPLE (user_status, tra_handle, count, vector)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	GDS_VAL (count);
    TEB		*vector;
{
/**************************************
 *
 *	i s c _ s t a r t _ m u l t i p l e
 *
 **************************************
 *
 * Functional description
 *	Start a transaction.
 *
 **************************************/

return isc_start_multiple (user_status, tra_handle, (SSHORT) *count, vector);
}

STATUS ISC_START_TRANSACTION (
    STATUS	*user_status,
    TRA		*tra_handle,
    SLONG	GDS_VAL (count),
    ...)
{
/**************************************
 *
 *	i s c _ s t a r t _ t r a n s a c t i o n
 *
 **************************************
 *
 * Functional description
 *	Start a transaction.
 *
 **************************************/
TEB	tebs [16], *teb, *end;
va_list	ptr;

teb = tebs;
end = teb + *count;
VA_START (ptr, count);

for (; teb < end; teb++)
    {
    teb->teb_database = va_arg (ptr, ATT*);
    teb->teb_tpb_length = *(va_arg (ptr, int*));
    teb->teb_tpb = va_arg (ptr, UCHAR*);
    }

return isc_start_multiple (user_status, tra_handle,
                (SSHORT) *count, tebs);
}

STATUS ISC_TRANSACT_REQUEST (user_status, db_handle, tra_handle,
	blr_length, blr, in_msg_length, in_msg, out_msg_length, out_msg)
    STATUS	*user_status;
    ATT		*db_handle;
    TRA		*tra_handle;
    SCHAR	*blr;
    SLONG	GDS_VAL (blr_length); 
    SLONG	GDS_VAL (in_msg_length), GDS_VAL (out_msg_length);
    SCHAR	*in_msg, *out_msg;
{
/**************************************
 *
 *	i s c _ t r a n s a c t _ r e q u e s t
 *
 **************************************
 *
 * Functional description
 *	Execute a procedure.
 *
 **************************************/

return isc_transact_request (user_status, db_handle, tra_handle,
	(USHORT) *blr_length, blr,
	(USHORT) *in_msg_length, in_msg, (USHORT) *out_msg_length, out_msg);
}

STATUS ISC_TRANSACTION_INFO (user_status, tra_handle, 
			item_length, items, buffer_length, buffer)
    STATUS	*user_status;
    TRA		*tra_handle;
    SLONG	*item_length, *buffer_length;
    SCHAR	*items, *buffer;
{
/**************************************
 *
 *	i s c _ t r a n s a c t i o n _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Provide information on blob object.
 *
 **************************************/

return isc_transaction_info (user_status, tra_handle, 
	(SSHORT) *item_length, items, 
	(SSHORT) *buffer_length, buffer);
}

STATUS ISC_UNWIND_REQUEST (user_status, req_handle, level)
    STATUS	*user_status;
    REQ		*req_handle;
    SLONG	*level;
{
/**************************************
 *
 *	i s c _ u n w i n d
 *
 **************************************
 *
 * Functional description
 *	Unwind a running request.  This is potentially nasty since it can be called
 *	asynchronously.
 *
 **************************************/

isc_unwind_request (user_status, req_handle, (SSHORT) *level);
return;
}

SLONG ISC_VAX_INTEGER (ptr, length)
    UCHAR	*ptr;
    SLONG	length;
{
/**************************************
 *
 *	i s c _ v a x _ i n t e g e r
 *
 **************************************
 *
 * Functional description
 *	Pick up (and convert) a VAX style integer of length 1, 2, or 4
 *	bytes.
 *
 **************************************/

return isc_vax_integer (ptr, (SSHORT) length);
}

ISC_VERSION (handle, routine, user_arg)
    int		*handle;
    int		(*routine)();
    SCHAR	*user_arg;
{
/**************************************
 *
 *	i s c _ v e r s i o n
 *
 **************************************
 *
 * Functional description
 *	Obtain and print information about a database.
 *
 **************************************/

isc_version (handle, routine, user_arg);
}
#endif

STATUS ISC_WAIT_FOR_EVENT (user_status, handle, length, events, buffer)
    STATUS	*user_status;
    ATT		*handle;
    SLONG	length;
    UCHAR	**events, **buffer;
{
/**************************************
 *
 *	i s c _ w a i t _ f o r _ e v e n t
 *
 **************************************
 *
 * Functional description
 *	Que request for event notification.
 *
 **************************************/

return isc_wait_for_event (user_status, (SSHORT) *handle, length, events, buffer);
}



#ifndef APOLLO
PERF_FORMAT (before, after, string, buffer, buf_len)
    PERF	*before, *after;
    SCHAR	*buffer, *string;
    SSHORT	*buf_len;
{
/**************************************
 *
 *	P E R F _ f o r m a t
 *
 **************************************
 *
 * Functional description
 *	Format a buffer with statistical stuff under control of formatting
 *	string.  Substitute in appropriate stuff.  Return the length of the
 *	formatting output.
 *
 **************************************/

perf_format (before, after, string, buffer, buf_len);
}

PERF_GET_INFO (handle, perf)
    int		**handle;
    PERF	*perf;
{
/**************************************
 *
 *	P E R F _ g e t _ i n f o
 *
 **************************************
 *
 * Functional description
 *	Acquire timing and performance information.  Some info comes
 *	from the system and some from the database.
 *
 **************************************/

perf_get_info (handle, perf);
}

void PERF_REPORT (before, after, buffer, buf_len)
    PERF	*before, *after;
    SCHAR	*buffer;
    SSHORT	*buf_len;
{
/**************************************
 *
 *	p e r f _ r e p o r t
 *
 **************************************
 *
 * Functional description
 *	Report a common set of parameters.
 *
 **************************************/

perf_report (before, after, buffer, buf_len);
}
#endif

