# The contents of this file are subject to the Interbase Public
# License Version 1.0 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy
# of the License at http://www.Inprise.com/IPL.html
#
# Software distributed under the License is distributed on an
# "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
# or implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code was created by Inprise Corporation
# and its predecessors. Portions created by Inprise Corporation are
#
# Copyright (C) 2000 Inprise Corporation
# All Rights Reserved.
# Contributor(s): ______________________________________.
# This script should only be run for 'formal' builds. Other builds should use
# the build_no.h in win_nt/original. (refresh will copy it to JRD)
# the variable BUILD_TYPE can be used for more complex manipulations of the
# the version resource flags, depending on if it is I B or V

BUILD_TYPE=V
MAJOR_VER=6
MINOR_VER=0
REV_NO=0

if ! [ -f last_build ]
then
	echo $0:last_build not found
	exit 1
fi

LASTBUILD=$(cat last_build)
THISBUILD=$(expr ${LASTBUILD} + 1)
PRODUCT_VER_STRING="${MAJOR_VER}"."${MINOR_VER}"."${REV_NO}"."${THISBUILD}"
FILE_VER_STRING='WI-'"${BUILD_TYPE}${MAJOR_VER}"."${MINOR_VER}"."${REV_NO}"."${THISBUILD}"
FILE_VER_NUMBER="${MAJOR_VER}"', '"${MINOR_VER}"', '"${REV_NO}"', '"${THISBUILD}"
echo '/*FILE GENERATED BY BUILD_NO.KSH. DO NOT EDIT*/' > jrd/build_no.h
echo '/*TO CHANGE ANY INFORMATION IN HERE PLEASE*/' >> jrd/build_no.h
echo '/*EDIT BUILD_NO.KSH IN THE BUILD_WIN32 COMPONENT*/' >> jrd/build_no.h
echo '/*FORMAL BUILD NUMBER:'${THISBUILD}'*/' >> jrd/build_no.h
echo '#define PRODUCT_VER_STRING '\"${PRODUCT_VER_STRING}\\\\0\" >> jrd/build_no.h
echo '#define FILE_VER_STRING '\"${FILE_VER_STRING}\\\\0\" >> jrd/build_no.h
echo '#define LICENSE_VER_STRING '\"${FILE_VER_STRING}\" >> jrd/build_no.h
echo '#define FILE_VER_NUMBER '${FILE_VER_NUMBER} >> jrd/build_no.h
echo '#define IB_MAJOR_VER '\"${MAJOR_VER}\" >> jrd/build_no.h
echo '#define IB_MINOR_VER '\"${MINOR_VER}\" >> jrd/build_no.h
echo '#define IB_REV_NO '\"${REV_NO}\" >> jrd/build_no.h
echo '#define IB_BUILD_NO '\"${THISBUILD}\" >> jrd/build_no.h
echo ${THISBUILD} > last_build
