/* The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 *
 * Copyright (C) 2000 Inprise Corporation
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 */
/* This database file is used by GPRE for metadata lookup on behalf of the .e
 * files.
 */
 
SET SQL DIALECT 1; 
 
CREATE DATABASE 'isc.gdb' PAGE_SIZE 1024;

/* Domain definitions */
CREATE DOMAIN COMMENT AS BLOB SUB_TYPE TEXT SEGMENT SIZE 80;
CREATE DOMAIN FIRST_NAME AS VARCHAR(32);
CREATE DOMAIN GID AS INTEGER;
CREATE DOMAIN GROUP_NAME AS VARCHAR(128);
CREATE DOMAIN HOST_KEY AS CHAR(20);
CREATE DOMAIN HOST_NAME AS CHAR(20);
CREATE DOMAIN LAST_NAME AS VARCHAR(32);
CREATE DOMAIN MIDDLE_NAME AS VARCHAR(32);
CREATE DOMAIN PASSWD AS VARCHAR(32);
CREATE DOMAIN PRIVILEGE AS INTEGER;
CREATE DOMAIN SYS_USER_NAME AS VARCHAR(128);
CREATE DOMAIN UID AS INTEGER;
CREATE DOMAIN USER_NAME AS VARCHAR(128);

/* Table: HOST_INFO, Owner: BUILDER */
CREATE TABLE HOST_INFO (HOST_NAME HOST_NAME,
        HOST_KEY HOST_KEY);

/* Table: USERS, Owner: BUILDER */
CREATE TABLE USERS (USER_NAME USER_NAME,
        GROUP_NAME GROUP_NAME,
        UID UID,
        GID GID,
        PASSWD PASSWD,
        PRIVILEGE PRIVILEGE,
        COMMENT COMMENT,
        FIRST_NAME FIRST_NAME,
        MIDDLE_NAME MIDDLE_NAME,
        LAST_NAME LAST_NAME,
        SYS_USER_NAME SYS_USER_NAME,
        FULL_NAME COMPUTED BY (first_name || " " || middle_name || " " || last_name) );

/*  Index definitions for all user tables */
CREATE UNIQUE INDEX USER_NAME_INDEX ON USERS(USER_NAME);



/* Grant permissions for this database */
