/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/*********** Preprocessed module -- do not edit ***************/
/***************** gpre version FB-V6.2.908 Firebird 1.0 **********************/
/*
 *	PROGRAM:	JRD Access Method
 *	MODULE:		ini.e
 *	DESCRIPTION:	Metadata initialization / population
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 * 2001.07.06 Sean Leyne - Code Cleanup, removed "#ifdef READONLY_DATABASE"
 *                         conditionals, as the engine now fully supports
 *                         readonly databases.
 */

#include <stdio.h>
#include <string.h>
#include "../jrd/flags.h"
#include "../jrd/jrd.h"
#include "../jrd/val.h"
#include "../jrd/gds.h"
#include "../jrd/ods.h"
#include "../jrd/btr.h"
#include "../jrd/ids.h"
#include "../jrd/tra.h"
#include "../jrd/trig.h"
#include "../jrd/intl.h"
#include "../jrd/dflt.h"
#include "../jrd/constants.h"
#include "../jrd/ini.h"
#include "../jrd/idx.h"
#include "../jrd/gdsassert.h"
#include "../jrd/all_proto.h"
#include "../jrd/blb_proto.h"
#include "../jrd/cch_proto.h"
#include "../jrd/cmp_proto.h"
#include "../jrd/dfw_proto.h"
#include "../jrd/dpm_proto.h"
#include "../jrd/exe_proto.h"
#include "../jrd/gds_proto.h"
#include "../jrd/idx_proto.h"
#include "../jrd/ini_proto.h"
#include "../jrd/jrd_proto.h"
#include "../jrd/met_proto.h"
#include "../jrd/thd_proto.h"
#include "../jrd/obj.h"
#include "../jrd/acl.h"
#include "../jrd/irq.h"

/*DATABASE
    DB = FILENAME "ODS.RDB";*/
static CONST UCHAR	jrd_0 [100] =
   {	/* blr string */

4,2,4,0,7,0,9,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,7,0,7,0,12,0,
15,'K',12,0,0,2,1,25,0,0,0,24,0,5,0,1,25,0,3,0,24,0,9,0,1,25,
0,4,0,24,0,3,0,1,25,0,5,0,24,0,8,0,1,25,0,6,0,24,0,2,0,1,25,0,
1,0,24,0,1,0,1,25,0,2,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_9 [103] =
   {	/* blr string */

4,2,4,0,7,0,41,3,0,32,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,7,0,7,
0,12,0,15,'K',5,0,0,2,1,25,0,3,0,24,0,8,0,1,25,0,4,0,24,0,13,
0,1,25,0,5,0,24,0,9,0,1,25,0,6,0,24,0,6,0,1,25,0,0,0,24,0,2,0,
1,25,0,1,0,24,0,0,0,1,25,0,2,0,24,0,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_18 [56] =
   {	/* blr string */

4,2,4,0,3,0,41,3,0,32,0,7,0,41,0,0,'Q',0,12,0,15,'K',17,0,0,2,
1,25,0,2,0,24,0,2,0,1,25,0,1,0,24,0,1,0,1,25,0,0,0,24,0,0,0,255,
255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_23 [64] =
   {	/* blr string */

4,2,4,0,4,0,41,3,0,32,0,7,0,7,0,7,0,12,0,15,'K',29,0,0,2,1,25,
0,1,0,24,0,4,0,1,25,0,2,0,24,0,1,0,1,25,0,3,0,24,0,2,0,1,25,0,
0,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_29 [78] =
   {	/* blr string */

4,2,4,0,5,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,7,0,12,0,15,'K',28,
0,0,2,1,25,0,2,0,24,0,5,0,1,25,0,3,0,24,0,8,0,1,25,0,4,0,24,0,
4,0,1,25,0,0,0,24,0,3,0,1,25,0,1,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_36 [150] =
   {	/* blr string */

4,2,4,0,15,0,9,0,41,3,0,32,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,
7,0,7,0,7,0,7,0,7,0,12,0,15,'K',2,0,0,2,1,25,0,2,0,24,0,10,0,
1,41,0,0,0,3,0,24,0,6,0,1,41,0,5,0,4,0,24,0,17,0,1,41,0,7,0,6,
0,24,0,25,0,1,41,0,9,0,8,0,24,0,26,0,1,41,0,11,0,10,0,24,0,11,
0,1,25,0,12,0,24,0,15,0,1,25,0,13,0,24,0,9,0,1,25,0,14,0,24,0,
8,0,1,25,0,1,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_53 [53] =
   {	/* blr string */

4,2,4,0,3,0,41,3,0,32,0,7,0,7,0,12,0,15,'K',20,0,0,2,1,25,0,1,
0,24,0,2,0,1,25,0,2,0,24,0,1,0,1,25,0,0,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_58 [164] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,2,0,41,3,0,32,0,7,0,4,1,3,0,41,3,0,32,0,7,
0,7,0,4,0,2,0,41,3,0,32,0,41,3,0,32,0,12,0,2,7,'C',1,'K',5,0,
0,'G',58,47,24,0,1,0,25,0,1,0,47,24,0,0,0,25,0,0,0,255,2,14,1,
2,1,24,0,2,0,25,1,0,0,1,21,8,0,1,0,0,0,25,1,1,0,1,24,0,8,0,25,
1,2,0,255,17,0,9,13,12,3,18,0,12,2,10,0,1,2,1,25,2,1,0,24,1,8,
0,1,25,2,0,0,24,1,2,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,1,
1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_71 [135] =
   {	/* blr string */

4,2,4,3,1,0,7,0,4,2,2,0,41,3,0,32,0,7,0,4,1,3,0,41,3,0,32,0,7,
0,7,0,4,0,1,0,41,3,0,32,0,12,0,2,7,'C',1,'K',6,0,0,'G',47,24,
0,8,0,25,0,0,0,255,2,14,1,2,1,24,0,14,0,41,1,0,0,2,0,1,21,8,0,
1,0,0,0,25,1,1,0,255,17,0,9,13,12,3,18,0,12,2,10,0,1,2,1,41,2,
0,0,1,0,24,1,14,0,255,255,255,14,1,1,21,8,0,0,0,0,0,25,1,1,0,
255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_83 [42] =
   {	/* blr string */

4,2,4,0,2,0,9,0,41,3,0,32,0,12,0,15,'K',9,0,0,2,1,25,0,0,0,24,
0,1,0,1,25,0,1,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_87 [42] =
   {	/* blr string */

4,2,4,0,2,0,9,0,41,3,0,32,0,12,0,15,'K',9,0,0,2,1,25,0,0,0,24,
0,1,0,1,25,0,1,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_91 [124] =
   {	/* blr string */

4,2,4,0,9,0,41,3,0,32,0,41,3,0,32,0,41,3,0,32,0,41,3,0,32,0,7,
0,7,0,7,0,7,0,41,0,0,7,0,12,0,15,'K',18,0,0,2,1,25,0,4,0,24,0,
7,0,1,25,0,5,0,24,0,6,0,1,41,0,0,0,6,0,24,0,5,0,1,25,0,1,0,24,
0,4,0,1,25,0,2,0,24,0,1,0,1,25,0,7,0,24,0,3,0,1,25,0,8,0,24,0,
2,0,1,25,0,3,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_102 [56] =
   {	/* blr string */

4,2,4,0,3,0,41,3,0,32,0,41,3,0,32,0,7,0,12,0,15,'K',3,0,0,2,1,
25,0,0,0,24,0,1,0,1,25,0,1,0,24,0,0,0,1,25,0,2,0,24,0,2,0,255,
255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_107 [100] =
   {	/* blr string */

4,2,4,0,7,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,7,0,7,0,7,0,12,0,
15,'K',4,0,0,2,1,25,0,2,0,24,0,2,0,1,25,0,3,0,24,0,6,0,1,25,0,
4,0,24,0,9,0,1,25,0,5,0,24,0,5,0,1,25,0,6,0,24,0,3,0,1,25,0,0,
0,24,0,0,0,1,25,0,1,0,24,0,1,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_116 [67] =
   {	/* blr string */

4,2,4,0,4,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,12,0,15,'K',11,0,
0,2,1,25,0,2,0,24,0,4,0,1,25,0,3,0,24,0,1,0,1,25,0,0,0,24,0,2,
0,1,25,0,1,0,24,0,0,0,255,255,76
   };	/* end of blr string */
static CONST UCHAR	jrd_122 [28] =
   {	/* blr string */

4,2,4,0,1,0,7,0,12,0,15,'K',1,0,0,2,1,25,0,0,0,24,0,1,0,255,255,
76
   };	/* end of blr string */
static CONST UCHAR	jrd_125 [104] =
   {	/* blr string */

4,2,4,0,8,0,41,3,0,32,0,41,3,0,32,0,7,0,7,0,7,0,7,0,7,0,7,0,12,
0,15,'K',6,0,0,2,1,41,0,0,0,2,0,24,0,13,0,1,25,0,3,0,24,0,5,0,
1,25,0,4,0,24,0,4,0,1,25,0,5,0,24,0,6,0,1,25,0,6,0,24,0,7,0,1,
25,0,1,0,24,0,8,0,1,25,0,7,0,24,0,3,0,255,255,76
   };	/* end of blr string */


#define PAD(string, field) jrd_vtof (string, field, sizeof (field))
#define MAX_ACL_SIZE    4096
#define DEFAULT_CLASS   "SQL$DEFAULT"

static void	add_generator (TEXT *, BLK *);
static void	add_global_fields (USHORT);
static void	add_index_set (DBB, USHORT, USHORT, USHORT);
static void	add_new_triggers (USHORT, USHORT);
static void	add_relation_fields (USHORT);
static void	add_security_to_sys_rel (TDBB,   TEXT *, TEXT *,
                                                TEXT *, SSHORT);
static void	add_trigger (TEXT *, BLK *, BLK *);
static void	add_user_priv           (TDBB,   TEXT *, TEXT *,
                                                TEXT *, TEXT);
static void	modify_relation_field	(TDBB, UCHAR *,
						UCHAR *, BLK *);
static void	store_generator		(TDBB, GEN *, BLK *);
static void	store_global_field	(TDBB, GFLD *, BLK *);
static void	store_intlnames		(TDBB, DBB);
static void	store_message		(TDBB, TRIGMSG *, BLK *);
static void	store_relation_field	(TDBB, UCHAR *, UCHAR *,
						int, BLK *, int);
static void	store_trigger		(TDBB, TRG *, BLK *);

/* This is the table used in defining triggers; note that
   RDB$TRIGGER_0 was first changed to RDB$TRIGGER_7 to make it easier to
   upgrade a database to support field-level grant.  It has since been
   changed to RDB$TRIGGER_9 to handle SQL security on relations whose
   name is > 27 characters */

static CONST TRG FAR_VARIABLE	triggers [] = {
    "RDB$TRIGGER_1", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
						  3, sizeof (trigger3), trigger3, 0, ODS_8_0,
    "RDB$TRIGGER_8", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
						  5, sizeof (trigger2), trigger2, 0, ODS_8_0,
    "RDB$TRIGGER_9", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
						  1, sizeof (trigger1), trigger1, 0, ODS_8_0,
    "RDB$TRIGGER_2", (UCHAR) nam_trgs, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
				       3, sizeof (trigger4), trigger4, 0, ODS_8_0,
    "RDB$TRIGGER_3", (UCHAR) nam_trgs, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
				       5, sizeof (trigger4), trigger4, 0, ODS_8_0,
    "RDB$TRIGGER_4", (UCHAR) nam_relations, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
					    1, sizeof (trigger5), trigger5, 0, ODS_8_0,
    "RDB$TRIGGER_5", (UCHAR) nam_relations, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					    3, sizeof (trigger6), trigger6, 0, ODS_8_0,
    "RDB$TRIGGER_6", (UCHAR) nam_gens, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
				       1, sizeof (trigger7), trigger7, 0, ODS_8_0,
    "RDB$TRIGGER_26", (UCHAR) nam_rel_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
					      1, sizeof (trigger26), trigger26, 0, ODS_8_0,
    "RDB$TRIGGER_25", (UCHAR) nam_rel_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger25), trigger25, 0, ODS_8_0,
    "RDB$TRIGGER_10", (UCHAR) nam_rel_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger10), trigger10, 0, ODS_8_0,
    "RDB$TRIGGER_11", (UCHAR) nam_rel_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.POST_ERASE*/
					      6, sizeof (trigger11), trigger11, 0, ODS_8_0,
    "RDB$TRIGGER_12", (UCHAR) nam_ref_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
					      1, sizeof (trigger12), trigger12, 0, ODS_8_0,
    "RDB$TRIGGER_13", (UCHAR) nam_ref_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger13), trigger13, 0, ODS_8_0,
    "RDB$TRIGGER_14", (UCHAR) nam_chk_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger14), trigger14, 0, ODS_8_0,
    "RDB$TRIGGER_15", (UCHAR) nam_chk_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger15), trigger15, 0, ODS_8_0,
    "RDB$TRIGGER_16", (UCHAR) nam_chk_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.POST_ERASE*/
					      6, sizeof (trigger16), trigger16, 0, ODS_8_0,
    "RDB$TRIGGER_17", (UCHAR) nam_i_segments, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger17), trigger17, 0, ODS_8_0,
    "RDB$TRIGGER_18", (UCHAR) nam_i_segments, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger18), trigger18, 0, ODS_8_0,
    "RDB$TRIGGER_19", (UCHAR) nam_indices,    /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger19), trigger19, 0, ODS_8_0,
    "RDB$TRIGGER_20", (UCHAR) nam_indices,    /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger20), trigger20, 0, ODS_8_0,
    "RDB$TRIGGER_21", (UCHAR) nam_trgs,       /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger21), trigger21, 0, ODS_8_0,
    "RDB$TRIGGER_22", (UCHAR) nam_trgs,       /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger22), trigger22, 0, ODS_8_0,
    "RDB$TRIGGER_23", (UCHAR) nam_r_fields,   /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
					      5, sizeof (trigger23), trigger23, 0, ODS_8_0,
    "RDB$TRIGGER_24", (UCHAR) nam_r_fields,   /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger24), trigger24, 0, ODS_8_0,
    "RDB$TRIGGER_27", (UCHAR) nam_r_fields,   /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.POST_ERASE*/
					      6, sizeof (trigger27), trigger27, 0, ODS_8_0,
    "RDB$TRIGGER_28", (UCHAR) nam_procedures, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
					      1, sizeof (trigger28), trigger28, 0, ODS_8_0,
    "RDB$TRIGGER_29", (UCHAR) nam_procedures, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
					      3, sizeof (trigger29), trigger29, 0, ODS_8_0,
    "RDB$TRIGGER_30", (UCHAR) nam_exceptions, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
					      1, sizeof (trigger30), trigger30, 0, ODS_8_0,
    "RDB$TRIGGER_31", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_MODIFY*/
						   3, sizeof (trigger31), trigger31, 0, ODS_8_1,
    "RDB$TRIGGER_32", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_ERASE*/
						   5, sizeof (trigger31), trigger31, 0, ODS_8_1,
    "RDB$TRIGGER_33", (UCHAR) nam_user_privileges, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.PRE_STORE*/
						   1, sizeof (trigger31), trigger31, 0, ODS_8_1,
    "RDB$TRIGGER_34", (UCHAR) nam_rel_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.POST_ERASE*/
					      6, sizeof (trigger34), trigger34, TRG_ignore_perm, ODS_8_1,
    "RDB$TRIGGER_35", (UCHAR) nam_chk_constr, /*RDB$TRIGGERS.RDB$TRIGGER_TYPE.POST_ERASE*/
					      6, sizeof (trigger35), trigger35, TRG_ignore_perm, ODS_8_1,
    0, 0, 0, 0, 0, 0
    };


/* this table is used in defining messages for system triggers */

static CONST TRIGMSG FAR_VARIABLE	trigger_messages [] = {
    "RDB$TRIGGER_9",	0,  "grant_obj_notfound",	ODS_8_0,
    "RDB$TRIGGER_9",	1,  "grant_fld_notfound",	ODS_8_0,
    "RDB$TRIGGER_9",	2,  "grant_nopriv",		ODS_8_0,
    "RDB$TRIGGER_9",	3,  "nonsql_security_rel",	ODS_8_0,
    "RDB$TRIGGER_9",	4,  "nonsql_security_fld",	ODS_8_0,
    "RDB$TRIGGER_9",	5,  "grant_nopriv_on_base",	ODS_8_0,
    "RDB$TRIGGER_1",	0,  "existing_priv_mod",	ODS_8_0,
    "RDB$TRIGGER_2",	0,  "systrig_update",		ODS_8_0,
    "RDB$TRIGGER_3",	0,  "systrig_update",		ODS_8_0,
    "RDB$TRIGGER_5",	0,  "not_rel_owner",		ODS_8_0,
    "RDB$TRIGGER_24",	1,  "cnstrnt_fld_rename",	ODS_8_0,
    "RDB$TRIGGER_23",	1,  "cnstrnt_fld_del",		ODS_8_0,
    "RDB$TRIGGER_22",	1,  "check_trig_update",	ODS_8_0,
    "RDB$TRIGGER_21",	1,  "check_trig_del",		ODS_8_0,
    "RDB$TRIGGER_20",	1,  "integ_index_mod",		ODS_8_0,
    "RDB$TRIGGER_20",	2,  "integ_index_deactivate",	ODS_8_0,
    "RDB$TRIGGER_20",	3,  "integ_deactivate_primary",	ODS_8_0,
    "RDB$TRIGGER_19",	1,  "integ_index_del",		ODS_8_0,
    "RDB$TRIGGER_18",	1,  "integ_index_seg_mod",	ODS_8_0,
    "RDB$TRIGGER_17",	1,  "integ_index_seg_del",	ODS_8_0,
    "RDB$TRIGGER_15",	1,  "check_cnstrnt_del",	ODS_8_0,
    "RDB$TRIGGER_14",	1,  "check_cnstrnt_update",	ODS_8_0,
    "RDB$TRIGGER_13",	1,  "ref_cnstrnt_update",	ODS_8_0,
    "RDB$TRIGGER_12",	1,  "ref_cnstrnt_notfound",	ODS_8_0,
    "RDB$TRIGGER_12",	2,  "foreign_key_notfound",	ODS_8_0,
    "RDB$TRIGGER_10",	1,  "primary_key_ref",		ODS_8_0,
    "RDB$TRIGGER_10",	2,  "primary_key_notnull",	ODS_8_0,
    "RDB$TRIGGER_25",	1,  "rel_cnstrnt_update",	ODS_8_0,
    "RDB$TRIGGER_26",	1,  "constaint_on_view",	ODS_8_0,
    "RDB$TRIGGER_26",	2,  "invld_cnstrnt_type",	ODS_8_0,
    "RDB$TRIGGER_26",	3,  "primary_key_exists",	ODS_8_0,
    "RDB$TRIGGER_31",   0,  "no_write_user_priv", 	ODS_8_1,
    "RDB$TRIGGER_32",   0,  "no_write_user_priv", 	ODS_8_1,
    "RDB$TRIGGER_33",   0,  "no_write_user_priv", 	ODS_8_1,
    0, 0, 0, 0
    };


void INI_format (
    TEXT	*owner)
{
   struct {
          TEXT  jrd_118 [32];	/* RDB$TYPE_NAME */
          TEXT  jrd_119 [32];	/* RDB$FIELD_NAME */
          SSHORT jrd_120;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_121;	/* RDB$TYPE */
   } jrd_117;
   struct {
          SSHORT jrd_124;	/* RDB$RELATION_ID */
   } jrd_123;
   struct {
          TEXT  jrd_127 [32];	/* RDB$OWNER_NAME */
          TEXT  jrd_128 [32];	/* RDB$RELATION_NAME */
          SSHORT jrd_129;	/* gds__null_flag */
          SSHORT jrd_130;	/* RDB$DBKEY_LENGTH */
          SSHORT jrd_131;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_132;	/* RDB$FORMAT */
          SSHORT jrd_133;	/* RDB$FIELD_ID */
          SSHORT jrd_134;	/* RDB$RELATION_ID */
   } jrd_126;
/**************************************
 *
 *	I N I _ f o r m a t
 *
 **************************************
 *
 * Functional description
 *	Initialize system relations in the database.
 *	The full complement of metadata should be
 *	stored here.
 *
 **************************************/
TDBB	tdbb;
DBB	dbb;
int	n;
RTYP	*type;
UCHAR	*relfld, *fld;
GFLD	*gfield;
TRG	*trigger;
TRIGMSG	*message;
GEN 	*generator;
TEXT	string [32], *p;
BLK	handle1, handle2;

UCHAR	        *acl, buffer [MAX_ACL_SIZE];
TEXT	        *p_1;
USHORT	        length;

tdbb = GET_THREAD_DATA;
dbb  = tdbb->tdbb_database;

/* Uppercase owner name */

*string = 0;
if (owner && *owner)
    for (p = string; *p++ = UPPER7 (*owner); owner++)
    	;

/* Make sure relations exist already */

for (n = 0; n < (int) rel_MAX; n++)
    DPM_create_relation (tdbb, MET_relation (tdbb, n));

/* Store RELATIONS and RELATION_FIELDS */

handle1 = handle2 = NULL;
for (relfld = relfields; relfld [RFLD_R_NAME]; relfld = fld + 1)
    {
    for (n = 0, fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH)
	if (!fld [RFLD_F_MINOR])
	    {
	    store_relation_field (tdbb, fld, relfld, n, &handle2, TRUE);
	    n++;
	    }

    /*STORE (REQUEST_HANDLE handle1) X IN RDB$RELATIONS*/
    {
    
	/*X.RDB$RELATION_ID*/
	jrd_126.jrd_134 = relfld [RFLD_R_ID];
	PAD (names [relfld [RFLD_R_NAME]], /*X.RDB$RELATION_NAME*/
					   jrd_126.jrd_128);
	/*X.RDB$FIELD_ID*/
	jrd_126.jrd_133 = n;
	/*X.RDB$FORMAT*/
	jrd_126.jrd_132 = 0;
	/*X.RDB$SYSTEM_FLAG*/
	jrd_126.jrd_131 = RDB_system;
	/*X.RDB$DBKEY_LENGTH*/
	jrd_126.jrd_130 = 8;
	/*X.RDB$OWNER_NAME.NULL*/
	jrd_126.jrd_129 = TRUE;
	if (*string)
	    {
	    PAD (string, /*X.RDB$OWNER_NAME*/
			 jrd_126.jrd_127);
	    /*X.RDB$OWNER_NAME.NULL*/
	    jrd_126.jrd_129 = FALSE;
	    }
    /*END_STORE*/
    if (!handle1)
       handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_125, TRUE);
    EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle1, 0, 76, (UCHAR*)&jrd_126);
    };
    }

CMP_release (tdbb, handle1);
CMP_release (tdbb, handle2);
handle1 = handle2 = NULL;

/* Store global FIELDS */

for (gfield = (GFLD*) gfields; gfield->gfld_name; gfield++)
    store_global_field (tdbb, gfield, &handle1);

CMP_release (tdbb, handle1);
handle1 = NULL;

/*STORE (REQUEST_HANDLE handle1) X IN RDB$DATABASE*/
{

    /*X.RDB$RELATION_ID*/
    jrd_123.jrd_124 = (int) USER_DEF_REL_INIT_ID;
/*END_STORE*/
if (!handle1)
   handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_122, TRUE);
EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle1, 0, 2, (UCHAR*)&jrd_123);
}

CMP_release (tdbb, handle1);
handle1 = NULL;

/* Create indices for system relations */
add_index_set (dbb, FALSE, 0, 0);

/* Create parameter types */

handle1 = NULL;

for (type = types; type->rtyp_name; type++)
    /*STORE (REQUEST_HANDLE handle1) X IN RDB$TYPES*/
    {
    
	PAD (names [type->rtyp_field], /*X.RDB$FIELD_NAME*/
				       jrd_117.jrd_119);
	PAD (type->rtyp_name, /*X.RDB$TYPE_NAME*/
			      jrd_117.jrd_118);
	/*X.RDB$TYPE*/
	jrd_117.jrd_121 = type->rtyp_value;
	/*X.RDB$SYSTEM_FLAG*/
	jrd_117.jrd_120 = RDB_system;
    /*END_STORE*/
    if (!handle1)
       handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_116, TRUE);
    EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle1, 0, 68, (UCHAR*)&jrd_117);
    };

CMP_release (tdbb, handle1);

/* Store symbols for international character sets & collations */

store_intlnames (tdbb, dbb);

/* Create generators to be used by system triggers */

handle1 = NULL;
for (generator = generators; generator->gen_name; generator++)
    store_generator (tdbb, generator, &handle1);
CMP_release (tdbb, handle1);

/* store system-defined triggers */

handle1 = NULL;
for (trigger = triggers; trigger->trg_relation; ++trigger)
    store_trigger (tdbb, trigger, &handle1);
CMP_release (tdbb, handle1);

/* store trigger messages to go with triggers */

handle1 = NULL;
for (message = trigger_messages; message->trigmsg_name; ++message)
    store_message (tdbb, message, &handle1);
CMP_release (tdbb, handle1);

DFW_perform_system_work();

add_relation_fields (0);

/*
====================================================================
==
== Add security on RDB$ROLES system table
==
======================================================================
*/

acl = buffer;
*acl++ = ACL_version;
*acl++ = ACL_id_list;
*acl++ = id_person;
p_1    = string;
if (*acl++ = length = strlen (string))
   do *acl++ = *p_1++; while (--length);
*acl++ = ACL_end;
*acl++ = ACL_priv_list;
*acl++ = priv_protect;
*acl++ = priv_control;
*acl++ = priv_delete;
*acl++ = priv_write;
*acl++ = priv_read;
*acl++ = ACL_end;
*acl++ = ACL_id_list;
*acl++ = ACL_end;
*acl++ = ACL_priv_list;
*acl++ = priv_read;
*acl++ = ACL_end;
*acl++ = ACL_end;
length = acl - buffer;

add_security_to_sys_rel (tdbb, string, "RDB$ROLES", buffer, length);

}

USHORT INI_get_trig_flags (
    TEXT        *trig_name)
{
/*********************************************
 *
 *      I N I _ g e t _ t r i g _ f l a g s
 *
 *********************************************
 *
 * Functional description
 *      Return the trigger flags for a system trigger.
 *
 **************************************/
TRG *trig;

for (trig = triggers; trig->trg_length > 0; trig++)
    if (!strcmp(trig->trg_name, trig_name))
        return (trig->trg_flags);

return(0);
}

void INI_init (void)
{
/**************************************
 *
 *	I N I _ i n i t
 *
 **************************************
 *
 * Functional description
 *	Initialize in memory meta data.  Assume that all meta data
 *	fields exist in the database even if this is not the case.
 *	Do not fill in the format length or the address in each
 *	format descriptor.
 *
 **************************************/
DBB	dbb;
REL	relation;
FMT	format;
FLD	*field;
VEC	formats, fields;
int	n;
UCHAR 	*relfld, *fld;
DSC	*desc;
GFLD	*gfield;
TRG	*trigger;
TDBB	tdbb;

tdbb = GET_THREAD_DATA;
dbb = tdbb->tdbb_database;
CHECK_DBB (dbb);

for (relfld = relfields; relfld [RFLD_R_NAME]; relfld = fld + 1)
    {
    relation = MET_relation (tdbb, relfld [RFLD_R_ID]);
    relation->rel_flags |= REL_system;
    relation->rel_name = names [relfld [RFLD_R_NAME]];
    relation->rel_length = strlen (relation->rel_name);
    for (n = 0, fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH)
	n++;

    /* Set a flag if their is a trigger on the relation.  Later we may
       need to compile it. */

    for (trigger = triggers; trigger->trg_relation; trigger++)
	if (relation->rel_name == names [trigger->trg_relation])
	    {
	    relation->rel_flags |= REL_sys_triggers;
	    break;
	    }

    relation->rel_fields = fields = (VEC) ALLOCPV (type_vec, n);
    fields->vec_count = n;
    field = (FLD*) fields->vec_object;
    relation->rel_current_format = format = (FMT) ALLOCPV (type_fmt, n);
    relation->rel_formats = formats = (VEC) ALLOCPV (type_vec, 1);
    formats->vec_count = 1;
    formats->vec_object [0] = (BLK) format;
    format->fmt_count = n;
    desc = format->fmt_desc;

    for (fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH, desc++, field++)
	{
	gfield = &gfields [fld [RFLD_F_ID]];
	desc->dsc_length = gfield->gfld_length;
	desc->dsc_dtype = gfield->gfld_dtype;
	*field = (FLD) ALLOCPV (type_fld, 0);
	(*field)->fld_name = names [fld [RFLD_F_NAME]];
	(*field)->fld_length = strlen ((*field)->fld_name);
	}
    }
}

void INI_init2 (void)
{
/**************************************
 *
 *	I N I _ i n i t 2
 *
 **************************************
 *
 * Functional description
 *	Re-initialize in memory meta data.  Fill in
 *	format 0 based on the minor ODS version of
 *	the database when it was created.
 *
 **************************************/
REL	relation;
FMT	format;
int	n;
UCHAR 	*relfld, *fld;
DSC	*desc;
TDBB	tdbb;
USHORT  major_version, minor_original, id;
register VEC    vector;
DBB     dbb;

tdbb = GET_THREAD_DATA;
dbb  = tdbb->tdbb_database;

major_version  = (SSHORT) dbb->dbb_ods_version;
minor_original = (SSHORT) dbb->dbb_minor_original;
vector         = dbb->dbb_relations;

for (relfld = relfields; relfld [RFLD_R_NAME]; relfld = fld + 1)
    {
    if (relfld [RFLD_R_MINOR] > ENCODE_ODS(major_version, minor_original))
        {
        /*****************************************************
        **
        ** free the space allocated for RDB$ROLES
        **
        ******************************************************/
        id = relfld [RFLD_R_ID];
        relation = vector->vec_object [id];
        ALL_release (relation->rel_current_format);
        ALL_release (relation->rel_formats);
        ALL_release (relation->rel_fields);
        vector->vec_object [id]= NULL;
        for (fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH);
        }
    else
        {
	relation = MET_relation (tdbb, relfld [RFLD_R_ID]);
	format = relation->rel_current_format;

	for (n = 0, fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH)
	    {
	    /* If the ODS is less than 10, then remove all fields named
	     * RDB$FIELD_PRECISION and field RDB$CHARACTER_LENGTH from
	     * relation RDB$FUNCTION_ARGUMENTS , as they were not present
	     * in < 10 ODS
	     */
	    if (fld [RFLD_F_NAME] == nam_f_precision ||
	       (fld [RFLD_F_NAME] == nam_char_length && relfld [RFLD_R_NAME] == nam_args))
	    	{
	    	if (major_version >= ODS_VERSION10)
		    if (!fld [RFLD_F_MINOR])
		    	{
		    	n++;
		    	if (fld [RFLD_F_UPD_MINOR])
			    relation->rel_flags |= REL_force_scan;
		    	}
		    else
		    	relation->rel_flags |= REL_force_scan;
	        }
	    else
	        {
	        if (!fld [RFLD_F_MINOR])
		    {
		    n++;
		    if (fld [RFLD_F_UPD_MINOR])
		    	relation->rel_flags |= REL_force_scan;
		    }
	    	else
		    relation->rel_flags |= REL_force_scan;
	        }
	    }

	relation->rel_fields->vec_count = n;
	format->fmt_count = n;
	format->fmt_length = FLAG_BYTES (n);
	desc = format->fmt_desc;
	for (fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; fld += RFLD_F_LENGTH, desc++)
	    if (n-- > 0)
	    	{
	    	format->fmt_length = MET_align (desc, format->fmt_length);
	    	desc->dsc_address = (UCHAR*) (SLONG) format->fmt_length;
	    	format->fmt_length += desc->dsc_length;
	    	}
        }
    }
}

TRG *INI_lookup_sys_trigger (
    REL		relation,
    TRG		*trigger,
    UCHAR	**blr,
    UCHAR	*trigger_type,
    SCHAR	**trigger_name,
    USHORT      *trig_flags)
{
/**************************************
 *
 *	I N I _ l o o k u p _ s y s _ t r i g g e r
 *
 **************************************
 *
 * Functional description
 *	Lookup the next trigger for a system relation.
 *
 **************************************/

trigger = (trigger) ? trigger + 1 : triggers;

for (; trigger->trg_relation; trigger++)
    if (!strcmp (relation->rel_name, names [trigger->trg_relation]))
	{
	*blr = trigger->trg_blr;
	*trigger_type = trigger->trg_type;
	*trigger_name = trigger->trg_name;
        *trig_flags = trigger->trg_flags;
	return trigger;
	}

return NULL;
}

void INI_update_database (void)
{
/**************************************
 *
 *	I N I _ u p d a t e _ d a t a b a s e
 *
 **************************************
 *
 * Functional description
 *	Perform changes to ODS that were required
 *	since ODS 8 and are dynamically updatable.
 *
 * %% Note %% Update the switch() statement to reflect new major ODS
 *            addition
 **************************************/
DBB	dbb;
HDR	header;
WIN	window;
USHORT	major_version, minor_version;
TDBB	tdbb;

tdbb = GET_THREAD_DATA;
dbb = tdbb->tdbb_database;
CHECK_DBB (dbb);

/* If database is ReadOnly, return without upgrading ODS */
if (dbb->dbb_flags & DBB_read_only)
    return;

/* check out the update version to see if we have work to do */

major_version = (SSHORT) dbb->dbb_ods_version;
minor_version = (SSHORT) dbb->dbb_minor_version;

/*******************************************************************
** when old engine is attaching a newer ODS database, do nothing
********************************************************************/

/* if database ODS is less than the server's, then upgrade */
if (ENCODE_ODS (major_version, minor_version) >= ODS_CURRENT_VERSION)
    return;

/*******************************************************************
** when new engine is attaching an older ODS database
**   perform the necessary modifications
********************************************************************/

if (major_version == ODS_VERSION8)
    {
    /*** NOTE: The following two functions/structures need to understand
               the difference between major ODS versions. The structure
               which holds their information needs to have an additional field
               to define which major ODS version they belong to.
               PENDING WORK.
                 add_global_fields (major_version, minor_version);
                 add_relation_fields (major_version, minor_version);
               Look at add_new_triggers() for reference.
     ***/

    add_global_fields (minor_version);
    add_relation_fields (minor_version);
    }

add_index_set (dbb, TRUE, major_version, minor_version);
add_new_triggers (major_version, minor_version);

    /* if the database was updated; mark it with the current ODS minor
       version so other process will attempt to do so. We mark this after
       doing the update so that no other process can see the new minor
       version but not the update. */

window.win_page = HEADER_PAGE;
window.win_flags = 0;
header= (HDR) CCH_FETCH (tdbb, &window, LCK_write, pag_header);
CCH_MARK (tdbb, &window);

/* Only minor upgrades can occur within a major ODS, define which one
   occured here. */
switch (major_version)
    {
    case ODS_VERSION8:
        header->hdr_ods_minor = ODS_CURRENT8;
        break;
    case ODS_VERSION9:
        header->hdr_ods_minor = ODS_CURRENT9;
        break;
    case ODS_VERSION10:
        header->hdr_ods_minor = ODS_CURRENT10;
        break;
    default:
        /* Make sure we add a new case per new major ODS. Look at code above */
        assert (FALSE);
        header->hdr_ods_minor = minor_version;
        break;
    }

dbb->dbb_minor_version = header->hdr_ods_minor;
CCH_RELEASE (tdbb, &window);

DFW_perform_system_work();
}

static void add_generator (
    TEXT	*generator_name,
    BLK		*handle)
{
/**************************************
 *
 *	a d d _ g e n e r a t o r
 *
 **************************************
 *
 * Functional description
 *	Store a generator of the given name.
 *	This routine is used to upgrade ODS versions.
 *	DO NOT DELETE, even though it is not used
 *	now, since it may be used when we go to 8.1.
 *
 **************************************/
TDBB	tdbb;
GEN	*generator;

tdbb = GET_THREAD_DATA;

/* find the new generator to be stored; assume it exists in the table */

for (generator = generators; strcmp (generator->gen_name, generator_name); generator++)
    ;

store_generator (tdbb, generator, handle);
}

static void add_global_fields (
    USHORT	minor_version)
{
/**************************************
 *
 *	a d d _ g l o b a l _ f i e l d s
 *
 **************************************
 *
 * Functional description
 *	Add any global fields which have a non-zero
 *	update number in the fields table.  That
 *	is, those that have been added since the last
 *	ODS change.
 *
 **************************************/
TDBB	tdbb;
BLK	handle;
GFLD	*gfield;

tdbb = GET_THREAD_DATA;

/* add desired global fields to system relations  */

handle = NULL;
for (gfield = (GFLD*) gfields; gfield->gfld_name; gfield++)
    if (minor_version < gfield->gfld_minor)
	store_global_field (tdbb, gfield, &handle);

if (handle)
    CMP_release (tdbb, handle);

DFW_perform_system_work();
}

static void add_index_set (
    DBB		dbb,
    USHORT	update_ods,
    USHORT	major_version,
    USHORT	minor_version
)
{
   struct {
          TEXT  jrd_104 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_105 [32];	/* RDB$INDEX_NAME */
          SSHORT jrd_106;	/* RDB$FIELD_POSITION */
   } jrd_103;
   struct {
          TEXT  jrd_109 [32];	/* RDB$INDEX_NAME */
          TEXT  jrd_110 [32];	/* RDB$RELATION_NAME */
          SSHORT jrd_111;	/* RDB$INDEX_ID */
          SSHORT jrd_112;	/* RDB$INDEX_INACTIVE */
          SSHORT jrd_113;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_114;	/* RDB$SEGMENT_COUNT */
          SSHORT jrd_115;	/* RDB$UNIQUE_FLAG */
   } jrd_108;
/**************************************
 *
 *	a d d _ i n d e x _ s e t
 *
 **************************************
 *
 * Functional description
 *	Add system indices.  If update_ods is TRUE we are performing
 *	an ODS update, and only add the indices marked as newer than
 *	ODS (major_version,minor_version).
 *
 **************************************/
TDBB	tdbb;
REL	relation;
TEXT	string [32];
struct ini_idx_t		*index;
struct ini_idx_segment_t 	*segment;
IDX	idx;
struct idx_repeat	*tail;
USHORT	position;
FLD	field;
float	selectivity;
BLK	handle1, handle2;
USHORT	n;

tdbb = GET_THREAD_DATA;
handle1 = handle2 = NULL;

for (n = 0; n < SYSTEM_INDEX_COUNT; n++)
    {

    index = &indices [n];

    /* For minor ODS updates, only add indices newer than on-disk ODS */
    if (update_ods &&
	  ((index->ini_idx_version_flag
		<= ENCODE_ODS (major_version, minor_version)) ||
	   (index->ini_idx_version_flag > ODS_CURRENT_VERSION) ||
	   (((USHORT) DECODE_ODS_MAJOR(index->ini_idx_version_flag)) != major_version)))
	/* The DECODE_ODS_MAJOR() is used (in this case) to instruct the server
	   to perform updates for minor ODS versions only within a major ODS */
	continue;

    /*STORE (REQUEST_HANDLE handle1) X IN RDB$INDICES*/
    {
    
	relation = MET_relation (tdbb, index->ini_idx_relid);
	PAD (relation->rel_name, /*X.RDB$RELATION_NAME*/
				 jrd_108.jrd_110);
	sprintf (string, "RDB$INDEX_%d", index->ini_idx_index_id);
	PAD (string, /*X.RDB$INDEX_NAME*/
		     jrd_108.jrd_109);
	/*X.RDB$UNIQUE_FLAG*/
	jrd_108.jrd_115 = index->ini_idx_unique_flag;
	/*X.RDB$SEGMENT_COUNT*/
	jrd_108.jrd_114 = index->ini_idx_segment_count;
	/*X.RDB$SYSTEM_FLAG*/
	jrd_108.jrd_113 = 1;
	/*X.RDB$INDEX_INACTIVE*/
	jrd_108.jrd_112 = 0;

	 /* Store each segment for the index */

	for (position = 0, tail = idx.idx_rpt;
	     position < index->ini_idx_segment_count;
	     position++, tail++)
	    {
	    segment = &index->ini_idx_segment [position];
	    /*STORE (REQUEST_HANDLE handle2) Y IN RDB$INDEX_SEGMENTS*/
	    {
	    
		field = (FLD) relation->rel_fields->vec_object [segment->ini_idx_rfld_id];
		/*Y.RDB$FIELD_POSITION*/
		jrd_103.jrd_106 = position;
		PAD (/*X.RDB$INDEX_NAME*/
		     jrd_108.jrd_109, /*Y.RDB$INDEX_NAME*/
  jrd_103.jrd_105);
		PAD (field->fld_name, /*Y.RDB$FIELD_NAME*/
				      jrd_103.jrd_104);
		tail->idx_field = segment->ini_idx_rfld_id;
		tail->idx_itype = segment->ini_idx_type;
	    /*END_STORE*/
	    if (!handle2)
	       handle2 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_102, TRUE);
	    EXE_start (tdbb, (REQ)handle2, dbb->dbb_sys_trans);
	    EXE_send (tdbb, (REQ)handle2, 0, 66, (UCHAR*)&jrd_103);
	    };
	    }
	idx.idx_count = index->ini_idx_segment_count;
	idx.idx_flags = index->ini_idx_unique_flag;
	IDX_create_index (tdbb, relation, &idx, string, NULL_PTR, NULL_PTR, &selectivity);
	/*X.RDB$INDEX_ID*/
	jrd_108.jrd_111 = idx.idx_id + 1;
    /*END_STORE*/
    if (!handle1)
       handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_107, TRUE);
    EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle1, 0, 74, (UCHAR*)&jrd_108);
    };

    }
if (handle1)
    CMP_release (tdbb, handle1);
if (handle2)
    CMP_release (tdbb, handle2);
}

static void add_new_triggers (
    USHORT major_version,
    USHORT minor_version)
{
/**************************************
 *
 *	a d d _ n e w _ t r i g g e r s
 *
 **************************************
 *
 * Functional description
 *	Store all new ODS 8.x (x > 0) triggers.
 *      The major and minor_version passed in are the ODS versions
 *      before the ODS is upgraded.
 *	This routine is used to upgrade ODS versions.
 *
 **************************************/
TDBB	tdbb;
TRG	*trig;
TRIGMSG	*message;
BLK     handle1, handle2;

tdbb = GET_THREAD_DATA;

handle1 = handle2 = NULL;

/* add all new triggers, that were added since the database was created */
for (trig = triggers; trig->trg_length > 0; trig++)
    if ((trig->trg_ods_version > ENCODE_ODS(major_version, minor_version)) &&
        (DECODE_ODS_MAJOR(trig->trg_ods_version) == major_version))
        store_trigger (tdbb, trig, &handle1);

for (message = trigger_messages; message->trigmsg_name; message++)
    if ((message->trg_ods_version > ENCODE_ODS (major_version, minor_version)) &&
        (DECODE_ODS_MAJOR(message->trg_ods_version) == major_version))
         store_message (tdbb, message, &handle2);

if (handle1)
    CMP_release (tdbb, handle1);
if (handle2)
    CMP_release (tdbb, handle2);
}

static void add_relation_fields (
    USHORT	minor_version)
{
/**************************************
 *
 *	a d d _ r e l a t i o n _ f i e l d s
 *
 **************************************
 *
 * Functional description
 *	Add any local fields which have a non-zero
 *	update number in the relfields table.  That
 *	is, those that have been added since the last
 *	ODS change.
 *
 **************************************/
TDBB	tdbb;
DBB	dbb;
DSC	desc;
BLK	s_handle, m_handle;
UCHAR	*fld, *relfld;
int	n;

tdbb = GET_THREAD_DATA;
dbb  = tdbb->tdbb_database;

/* add desired fields to system relations, forcing a new format version */

s_handle = m_handle = NULL;
for (relfld = relfields; relfld [RFLD_R_NAME]; relfld = fld + 1)
    for (n = 0, fld = relfld + RFLD_RPT; fld [RFLD_F_NAME]; n++, fld += RFLD_F_LENGTH)
	if (minor_version < fld [RFLD_F_MINOR] ||
	    minor_version < fld [RFLD_F_UPD_MINOR])
	    {
	    if (minor_version < fld [RFLD_F_MINOR])
		store_relation_field (tdbb, fld, relfld, n,
					&s_handle, FALSE);
	    else
		modify_relation_field (tdbb, fld, relfld, &m_handle);
	    desc.dsc_dtype = dtype_text;
	    INTL_ASSIGN_DSC (&desc, CS_METADATA, COLLATE_NONE);
	    desc.dsc_address = (UCHAR*) names [relfld [RFLD_R_NAME]];
	    desc.dsc_length = strlen (desc.dsc_address);
	    DFW_post_work (dbb->dbb_sys_trans, dfw_update_format, &desc, 0);
	    }

if (s_handle)
    CMP_release (tdbb, s_handle);
if (m_handle)
    CMP_release (tdbb, m_handle);

DFW_perform_system_work();
}

static void add_security_to_sys_rel (
    TDBB        tdbb,
    TEXT        *user_name,
    TEXT        *rel_name,
    TEXT        *acl,
    SSHORT      acl_length)
{
   struct {
          SSHORT jrd_82;	/* gds__utility */
   } jrd_81;
   struct {
          TEXT  jrd_79 [32];	/* RDB$DEFAULT_CLASS */
          SSHORT jrd_80;	/* gds__null_flag */
   } jrd_78;
   struct {
          TEXT  jrd_75 [32];	/* RDB$DEFAULT_CLASS */
          SSHORT jrd_76;	/* gds__utility */
          SSHORT jrd_77;	/* gds__null_flag */
   } jrd_74;
   struct {
          TEXT  jrd_73 [32];	/* RDB$RELATION_NAME */
   } jrd_72;
   struct {
          GDS__QUAD  jrd_85;	/* RDB$ACL */
          TEXT  jrd_86 [32];	/* RDB$SECURITY_CLASS */
   } jrd_84;
   struct {
          GDS__QUAD  jrd_89;	/* RDB$ACL */
          TEXT  jrd_90 [32];	/* RDB$SECURITY_CLASS */
   } jrd_88;
   struct {
          TEXT  jrd_93 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_94 [32];	/* RDB$RELATION_NAME */
          TEXT  jrd_95 [32];	/* RDB$GRANTOR */
          TEXT  jrd_96 [32];	/* RDB$USER */
          SSHORT jrd_97;	/* RDB$OBJECT_TYPE */
          SSHORT jrd_98;	/* RDB$USER_TYPE */
          SSHORT jrd_99;	/* gds__null_flag */
          SSHORT jrd_100;	/* RDB$GRANT_OPTION */
          TEXT  jrd_101 [7];	/* RDB$PRIVILEGE */
   } jrd_92;
/**************************************
 *
 *      a d d _ s e c u r i t y _ t o _ s y s _ r e l
 *
 **************************************
 *
 * Functional description
 *
 *      Add security to system relations. Only the owner of the
 *      database has SELECT/INSERT/UPDATE/DELETE privileges on
 *      any system relations. Any other users only has SELECT
 *      privilege.
 *
 **************************************/

DBB             dbb;
GDS__QUAD       blob_id_1, blob_id_2;
BLB             blob;
BLK             request;
BLK             handle1;
TEXT            sec_class_name [100];
TEXT	        default_class [32];
SSHORT          cnt;

SET_TDBB (tdbb);
dbb =  tdbb->tdbb_database;

strcpy (sec_class_name, "SQL$");
strcat (sec_class_name, rel_name);

blob = BLB_create (tdbb, dbb->dbb_sys_trans, &blob_id_1);
BLB_put_segment (tdbb, blob, acl, acl_length);
BLB_close (tdbb, blob);

blob = BLB_create (tdbb, dbb->dbb_sys_trans, &blob_id_2);
BLB_put_segment (tdbb, blob, acl, acl_length);
BLB_close (tdbb, blob);

sprintf (default_class, "%s%" QUADFORMAT "d\0", DEFAULT_CLASS,
         DPM_gen_id (tdbb, MET_lookup_generator (tdbb, DEFAULT_CLASS),
         0, (SINT64) 1));

for (cnt = 0; cnt < 6; cnt++)
    {
    handle1 = NULL;

    /*STORE (REQUEST_HANDLE handle1) PRIV IN RDB$USER_PRIVILEGES*/
    {
    
        switch (cnt)
            {
            case 0:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, user_name);
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'S';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 1;
                break;
            case 1:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, user_name);
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'I';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 1;
                break;
            case 2:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, user_name);
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'U';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 1;
                break;
            case 3:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, user_name);
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'D';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 1;
                break;
            case 4:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, user_name);
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'R';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 1;
                break;
            default:
                strcpy (/*PRIV.RDB$USER*/
			jrd_92.jrd_96, "PUBLIC");
                /*PRIV.RDB$PRIVILEGE*/
		jrd_92.jrd_101 [0] = 'S';
                /*PRIV.RDB$GRANT_OPTION*/
		jrd_92.jrd_100  = 0;
                break;
            }
        strcpy (/*PRIV.RDB$GRANTOR*/
		jrd_92.jrd_95, user_name);
        /*PRIV.RDB$PRIVILEGE*/
	jrd_92.jrd_101 [1] = 0;
        strcpy (/*PRIV.RDB$RELATION_NAME*/
		jrd_92.jrd_94, rel_name);
        /*PRIV.RDB$FIELD_NAME.NULL*/
	jrd_92.jrd_99 = TRUE;
        /*PRIV.RDB$USER_TYPE*/
	jrd_92.jrd_98   = obj_user;
        /*PRIV.RDB$OBJECT_TYPE*/
	jrd_92.jrd_97 = obj_relation;
    /*END_STORE*/
    if (!handle1)
       handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_91, TRUE);
    EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle1, 0, 143, (UCHAR*)&jrd_92);
    };

    CMP_release (tdbb, handle1);
    }

handle1 = NULL;

/*STORE (REQUEST_HANDLE handle1)
        CLS IN RDB$SECURITY_CLASSES*/
{

    jrd_vtof (sec_class_name, /*CLS.RDB$SECURITY_CLASS*/
			      jrd_88.jrd_90,
              sizeof (/*CLS.RDB$SECURITY_CLASS*/
		      jrd_88.jrd_90));
    /*CLS.RDB$ACL*/
    jrd_88.jrd_89 = blob_id_1;
/*END_STORE*/
if (!handle1)
   handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_87, TRUE);
EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle1, 0, 40, (UCHAR*)&jrd_88);
};

CMP_release (tdbb, handle1);

handle1 = NULL;

/*STORE (REQUEST_HANDLE handle1)
        CLS IN RDB$SECURITY_CLASSES*/
{

    jrd_vtof (default_class, /*CLS.RDB$SECURITY_CLASS*/
			     jrd_84.jrd_86,
              sizeof (/*CLS.RDB$SECURITY_CLASS*/
		      jrd_84.jrd_86));
    /*CLS.RDB$ACL*/
    jrd_84.jrd_85 = blob_id_2;
/*END_STORE*/
if (!handle1)
   handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_83, TRUE);
EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle1, 0, 40, (UCHAR*)&jrd_84);
};

CMP_release (tdbb, handle1);

handle1 = NULL;

/*FOR (REQUEST_HANDLE handle1) REL IN RDB$RELATIONS
    WITH REL.RDB$RELATION_NAME EQ rel_name*/
{
if (!handle1)
   handle1 = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_71, TRUE);
gds__vtov (rel_name, jrd_72.jrd_73, 32);
EXE_start (tdbb, (REQ)handle1, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)handle1, 0, 32, (UCHAR*)&jrd_72);
while (1)
   {
   EXE_receive (tdbb, (REQ)handle1, 1, 36, (UCHAR*)&jrd_74);
   if (!jrd_74.jrd_76) break;

    /*MODIFY REL USING*/
    {
    
        /*REL.RDB$DEFAULT_CLASS.NULL*/
	jrd_74.jrd_77 = FALSE;
        jrd_vtof (default_class, /*REL.RDB$DEFAULT_CLASS*/
				 jrd_74.jrd_75,
                  sizeof (/*REL.RDB$DEFAULT_CLASS*/
			  jrd_74.jrd_75));
    /*END_MODIFY*/
    gds__vtov (jrd_74.jrd_75, jrd_78.jrd_79, 32);
    jrd_78.jrd_80 = jrd_74.jrd_77;
    EXE_send (tdbb, (REQ)handle1, 2, 34, (UCHAR*)&jrd_78);
    };

/*END_FOR*/
   EXE_send (tdbb, (REQ)handle1, 3, 2, (UCHAR*)&jrd_81);
   }
};

CMP_release (tdbb, handle1);

}

static void add_trigger (
    TEXT	*trigger_name,
    BLK		*handle1,
    BLK		*handle2)
{
/**************************************
 *
 *	a d d _ t r i g g e r
 *
 **************************************
 *
 * Functional description
 *	Store a trigger of the given name.
 *	This routine is used to upgrade ODS versions.
 *	DO NOT DELETE, even though it is not used
 *	now, since it will be used when we go to 8.1.
 *
 **************************************/
TDBB	tdbb;
TRG	*trigger;
TRIGMSG	*message;

tdbb = GET_THREAD_DATA;

/* Find the new trigger to be stored; assume it exists in the table */

for (trigger = triggers; strcmp (trigger->trg_name, trigger_name); trigger++)
    ;

store_trigger (tdbb, trigger, handle1);

/* Look for any related trigger messages */

for (message = trigger_messages; message->trigmsg_name; ++message)
    if (!strcmp (message->trigmsg_name, trigger->trg_name))
	store_message (tdbb, message, handle2);
}

static void modify_relation_field (
    TDBB	tdbb,
    UCHAR	*fld,
    UCHAR	*relfld,
    BLK		*handle)
{
   struct {
          SSHORT jrd_70;	/* gds__utility */
   } jrd_69;
   struct {
          TEXT  jrd_67 [32];	/* RDB$FIELD_SOURCE */
          SSHORT jrd_68;	/* RDB$UPDATE_FLAG */
   } jrd_66;
   struct {
          TEXT  jrd_63 [32];	/* RDB$FIELD_SOURCE */
          SSHORT jrd_64;	/* gds__utility */
          SSHORT jrd_65;	/* RDB$UPDATE_FLAG */
   } jrd_62;
   struct {
          TEXT  jrd_60 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_61 [32];	/* RDB$RELATION_NAME */
   } jrd_59;
/**************************************
 *
 *	m o d i f y _ r e l a t i o n _ f i e l d
 *
 **************************************
 *
 * Functional description
 *	Modify a local field according to the
 *	passed information.  Note that the field id and
 *	field position do not change.
 *
 **************************************/
DBB	dbb;
GFLD	*gfield;

SET_TDBB (tdbb);
dbb  = tdbb->tdbb_database;

/*FOR (REQUEST_HANDLE *handle) X IN RDB$RELATION_FIELDS WITH
    X.RDB$RELATION_NAME EQ names [relfld [RFLD_R_NAME]] AND
    X.RDB$FIELD_NAME EQ names [fld [RFLD_F_NAME]]*/
{
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_58, TRUE);
gds__vtov (names[fld[RFLD_F_NAME]], jrd_59.jrd_60, 32);
gds__vtov (names[relfld[RFLD_R_NAME]], jrd_59.jrd_61, 32);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 64, (UCHAR*)&jrd_59);
while (1)
   {
   EXE_receive (tdbb, (REQ)*handle, 1, 36, (UCHAR*)&jrd_62);
   if (!jrd_62.jrd_64) break;
    /*MODIFY X USING*/
    {
    
	gfield = &gfields [fld [RFLD_F_UPD_ID]];
	PAD (names [gfield->gfld_name], /*X.RDB$FIELD_SOURCE*/
					jrd_62.jrd_63);
	/*X.RDB$UPDATE_FLAG*/
	jrd_62.jrd_65 = fld [RFLD_F_UPDATE];
    /*END_MODIFY*/
    gds__vtov (jrd_62.jrd_63, jrd_66.jrd_67, 32);
    jrd_66.jrd_68 = jrd_62.jrd_65;
    EXE_send (tdbb, (REQ)*handle, 2, 34, (UCHAR*)&jrd_66);
    };
/*END_FOR*/
   EXE_send (tdbb, (REQ)*handle, 3, 2, (UCHAR*)&jrd_69);
   }
};
}

static void store_generator (
    TDBB	tdbb,
    GEN		*generator,
    BLK		*handle)
{
   struct {
          TEXT  jrd_55 [32];	/* RDB$GENERATOR_NAME */
          SSHORT jrd_56;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_57;	/* RDB$GENERATOR_ID */
   } jrd_54;
/**************************************
 *
 *	s t o r e _ g e n e r a t o r
 *
 **************************************
 *
 * Functional description
 *	Store the passed generator according to
 *	the information in the generator block.
 *
 **************************************/
DBB	dbb;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

/*STORE (REQUEST_HANDLE *handle) X IN RDB$GENERATORS*/
{

    PAD (generator->gen_name, /*X.RDB$GENERATOR_NAME*/
			      jrd_54.jrd_55);
    /*X.RDB$GENERATOR_ID*/
    jrd_54.jrd_57 = generator->gen_id;
    /*X.RDB$SYSTEM_FLAG*/
    jrd_54.jrd_56 = RDB_system;
/*END_STORE*/
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_53, TRUE);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 36, (UCHAR*)&jrd_54);
};
}

static void store_global_field (
    TDBB	tdbb,
    GFLD	*gfield,
    BLK		*handle)
{
   struct {
          GDS__QUAD  jrd_38;	/* RDB$DEFAULT_VALUE */
          TEXT  jrd_39 [32];	/* RDB$FIELD_NAME */
          SSHORT jrd_40;	/* RDB$FIELD_TYPE */
          SSHORT jrd_41;	/* gds__null_flag */
          SSHORT jrd_42;	/* gds__null_flag */
          SSHORT jrd_43;	/* RDB$SEGMENT_LENGTH */
          SSHORT jrd_44;	/* gds__null_flag */
          SSHORT jrd_45;	/* RDB$COLLATION_ID */
          SSHORT jrd_46;	/* gds__null_flag */
          SSHORT jrd_47;	/* RDB$CHARACTER_SET_ID */
          SSHORT jrd_48;	/* gds__null_flag */
          SSHORT jrd_49;	/* RDB$FIELD_SUB_TYPE */
          SSHORT jrd_50;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_51;	/* RDB$FIELD_SCALE */
          SSHORT jrd_52;	/* RDB$FIELD_LENGTH */
   } jrd_37;
/**************************************
 *
 *	s t o r e _ g l o b a l _ f i e l d
 *
 **************************************
 *
 * Functional description
 *	Store a global field according to the
 *	passed information.
 *
 **************************************/
DBB		dbb;
TRA		trans;
struct blb	*blob;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

trans = dbb->dbb_sys_trans;

/*STORE (REQUEST_HANDLE *handle) X IN RDB$FIELDS*/
{

    PAD (names [gfield->gfld_name], /*X.RDB$FIELD_NAME*/
				    jrd_37.jrd_39);
    /*X.RDB$FIELD_LENGTH*/
    jrd_37.jrd_52 = gfield->gfld_length;
    /*X.RDB$FIELD_SCALE*/
    jrd_37.jrd_51 = 0;
    /*X.RDB$SYSTEM_FLAG*/
    jrd_37.jrd_50 = RDB_system;
    /*X.RDB$FIELD_SUB_TYPE.NULL*/
    jrd_37.jrd_48 = TRUE;
    /*X.RDB$CHARACTER_SET_ID.NULL*/
    jrd_37.jrd_46 = TRUE;
    /*X.RDB$COLLATION_ID.NULL*/
    jrd_37.jrd_44 = TRUE;
    /*X.RDB$SEGMENT_LENGTH.NULL*/
    jrd_37.jrd_42 = TRUE;
    if (gfield->gfld_dflt_blr)
	{
	blob = BLB_create (tdbb, trans, &/*X.RDB$DEFAULT_VALUE*/
					 jrd_37.jrd_38);
	BLB_put_segment (tdbb, blob, gfield->gfld_dflt_blr, gfield->gfld_dflt_len);
	BLB_close (tdbb, blob);
	/*X.RDB$DEFAULT_VALUE.NULL*/
	jrd_37.jrd_41 = FALSE;
	}
    else
	/*X.RDB$DEFAULT_VALUE.NULL*/
	jrd_37.jrd_41 = TRUE;
    switch (gfield->gfld_dtype)
	{
	case dtype_timestamp:
	    /*X.RDB$FIELD_TYPE*/
	    jrd_37.jrd_40 = (int) blr_timestamp;
	    break;

	case dtype_sql_time:
	    /*X.RDB$FIELD_TYPE*/
	    jrd_37.jrd_40 = (int) blr_sql_time;
	    break;

	case dtype_sql_date:
	    /*X.RDB$FIELD_TYPE*/
	    jrd_37.jrd_40 = (int) blr_sql_date;
	    break;

	case dtype_short:
	case dtype_long:
	case dtype_int64:
	    if (gfield->gfld_dtype == dtype_short)
		/*X.RDB$FIELD_TYPE*/
		jrd_37.jrd_40 = (int) blr_short;
	    else if (gfield->gfld_dtype == dtype_long)
		/*X.RDB$FIELD_TYPE*/
		jrd_37.jrd_40 = (int) blr_long;
	    else
		/*X.RDB$FIELD_TYPE*/
		jrd_37.jrd_40 = (int) blr_int64;
	    if ((gfield->gfld_sub_type == dsc_num_type_numeric) ||
		(gfield->gfld_sub_type == dsc_num_type_decimal))
		{
	        /*X.RDB$FIELD_SUB_TYPE.NULL*/
		jrd_37.jrd_48 = FALSE;
	        /*X.RDB$FIELD_SUB_TYPE*/
		jrd_37.jrd_49 = gfield->gfld_sub_type;
		}
	    break;

	case dtype_double:
	    /*X.RDB$FIELD_TYPE*/
	    jrd_37.jrd_40 = (int) blr_double;
	    break;

	case dtype_text:
	case dtype_varying:
	    if (gfield->gfld_dtype == dtype_text)
	        /*X.RDB$FIELD_TYPE*/
		jrd_37.jrd_40 = (int) blr_text;
	    else
		{
	        /*X.RDB$FIELD_TYPE*/
		jrd_37.jrd_40 = (int) blr_varying;
	        /*X.RDB$FIELD_LENGTH*/
		jrd_37.jrd_52 -= sizeof (USHORT);
		}
	    if (gfield->gfld_sub_type == dsc_text_type_metadata)
		{
    	        /*X.RDB$CHARACTER_SET_ID.NULL*/
		jrd_37.jrd_46 = FALSE;
    	        /*X.RDB$CHARACTER_SET_ID*/
		jrd_37.jrd_47 = CS_METADATA;
    	        /*X.RDB$COLLATION_ID.NULL*/
		jrd_37.jrd_44 = FALSE;
    	        /*X.RDB$COLLATION_ID*/
		jrd_37.jrd_45 = COLLATE_NONE;
	        /*X.RDB$FIELD_SUB_TYPE.NULL*/
		jrd_37.jrd_48 = FALSE;
	        /*X.RDB$FIELD_SUB_TYPE*/
		jrd_37.jrd_49 = gfield->gfld_sub_type;
		}
	    else
		{
    	        /*X.RDB$CHARACTER_SET_ID.NULL*/
		jrd_37.jrd_46 = FALSE;
    	        /*X.RDB$CHARACTER_SET_ID*/
		jrd_37.jrd_47 = CS_NONE;
    	        /*X.RDB$COLLATION_ID.NULL*/
		jrd_37.jrd_44 = FALSE;
    	        /*X.RDB$COLLATION_ID*/
		jrd_37.jrd_45 = COLLATE_NONE;
		}
	    break;

	case dtype_blob:
	    /*X.RDB$FIELD_TYPE*/
	    jrd_37.jrd_40 = (int) blr_blob;
	    /*X.RDB$FIELD_SUB_TYPE.NULL*/
	    jrd_37.jrd_48 = FALSE;
	    /*X.RDB$SEGMENT_LENGTH.NULL*/
	    jrd_37.jrd_42 = FALSE;
	    /*X.RDB$FIELD_SUB_TYPE*/
	    jrd_37.jrd_49 = gfield->gfld_sub_type;
	    /*X.RDB$SEGMENT_LENGTH*/
	    jrd_37.jrd_43 = 80;
	    if (gfield->gfld_sub_type == BLOB_text)
		{
    	        /*X.RDB$CHARACTER_SET_ID.NULL*/
		jrd_37.jrd_46 = FALSE;
    	        /*X.RDB$CHARACTER_SET_ID*/
		jrd_37.jrd_47 = CS_METADATA;
		}
	    break;

	default:
	    assert (FALSE);
	    break;
	}

/*END_STORE*/
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_36, TRUE);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 66, (UCHAR*)&jrd_37);
};
}

static void store_intlnames (
    TDBB	tdbb,
    DBB		dbb)
{
   struct {
          TEXT  jrd_25 [32];	/* RDB$COLLATION_NAME */
          SSHORT jrd_26;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_27;	/* RDB$COLLATION_ID */
          SSHORT jrd_28;	/* RDB$CHARACTER_SET_ID */
   } jrd_24;
   struct {
          TEXT  jrd_31 [32];	/* RDB$DEFAULT_COLLATE_NAME */
          TEXT  jrd_32 [32];	/* RDB$CHARACTER_SET_NAME */
          SSHORT jrd_33;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_34;	/* RDB$BYTES_PER_CHARACTER */
          SSHORT jrd_35;	/* RDB$CHARACTER_SET_ID */
   } jrd_30;
/**************************************
 *
 *	s t o r e _ i n t l n a m e s
 *
 **************************************
 *
 * Functional description
 *	Store symbolic names & information for international
 *	character sets & collations.
 *
 **************************************/
CS_TYPE		*csptr;
COLL_TYPE	*collptr;
BLK		handle;

SET_TDBB (tdbb);

handle = NULL;
for (csptr = cs_types; csptr->init_charset_name; csptr++)
    {
    /*STORE (REQUEST_HANDLE handle) X IN RDB$CHARACTER_SETS USING*/
    {
    
	PAD (csptr->init_charset_name, /*X.RDB$CHARACTER_SET_NAME*/
				       jrd_30.jrd_32);
	PAD (csptr->init_charset_name, /*X.RDB$DEFAULT_COLLATE_NAME*/
				       jrd_30.jrd_31);
	/*X.RDB$CHARACTER_SET_ID*/
	jrd_30.jrd_35     = csptr->init_charset_id;
	/*X.RDB$BYTES_PER_CHARACTER*/
	jrd_30.jrd_34  = csptr->init_charset_bytes_per_char;
	/*X.RDB$SYSTEM_FLAG*/
	jrd_30.jrd_33 = RDB_system;
    /*END_STORE*/
    if (!handle)
       handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_29, TRUE);
    EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle, 0, 70, (UCHAR*)&jrd_30);
    };
    }

CMP_release (tdbb, handle);
handle = NULL;

for (collptr = coll_types; collptr->init_collation_name; collptr++)
    {
    /*STORE (REQUEST_HANDLE handle) X IN RDB$COLLATIONS USING*/
    {
    
	PAD (collptr->init_collation_name, /*X.RDB$COLLATION_NAME*/
					   jrd_24.jrd_25);
	/*X.RDB$CHARACTER_SET_ID*/
	jrd_24.jrd_28 = collptr->init_collation_charset;
	/*X.RDB$COLLATION_ID*/
	jrd_24.jrd_27     = collptr->init_collation_id;
	/*X.RDB$SYSTEM_FLAG*/
	jrd_24.jrd_26 = RDB_system;
    /*END_STORE*/
    if (!handle)
       handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_23, TRUE);
    EXE_start (tdbb, (REQ)handle, dbb->dbb_sys_trans);
    EXE_send (tdbb, (REQ)handle, 0, 38, (UCHAR*)&jrd_24);
    };
    }

CMP_release (tdbb, handle);
handle = NULL;
}

static void store_message (
    TDBB	tdbb,
    TRIGMSG	*message,
    BLK		*handle)
{
   struct {
          TEXT  jrd_20 [32];	/* RDB$TRIGGER_NAME */
          SSHORT jrd_21;	/* RDB$MESSAGE_NUMBER */
          TEXT  jrd_22 [81];	/* RDB$MESSAGE */
   } jrd_19;
/**************************************
 *
 *	s t o r e _ m e s s a g e
 *
 **************************************
 *
 * Functional description
 *	Store system trigger messages.
 *
 **************************************/
DBB	dbb;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

/* store the trigger */

/*STORE (REQUEST_HANDLE *handle) X IN RDB$TRIGGER_MESSAGES*/
{

   PAD (message->trigmsg_name, /*X.RDB$TRIGGER_NAME*/
			       jrd_19.jrd_20);
   /*X.RDB$MESSAGE_NUMBER*/
   jrd_19.jrd_21 = message->trigmsg_number;
   PAD (message->trigmsg_text, /*X.RDB$MESSAGE*/
			       jrd_19.jrd_22);
/*END_STORE*/
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_18, TRUE);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 115, (UCHAR*)&jrd_19);
};
}

static void store_relation_field (
    TDBB	tdbb,
    UCHAR	*fld,
    UCHAR	*relfld,
    int		field_id,
    BLK		*handle,
    int		fmt0_flag)
{
   struct {
          TEXT  jrd_11 [32];	/* RDB$FIELD_SOURCE */
          TEXT  jrd_12 [32];	/* RDB$FIELD_NAME */
          TEXT  jrd_13 [32];	/* RDB$RELATION_NAME */
          SSHORT jrd_14;	/* RDB$UPDATE_FLAG */
          SSHORT jrd_15;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_16;	/* RDB$FIELD_ID */
          SSHORT jrd_17;	/* RDB$FIELD_POSITION */
   } jrd_10;
/**************************************
 *
 *	s t o r e _ r e l a t i o n _ f i e l d
 *
 **************************************
 *
 * Functional description
 *	Store a local field according to the
 *	passed information.
 *
 **************************************/
DBB	dbb;
GFLD	*gfield;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

/*STORE (REQUEST_HANDLE *handle) X IN RDB$RELATION_FIELDS*/
{

    gfield = (fld [RFLD_F_UPD_MINOR] && !fmt0_flag) ?
	&gfields [fld [RFLD_F_UPD_ID]] : &gfields [fld [RFLD_F_ID]];
    PAD (names [relfld [RFLD_R_NAME]], /*X.RDB$RELATION_NAME*/
				       jrd_10.jrd_13);
    PAD (names [fld [RFLD_F_NAME]], /*X.RDB$FIELD_NAME*/
				    jrd_10.jrd_12);
    PAD (names [gfield->gfld_name], /*X.RDB$FIELD_SOURCE*/
				    jrd_10.jrd_11);
    /*X.RDB$FIELD_POSITION*/
    jrd_10.jrd_17 = field_id;
    /*X.RDB$FIELD_ID*/
    jrd_10.jrd_16 = field_id;
    /*X.RDB$SYSTEM_FLAG*/
    jrd_10.jrd_15 = RDB_system;
    /*X.RDB$UPDATE_FLAG*/
    jrd_10.jrd_14 = fld [RFLD_F_UPDATE];
/*END_STORE*/
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_9, TRUE);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 104, (UCHAR*)&jrd_10);
};
}

static void store_trigger (
    TDBB	tdbb,
    TRG		*trigger,
    BLK		*handle)
{
   struct {
          GDS__QUAD  jrd_2;	/* RDB$TRIGGER_BLR */
          TEXT  jrd_3 [32];	/* RDB$RELATION_NAME */
          TEXT  jrd_4 [32];	/* RDB$TRIGGER_NAME */
          SSHORT jrd_5;	/* RDB$FLAGS */
          SSHORT jrd_6;	/* RDB$TRIGGER_TYPE */
          SSHORT jrd_7;	/* RDB$SYSTEM_FLAG */
          SSHORT jrd_8;	/* RDB$TRIGGER_SEQUENCE */
   } jrd_1;
/**************************************
 *
 *	s t o r e _ t r i g g e r
 *
 **************************************
 *
 * Functional description
 *	Store the trigger according to the
 *	information in the trigger block.
 *
 **************************************/
DBB		dbb;
TRA		trans;
DSC		desc;
struct blb	*blob;

SET_TDBB (tdbb);
dbb = tdbb->tdbb_database;

trans = dbb->dbb_sys_trans;

/* indicate that the relation format needs revising */

desc.dsc_dtype = dtype_text;
INTL_ASSIGN_DSC (&desc, CS_METADATA, COLLATE_NONE);
desc.dsc_address = (UCHAR*) names [trigger->trg_relation];
desc.dsc_length = strlen (desc.dsc_address);
DFW_post_work (trans, dfw_update_format, &desc, 0);

/* store the trigger */

/*STORE (REQUEST_HANDLE *handle) X IN RDB$TRIGGERS*/
{

   PAD (trigger->trg_name, /*X.RDB$TRIGGER_NAME*/
			   jrd_1.jrd_4);
   PAD (names [trigger->trg_relation], /*X.RDB$RELATION_NAME*/
				       jrd_1.jrd_3);
   /*X.RDB$TRIGGER_SEQUENCE*/
   jrd_1.jrd_8 = 0;
   /*X.RDB$SYSTEM_FLAG*/
   jrd_1.jrd_7 = RDB_system;
   /*X.RDB$TRIGGER_TYPE*/
   jrd_1.jrd_6 = trigger->trg_type;
   /*X.RDB$FLAGS*/
   jrd_1.jrd_5 = trigger->trg_flags;
   blob = BLB_create (tdbb, trans, &/*X.RDB$TRIGGER_BLR*/
				    jrd_1.jrd_2);
   BLB_put_segment (tdbb, blob, trigger->trg_blr, trigger->trg_length);
   BLB_close (tdbb, blob);
/*END_STORE*/
if (!*handle)
   *handle = (BLK) CMP_compile2 (tdbb, (UCHAR*)jrd_0, TRUE);
EXE_start (tdbb, (REQ)*handle, dbb->dbb_sys_trans);
EXE_send (tdbb, (REQ)*handle, 0, 80, (UCHAR*)&jrd_1);
};
}