/***************************************************************************
                          default.h  -  description
                             -------------------
    begin                : Sa Feb 12 2005
    copyright            : (C) 2005 by Christian Hilgers
    email                : christian@hilgers.ag
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef DEFAULT_H
#define DEFAULT_H

#define VERSION "0.73"

//##############################################################
//Define if you want to rewrite a URL
#define REWRITE URLRewrite["havp"]="www.server-side.de";\
		URLRewrite["www.havp"]="www.server-side.de";

//##############################################################
//Paramter in Configurationfile

//Choose your scanner (only one)


#if 0 == 1
 #define USEKASPERSKY
 #define CONFIGPARAMS "USER","GROUP","SERVERNUMBER","PORT","BIND_ADDRESS","SOURCE_ADDRESS","KEEPBACKBUFFER","TRICKLING","MAXSCANSIZE","WHITELIST","BLACKLIST","PIDFILE","DAEMON","TRANSPARENT","LOG_OKS","ACCESSLOG","ERRORLOG","DISPLAYINITIALMESSAGES","DBRELOAD","SCANTEMPFILE","TEMPLATEPATH","PARENTPROXY","PARENTPORT","MAXSERVERS","AVECLIENT","AVESOCKET"
#else
  #if 0 == 2
    #define USEFPROT
    #define CONFIGPARAMS "USER","GROUP","SERVERNUMBER","PORT","BIND_ADDRESS","SOURCE_ADDRESS","KEEPBACKBUFFER","TRICKLING","MAXSCANSIZE","WHITELIST","BLACKLIST","PIDFILE","DAEMON","TRANSPARENT","LOG_OKS","ACCESSLOG","ERRORLOG","DISPLAYINITIALMESSAGES","DBRELOAD","SCANTEMPFILE","TEMPLATEPATH","PARENTPROXY","PARENTPORT","MAXSERVERS","FPROTSERVER","FPROTPORT"
  #else
   #define USECLAM
   #define CONFIGPARAMS "USER","GROUP","SERVERNUMBER","PORT","BIND_ADDRESS","SOURCE_ADDRESS","KEEPBACKBUFFER","TRICKLING","MAXSCANSIZE","WHITELIST","BLACKLIST","PIDFILE","DAEMON","TRANSPARENT","LOG_OKS","ACCESSLOG","ERRORLOG","DISPLAYINITIALMESSAGES","DBRELOAD","SCANTEMPFILE","TEMPLATEPATH","PARENTPROXY","PARENTPORT","MAXSERVERS"
  #endif
#endif

#define WHITELISTFILE "/usr/local/etc/havp/whitelist"
#define BLACKLISTFILE "/usr/local/etc/havp/blacklist"
#define TEMPLATEDIR  "/usr/local/etc/havp/templates/en"
#define CONFIGFILE "/usr/local/etc/havp/havp.config"


//Change to User and Group
#define USER "nobody"
#define GROUP "nogroup"

//Fork min server
#define SERVERNUMBER 4

//Port of proxy server
#define PORT 8080

//Address to bind to for listening: "NULL" for any, "127.0.0.1" for local, or specific address
#define BIND_ADDRESS "NULL"

//Bytes which will be hold back
#define KEEPBACKBUFFER "50000"

//Trickling Time
#define TRICKLING "0"

//##############################################################
//Configuration not setable in havp.config

//Kaspersky Options - Do not change!!!
#define KASPERSKYOPTION " -s -p "

//Don't let pass when scanner failed
#define CATCHONSCANNERERROR

//Time format
#define TIMEFORMAT "%d/%m/%Y %H:%M:%S"


//RECVTIMEOUT in seconds
#define RECVTIMEOUT    300

//SENDTIMEOUT in seconds
#define SENDTIMEOUT    300

//Display Virusname
#define QUEUE

//Disable Encoding - This is a work around for the IE 5.5 and IE 6.X bug
#define NOENCODING 1

//Maximum client connection waiting for accept
#define MAXCONNECTIONS  1024

//Maximum bytes received in one request
#define MAXRECV   10000

//Maximum logfile line length
#define STRINGLENGTH 1000

//Maximum hardlock size - do not change
#define MAXFILELOCKSIZE 1000000000

//Valid Methods
#define METHODS "GET","POST","HEAD","PUT","SEARCH","PROPFIND","PROPPATCH","MKCOL","MOVE","BMOVE","DELETE","BDELETE","SUBSCRIBE","POLL"

//Maximum length of SCANTEMPFILE
#define MAXSCANTEMPFILELENGTH 200 

// HTML Error String
#define ERROR_DNS       "dns.html"
#define VIRUS_FOUND     "virus.html"
#define ERROR_SCANNER   "scanner.html"
#define ERROR_SERVERDOWN "down.html"
#define ERROR_BODY   "error.html"
#define ERROR_BLACKLIST "blacklist.html"

//CLAMLIB Config -----------------------------------

//scanner options
#define SCANOPTS CL_SCAN_STDOPT | CL_SCAN_ARCHIVE | CL_SCAN_OLE2 | CL_SCAN_PE

//max files scanned in archiv
#define MAXSCANFILES 1000

//maximal archived file size in MB
#define MAXARCHIVFILESIZE 10

//maximal recursion level in Archiv
#define MAXRECLEVEL 5

//maximal compression ratio
#define MAXRATIO 200

//disable memory limit for bzip2 scanner
#define ARCHIVEMEMLIM 0

// CLAMLIB End -------------------------------------


#define ERRORHEADER "HTTP/1.0 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n";

#endif
