//////////////////////////////////////////////////////////////////
//
// gk_wldap.h
//
// Gatekeeper LDAP authentication modules
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
//
// History:
//      2003/10/01      initial version (Franz J Ehrengruber)
//                      based on gkldap.h (Markus Muehlenbernd)
//
//////////////////////////////////////////////////////////////////


#ifndef __gk_wldap_h_
#define __gk_wldap_h_ "#(@) $Id: gk_wldap.h,v 1.1.2.3 2004/05/12 17:46:40 zvision Exp $"

// LDAP authentification
#if defined(HAS_WLDAP)		// shall use WLDAP

#ifndef _PTLIB_H
#include <ptlib.h>
#endif

#include "gk_wldap_link.h"	// link to MS LDAP functions
#include "singleton.h"
#include "h225.h"
#include "h323pdu.h"

class GkLDAP : public Singleton<GkLDAP>{
public:
  
  //  LDAP initialisation must be done with method "Initialize". 
  //  This is necessary because this class is singleton.
  //  LDAP Disconnection/unbind must be done with method "Close". 
  //
  GkLDAP();
  virtual void Initialize(PConfig &);
  virtual void Close(void);
  
  virtual ~GkLDAP();
  
  //  converts a telephonNo from LDAP entry (E.123 string) to
  //  dialedDigits
  //  @returns dialedDigits
  //
  virtual PString convertE123ToDialedDigits(PString e123);  

  //  @returns #the number attributes + values found# if LDAPQuery succeeds.
  //  attribute names + values are returned via param list 'LDAPAnswer * answer'.
  //
  virtual int GkLDAP::getAttributes(const PString      & common_name,    // [ in ] 
							        const PStringArray & attr_names,     // [ in ]
							        LDAPAnswer         * answer);        // [ out ]
	
  // @returns #number of value(s)# associated with an attribute;
  // as per parameter 'LDAPAnswer * answer' and 'attribute_name'.
  // The return parameter 'PStringList attrib_values' holds the 
  // actual attribute values, if any.
  //
  virtual int GkLDAP::getAttributeValues(LDAPAnswer  * answer,         // [ in ]
							             const int   & attribute_name, // [ in ]
								         PStringList & attrib_values); // [ out ]

  //  checks if all given aliases (dialedDigits & H323ID) exist in 
  //  telephonNo and H323ID attributes of an LDAP entry
  //  @returns #TRUE# if aliases are valid
  //
  virtual bool validateAliases(const H225_ArrayOf_AliasAddress & aliases, // [ in ]
							   PString & H323ID_attrvalue,                // [ in ]
							   PStringList & TelephonNo_values);          // [ in ]

private:

  // Methods
  void Destroy(void);

  // Data
  LDAPAttributeNamesClass AN;	// names of the LDAP attributes
  LDAPCtrl *LDAPConn;		    // a HAS-A relation is prefered over a IS-A relation
				                // because one can better steer the parameters  

  PMutex m_usedLock;
};


#endif // HAS_WLDAP

#endif  // __gk_wldap_h_
