/*
 * odbcauth.cxx
 *
 * ODBC based authenticator modules for GNU Gatekeeper. 
 * H.235 based and alias based authentication schemes are supported.
 * Please see docs/odbcdauth.txt for more details.
 *
 * Copyright (c) 2003 - Farooq S. Khan
 *
 * This work is published under the GNU Public License (GPL)
 * see file COPYING for details.
 * We also explicitely grant the right to link this code
 * with the OpenH323 library.

  10/03/2003 - Farooq.Khan created.
*/

#if (_MSC_VER >= 1200)
#pragma warning( disable : 4786 ) // warning about too long debug symbol off
#pragma warning( disable : 4800 ) // warning about forcing value to bool
#endif

#include <ptlib.h>
#include <h323pdu.h>
#include <h225.h>
#include <h235.h>
#include <h235auth.h>
#include "gkauth.h"
#include "gk_const.h"
#include "h323util.h"
#include "stl_supp.h"
#include "RasTbl.h"
#include "Toolkit.h"
#include "gkacct.h"

#ifndef ODBCCON_H
#include "odbcsupp.h"
#endif

 PString GetCallIDString( const H225_GloballyUniqueID & id );



class ODBCAcct : public GkAcctLogger,  private ODBCsupp 
{
	PCLASSINFO(ODBCAcct,GkAcctLogger)
public:
	enum Constants
	{
		/// events recognized by this module
		ODBCAcctEvents = AcctStop
	};
	
	ODBCAcct( 
		/// accounting logger settings
		PConfig& cfg, 
		/// name from Gatekeeper::Acct section
		const PString& acctName,
		const char* cfgSecName = NULL
		);
		
	/// Destroy the accounting logger
	virtual ~ODBCAcct();

	virtual Status LogAcctEvent(
		AcctEvent evt,
		callptr& call
		);


private:
       ODBCsupp * aODBCConn;
		

};

GkAcctFactory<ODBCAcct> ODBC_ACCT("ODBCAcct");

ODBCAcct::ODBCAcct(PConfig& cfg, const PString& acctName,const char* cfgSecName)
	:GkAcctLogger( cfg, acctName, cfgSecName ), ODBCsupp(GkConfig(), ODBCAliasAuthConfigSectionName)
{

	SetSupportedEvents( ODBCAcctEvents );	

	//(GkConfig(),ODBCAliasAuthConfigSectionName);
}

ODBCAcct::~ODBCAcct()
{
}


GkAcctLogger::Status ODBCAcct::LogAcctEvent(
	GkAcctLogger::AcctEvent evt, 
	callptr& call
	)
{
		if( (evt & GetEnabledEvents() & GetSupportedEvents()) == 0 )
		{
			return Ok;	
		}
		
		callptr& xcall = call;

		if( (evt & AcctStop) && call ) 
		{

// Build CDR and insert into DB
	        PString CallNum;
			PString Duration ;
			time_t sTime = call->GetConnectTime();
			time_t eTime = call->GetDisconnectTime();
			sTime = (sTime ? sTime : eTime );
			const PTime startTime(sTime);
			const PTime endTime(eTime);

			char s_datetime[40];
			char e_datetime[40];
            endptr x_Forwarder = call->GetForwarder();            
		    endptr x_Calling = call->GetCallingParty();
			PString pSdate;
            PString pEdate;
			PIPSocket::Address addr;
			PString CalledIPAddress;
			PString CallingIPAddress;
			const char * csqlStmt ;			
			PString x_CallID;

			memset(s_datetime, '\0', sizeof(s_datetime));
			memset(e_datetime, '\0', sizeof(e_datetime));

			strncpy(s_datetime, ((const char *) startTime.AsString()), 25);
			strncpy(e_datetime, ((const char *) endTime.AsString()), 25);
			pSdate.sprintf("%s",s_datetime);
			pEdate.sprintf("%s",e_datetime);
			const endptr  & ep = (x_Forwarder ? x_Forwarder : x_Calling);
			const H225_CallIdentifier  & x_callIdentifier = call->GetCallIdentifier();

			
			CallNum.sprintf("%d",call->GetCallNumber());
			Duration.sprintf("%d",(eTime - sTime));

			if( call->GetCalledAddress() != NULL )
			{
			  if( GetIPFromTransportAddr(*call->GetCalledAddress(),addr)	&& addr.IsValid() )
						CalledIPAddress =  addr.AsString();
			}
            
			if( call->GetCallingAddress() != NULL )
			{
			  if( GetIPFromTransportAddr(*call->GetCallingAddress(),addr)	&& addr.IsValid() )
						CallingIPAddress =  addr.AsString();
			}

			x_CallID = GetCallIDString(x_callIdentifier.m_guid);
			PString sqlStmt = "INSERT INTO T_GK_CDR ";
			sqlStmt +=  "( GATEKEEPER_ID,  CALLNO, CALLID, DURATION , STARTTIME , ENDTIME, CALLERIP, ";
			sqlStmt +=  " CALLERENDID,  CALLEDIP, CALLEDENDID,   DESTINATIONINFO,  SOURCEINFO, GKNAME ) ";    
			sqlStmt +=  " VALUES( 1, ";//GATEKEEPER_ID
			sqlStmt += "'" + CallNum  + "', "; //Callno
			sqlStmt += "'" + x_CallID + "', "; //CALLID
			sqlStmt += "'" + Duration + "', ";// Duration
			sqlStmt += " to_date('" + pSdate + "', 'DY, DD MON YYYY HH24:MI:SS'), ";  //  Start Time 
			sqlStmt += " to_date('" + pEdate + "', 'DY, DD MON YYYY HH24:MI:SS'), ";  //  End Time 
			sqlStmt += "'" + CallingIPAddress + "', ";	// CALLERIP:port .. 
			sqlStmt += "'" + ep->GetEndpointIdentifier().GetValue() + "', ";	// CALLERENDID endpoint_ID .. 
			sqlStmt += "'" + CalledIPAddress + "', ";	// CalledIP:port .. 
			sqlStmt += "'" + call->GetCalledParty()->GetEndpointIdentifier().GetValue() + "', ";	// ClleD endpoint_ID .. 
			sqlStmt += "'" + call->GetDestInfo() + "', ";	// Callerendid
			sqlStmt += "'" + call->GetSourceInfo() + "', ";	// Callerendid
			sqlStmt += "'" + Toolkit::Instance()->GKName() + "' ";	// Callerendid
			sqlStmt += ")";
            PTRACE(2,"ODBC\t Executing SQL  :" << sqlStmt);

/* 
|CallNo|CallId|Duration|Starttime  |Endtime            
|1     |02 b2 |0       |unconnected|Sun, 02 Nov 2003 16:02:55 -0800
|CallerIP           |CallerEndId|CalledIP           |CalledEndId|DestinationInfo
|66.122.206.140:1720|4380_endp  |66.122.206.138:1720|4053_endp  |15103241170:dialedDigits
|SrcInfo                          |GatekeeperID;
|Unknown:h323_ID=UnionCity:h323_ID|OpenH323GK;
*/
            csqlStmt = sqlStmt;			
            ExecThisQuery((SQLCHAR * )csqlStmt);



		}	
		return Ok;	
}

PString GetCallIDString( const H225_GloballyUniqueID & id )
{
	if( id.GetSize() < 16 )
		return PString::Empty();
	
		
	PString h323ConfId;
					
	for( int j = 0, i = 0; j < 4; j++ )
	{
		unsigned long hex = (unsigned)(id[i++])<<24;
		hex |= (unsigned)(id[i++])<<16;
		hex |= (unsigned)(id[i++])<<8;
		hex |= (unsigned)(id[i++]);
							
		h323ConfId += PString( PString::Unsigned, (long)hex, 16 );
	}

	return h323ConfId;
}




