#!/bin/sh

if [ -d NSIS ]
then
  NSISDIR="$PWD/NSIS"
else
  gcc -Wall findnsis.c -o findnsis || exit 1
  NSISDIR=`./findnsis`
  if [ $? != 0 ]
  then
    echo "Could not find the NSIS installation directory."
    echo "If you don't have NSIS, download it from http://nsis.sf.net"
    echo "If you have it installed but it's still not detected,"
    echo "copy the whole NSIS directory here (it will be win32inst/NSIS)."
    exit 1
  fi
fi

mkdir temp
windres --use-temp-file -i resource.rc -I rc -o resource.res -O coff
gcc "-I$NSISDIR/Contrib/ExDLL" -Os -mwindows -shared unwarn.c resource.res -o ./temp/Unwarn.dll
gcc "-I$NSISDIR/Contrib/ExDLL" -Os -mwindows -shared proxysettings.c -o ./temp/ProxySettings.dll
strip ./temp/Unwarn.dll
strip ./temp/ProxySettings.dll
rm -f resource.res
cp ../main/gui/win32/bfilter.exe ./temp/
strip ./temp/bfilter.exe
cp ../main/bfilter-backend.exe ./temp/bfilter-backend.exe
strip ./temp/bfilter-backend.exe
mkdir temp/doc
cp ../doc/*.html temp/doc/
cp ../doc/*.png temp/doc/
./unix2dos.sh bfilter.nsi > temp/bfilter.nsi
./unix2dos.sh lastpage.ini > temp/lastpage.ini
./unix2dos.sh ../COPYING > temp/License.txt
./unix2dos.sh ../conf/config.default > temp/config.default
./unix2dos.sh ../conf/rules > temp/rules
./unix2dos.sh ../conf/rules.local > temp/rules.local

(cd temp && "$NSISDIR/makensis.exe" bfilter.nsi && mv bfilter-*-install.exe ../)

rm -Rf temp
