/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ReactorFactory.h"
#include "Reactor.h"
#include "WFMOReactor.h"
#include "PollReactor.h"
#include "SelectReactor.h"

std::auto_ptr<Reactor>
ReactorFactory::createBestReactor(
	AbstractSynchFactory const& synch_factory, bool wakeup_on_interrupt)
{
	std::auto_ptr<Reactor> res;
#if defined(HAVE_WFMO_REACTOR)
	res.reset(new WFMOReactor(synch_factory));
#elif defined(HAVE_POLL_REACTOR)
	res.reset(new PollReactor(synch_factory, wakeup_on_interrupt));
#else
	res.reset(new SelectReactor(synch_factory, wakeup_on_interrupt));
#endif
	return res;
}
