/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ADVANCEDCONFIGWINDOW_H_
#define ADVANCEDCONFIGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractLogView.h"
#include <ace/config.h>
#include <wx/frame.h>

class Application;
class LogWidget;
class wxString;
class wxPanel;
class wxNotebook;
class wxWindows;
class wxCommandEvent;
class wxNotebookEvent;
class wxActivateEvent;
class wxCloseEvent;

class AdvancedConfigWindow : public wxFrame, private AbstractLogView
{
private:
	AdvancedConfigWindow();
public:
	virtual ~AdvancedConfigWindow();
	
	static void show();
protected: /* to be used by friend classes */
	class Button;
	
	Button* getReloadButton() { return m_pReloadButton; }
	
	Button* getSaveButton() { return m_pSaveButton; }
private:
	class TextControl;
	class Page;
	class ConfigPage;
	class ConfigDefaultPage;
	class UrlsPage;
	class UrlsLocalPage;
	friend class AdvancedConfigWindow::Page;
	
	void onWindowClose(wxCloseEvent& evt);
	
	bool prepareForWindowDestruction();
	
	void onWindowActivate(wxActivateEvent& evt);
	
	Page* getPage(int idx);
	
	Page const* getPage(int idx) const;
	
	Page* getCurrentPage();
	
	bool haveModifiedPages() const;
	
	void updateLineColInfo(Page* page);
	
	void onTabChanged(wxNotebookEvent& evt);
	
	void onTabChanged(Page* page);
	
	void onCaretMove(wxCommandEvent& evt);
	
	void onReload(wxCommandEvent& evt);
	
	void onSave(wxCommandEvent& evt);
	
	void onClearLog(wxCommandEvent& evt);
	
	static AdvancedConfigWindow* m_spInstance;
	bool m_isConstructionFinished;
	wxNotebook* m_pNotebook;
	Button* m_pReloadButton;
	Button* m_pSaveButton;
	LogWidget* m_pLogWidget;
	long m_caretLine;
	long m_caretCol;
	
	DECLARE_EVENT_TABLE()
};

#endif
