/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUGAGENT_H_
#define DEBUGAGENT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AbstractDebugAgent.h"

class InterthreadCommandQueue;

class DebugAgent :
	public AbstractDebugAgent,
	private NonCopyable
{
public:
	DebugAgent(InterthreadCommandQueue& command_queue);
	
	virtual ~DebugAgent();
	
	virtual InterthreadCommandQueue& getCommandQueue();
	
	virtual void clientConnectionBegin(ACE_thread_t thread_id);
	
	virtual void clientConnectionEnd(ACE_thread_t thread_id);
	
	virtual void registerClientRequest(ACE_thread_t thread_id,
		int request_id, std::string request_url);
	
	virtual void httpMessageBegin(
		ACE_thread_t thread_id, int request_id,
		HttpMessageType type, std::string const& headers);
	
	virtual void httpMessageEnd(
		ACE_thread_t thread_id, HttpMessageType type, bool error);
	
	virtual void logMessage(ACE_thread_t thread_id, std::string const& msg);
	
	virtual void logTraffic(ACE_thread_t thread_id,
		SplittableBuffer& traf, TrafficDirection dir);
private:
	InterthreadCommandQueue& m_rCommandQueue;
};

#endif
