/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AutoScrollingWindow.h"
#include <gtkmm/adjustment.h>

AutoScrollingWindow::AutoScrollingWindow()
:	m_isAtBottom(true)
{
	get_vadjustment()->signal_changed().connect(
		sigc::mem_fun(*this, &AutoScrollingWindow::onVAdjustmentChanged)
	);
	get_vadjustment()->signal_value_changed().connect(
		sigc::mem_fun(*this, &AutoScrollingWindow::onVAdjustmentValueChanged)
	);
}

AutoScrollingWindow::~AutoScrollingWindow()
{
}

void
AutoScrollingWindow::onVAdjustmentChanged()
{
	Gtk::Adjustment* adj = get_vadjustment();
	if (m_isAtBottom) {
		adj->set_value(adj->get_upper() - adj->get_page_size());
		adj->value_changed();
	}
}

void
AutoScrollingWindow::onVAdjustmentValueChanged()
{
	Gtk::Adjustment* adj = get_vadjustment();
	m_isAtBottom = (adj->get_value() >= adj->get_upper() - adj->get_page_size());
}
