/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef URLPATTERNS_H_
#define URLPATTERNS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include <deque>
#include <utility>

class BString;
class TextPattern;

class UrlPatterns
{
public:
	enum Substitution {
		NO_SUBSTITUTION = 0, EMPTY_HTML,
		EMPTY_IMAGE, EMPTY_FLASH, EMPTY_JS
	};
	typedef IntrusivePtr<TextPattern const> PatternPtr;
	
	UrlPatterns();
	
	UrlPatterns(UrlPatterns const& other);
	
	~UrlPatterns();
	
	UrlPatterns& operator=(UrlPatterns const& other);
	
	void clear();
	
	void addForbidPattern(PatternPtr const& pattern);
	
	void addAllowPattern(PatternPtr const& pattern);
	
	void addSubstitutionPattern(PatternPtr const& pattern, Substitution subst);
	
	void addHintPattern(PatternPtr const& pattern, int hint);
	
	bool isForbidden(BString const& subj) const;
	
	bool isExplicitlyAllowed(BString const& subj) const;
	
	Substitution getSubstitutionFor(BString const& subj) const;
	
	int getHintFor(BString const& subj) const;
private:
	typedef std::deque<PatternPtr> ForbidPatterns;
	typedef std::deque<PatternPtr> AllowPatterns;
	typedef std::deque<std::pair<PatternPtr, Substitution> > SubstPatterns;
	typedef std::deque<std::pair<PatternPtr, int> > HintPatterns;
	
	ForbidPatterns m_forbidPatterns;
	AllowPatterns m_allowPatterns;
	SubstPatterns m_substPatterns;
	HintPatterns m_hintPatterns;
};

#endif
