/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TEXTPATTERN_H_
#define TEXTPATTERN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RefCountable.h"
#include "RefCounter.h"
#include <ace/Synch_Traits.h>
#include <boost/regex.hpp>
#include <string>

class TextPattern : public RefCountable<RefCounter<ACE_MT_SYNCH> >
{
public:
	enum InvalidTag { MAKE_INVALID };
	
	TextPattern(std::string const& source, InvalidTag);
	
	TextPattern(std::string const& source, boost::regex::flag_type flags);
	
	// Member-wise copying is OK	
	
	std::string const& source() const { return m_source; }
	
	boost::regex const& regex() const { return m_regex; }
	
	bool isValid() const { return m_isValid; }
	
	void swap(TextPattern& other);
private:
	static std::string globToRegex(std::string const& glob);
	
	std::string m_source;
	boost::regex m_regex;
	bool m_isValid;
};


inline void swap(TextPattern& o1, TextPattern& o2)
{
	o1.swap(o2);
}

#endif
