/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef RESPONSEFILTERBASE_H_
#define RESPONSEFILTERBASE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractResponseFilter.h"
#include "ResponseFilterChain.h"
#include "ResponseErrorInitiator.h"
#include "IntrusivePtr.h"
#include "ErrorDescriptor.h"
#include "HttpResponseMetadata.h"
#include <memory>

class AsyncResponseHandler;
class HttpRequestMetadata;
class SplittableBuffer;

class ResponseFilterBase : public AbstractResponseFilter
{
public:
	ResponseFilterBase(ResponseFilterChain& chain);
	
	virtual ~ResponseFilterBase();
protected:
	void outputMetadata(std::auto_ptr<HttpResponseMetadata> metadata);
	
	void outputBodyData(SplittableBuffer& data, bool eof);
	
	void raiseError(std::auto_ptr<ErrorDescriptor> edesc);
	
	bool isErrorRaised() const;
	
	ResponseFilterChain& getFilterChain() { return m_rChain; }
	
	ResponseFilterChain const& getFilterChain() const { return m_rChain; }
	
	HttpRequestMetadata const& getRequest() const { return m_rChain.getRequest(); }
	
	AbstractResponseHandler& getFinalRecipient() { return m_rChain.getFinalRecipient(); }
private:
	ResponseFilterChain& m_rChain;
	IntrusivePtr<AbstractResponseFilter> m_ptrNextFilter;
};


inline void
ResponseFilterBase::outputMetadata(
	std::auto_ptr<HttpResponseMetadata> metadata)
{
	m_ptrNextFilter = m_rChain.nextFilter(*metadata);
	m_ptrNextFilter->processMetadata(metadata);
}

inline void
ResponseFilterBase::outputBodyData(SplittableBuffer& data, bool eof)
{
	m_ptrNextFilter->processBodyData(data, eof);
}

inline void
ResponseFilterBase::raiseError(std::auto_ptr<ErrorDescriptor> edesc)
{
	m_rChain.getErrorInitiator().raiseError(edesc);
}

inline bool
ResponseFilterBase::isErrorRaised() const
{
	return m_rChain.getErrorInitiator().isErrorRaised();
}

#endif
