/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NetworkActivityReporter.h"
#include "AbstractNetworkActivityHandler.h"
#include "InterthreadCommandQueue.h"
#include "AbstractCommand.h"
#include "GlobalState.h"
#include <ace/Singleton.h>
#include <ace/OS_NS_time.h>

using namespace std;

class NetworkActivityReporter::Holder : public NetworkActivityReporter
{
};


class NetworkActivityReporter::ReportCommand : public AbstractCommand
{
public:
	ReportCommand();
	
	virtual ~ReportCommand();
	
	virtual void operator()();
};


AbstractNetworkActivityHandler* NetworkActivityReporter::m_spHandler = 0;

NetworkActivityReporter::NetworkActivityReporter()
:	m_reportDelay(0, REPORT_DELAY*1000)
{
}

NetworkActivityReporter::~NetworkActivityReporter()
{
}

void
NetworkActivityReporter::reportActivity()
{
	if (!m_spHandler) {
		return;
	}
	
	ACE_Guard<ACE_Thread_Mutex> guard(m_mutex);
	
	ACE_Time_Value const now(ACE_OS::gettimeofday());
	if (now > m_lastReportTime + m_reportDelay) {
		m_lastReportTime = now;
		if (GlobalState::ReadAccessor()->config().isTrayAnimationEnabled()) {
			m_spHandler->getCommandQueue().push(
				InterthreadCommandQueue::CommandPtr(
					new ReportCommand()
				)
			);
		}
	}
}

NetworkActivityReporter*
NetworkActivityReporter::instance()
{
	return ACE_Singleton<Holder, ACE_Recursive_Thread_Mutex>::instance();
}

/*=============== NetworkActivityReporter::ReportCommand ================*/

NetworkActivityReporter::ReportCommand::ReportCommand()
{
}

NetworkActivityReporter::ReportCommand::~ReportCommand()
{
}

void
NetworkActivityReporter::ReportCommand::operator()()
{
	NetworkActivityReporter::getHandler()->handleNetworkActivity();
}
