/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef INTERTHREADCOMMANDQUEUE_H_
#define INTERTHREADCOMMANDQUEUE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "AbstractCommand.h"
#include <ace/Synch.h>
#include <ace/Thread_Semaphore.h>
#include <deque>
#include <stddef.h>

class InterthreadCommandQueue : private NonCopyable
{
public:
	typedef IntrusivePtr<AbstractCommand> CommandPtr;
	
	class Notifier
	{
	public:
		virtual ~Notifier() {}
		
		// called by push(), no lock
		virtual void notifyCommandsPending() = 0;
		
		// called by pop(), queue locked
		virtual void notifyQueueEmpty() = 0;
	};
	
	InterthreadCommandQueue(unsigned capacity, Notifier& notifier);
	
	virtual ~InterthreadCommandQueue();
	
	unsigned getCapacity() const { return m_capacity; }
	
	// returns true on success, false if the queue is closed
	bool push(CommandPtr const& cmd);
	
	CommandPtr pop();
	
	// Rrevents queueing of new commands and wakes up blocked threads.
	// Returns the number of commands still in the queue.
	size_t close();
private:
	class SemaphoreGuard;
	
	unsigned m_capacity;
	Notifier& m_rNotifier;
	std::deque<CommandPtr> m_commandQueue;
	ACE_Thread_Semaphore m_capacitySemaphore;
	ACE_Thread_Mutex m_queueAccessMutex;
	bool m_isClosed;
};

#endif
