/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConnAcceptor.h"
#include "EventHandler.h"
#include "RefCounter.h"
#include "IntrusivePtr.h"
#include "ReactorFactory.h"
#include "SynchFactory.h"
#include "RefCountableSAP.h"
#include <ace/SOCK_Acceptor.h>
#include <ace/SOCK_Stream.h>
#include <ace/Time_Value.h>
#include <ace/INET_Addr.h>

using namespace std;

class ConnAcceptor::EH : public EventHandler<RefCounter<ACE_MT_SYNCH> >
{
public:
	EH(ConnAcceptor& owner, AcceptorPtr const& acceptor);
private:
	virtual void handleRead(ACE_HANDLE);
	
	ConnAcceptor& m_rOwner;
	AcceptorPtr m_ptrAcceptor;
};


ConnAcceptor::ConnAcceptor(bool stop_on_signals)
{
	m_ptrReactor = ReactorFactory::createBestReactor(
		SynchFactory<ACE_MT_SYNCH>(), stop_on_signals
	);
}

ConnAcceptor::~ConnAcceptor()
{
}

bool
ConnAcceptor::add(AcceptorPtr const& acceptor)
{
	Reactor::EventHandlerPtr handler(new EH(*this, acceptor));
	try {
		m_ptrReactor->registerHandler(
			acceptor->get_handle(), handler, Reactor::READ
		);
		return true;
	} catch (Reactor::Exception&) {
		return false;
	}
}

void
ConnAcceptor::remove(AcceptorPtr const& acceptor)
{
	ReactorHandlerId id = m_ptrReactor->findHandler(acceptor->get_handle());
	if (id) {
		m_ptrReactor->unregisterHandler(id);
	}
}

void
ConnAcceptor::removeAll()
{
	m_ptrReactor->unregisterAllHandlers();
}

int
ConnAcceptor::acceptConnections()
{
	m_ptrReactor->restart(); // in case we have been forceStop()'ed
	return m_ptrReactor->runEventLoop();
}

void
ConnAcceptor::forceStop()
{
	m_ptrReactor->stop();
}


/*======================= ConnAcceptor::EH =========================*/

ConnAcceptor::EH::EH(ConnAcceptor& owner, AcceptorPtr const& acceptor)
:	m_rOwner(owner),
	m_ptrAcceptor(acceptor)
{
}

void
ConnAcceptor::EH::handleRead(ACE_HANDLE)
{
	typedef IntrusivePtr<RefCountableSAP<ACE_SOCK_Stream> > SocketPtr;
	SocketPtr sock(new RefCountableSAP<ACE_SOCK_Stream>);
	ACE_INET_Addr client_addr;
	ACE_Time_Value timeout(ACE_Time_Value::zero);
	if (m_ptrAcceptor->accept(*sock, &client_addr, &timeout) != -1) {
		m_rOwner.workerPool().handleConnection(sock, client_addr);
	}
}
