/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ADSUSPECTLIST_H_
#define ADSUSPECTLIST_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AdSuspect.h"
#include "HeuristicScore.h"
#include "IntrusivePtr.h"
#include "InsensitiveLess.h"
#include <deque>
#include <memory>
#include <string>
#include <set>

class SplittableBuffer;
class BString;

class AdSuspectList
{
public:
	AdSuspectList();
	
	~AdSuspectList();
	
	void add(IntrusivePtr<AdSuspect> const& suspect) { m_suspects.push_back(suspect); }
	
	bool empty() const { return m_suspects.empty(); }
	
	bool isSameHost() const;
	
	bool isConsistentSize() const;
	
	AdSuspect const* findMainSuspect() const;
	
	// returns the number of marks made
	int markForAnalyzing(SplittableBuffer const& script_code,
		SplittableBuffer& result, HeuristicScore::Status min_status) const;
private:
	typedef std::deque<IntrusivePtr<AdSuspect> > SuspectList;
	typedef std::set<BString, InsensitiveLess> HostSet;
	
	std::auto_ptr<HostSet> getUniqueHosts(HeuristicScore::Status min_status) const;
	
	static int markSingleHost(SplittableBuffer const& script_code,
		SplittableBuffer& result, BString const& host);
	
	SuspectList m_suspects;
};

#endif
