/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SYNCHFACTORY_H_
#define SYNCHFACTORY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <memory>

class ACE_Lock;
class ACE_NULL_SYNCH;
class ACE_MT_SYNCH;

class AbstractSynchFactory
{
public:
	virtual ~AbstractSynchFactory() {}
	
	virtual std::auto_ptr<ACE_Lock> createMutex() const = 0;
	
	virtual std::auto_ptr<ACE_Lock> createRecursiveMutex() const = 0;
	
	virtual std::auto_ptr<ACE_Lock> createReadWriteMutex() const = 0;
};


template<typename SYNCH> class SynchFactory : public AbstractSynchFactory
{
public:
	// Each method is specialized for ACE_MT_MUTEX and ACE_NULL_MUTEX.
	
	virtual std::auto_ptr<ACE_Lock> createMutex() const;
	
	virtual std::auto_ptr<ACE_Lock> createRecursiveMutex() const;
	
	virtual std::auto_ptr<ACE_Lock> createReadWriteMutex() const;
};

#endif
