/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SynchFactory.h"
#include "LockAdapter.h"
#include <ace/Synch.h>

using namespace std;

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_NULL_SYNCH>::createMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_Null_Mutex>);
};

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_NULL_SYNCH>::createRecursiveMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_Null_Mutex>);
};

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_NULL_SYNCH>::createReadWriteMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_Null_Mutex>);
};


#ifdef ACE_HAS_THREADS

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_MT_SYNCH>::createMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_Thread_Mutex>);
};

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_MT_SYNCH>::createRecursiveMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_Recursive_Thread_Mutex>);
};

template<>
auto_ptr<ACE_Lock>
SynchFactory<ACE_MT_SYNCH>::createReadWriteMutex() const
{
	return auto_ptr<ACE_Lock>(new LockAdapter<ACE_RW_Mutex>);
};

#endif // ACE_HAS_THREADS
