/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <glade/glade.h>

#include <stdio.h>

#include "gui.h"
#include "gststuff.h"
#include "relay.h"

#ifndef GST_06
#include <gst/xoverlay/xoverlay.h>
#endif

#ifdef VUMETER
#include "gtkvumeter.h"
#endif
//struct gstsave_gui gsgui;

//extern struct pipeline_elements pe;
//extern struct stream_details sd;

/* callback from pipeline */
static void pipeline_changed (GstElement* object, gint arg0, gint arg1, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	if (arg1==GST_STATE_NULL) {
		/* pipeline has stopped playing */
		if (gsgui->sd->active==1) {
			GtkMessageDialog* dialog;
			GtkWidget* b=glade_xml_get_widget(gsgui->windowdefs,"execute_button");
			gsgui->sd->active=0;
			gtk_button_set_label(GTK_BUTTON(b),"gtk-execute");
	  		gtk_button_set_use_stock(GTK_BUTTON(b),TRUE);
	  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"preferences1"),TRUE);
	  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"changefilename_button"),FALSE);
	  		
	  		/* show an error dialog */
	  		dialog = gtk_message_dialog_new (glade_xml_get_widget(gsgui->windowdefs,"mainwindow"),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Pipeline stopped unexpectedly");
			gtk_dialog_run (GTK_DIALOG (dialog));
			gtk_widget_destroy (dialog);
		}
	}
}

#ifdef GST_06
static void xvideosink_have_size(GObject* object, gint arg0, gint arg1, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	GtkWidget* drawingarea;


	drawingarea=GTK_WIDGET(g_hash_table_lookup(gsgui->table,"visualisation"));

        gtk_widget_set_size_request(drawingarea,arg0,arg1);
}


static void xvideosink_have_xid(GObject* object, gint arg0, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	GtkWidget* drawingarea;

	drawingarea=GTK_WIDGET(g_hash_table_lookup(gsgui->table,"visualisation"));

	gtk_socket_steal(GTK_SOCKET(drawingarea),arg0);
	
}

#else
static void xvimagesink_have_size(GObject* object, gint arg0, gint arg1, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	GtkWidget* drawingarea;

	g_print("xvimagesink has size %d %d\n",arg0,arg1);
	//drawingarea=GTK_WIDGET(g_hash_table_lookup(gsgui->table,"visualisation"));
	drawingarea=glade_xml_get_widget(gsgui->windowdefs,"visualisation");
	gtk_widget_set_size_request(drawingarea,arg0,arg1);
	
	
}

static gboolean embed_xvideosink(struct gstsave_gui* gsgui)
{
	GtkWidget* drawingarea;

	g_print("In exmbed_xvideosink\n");
	//drawingarea=g_hash_table_lookup(gsgui->table,"visualisation");
	drawingarea=glade_xml_get_widget(gsgui->windowdefs,"visualisation");
	if (GST_IS_X_OVERLAY(gsgui->sd->pe->vsink) && GDK_IS_WINDOW(drawingarea->window)) {
		/* Creating our video window */


		XID id=GDK_WINDOW_XID(GTK_WIDGET(drawingarea)->window);
		gst_x_overlay_set_xwindow_id(GST_X_OVERLAY(gsgui->sd->pe->vsink),id);
		return FALSE;

	}
	return TRUE;
}

static void drawingarea_after_realize(GObject* object,gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	g_print("In drawingarea_after_realize\n");
	g_idle_add(embed_xvideosink,gsgui);
}



#endif

static void exit_button_clicked(GtkButton* b, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;

	gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PAUSED);
	gtk_main_quit();
}

static void changefilename_button_clicked(GtkButton* b, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;

	gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PAUSED);
	g_print("Changing filename...paused\n");
	switch_file(gsgui->sd);
	g_print("FIlename changed,...unpausing\n");
	gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PLAYING);
	display_stream_status(gsgui->sd);
}

static void listen_checkbox_toggled(GtkToggleButton* tb, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	
	if (gsgui->sd->active==1) {
		gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PAUSED);
		if (gsgui->sd->sub_stream_status[5]==1) {
			stop_listen_substream(gsgui->sd);
		}
		else {
			add_listen_substream(gsgui->sd);
		}
		gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PLAYING);
	}
	
}
	
static void checkbox_toggled(GtkToggleButton* tb, gpointer user_data)
{
  struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;

  int i;
  gchar* key;
  GtkWidget* tempwidget;
  gboolean how_toggled;

  if (gsgui->sd->active==1) {
  	how_toggled=gtk_toggle_button_get_active(tb);
  	//g_print("In checkbox_toggled\n");
  	for(i=0;i<5;i++) {
		key=g_strdup_printf("stream_checkbox%d",i);
		//tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,key));
		tempwidget=glade_xml_get_widget(gsgui->windowdefs,key);
		if (tb==tempwidget) {
			// do the stuff
			g_print("About to pause\n");
			gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PAUSED);
			g_print("Paused\n");

			switch (i) {
			case 0:
				if (gsgui->sd->sub_stream_status[0] && !how_toggled)
					stop_record_stream(gsgui->sd);
				else if (!gsgui->sd->sub_stream_status[0] && how_toggled)
					add_record_stream(gsgui->sd);
				break;
			case 1:
				if (gsgui->sd->sub_stream_status[1] && !how_toggled)
					stop_webcast_record_stream(gsgui->sd);
				else if (!gsgui->sd->sub_stream_status[1] && how_toggled)
					add_webcast_record_stream(gsgui->sd,FALSE);
				break;
			case 2:
				if (gsgui->sd->sub_stream_status[2] && !how_toggled)
					stop_webcast_substream(gsgui->sd);
				else if (!gsgui->sd->sub_stream_status[2] && how_toggled)
					add_webcast_substream(gsgui->sd,FALSE);
				break;
			case 3:
				/* bug in gstreamer means this has to be disabled */
				#if 0
	
				if (gsgui->sd->sub_stream_status[3] && !how_toggled)
					stop_visualisation_substream(gsgui->sd);
				else if (!gsgui->sd->sub_stream_status[3] && how_toggled)
					add_visualisation_substream(gsgui->sd);
				#endif
				break;
			case 4:
				if (gsgui->sd->sub_stream_status[4] && !how_toggled)
					stop_wav_substream1(gsgui->sd);
				else if (!gsgui->sd->sub_stream_status[4] && how_toggled)
					add_wav_substream1(gsgui->sd);
					
				break;
			default:
				printf("shouldnt be here\n");
			}
			g_print("About to unpause\n");

			gst_element_set_state(GST_ELEMENT(gsgui->sd->pe->pipeline),GST_STATE_PLAYING);
			g_print("Unpaused\n");
			
			display_stream_status(gsgui->sd);
			break;
		}
  	}
  }
}

static gboolean execute_button_clicked(GtkButton* b, struct gstsave_gui* gsgui)
{
	int c;

	for(c=0;c<5;c++) {
  		GtkWidget* streamcheckbox;
  		streamcheckbox=glade_xml_get_widget(gsgui->windowdefs,g_strdup_printf("stream_checkbox%d",c));
  		gtk_widget_set_sensitive(streamcheckbox, gsgui->sd->active == 0);
  		if (gsgui->sd->active==0 && gsgui->sd->sub_stream_status[c]) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(streamcheckbox),TRUE);
	}
	
	if (gsgui->sd->active==0) {
		gsgui->sd->active=1;
		g_print ("Playing Pipeline\n");
		display_stream_status(gsgui->sd);
  		gst_element_set_state (gsgui->sd->pe->pipeline, GST_STATE_PLAYING);
  		g_idle_add(continue_pipeline,gsgui->sd);
  		gtk_button_set_label(b,"gtk-stop");
  		gtk_button_set_use_stock(b,TRUE);
  		//gtk_widget_set_sensitive(b,FALSE);
  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"preferences1"),FALSE);
  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"changefilename_button"),TRUE);
 		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"stream_listen_checkbox"),TRUE);
		g_list_foreach(gsgui->relay_checkbuttons,gtk_widget_set_sensitive,TRUE);
		
  	}
	else {
		
		gsgui->sd->active=0;
		
		g_print ("Stopping Pipeline\n");

		g_list_foreach(gsgui->relay_checkbuttons,gtk_toggle_button_set_active,FALSE);

		gst_element_set_state (gsgui->sd->pe->pipeline, GST_STATE_NULL);
		gtk_button_set_label(b,"gtk-execute");
  		gtk_button_set_use_stock(b,TRUE);
  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"preferences1"),TRUE);
  		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"changefilename_button"),FALSE);
		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"stream_listen_checkbox"),TRUE);
				g_list_foreach(gsgui->relay_checkbuttons,gtk_widget_set_sensitive,FALSE);

	}
	return FALSE;
}
static gboolean save_relay_preferences(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer user_data)
{
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	FILE* fp=(FILE*)g_hash_table_lookup(gsgui->table,"fileptr");
	struct acast_relay* ar;
	gchar* ip, *password, *mount, *name;
	gint port;
	GtkWidget* temp;
	GValue* val=g_new0(GValue,1);
	gtk_tree_model_get_value(model,iter,0,val);
	
	name=g_strdup(g_value_get_string(val));
	
	g_value_unset(val);
	g_free(val);
	ar=(struct acast_relay*)g_hash_table_lookup(gsgui->sd->relays,name);
	
	g_object_get(ar->sink,"ip",&ip,"password",&password,"mount",&mount,"port",&port,NULL);
	fprintf(fp,"<relay>\n");
	fprintf(fp,"	<name>%s</name>\n",name);
	fprintf(fp,"	<ip>%s</ip>\n",ip);
	fprintf(fp,"	<port>%d</port>\n",port);
	fprintf(fp,"	<mount>%s</mount>\n",mount);
	fprintf(fp,"	<password>%s</password>\n",password);
	/* rest get from webcaststream */
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<server>icecast2</server>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<server>icecast1</server>\n");
		}
		else {
			temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
				fprintf(fp,"	<server>shoutcast</server>\n");
			}
		}
	}
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<type>ogg</type>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<type>mp3</type>\n");
		}
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_quality_hscale");
	fprintf(fp,"	<quality>%d</quality>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_hscale");
	fprintf(fp,"	<bitrate>%d</bitrate>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_stereo_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<channels>stereo</channels>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_mono_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<channels>mono</channels>\n");
		}
	}

	
	fprintf(fp,"</relay>\n");
	g_free(ip);
	g_free(password);
	g_free(mount);

	return FALSE;
}
static gboolean save_preferences(GtkWidget* w, GdkEvent* event, gpointer user_data)
{
	struct gstsave_gui* gsgui;
	FILE* fp;
	GtkWidget* temp;
	/* TODO: it should be an instant apply */	
	gsgui=(struct gstsave_gui*)user_data;
	fp=fopen(gsgui->sd->config_fname,"w");
	fprintf(fp,"<acast>\n");
	/* general pane */
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_active_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"<active>yes</active>\n");
	}
	else {
		fprintf(fp,"<active>no</active>\n");
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_directory_entry");
	fprintf(fp,"<directory>%s</directory>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	/*if (gsgui->sd->dirname) g_free(gsgui->sd->dirname);
	gsgui->sd->dirname=g_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));*/
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_basefilename_entry");
	fprintf(fp,"<basefile>%s</basefile>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	/*if (gsgui->sd->str) g_free(gsgui->sd->str);
	gsgui->sd->str=g_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));*/
	/* input pane */
	fprintf(fp,"<input>\n");
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_device_entry");
	fprintf(fp,"	<device>%s</device>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_oss_radiobutton");
	/*if (gsgui->sd->audiosrc) g_free(gsgui->sd->audiosrc);*/
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<type>oss</type>\n");
		/*gsgui->sd->audiosrc=g_strdup("osssrc");*/
	}
	else {
		temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_alsa_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<type>alsa</type>\n");
			/*gsgui->sd->audiosrc=g_strdup("alsasrc");*/
		}
		else {
			temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_file_radiobutton");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
				fprintf(fp,"	<type>file</type>\n");
				/*gsgui->sd->audiosrc=g_strdup("filesrc");*/
			}	
		}
	}
	fprintf(fp,"</input>\n");
	/* wave recording pane */
	fprintf(fp,"<wavestream>\n");
	temp = glade_xml_get_widget(gsgui->windowdefs,"wave_active_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<active>yes</active>\n");
	}
	else {
		fprintf(fp,"	<active>no</active>\n");
	}
	fprintf(fp,"</wavestream>\n");
	/* visualisation pane */
	fprintf(fp,"<visualisation>\n");
	temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_active_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<active>yes</active>\n");
	}
	else {
		fprintf(fp,"	<active>no</active>\n");
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_monoscope_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<plugin>monoscope</plugin>\n");
	}
	else {
		temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_goom_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<plugin>goom</plugin>\n");
		}
	}
	fprintf(fp,"</visualisation>\n");
	/* record pane */
	fprintf(fp,"<recordstream>\n");
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_active_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<active>yes</active>\n");
	}
	else {
		fprintf(fp,"	<active>no</active>\n");
	}
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_oggvorbis_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<type>ogg</type>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_mp3_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<type>mp3</type>\n");
		}
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_quality_hscale");
	//fprintf(fp,"	<quality>%d</quality>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_bitrate_hscale");
	fprintf(fp,"	<bitrate>%d</bitrate>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_stereo_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<channels>stereo</channels>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_mono_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<channels>mono</channels>\n");
		}
	}
	fprintf(fp,"</recordstream>\n");
	/* webcast pane */
	fprintf(fp,"<webcaststream>\n");
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_active_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<active>yes</active>\n");
	}
	else {
		fprintf(fp,"	<active>no</active>\n");
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_record_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<record>yes</record>\n");
	}
	else {
		fprintf(fp,"	<record>no</record>\n");
	}
	
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<type>ogg</type>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<type>mp3</type>\n");
		}
	}
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_quality_hscale");
	//fprintf(fp,"	<quality>%d</quality>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_hscale");
	fprintf(fp,"	<bitrate>%d</bitrate>\n",(gint)gtk_range_get_value(GTK_RANGE(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_stereo_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<channels>stereo</channels>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_mono_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<channels>mono</channels>\n");
		}
	}
	
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_ipaddress_entry");
	fprintf(fp,"	<ip>%s</ip>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_port_entry");
	fprintf(fp,"	<port>%s</port>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_mountpoint_entry");
	fprintf(fp,"	<mount>%s</mount>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_password_entry");
	fprintf(fp,"	<password>%s</password>\n",gtk_entry_get_text(GTK_ENTRY(temp)));
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
		fprintf(fp,"	<server>icecast2</server>\n");
	}
	else {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
			fprintf(fp,"	<server>icecast1</server>\n");
		}
		else {
			temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
				fprintf(fp,"	<server>shoutcast</server>\n");
			}
		}
	}
	fprintf(fp,"</webcaststream>\n");

	/* now relays */
	/* temporarily add fp to gsgui's hashtable */
	g_hash_table_insert(gsgui->table,"fileptr",fp);
	//g_hash_table_foreach(gsgui->sd->relays, save_relay_preferences, gsgui);
	temp=glade_xml_get_widget(gsgui->windowdefs,"relays_treeview");
	gtk_tree_model_foreach(gtk_tree_view_get_model(GTK_TREE_VIEW(temp)), G_CALLBACK(save_relay_preferences), gsgui);
	fprintf(fp,"</acast>\n");
	
	fclose(fp);
	//g_hash_table_remove(gsgui->table,"fileptr");

	//temp = glade_xml_get_widget(gsgui->windowdefs,"apply_button");
	//gtk_widget_set_sensitive(temp,FALSE);
	gtk_widget_hide(w);
	return TRUE;
}

static gboolean make_apply_button_sensitive(GtkWidget* blah, struct gstsave_gui* gsgui)
{
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"apply_button"),TRUE);
	return FALSE;
}

static gboolean make_icecastsend_sensitive(GtkWidget* blah, struct gstsave_gui* gsgui)
{
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton"),TRUE);
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton"),TRUE);
	return FALSE;
}

static gboolean make_icecastsend_unsensitive(GtkWidget* blah, struct gstsave_gui* gsgui)
{
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton"),FALSE);
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton"),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton")),TRUE);
	
	return FALSE;
}

static gboolean change_spinbutton_of_scale(GtkHScale* scale, GtkSpinButton* spin)
{
	if (gtk_spin_button_get_value(spin)!=gtk_range_get_value(scale)) {
		gtk_spin_button_set_value(spin,gtk_range_get_value(scale));
	}
	return FALSE;
}

static gboolean change_scale_of_spinbutton(GtkSpinButton* spin, GtkHScale* scale)
{
	if (gtk_spin_button_get_value(spin)!=gtk_range_get_value(scale)) {
		gtk_range_set_value(scale,gtk_spin_button_get_value(spin));
	}
	return FALSE;
}

static gboolean close_preferences_window(GtkWidget* blah, GtkWindow* window)
{
	gtk_widget_hide_all(GTK_WIDGET(window));
	
	return TRUE;
}

static gboolean show_preferences_window(GtkWidget* blah, struct gstsave_gui* gsgui)
{
	GtkWidget* preferences_window;
	preferences_window = glade_xml_get_widget(gsgui->windowdefs,"acast_preferences_window");
	gtk_widget_show_all(preferences_window);
	
	return TRUE;
}

static void add_relay_to_list_view(gconstpointer name, gconstpointer value, gpointer user_data)
{
	GtkTreeIter iter;
	GtkListStore* relay_list=(GtkListStore*)user_data;

	gtk_list_store_append(relay_list,&iter);
	gtk_list_store_set(relay_list,&iter,0,(const gchar*)name,-1);
}

static void relay_treeview_cursor_changed(GtkTreeView* view, gpointer data)
{
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	GtkTreeSelection  *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	struct gstsave_gui* gsgui=(struct gstsave_gui*)data;
	
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gchar *name;
		struct acast_relay* ar;

		gtk_tree_model_get (model, &iter, 0, &name, -1);

		ar=(struct acast_relay*)g_hash_table_lookup(gsgui->sd->relays,g_strdup(name));

		if (ar) {
			/* fill out entry fields */
			gchar* ip, *password, *mount;
			gint port;
			GtkWidget* temp;
	
			g_object_get(ar->sink,"ip",&ip,"password",&password,"mount",&mount,"port",&port,NULL);
			temp = glade_xml_get_widget(gsgui->windowdefs,"relay_name_entry");
			gtk_entry_set_text(GTK_ENTRY(temp),name);
	
			temp = glade_xml_get_widget(gsgui->windowdefs,"relay_ipaddress_entry");
			gtk_entry_set_text(GTK_ENTRY(temp),ip);
			temp = glade_xml_get_widget(gsgui->windowdefs,"relay_mountpoint_entry");
			gtk_entry_set_text(GTK_ENTRY(temp),mount);
			temp = glade_xml_get_widget(gsgui->windowdefs,"relay_port_entry");
			gtk_entry_set_text(GTK_ENTRY(temp),g_strdup_printf("%d",port));
			temp = glade_xml_get_widget(gsgui->windowdefs,"relay_password_entry");
			gtk_entry_set_text(GTK_ENTRY(temp),password);
			/* rest get from webcaststream */
			temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
				gtk_toggle_button_set_active(glade_xml_get_widget(gsgui->windowdefs,"relay_servertype_icecast2_radiobutton"),TRUE);
			}
			else {
				temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
					gtk_toggle_button_set_active(glade_xml_get_widget(gsgui->windowdefs,"relay_servertype_icecast1_radiobutton"),TRUE);
	
				}
				else {
					temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
					if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
						gtk_toggle_button_set_active(glade_xml_get_widget(gsgui->windowdefs,"relay_servertype_shoutcast_radiobutton"),TRUE);

					}
				}
			}


			gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"relays_delete_button"),TRUE);

			

		}
		else {
			g_print("could not find %s in hash table\n",name);
		}

		g_free(name);
  	}
  	else
  	{
		gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"relays_delete_button"),FALSE);
		
  	}

	
}

void relay_delete_button_clicked(GtkWidget* widget, gpointer user_data)
{
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	GtkWidget *temp;

	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;

	GtkTreeSelection  *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview")));

	if (gtk_tree_selection_get_selected(selection, &model, &iter)) {
		gtk_list_store_remove(GTK_LIST_STORE(model),&iter);
		gtk_widget_set_sensitive(widget,FALSE);
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_name_entry");
		gtk_entry_set_text(GTK_ENTRY(temp),"");

		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_ipaddress_entry");
		gtk_entry_set_text(GTK_ENTRY(temp),"");
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_mountpoint_entry");
		gtk_entry_set_text(GTK_ENTRY(temp),"");
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_port_entry");
		gtk_entry_set_text(GTK_ENTRY(temp),"");
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_password_entry");
		gtk_entry_set_text(GTK_ENTRY(temp),"");

	}
}

void relay_add_button_clicked(GtkWidget* widget, gpointer user_data)
{
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	GtkWidget *temp;

	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;

	model = gtk_tree_view_get_model(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview"));

	if (model) {
		gchar* name, *ip, *mount, *port, *password;
		
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_name_entry");
		name = gtk_entry_get_text(GTK_ENTRY(temp));
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_ipaddress_entry");
		ip = gtk_entry_get_text(GTK_ENTRY(temp));
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_mountpoint_entry");
		mount = gtk_entry_get_text(GTK_ENTRY(temp));
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_port_entry");
		port = gtk_entry_get_text(GTK_ENTRY(temp));
		temp = glade_xml_get_widget(gsgui->windowdefs,"relay_password_entry");
		password = gtk_entry_get_text(GTK_ENTRY(temp));

		if (strlen(name)>0 && strlen(ip)>0 && strlen(port)>0 && strlen(mount)>0 && strlen(password)>0) {
			
			/* check if name is already taken */
			gboolean is_name_in_use = FALSE;
			gtk_tree_model_get_iter_first(model,&iter);
			do {
				GValue* val=g_new0(GValue,1);
				gtk_tree_model_get_value(model,&iter,0,val);
				if (g_strcasecmp(g_value_get_string(val),name)==0) {
					is_name_in_use=TRUE;
					g_value_unset(val);
					g_free(val);
					break;
				}
				g_value_unset(val);
				g_free(val);
			} while (gtk_tree_model_iter_next(model,&iter));

			if (!is_name_in_use) {
				
				gchar* servertype, *webcasttype;
				gint bitrate;
				gint channels;
				
				/* add to tree model */
				gtk_list_store_append(GTK_LIST_STORE(model),&iter);
				gtk_list_store_set(GTK_LIST_STORE(model),&iter,0,(const gchar*)name,-1);
				
				/* get missing info */
				temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
					servertype=g_strdup("icecast2");
				}
				else {
					temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
					if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
						servertype=g_strdup("icecast1");
					}
					else {
						temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
						if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
							servertype=g_strdup("shoutcast");
						}
					}
				}
				temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
					webcasttype=g_strdup("ogg");
				}
				else {
					temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
					if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
						webcasttype=g_strdup("mp3");
					}
				}
				
				temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_stereo_radiobutton");
				if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
					channels=2;
				}
				else {
					temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_mono_radiobutton");
					if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
						channels=1;
					}
				}
				temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_hscale");
				bitrate = (int)gtk_range_get_value(temp);

				/* add to relay hashtable */
				acast_add_relay(gsgui->sd,g_strdup(name),ip,atoi(port),mount,password,servertype,webcasttype,bitrate,channels);

				g_free(servertype);
				g_free(webcasttype);
				
				
			}
		}
	


	}
}
	
void setup_preferences_window(struct gstsave_gui* gsgui)
{
	GtkWidget* preferences_window;
	GtkWidget* temp;
	preferences_window = glade_xml_get_widget(gsgui->windowdefs,"acast_preferences_window");

	GtkListStore* relay_list;
	GtkCellRenderer* text_renderer;
	GtkTreeViewColumn* name_column;
	
	gtk_widget_hide_all(preferences_window);	
	
	
	/* general pane */
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_directory_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->dirname);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_basefilename_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->str);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"general_active_checkbutton");
	if (gsgui->sd->active==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}	
	/* input pane */
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_device_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->audiodevice);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp=NULL;
	if (g_strcasecmp(gsgui->sd->audiosrc,"osssrc")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_oss_radiobutton");
	}
	else if (g_strcasecmp(gsgui->sd->audiosrc,"alsasrc")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_alsa_radiobutton");
	}
	else if (g_strcasecmp(gsgui->sd->audiosrc,"filesrc")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_file_radiobutton");
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_oss_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_alsa_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"input_type_file_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	
	/* wave recording pane */
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"wave_active_checkbutton");
	if (gsgui->sd->sub_stream_status[4]==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	/* visualisation pane */
	temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_active_checkbutton");
	if (gsgui->sd->sub_stream_status[3]==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp=NULL;
	if (g_strcasecmp(gsgui->sd->visplugin,"monoscope")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_monoscope_radiobutton");
	}
	else if (g_strcasecmp(gsgui->sd->visplugin,"goom")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_goom_radiobutton");
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_monoscope_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"visualisation_plugin_goom_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	/* recording pane */
		
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_active_checkbutton");
	if (gsgui->sd->sub_stream_status[0]==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp=NULL;
	if (g_strcasecmp(gsgui->sd->recordtype,"ogg")==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_oggvorbis_radiobutton");
	}
	else if (g_strcasecmp(gsgui->sd->recordtype,"mp3")==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_mp3_radiobutton");
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);

	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_oggvorbis_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_type_mp3_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_quality_hscale");
	gtk_range_set_value(GTK_RANGE(temp),gsgui->sd->quality[0]);
	//g_signal_connect(temp,"value-changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_bitrate_hscale");
	gtk_range_set_value(GTK_RANGE(temp),gsgui->sd->bitrate[0]);
	//g_signal_connect(temp,"value-changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	g_signal_connect(temp,"value-changed",G_CALLBACK(change_spinbutton_of_scale),glade_xml_get_widget(gsgui->windowdefs,"recording_bitrate_spinbutton"));
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"recording_bitrate_spinbutton");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),(gdouble)gsgui->sd->bitrate[0]);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	g_signal_connect(temp,"changed",G_CALLBACK(change_scale_of_spinbutton),glade_xml_get_widget(gsgui->windowdefs,"recording_bitrate_hscale"));
	temp=NULL;
	if (gsgui->sd->mode[0]==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_stereo_radiobutton");
	}
	else if (gsgui->sd->mode[0]==3) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_mono_radiobutton");
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_stereo_radiobutton");
	g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"recording_channels_mono_radiobutton");
	g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	/* webcast pane */
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_active_checkbutton");
	if (gsgui->sd->sub_stream_status[2]==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_record_checkbutton");
	if (gsgui->sd->sub_stream_status[1]==1) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	}
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp=NULL;
	#ifdef HAVE_SHOUT2
	if (g_strcasecmp(gsgui->sd->webcasttype,"ogg")==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton");
	}
	else if (g_strcasecmp(gsgui->sd->webcasttype,"mp3")==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
	}
	#else
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
	#endif
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton");
	g_signal_connect(temp,"toggled",G_CALLBACK(make_icecastsend_unsensitive),gsgui);
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_type_mp3_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	g_signal_connect(temp,"toggled",G_CALLBACK(make_icecastsend_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_quality_hscale");
	gtk_range_set_value(GTK_RANGE(temp),gsgui->sd->quality[1]);
	//g_signal_connect(temp,"value-changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_hscale");
	gtk_range_set_value(GTK_RANGE(temp),gsgui->sd->bitrate[1]);
	//g_signal_connect(temp,"value-changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	g_signal_connect(temp,"value-changed",G_CALLBACK(change_spinbutton_of_scale),glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_spinbutton"));
	
	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_spinbutton");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),(gdouble)gsgui->sd->bitrate[1]);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);
	g_signal_connect(temp,"changed",G_CALLBACK(change_scale_of_spinbutton),glade_xml_get_widget(gsgui->windowdefs,"webcast_bitrate_hscale"));

	temp=NULL;
	if (gsgui->sd->mode[1]==0) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_stereo_radiobutton");
	}
	else if (gsgui->sd->mode[1]==3) {
		temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_mono_radiobutton");
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_stereo_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);
	temp = 	glade_xml_get_widget(gsgui->windowdefs,"webcast_channels_mono_radiobutton");
	//g_signal_connect(temp,"toggled",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_ipaddress_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->iceip);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_port_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),g_strdup_printf("%d",gsgui->sd->iceport));
	g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_mountpoint_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->icemount);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_password_entry");
	gtk_entry_set_text(GTK_ENTRY(temp),gsgui->sd->icepass);
	//g_signal_connect(temp,"changed",G_CALLBACK(make_apply_button_sensitive),gsgui);

	temp=NULL;
	if (g_strcasecmp(gsgui->sd->webcasttype,"ogg")!=0 && gsgui->sd->webcastserver==NULL) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
	}
	#ifdef HAVE_SHOUT2
	else if (g_strcasecmp(gsgui->sd->webcasttype,"ogg")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
	}
	#endif
	else {
		#ifdef HAVE_SHOUT2
		if (g_strcasecmp(gsgui->sd->webcastserver,"icecast2")==0) {
			temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton");
		}
		else if (g_strcasecmp(gsgui->sd->webcastserver,"icecast1")==0) {
			temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
		}
		#else
		if (g_strcasecmp(gsgui->sd->webcastserver,"icecast1")==0) {
			temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
		}
		#endif
		else if (g_strcasecmp(gsgui->sd->webcastserver,"shoutcast")==0) {
			temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
		}
		
	}
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),TRUE);	

	#ifdef HAVE_SHOUT2
	/* grey out incompatible webcast servers */
	if (g_strcasecmp(gsgui->sd->webcasttype,"ogg")==0) {
		temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast1_radiobutton");
		gtk_widget_set_sensitive(temp,FALSE);
		temp = glade_xml_get_widget(gsgui->windowdefs,"webcast_server_shoutcast_radiobutton");
		gtk_widget_set_sensitive(temp,FALSE);
	}
	#endif
	
	//temp = glade_xml_get_widget(gsgui->windowdefs,"apply_button");
	//gtk_widget_set_sensitive(temp,FALSE);
	
	//g_signal_connect(temp, "clicked", G_CALLBACK(save_preferences),gsgui);
	//g_signal_connect(temp, "clicked", G_CALLBACK(close_preferences_window),preferences_window);
	//temp = glade_xml_get_widget(gsgui->windowdefs,"cancel_button");
	g_signal_connect(preferences_window, "delete-event", G_CALLBACK(save_preferences),gsgui);
	
	#ifndef HAVE_SHOUT2
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_server_icecast2_radiobutton"),FALSE);
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"webcast_type_oggvorbis_radiobutton"),FALSE);
	#endif

	/* relay pane */
	relay_list = gtk_list_store_new(1,G_TYPE_STRING);
	g_hash_table_foreach(gsgui->sd->relays,add_relay_to_list_view,relay_list);
	gtk_tree_view_set_model(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview"),relay_list);
	text_renderer=gtk_cell_renderer_text_new();
	name_column=gtk_tree_view_column_new_with_attributes("Name",text_renderer,"text",0,NULL);
	gtk_tree_view_append_column(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview"),name_column);
	gtk_tree_selection_set_mode(gtk_tree_view_get_selection(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview")),GTK_SELECTION_SINGLE);
	g_signal_connect(glade_xml_get_widget(gsgui->windowdefs,"relays_treeview"),"cursor-changed",G_CALLBACK(relay_treeview_cursor_changed),gsgui);
	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"relays_delete_button"),FALSE);
	g_signal_connect(glade_xml_get_widget(gsgui->windowdefs,"relays_delete_button"),"clicked",G_CALLBACK(relay_delete_button_clicked),gsgui);
	g_signal_connect(glade_xml_get_widget(gsgui->windowdefs,"relays_add_button"),"clicked",G_CALLBACK(relay_add_button_clicked),gsgui);

	
}

static void relay_checkbutton_toggled(GtkCheckButton* button, gpointer user_data)
{

	gchar* relay_key;
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	relay_key=gtk_button_get_label(GTK_BUTTON(button));

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) &&
	    !acast_relay_get_active(gsgui->sd,relay_key)) {
		if (acast_start_relay(gsgui->sd, relay_key)!=1) {
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),FALSE);
		}
		else {
			display_stream_status(gsgui->sd);
		}
	}
	else if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) &&
	    acast_relay_get_active(gsgui->sd,relay_key)) {
		if (acast_stop_relay(gsgui->sd, relay_key)!=1) {
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),TRUE);
		}
		else {
			display_stream_status(gsgui->sd);
		}
	}
}
			

/* add relay to GUI */
static void gui_add_relay(gconstpointer key, gconstpointer value, gpointer user_data)
{
	GtkWidget* vbox;
	GtkWidget* checkbox;
	int pos;	
	struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;
	
	vbox=glade_xml_get_widget(gsgui->windowdefs,"vbox9");
	checkbox=gtk_check_button_new_with_label((const gchar*)key);
	gsgui->relay_checkbuttons=g_list_append(gsgui->relay_checkbuttons,checkbox);
	g_signal_connect(G_OBJECT(checkbox),"toggled",G_CALLBACK(relay_checkbutton_toggled),gsgui);

	pos=g_list_length(GTK_BOX(vbox)->children)-2;
	gtk_box_pack_start_defaults(GTK_BOX(vbox),checkbox);
	gtk_box_reorder_child(GTK_BOX(vbox),checkbox,pos);
}

static void update_relay_checkbox(GtkWidget* checkbox, struct gstsave_gui* gsgui)
{
	const gchar* name=gtk_button_get_label(GTK_BUTTON(checkbox));
	struct acast_relay* ar=(struct acast_relay*)g_hash_table_lookup(gsgui->sd->relays,name);

	if (ar) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox),ar->status==1);
	}
}
	
/* TODO: called when there is a change in relay status or substream status */
void update_stream_checkboxes(struct gstsave_gui* gsgui)
{
	int c;
	/* update steam checkboxes */
	for(c=0;c<5;c++) {
  		GtkWidget* streamcheckbox;
  	  	streamcheckbox=glade_xml_get_widget(gsgui->windowdefs,g_strdup_printf("stream_checkbox%d",c));

		 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(streamcheckbox),gsgui->sd->sub_stream_status[c]);
  		
  	}

	/* update relays */
	g_list_foreach(gsgui->relay_checkbuttons,update_relay_checkbox,gsgui);
}

void
setup_gui (struct gstsave_gui* gsgui)
{
  GtkWidget *window;
  GtkWidget *vbox, *controlvbox;
  GtkWidget *label, *hbox, *mainhbox;
  GtkWidget* tempwidget;
  gchar* tempkey;
  int xid;
  int c;
  char* disp;

  /* setup gui hashtable */
  gsgui->table=g_hash_table_new_full(g_str_hash, g_str_equal,g_free,g_free);

  /* open glade file */
  gsgui->windowdefs=glade_xml_new(ACAST_GLADEDIR "acast.glade", NULL, NULL);

  window = glade_xml_get_widget(gsgui->windowdefs,"mainwindow");
  gtk_widget_hide_all(window);
  tempwidget = glade_xml_get_widget(gsgui->windowdefs,"execute_button");
  if (gsgui->sd->active==0) {
  	gtk_button_set_label(tempwidget,"gtk-execute");
  	gtk_button_set_use_stock(tempwidget,TRUE);
  	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"changefilename_button"),FALSE);
  	
  }
  else {
  	gtk_button_set_label(tempwidget,"gtk-stop");
  	gtk_button_set_use_stock(tempwidget,TRUE);
  	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"preferences1"),FALSE);
  	
  }
  //gtk_widget_set_sensitive(tempwidget,gsgui->sd->active==0);
  g_signal_connect(tempwidget,"clicked",G_CALLBACK(execute_button_clicked),gsgui);
  
  g_hash_table_insert(gsgui->table, g_strdup("numstreams"),(gpointer)5);
  g_hash_table_insert(gsgui->table, g_strdup("stream_desc0"),g_strdup_printf("%s recording %dKbs",
  	g_strcasecmp(gsgui->sd->recordtype,"ogg")==0 ? "ogg" : "mp3",gsgui->sd->bitrate[0]));
  g_hash_table_insert(gsgui->table, g_strdup("stream_desc1"),g_strdup_printf("%s recording %dKbs",
  	g_strcasecmp(gsgui->sd->webcasttype,"ogg")==0 ? "ogg" : "mp3",gsgui->sd->bitrate[1]));
  g_hash_table_insert(gsgui->table, g_strdup("stream_desc2"),g_strdup_printf("webcast stream"));
  g_hash_table_insert(gsgui->table, g_strdup("stream_desc3"),g_strdup_printf("sound level visualisation"));
  g_hash_table_insert(gsgui->table, g_strdup("stream_desc4"),g_strdup_printf("wav format recording"));
 
  /* check boxes etc. */
  if (gsgui->sd->active==0) {
  	gtk_widget_set_sensitive(glade_xml_get_widget(gsgui->windowdefs,"stream_listen_checkbox"),FALSE);
  }
  g_signal_connect(G_OBJECT(glade_xml_get_widget(gsgui->windowdefs,"stream_listen_checkbox")), "toggled", G_CALLBACK(listen_checkbox_toggled),gsgui);
  for(c=0;c<5;c++) {
  	GtkWidget* streamcheckbox;
  	gchar* key;
  	streamcheckbox=glade_xml_get_widget(gsgui->windowdefs,g_strdup_printf("stream_checkbox%d",c));

	key=g_strdup_printf("stream_desc%d",c);
	gtk_button_set_label(GTK_BUTTON(streamcheckbox),(gchar*)g_hash_table_lookup(gsgui->table,key));
	
	//streamcheckbox=gtk_check_button_new_with_label((gchar*)g_hash_table_lookup(gsgui->table,key));
	g_free(key);
	/*g_hash_table_insert(gsgui->table, g_strdup_printf("stream_checkbox%d",c), streamcheckbox);
	gtk_container_add(GTK_CONTAINER(controlvbox),streamcheckbox);*/
  	if (gsgui->sd->active==1) {
  		if (gsgui->sd->sub_stream_status[c]) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(streamcheckbox),TRUE);
  		
  	}
  	else {
  		gtk_widget_set_sensitive(streamcheckbox,FALSE);
  	}
  	g_signal_connect (G_OBJECT(streamcheckbox), "toggled", G_CALLBACK (checkbox_toggled), gsgui);
  }
  /* Add relays */
  gsgui->relay_checkbuttons=NULL;
  g_hash_table_foreach(gsgui->sd->relays, gui_add_relay, gsgui);
  if (gsgui->sd->active==0) {
	g_list_foreach(gsgui->relay_checkbuttons,gtk_widget_set_sensitive,FALSE);
  }
  /* sort out vumeter */
#ifdef VUMETER
  /* remove scales and replace them with vumeters */
  tempwidget = glade_xml_get_widget(gsgui->windowdefs, "table7"); 
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "rms0_scale"));
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "peak0_scale"));
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "decay0_scale"));
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "rms1_scale"));
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "peak1_scale"));
  gtk_container_remove(GTK_CONTAINER(tempwidget), glade_xml_get_widget(gsgui->windowdefs, "decay1_scale"));

  #endif
#ifdef GST_06
  tempwidget=gtk_socket_new();
  g_hash_table_insert(gsgui->table,g_strdup("visualisation"),tempwidget);


  // get the xid from the drawing area
  g_object_get (G_OBJECT (gsgui->sd->pe->vsink), "xid",&xid,NULL);
  g_object_set (G_OBJECT (gsgui->sd->pe->vsink), "toplevel",FALSE,NULL);
  g_signal_connect (G_OBJECT(gsgui->sd->pe->vsink), "have-size", G_CALLBACK (xvideosink_have_size), gsgui);
  
  if (xid!=0) {
	printf("stolen!\n");
	gtk_socket_steal(GTK_SOCKET(tempwidget),xid);
  }
  gtk_container_remove(GTK_CONTAINER(glade_xml_get_widget(gsgui->windowdefs,"vbox9")),glade_xml_get_widget(gsgui->windowdefs,"visualisation"));
  gtk_container_add (GTK_CONTAINER(glade_xml_get_widget(gsgui->windowdefs,"vbox9")), tempwidget);
  gtk_widget_show_all (GTK_WIDGET (window));
  gtk_widget_show_now (GTK_WIDGET (window));
  g_signal_connect (G_OBJECT(gsgui->sd->pe->vsink), "have-xid", G_CALLBACK (xvideosink_have_xid),gsgui);
#else
  if (gsgui->sd->sub_stream_status[3]==1) {
  	tempwidget=glade_xml_get_widget(gsgui->windowdefs,"visualisation");
  	g_signal_connect_after(GTK_WIDGET(tempwidget), "realize", G_CALLBACK(drawingarea_after_realize),gsgui);
  	g_signal_connect(GST_X_OVERLAY(gsgui->sd->pe->vsink),"desired_size_changed",G_CALLBACK(xvimagesink_have_size),gsgui);
  }
  gtk_widget_show_all(GTK_WIDGET(window));
  gtk_widget_show_now(GTK_WIDGET(window));
  #endif
#ifdef VUMETER
  tempwidget = glade_xml_get_widget(gsgui->windowdefs, "table7"); 
  GtkVUMeter* vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);

  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 2, 3);
  g_hash_table_insert(gsgui->table, g_strdup("rms0_vumeter"), vumeter);

  vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);
  
  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 3, 4);
  g_hash_table_insert(gsgui->table, g_strdup("peak0_vumeter"), vumeter);

  vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);
  
  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 4, 5);
  g_hash_table_insert(gsgui->table, g_strdup("decay0_vumeter"), vumeter);
  
  vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);
  
  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 6, 7);
  g_hash_table_insert(gsgui->table, g_strdup("rms1_vumeter"), vumeter);

  vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);
  
  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 7, 8);
  g_hash_table_insert(gsgui->table, g_strdup("peak1_vumeter"), vumeter);

  vumeter = gtk_vumeter_new (FALSE);
  gtk_vumeter_set_min_max (vumeter, -900, 0);
  gtk_vumeter_set_scale (vumeter, GTK_VUMETER_SCALE_LOG);
  gtk_vumeter_set_level (vumeter, -900);
  gtk_table_attach_defaults (GTK_TABLE(tempwidget), GTK_WIDGET(vumeter), 1, 2, 8, 9);
  g_hash_table_insert(gsgui->table, g_strdup("decay1_vumeter"), vumeter);

  gtk_widget_show_all(tempwidget);
  #endif

  /* exit button */
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"exit_button");
  g_signal_connect(G_OBJECT(tempwidget),"clicked", G_CALLBACK(exit_button_clicked),gsgui);
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"quit1");
  g_signal_connect(tempwidget, "activate",G_CALLBACK(exit_button_clicked),gsgui);
  
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"changefilename_button");
  g_signal_connect(G_OBJECT(tempwidget),"clicked", G_CALLBACK(changefilename_button_clicked),gsgui);
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"change_filename1");
  g_signal_connect(G_OBJECT(tempwidget),"activate", G_CALLBACK(changefilename_button_clicked),gsgui);

  setup_preferences_window(gsgui);
  /* preferences window */
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"preferences1");
  g_signal_connect(tempwidget, "activate", G_CALLBACK(show_preferences_window),gsgui);
  tempwidget=glade_xml_get_widget(gsgui->windowdefs,"save1");
  g_signal_connect(tempwidget, "activate",G_CALLBACK(save_preferences),gsgui);
  
  glade_xml_signal_autoconnect(gsgui->windowdefs);
}
