/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * 
 * Derived from
 * demo.c from GStreamer examples
 * demo.c: sample application to display VU meter-like output of level
 * Copyright (C) 2003
 *           Thomas Vander Stichele <thomas at apestaart dot org>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <fcntl.h>
/* global array for the scale widgets, we'll assume stereo */
GtkWidget *elapsed;
GtkWidget *scale[2][3];

static gboolean
level_changed (GIOChannel* source, GIOCondition condition, gpointer data)
{
  gchar** vars;
  gint channel;
  gchar* line;
  if (condition==G_IO_IN) {
    if (g_io_channel_read_line(source,&line,NULL,NULL,NULL)==G_IO_STATUS_NORMAL) {
	vars=g_strsplit(line," ",0);
    	if (vars[0]!=NULL) {
    		channel=atoi(vars[0]);
		gtk_label_set(GTK_LABEL(elapsed), vars[1]);
		gtk_range_set_value(GTK_RANGE(scale[channel][0]),g_ascii_strtod(vars[2],NULL));
		gtk_range_set_value(GTK_RANGE(scale[channel][1]),g_ascii_strtod(vars[3],NULL));
		gtk_range_set_value(GTK_RANGE(scale[channel][2]),g_ascii_strtod(vars[4],NULL));
    	}
    	g_strfreev(vars);
	g_free(line);
    	return TRUE;
    }
  }
  gtk_main_quit ();
  return FALSE;
}

static void
setup_gui ()
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *label, *hbox;
  int c;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_signal_connect (window, "destroy", gtk_main_quit, NULL);

  vbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  /* elapsed widget */
  hbox = gtk_hbox_new (TRUE, 0);
  label = gtk_label_new ("Elapsed");
  elapsed = gtk_label_new ("0.000");
  gtk_container_add (GTK_CONTAINER (hbox), label);
  gtk_container_add (GTK_CONTAINER (hbox), elapsed);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);

  for (c = 0; c < 2; c++) {
    /* RMS */
    hbox = gtk_hbox_new (TRUE, 0);
    label = gtk_label_new ("RMS");
    gtk_container_add (GTK_CONTAINER (hbox), label);
    scale[c][0] = gtk_hscale_new_with_range (-90.0, 0.0, 0.2);
    gtk_widget_set_size_request (scale[c][0], 100, -1);
    gtk_container_add (GTK_CONTAINER (hbox), scale[c][0]);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    /* peak */
    hbox = gtk_hbox_new (TRUE, 0);
    label = gtk_label_new ("peak");
    gtk_container_add (GTK_CONTAINER (hbox), label);
    scale[c][1] = gtk_hscale_new_with_range (-90.0, 0.0, 0.2);
    gtk_widget_set_size_request (scale[c][1], 100, -1);
    gtk_container_add (GTK_CONTAINER (hbox), scale[c][1]);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
    /* decay */
    hbox = gtk_hbox_new (TRUE, 0);
    label = gtk_label_new ("decaying peek");
    gtk_container_add (GTK_CONTAINER (hbox), label);
    scale[c][2] = gtk_hscale_new_with_range (-90.0, 0.0, 0.2);
    gtk_widget_set_size_request (scale[c][2], 100, -1);
    gtk_container_add (GTK_CONTAINER (hbox), scale[c][2]);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);
  }

  gtk_widget_show_all (GTK_WIDGET (window));
}

int
main (int argc, char *argv[])
{

  GIOChannel* ioc;
  int fd;
  gtk_init (&argc, &argv);
  
  /* setup GUI */
  setup_gui ();
  fd=open("blah",O_RDONLY|O_NONBLOCK,NULL);
  ioc=g_io_channel_unix_new(fd);
  g_io_add_watch(ioc,G_IO_IN,level_changed,NULL);
  
  gtk_main ();

  return 0;
}
