#ifndef _ACAST_RELAY_H
#define _ACAST_RELAY_H

#include <gst/gst.h>
#include <glib.h>

#include "gststuff.h"
struct acast_relay
{
	GstThread* thread;
	GstElement* src;
	GstElement* sink;
	
	/* optional */
	GstElement* decode;
	GstElement* encode;
	
	int status;
};

int acast_add_relay(struct stream_details* sd, gchar* name, gchar* ip, int port, gchar* mount, gchar* password, 
				gchar* servertype, gchar* webcasttype, int bitrate, int channels);
int acast_start_relay(struct stream_details* sd, const gchar* name);
int acast_stop_relay(struct stream_details* sd, const gchar* name);
int acast_delete_relay(struct stream_details* sd,const gchar* name);
gboolean acast_relay_get_active(struct stream_details* sd, const gchar* name);


#endif
