/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GSTSAVE_GUI_H
#define _GSTSAVE_GUI_H

#include <gtk/gtk.h>
#include <glib.h>

#include <glade/glade.h>

struct pipeline_elements;
struct stream_details;


/* GUI elements */
struct gstsave_gui
{
	GHashTable* table;
	GList* relay_checkbuttons;
	GladeXML* windowdefs;
	struct stream_details* sd;
};

/* function prototypes */
/* gui callbacks */
static void xvideosink_have_size(GObject* object, gint arg0, gint arg1, gpointer user_data);
static void xvideosink_have_xid(GObject* object, gint arg0, gpointer user_data);
static void checkbox_toggled(GtkToggleButton* tb, gpointer user_data);
static void changefilename_button_clicked(GtkButton* b, gpointer user_data);
static void exit_button_clicked(GtkButton* b, gpointer user_data);


/* gui setup */
//void save_preferences(struct gstsave_gui* gsgui);

void update_stream_checkboxes(struct gstsave_gui* gsgui);

void setup_preferences_window(struct gstsave_gui* gsgui);
void setup_gui (struct gstsave_gui* gsgui);

#endif
