/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <glade/glade.h>

#include <stdio.h>
#include <string.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

#include "gststuff.h"
#include "gui.h"
#include "console.h"
#include "parser.h"

#ifndef GST_06
#include <gst/xoverlay/xoverlay.h>
#endif

#ifdef VUMETER
#include "gtkvumeter.h"
#endif

/* ugly  for vorbis bitrates less than 48k/sec */
#define BITRATE_MAP_NUMBITRATES 2
int bitrate_map[2][BITRATE_MAP_NUMBITRATES]= { {16, 11025}, {20, 20050} };

static void
level_callback (GstElement * element, gdouble time, gint channel,
    gdouble rms, gdouble peak, gdouble decay, gpointer user_data)
{
  gchar *label;
  gchar* tempkey;
  GtkWidget* tempwidget;
  struct gstsave_gui* gsgui=(struct gstsave_gui*)user_data;


  if (gsgui->sd->gui) {
	//tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,"elapsedtime_label"));
	gdk_threads_enter();
	tempwidget=glade_xml_get_widget(gsgui->windowdefs,"elapsedtime_label");
	label=g_strdup_printf("% 07.3f",time);
	if (strlen(label)>6) label[6]='\0';
	gtk_label_set(GTK_LABEL(tempwidget), label);
	g_free(label);
	#ifdef VUMETER
	tempkey=g_strdup_printf("rms%d_vumeter",channel);
	tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
	g_free(tempkey);
	gtk_vumeter_set_level (tempwidget, (gint)(rms*10.0));
	tempkey=g_strdup_printf("peak%d_vumeter",channel);
	tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
	g_free(tempkey);
	gtk_vumeter_set_level (tempwidget, (gint)(peak*10.0));
	tempkey=g_strdup_printf("decay%d_vumeter",channel);
        tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
        g_free(tempkey);
        gtk_vumeter_set_level (tempwidget, (gint)(decay*10.0));
	#else
	tempkey=g_strdup_printf("rms%d_scale",channel);
	//tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
	tempwidget=glade_xml_get_widget(gsgui->windowdefs,tempkey);
	g_free(tempkey);
	gtk_range_set_value(GTK_RANGE(tempwidget),(gint)(rms*10.0));
	tempkey=g_strdup_printf("peak%d_scale",channel);
	//tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
	tempwidget=glade_xml_get_widget(gsgui->windowdefs,tempkey);
	
	g_free(tempkey);
        gtk_range_set_value(GTK_RANGE(tempwidget),(gint)(peak*10.0));
	tempkey=g_strdup_printf("decay%d_scale",channel);
	//tempwidget=GTK_WIDGET(g_hash_table_lookup(gsgui->table,tempkey));
	tempwidget=glade_xml_get_widget(gsgui->windowdefs,tempkey);
	
	g_free(tempkey);
        gtk_range_set_value(GTK_RANGE(tempwidget),(gint)(decay*10.0));
	#endif
	gdk_threads_leave();

  }	
  label = g_strdup_printf ("%d %.3f %.3f %.3f %.3f\n", channel, time,rms,peak,decay);
  if (gsgui->sd->ioc->is_writeable) {
  	g_io_channel_write_chars(gsgui->sd->ioc,label,-1,NULL,NULL);
  	g_io_channel_flush(gsgui->sd->ioc,NULL);
  }
  g_free (label);
  
}

GstElement *
element_create (char *name, char *element)
  /*
   * create the element
   * print an error if it can't be created
   * return NULL if it couldn't be created
   * return element if it did work
   */
{
  GstElement *el = NULL;

  el = (GstElement *) gst_element_factory_make (element, name);
  if (el == NULL)
  {
    fprintf (stderr, "Could not create element %s (%s) !\n", name, element);
    return NULL;
  }
  else
    return el;
}

static void remove_webcast_encoder(struct stream_details* sd)
{
  /*lets remove the elements and unlink the pads*/
  if (sd->pe->tempas1) {
    gst_pad_disconnect(gst_element_get_pad(sd->pe->tempac1,"src"),
		       gst_element_get_pad(sd->pe->tempas1,"sink"));
    if (sd->pe->tempas2) {
      gst_pad_disconnect(gst_element_get_pad(sd->pe->tempas1,"src"),
			 gst_element_get_pad(sd->pe->tempas2,"sink"));
      gst_pad_disconnect(gst_element_get_pad(sd->pe->tempas2,"src"),
			 gst_element_get_pad(sd->pe->enc2,"sink"));
    }
    else {
      gst_pad_disconnect(gst_element_get_pad(sd->pe->tempac1,"src"),
			 gst_element_get_pad(sd->pe->enc2,"sink"));
    }
  }
  else {
    gst_pad_disconnect(gst_element_get_pad(sd->pe->tempac1,"src"),
		       gst_element_get_pad(sd->pe->enc2,"sink"));
  }
  gst_pad_disconnect(gst_element_get_pad(sd->pe->enc2,"src"),
		     gst_element_get_pad(sd->pe->tee2,"sink"));

  if (sd->sub_stream_status[1]) {
    gst_pad_disconnect (sd->pe->tee2_src1, gst_element_get_pad(sd->pe->sink2,"sink"));
    gst_element_release_request_pad(sd->pe->tee2, sd->pe->tee2_src1);
  }
  if (sd->sub_stream_status[2]) {
    gst_pad_disconnect (sd->pe->tee2_src2, gst_element_get_pad(sd->pe->sinkweb,"sink"));
    gst_element_release_request_pad(sd->pe->tee2, sd->pe->tee2_src2);
  }
  gst_bin_remove(sd->pe->pipeline,sd->pe->tee2);
  sd->pe->tee2=NULL;
  if (sd->pe->tempas1) {
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->tempas1);
    sd->pe->tempas1=NULL;
  }
  if (sd->pe->tempas2) {
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->tempas2);
    sd->pe->tempas2=NULL;
  }
  
  gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->enc2);
}

static void add_webcast_encoder(struct stream_details* sd, gboolean start)
{
  GstStaticCaps tempcaps,tempcaps2;
  int i;
  int rateneeded;
  gboolean add_queue=FALSE;
  gboolean add_tee=FALSE;
  gboolean add_thread=FALSE;
  gboolean add_tempac1=FALSE;

  tempcaps.caps.type=0;
  tempcaps2.caps.type=0;

  /*if (!sd->pe->webcast_encoder_thread) {
    sd->pe->webcast_encoder_thread=gst_thread_new("webcast_encoder_thread");
    add_thread=TRUE;
  }
  if (!sd->pe->webcast_encoder_queue) { 
    sd->pe->webcast_encoder_queue=element_create("webcast_encoder_queue","queue");
    add_queue=TRUE;
    }*/
  if (!sd->pe->tee2) {
    sd->pe->tee2 = element_create ("tee2", "tee");
    add_tee=TRUE;
  }
  if (!sd->pe->tempac1) {
    sd->pe->tempac1 = element_create("tempac1","audioconvert");
    add_tempac1=TRUE;
  }
  /* do ugly stuff */
  rateneeded=44100;
  if (sd->bitrate[1]<64) {
    for(i=0;i<BITRATE_MAP_NUMBITRATES;i++) {
      if (sd->bitrate[1]>=bitrate_map[i][0]) {
	rateneeded=bitrate_map[i][1];
      }
    }
    switch (rateneeded) {
    case 11025:
      sd->pe->tempas1=element_create("wcas1","audioscale");
      sd->pe->tempas2=element_create("wcas2","audioscale");
      break;
    case 22050:
      sd->pe->tempas1=element_create("wcas1","audioscale");
      sd->pe->tempas2=NULL;
      break;
    }
  }
  if (g_strcasecmp(sd->webcasttype,"ogg")==0) {
    
    
    sd->pe->enc2 = element_create("enc2","vorbisenc");
    //g_print("bitrate: %d\n",sd->bitrate[1]);
    g_object_set (G_OBJECT(sd->pe->enc2), "max-bitrate",(int)(sd->bitrate[1]*1000),NULL);

    
  }
  else {
    sd->pe->enc2 = element_create ("enc2","lame");
    g_object_set (G_OBJECT(sd->pe->enc2), "mode", sd->mode[1], NULL);
    g_object_set (G_OBJECT(sd->pe->enc2), "bitrate", sd->bitrate[1], NULL);
  }
  //if (add_queue) gst_bin_add(GST_BIN(sd->pe->webcast_encoder_thread),sd->pe->webcast_encoder_queue);
  if (add_tempac1) gst_bin_add(GST_BIN(sd->pe->pipeline),sd->pe->tempac1);
  if (sd->pe->tempas1) gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->tempas1);
  if (sd->pe->tempas2) gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->tempas2);
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc2);
  if (add_tee) gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->tee2);
  //if (add_thread) gst_bin_add(GST_BIN(sd->pe->pipeline),sd->pe->webcast_encoder_thread);
  /* request one pad from tee */
  if (add_tempac1) {
    sd->pe->tee1_src2 = gst_element_get_request_pad (sd->pe->tee, "src%d");
    tempcaps2.string=g_strdup("audio/x-raw-int, rate=44100, channels=2");
    gst_pad_link_filtered(sd->pe->tee1_src2,gst_element_get_pad(sd->pe->tempac1,"sink"),gst_static_caps_get(&tempcaps2));
    //gst_pad_connect(sd->pe->tee1_src2,gst_element_get_pad(sd->pe->tempac1,"sink"));
    g_free(tempcaps2.string);
  }
  
  //gst_pad_connect(gst_element_get_pad(sd->pe->webcast_encoder_queue,"src"),gst_element_get_pad(sd->pe->tempac1,"sink"));
				   
  if (sd->pe->tempas1) {
    tempcaps.string=g_strdup_printf("audio/x-raw-int, rate=22050, channels=%d",sd->mode[1]==0 ? 2 : 1);
    gst_pad_connect (gst_element_get_pad(sd->pe->tempac1,"src"), gst_element_get_pad (sd->pe->tempas1, "sink"));
    if (sd->pe->tempas2) {
      //gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas1, "src"), gst_element_get_pad (sd->pe->tempas2, "sink"), gst_static_caps_get(&tempcaps));
      g_free(tempcaps.string);
      gst_pad_connect(gst_element_get_pad(sd->pe->tempas1,"src"),gst_element_get_pad(sd->pe->tempas2,"sink"));
      tempcaps.string=g_strdup_printf("audio/x-raw-int, rate=11025, channels=%d",sd->mode[1]==0 ?2:1);
      gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas2, "src"), gst_element_get_pad (sd->pe->enc2, "sink"), gst_static_caps_get(&tempcaps));
      g_free(tempcaps.string);
    }
    else {
      gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas1, "src"), gst_element_get_pad (sd->pe->enc2, "sink"), gst_static_caps_get(&tempcaps));
      g_free(tempcaps.string);
    }
 
  }
  else {
    gst_pad_connect (sd->pe->tee1_src2, gst_element_get_pad (sd->pe->enc2, "sink"));
  }

  if (!start && add_tee) {
    if (sd->sub_stream_status[1]) {
      sd->pe->tee2_src1=gst_element_get_request_pad(sd->pe->tee2,"src%d");
      gst_pad_connect (sd->pe->tee2_src1, gst_element_get_pad(sd->pe->sink2,"sink"));
    }
    if (sd->sub_stream_status[2]) {
      sd->pe->tee2_src2=gst_element_get_request_pad(sd->pe->tee2,"src%d");
      gst_pad_connect (sd->pe->tee2_src2, gst_element_get_pad(sd->pe->sinkweb,"sink"));
    }
  }
  gst_pad_connect (gst_element_get_pad(sd->pe->enc2,"src"), 
		   gst_element_get_pad(sd->pe->tee2,"sink"));
    
}

int stop_record_stream(struct stream_details* sd)
{

  if (sd->sub_stream_status[0]) {
    

    gst_pad_disconnect (gst_element_get_pad(sd->pe->enc1,"src"),
			gst_element_get_pad(sd->pe->sink1,"sink"));
    gst_pad_disconnect (sd->pe->tee1_src1, 
			/*gst_element_get_pad(sd->pe->record_queue,"sink"));
			  gst_pad_disconnect(gst_element_get_pad(sd->pe->record_queue,"src"),*/
		       gst_element_get_pad(sd->pe->tempac2,"sink"));
    if (sd->pe->tempas3) {
      gst_pad_disconnect(gst_element_get_pad(sd->pe->tempac2,"src"),
			 gst_element_get_pad(sd->pe->tempas3,"sink"));
      if (sd->pe->tempas4) {
	gst_pad_disconnect(gst_element_get_pad(sd->pe->tempas3,"src"),
			   gst_element_get_pad(sd->pe->tempas4,"sink"));
	gst_pad_disconnect(gst_element_get_pad(sd->pe->tempas4,"src"),
		       gst_element_get_pad(sd->pe->enc1,"sink"));
      }
      else {
	gst_pad_disconnect(gst_element_get_pad(sd->pe->tempas3,"src"),
		       gst_element_get_pad(sd->pe->enc1,"sink"));
      }
    }
    else {
      gst_pad_disconnect(gst_element_get_pad(sd->pe->tempac2,"src"),
			 gst_element_get_pad(sd->pe->enc1,"sink"));
    }
    //gst_element_set_state(GST_ELEMENT(sd->pe->record_thread),GST_STATE_NULL);    
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sink1);
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->enc1);
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->tempac2);
    if (sd->pe->tempas3) {
      gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->tempas3);
      sd->pe->tempas3=NULL;
    }
    if (sd->pe->tempas4) {
      gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->tempas4);
      sd->pe->tempas4=NULL;
    }
    //gst_bin_remove(GST_BIN(sd->pe->record_thread),sd->pe->record_queue);
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->record_thread);


    gst_element_release_request_pad(sd->pe->tee, sd->pe->tee1_src1);
    sd->sub_stream_status[0]=0;
    return(0);
  }
  return -1;
}

int stop_webcast_record_stream(struct stream_details* sd)
{
  // g_free(mp3stream1fname);
  
  if (sd->sub_stream_status[1]) {
    gst_pad_disconnect (sd->pe->tee2_src1, gst_element_get_pad(sd->pe->sink2,"sink"));
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sink2);
    // free sink1
    //gst_element_destroy(sink2);
    
    gst_element_release_request_pad(sd->pe->tee2, sd->pe->tee2_src1);
    sd->sub_stream_status[1]=0;
    return(0);
  }
  return -1;
}
int stop_webcast_substream(struct stream_details* sd)
{
  if (sd->sub_stream_status[2]) {
    gst_pad_disconnect (sd->pe->tee2_src2, gst_element_get_pad(sd->pe->sinkweb,"sink"));
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sinkweb);
    gst_element_release_request_pad(sd->pe->tee2, sd->pe->tee2_src2);
    sd->sub_stream_status[2]=0;
    return(0);
  }
  return -1;
}
int stop_visualisation_substream(struct stream_details* sd)
{
  /* currently bug in gst means this has to be disabled */
#if 0
  if (sd->sub_stream_status[3]) {
    
#ifdef GST_06
    
    gst_pad_disconnect (gst_element_get_pad (sd->pe->color,"src"),
#else
    gst_x_overlay_set_xwindow_id(GST_X_OVERLAY(sd->pe->vsink),0);
    gst_pad_disconnect (gst_element_get_pad (sd->pe->color,"src"),
#endif
			gst_element_get_pad (sd->pe->vsink,"sink"));	
			gst_pad_disconnect (gst_element_get_pad (sd->pe->queue,"src"),
			gst_element_get_pad (sd->pe->color,"sink"));
			gst_pad_disconnect (gst_element_get_pad (sd->pe->vis,"src"),
					    gst_element_get_pad (sd->pe->queue,"sink"));
			gst_pad_disconnect (gst_element_get_pad (sd->pe->s2m,"src"),
					    gst_element_get_pad (sd->pe->vis,"sink"));
			gst_pad_disconnect(sd->pe->tee1_src3, 
					   gst_element_get_pad (sd->pe->s2m, "sink"));
			gst_bin_remove (GST_BIN (sd->pe->vis_thread), sd->pe->queue);
			gst_bin_remove (GST_BIN (sd->pe->vis_thread), sd->pe->color);
			gst_bin_remove (GST_BIN (sd->pe->vis_thread), sd->pe->vsink);
			
			gst_bin_remove (GST_BIN (sd->pe->pipeline), sd->pe->s2m);
			gst_bin_remove (GST_BIN (sd->pe->pipeline), sd->pe->vis);
			
			gst_bin_remove (GST_BIN (sd->pe->pipeline), sd->pe->vis_thread);
			
			gst_element_release_request_pad(sd->pe->tee, sd->pe->tee1_src3);
			sd->sub_stream_status[3]=0;
	 	return 0;
	
	}
	#endif
	return -1;
}

int stop_listen_substream(struct stream_details* sd)
{
  if (sd->sub_stream_status[5]) {
    gst_element_set_state(GST_ELEMENT(sd->pe->listen_thread),GST_STATE_NULL);
    gst_pad_disconnect(gst_element_get_pad(sd->pe->listen_queue,"src"),
		       gst_element_get_pad(sd->pe->audiosink,"sink"));
    
    gst_pad_disconnect(GST_PAD(sd->pe->tee1_src5), 
		       gst_element_get_pad(sd->pe->listen_queue,"sink"));
    
    gst_bin_remove(GST_BIN(sd->pe->listen_thread),sd->pe->audiosink);
    gst_bin_remove(GST_BIN(sd->pe->listen_thread),sd->pe->listen_queue);
    //gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->listen_thread);
    /* need to free the listen_thread and the removed elements */
    
    gst_element_release_request_pad(sd->pe->tee, GST_PAD(sd->pe->tee1_src5));
    
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->listen_thread);
    sd->sub_stream_status[5]=0;
    return(0);
  }
  return -1;
}	
int stop_wav_substream1(struct stream_details* sd)
{

  if (sd->sub_stream_status[4]) {
    gst_pad_disconnect (gst_element_get_pad(sd->pe->enc3,"src"),
			gst_element_get_pad(sd->pe->sink3,"sink"));
    gst_pad_disconnect(sd->pe->tee1_src4, gst_element_get_pad(sd->pe->enc3,"sink"));
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sink3);
    gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->enc3);
    
    gst_element_release_request_pad(sd->pe->tee, sd->pe->tee1_src4);
    sd->sub_stream_status[4]=0;
    return(0);
  }
  return -1;
}

int add_record_stream(struct stream_details* sd)
{
  GstStaticCaps tempcaps, tempcaps2;
  int rateneeded,i;
  tempcaps.caps.type=0;
  tempcaps2.caps.type=0;
  rateneeded=44100;

  if (!sd->sub_stream_status[0]) {
    g_print ("Add & Connect %s Record Stream Bitrate:%d\n", sd->recordtype, sd->bitrate[0]);
    sd->curcounter++;
    
    sd->recordstream_fname=g_strdup_printf("%s/%s_%s_%d_%d.%s",sd->dirname, sd->str,
					   sd->datestr, sd->bitrate[0], sd->curcounter,
					   g_strcasecmp(sd->recordtype,"ogg")==0 ? "ogg" : "mp3");
    
    //sd->pe->record_thread=gst_bin_new("record_thread");
    //if (!(sd->pe->record_queue=element_create("record_queue","queue"))) return 1;
    if (!(sd->pe->tempac2=element_create("tempac2","audioconvert"))) return 1;

    /* do ugly stuff */
    
    if (sd->bitrate[0]<64) {
      for(i=0;i<BITRATE_MAP_NUMBITRATES;i++) {
	if (sd->bitrate[0]>=bitrate_map[i][0]) {
	  rateneeded=bitrate_map[i][1];
	}
      }
      switch (rateneeded) {
      case 11025:
	sd->pe->tempas3=element_create("wcas1","audioscale");
	sd->pe->tempas4=element_create("wcas2","audioscale");
	break;
      case 22050:
	sd->pe->tempas3=element_create("wcas1","audioscale");
	sd->pe->tempas4=NULL;
	break;
      case 44100:
	sd->pe->tempas3=NULL;
	sd->pe->tempas4=NULL;
      }
    }
    if (g_strcasecmp(sd->recordtype,"ogg")==0) {
      if (!(sd->pe->enc1 = element_create("enc1","vorbisenc"))) return 1;
      //g_object_set (G_OBJECT(sd->pe->enc1), "quality",(float)(sd->quality[0]/10),NULL);
      g_object_set (G_OBJECT(sd->pe->enc1), "max-bitrate",(int)(sd->bitrate[0]*1000),NULL);

     
    }
    else {						
      if (!(sd->pe->enc1 = element_create ("enc1","lame"))) return 1;
      g_object_set (G_OBJECT(sd->pe->enc1), "mode", sd->mode[0], NULL);
      g_object_set (G_OBJECT(sd->pe->enc1), "bitrate", sd->bitrate[0], NULL);
    }
    
    if (!(sd->pe->sink1 = element_create ("sink1", "filesink"))) return 1;
    g_object_set (G_OBJECT (sd->pe->sink1), "location", sd->recordstream_fname, NULL);
    /* request one pad from tee */
    sd->pe->tee1_src1 = gst_element_get_request_pad (sd->pe->tee, "src%d");
    //gst_bin_add (GST_BIN (sd->pe->record_thread), sd->pe->record_queue);
    gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->tempac2);
    if (sd->pe->tempas3) gst_bin_add(sd->pe->pipeline, sd->pe->tempas3);
    if (sd->pe->tempas4) gst_bin_add(sd->pe->pipeline, sd->pe->tempas4);
    gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc1);
    gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->sink1);
    //gst_bin_add (GST_BIN (sd->pe->pipeline),sd->pe->record_thread);		
    /*gst_pad_connect (sd->pe->tee1_src1, 
      gst_element_get_pad(sd->pe->record_queue,"sink"));*/
    tempcaps.string=g_strdup("audio/x-raw-int, rate=44100, channels=2");
    gst_pad_link_filtered(/*gst_element_get_pad(sd->pe->record_queue,"src"),*/sd->pe->tee1_src1,
			  gst_element_get_pad(sd->pe->tempac2,"sink"),
			  gst_static_caps_get(&tempcaps));
    g_free(tempcaps.string);
    tempcaps2.string=g_strdup_printf("audio/x-raw-int, rate=%d, channels=%d",rateneeded,sd->mode[0]==0 ? 1:2);
    if (sd->pe->tempas3) {
      gst_pad_connect(gst_element_get_pad(sd->pe->tempac2,"src"),
		      gst_element_get_pad(sd->pe->tempas3,"sink"));
      if (sd->pe->tempas4) {
	gst_pad_connect(gst_element_get_pad(sd->pe->tempas3,"src"),
			gst_element_get_pad(sd->pe->tempas4,"sink"));
	gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas4,"src"),
			       gst_element_get_pad (sd->pe->enc1, "sink"),
			       gst_static_caps_get(&tempcaps2));
      }
      else {
	gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas3,"src"),
			       gst_element_get_pad (sd->pe->enc1, "sink"),
			       gst_static_caps_get(&tempcaps2));
      }
    }
    else {
      gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempac2,"src"),
			     gst_element_get_pad (sd->pe->enc1, "sink"),
			     gst_static_caps_get(&tempcaps2));
    }
    g_free(tempcaps2.string);
    gst_pad_connect (gst_element_get_pad(sd->pe->enc1,"src"), 
		     gst_element_get_pad(sd->pe->sink1,"sink"));
    gst_element_set_state(sd->pe->tempac2,GST_STATE_READY);
    if (sd->pe->tempas3) gst_element_set_state(sd->pe->tempas3,GST_STATE_READY);
    if (sd->pe->tempas4) gst_element_set_state(sd->pe->tempas4,GST_STATE_READY);
    gst_element_set_state (sd->pe->enc1,GST_STATE_READY);
    gst_element_set_state(sd->pe->sink1,GST_STATE_READY);
    sd->sub_stream_status[0]=1;
    
    return 0;
  }
  return -1;
}

int add_webcast_record_stream(struct stream_details* sd,gboolean start)
{
  GstStaticCaps tempcaps;  
  int rateneeded;
  int i;

  tempcaps.caps.type=0;

  if (!sd->sub_stream_status[1]) {
    g_print ("Add & Connect %s Webcast Quality Stream Bitrate:%d\n", sd->webcasttype, sd->bitrate[1]);
    
    if (!start) {
      remove_webcast_encoder(sd);
      add_webcast_encoder(sd,FALSE);
    }
		

    sd->curcounter++;
    sd->webcaststream_fname=g_strdup_printf("%s/%s_%s_%d_%d.%s",sd->dirname, sd->str,
					    sd->datestr, sd->bitrate[1], sd->curcounter,
					    g_strcasecmp(sd->webcasttype,"ogg")==0 ? "ogg" : "mp3");
    if (!(sd->pe->sink2 = element_create ("sink2", "filesink"))) return 1;
    g_object_set (G_OBJECT (sd->pe->sink2), "location", sd->webcaststream_fname, NULL);
    sd->pe->tee2_src1 = gst_element_get_request_pad(sd->pe->tee2, "src%d");
    gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->sink2);
    gst_pad_connect (sd->pe->tee2_src1, gst_element_get_pad (sd->pe->sink2, "sink"));
    sd->sub_stream_status[1]=1;
    return 0;
  }
  return -1;
}

int add_webcast_substream(struct stream_details* sd,gboolean start)
{

  if (!sd->sub_stream_status[2]) {
    g_print ("Add & Connect Webcast Stream 3 Server Type: %s IP:%s Port: %d Mount: %s\n", sd->webcastserver,sd->iceip,sd->iceport,sd->icemount);
    if (!start) {
      remove_webcast_encoder(sd);
      add_webcast_encoder(sd,FALSE);
    }
#ifdef HAVE_SHOUT2
    if (g_strcasecmp(sd->webcasttype,"ogg")==0 || g_strcasecmp(sd->webcastserver,"icecast2")==0) {
      if (!(sd->pe->sinkweb = element_create ("sinkweb", "shout2send"))) return 1;
      g_object_set(G_OBJECT(sd->pe->sinkweb), "protocol",3,NULL);
    }
#endif		
    if (g_strcasecmp(sd->webcasttype,"mp3")==0) {
#ifdef HAVE_SHOUT2
      if (g_strcasecmp(sd->webcastserver,"icecast2")==0) {
	if (!(sd->pe->sinkweb = element_create ("sinkweb", "shout2send"))) return 1;
	g_object_set(G_OBJECT(sd->pe->sinkweb), "protocol",3,NULL);
      }
      else if (g_strcasecmp(sd->webcastserver,"icecast1")==0) {
	if (!(sd->pe->sinkweb = element_create ("sinkweb", "shout2send"))) return 1;
	g_object_set(G_OBJECT(sd->pe->sinkweb), "protocol",1,NULL);
      }
      else if (g_strcasecmp(sd->webcastserver,"shoutcast")==0) {
	if (!(sd->pe->sinkweb = element_create ("sinkweb", "shout2send"))) return 1;
	g_object_set(G_OBJECT(sd->pe->sinkweb), "protocol",2,NULL);
      }
#else
      if (g_strcasecmp(sd->webcastserver,"icecast1")==0) {
	if (!(sd->pe->sinkweb = element_create ("sinkweb", "icecastsend"))) return 1;
	g_object_set(G_OBJECT(sd->pe->sinkweb), "icy",FALSE,NULL);
      }
      else if (g_strcasecmp(sd->webcastserver,"shoutcast")==0) {
	if (!(sd->pe->sinkweb = element_create ("sinkweb", "icecastsend"))) return 1;
	g_object_set(G_OBJECT(sd->pe->sinkweb), "icy",TRUE,NULL);
      }
#endif
    }
    
    g_object_set (G_OBJECT(sd->pe->sinkweb), "ip", sd->iceip, NULL);
    g_object_set (G_OBJECT(sd->pe->sinkweb), "port", sd->iceport, NULL);
    g_object_set (G_OBJECT(sd->pe->sinkweb), "mount", sd->icemount, NULL);
    g_object_set (G_OBJECT(sd->pe->sinkweb), "password", sd->icepass, NULL);
    
    g_print ("Add & Connect Webcast Stream\n");
    sd->pe->tee2_src2 = gst_element_get_request_pad(sd->pe->tee2, "src%d");
    gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->sinkweb);
    gst_pad_connect (sd->pe->tee2_src2, gst_element_get_pad (sd->pe->sinkweb, "sink"));
    sd->sub_stream_status[2]=1;
    return 0;
  }
  return -1;
}

int add_visualisation_substream(struct stream_details* sd)
{
	
  if (sd->gui) {
    g_print ("Add & Connect Visualisation Stream\n");
#ifdef GST_06
    if (!(sd->pe->s2m = element_create("s2m","stereo2mono"))) return 1;
    if (!(sd->pe->vis = element_create("vis","monoscope"))) return 1;
    
#else
    if (!(sd->pe->s2m = element_create("s2m","audioconvert"))) return 1;
    
    if (!(sd->pe->vis = element_create("vis",sd->visplugin))) return 1;
    
#endif
    if (!(sd->pe->queue = element_create("queue1","queue"))) return 1;
#ifdef GST_06
    if (!(sd->pe->color = element_create("color","colorspace"))) return 1;
    if (!(sd->pe->vsink = element_create("vsink","xvideosink"))) return 1;
#else
    if (!(sd->pe->color = element_create("color","ffcolorspace"))) return 1;
    
    if (!(sd->pe->vsink = element_create("vsink","ximagesink"))) return 1;
    //g_object_set(G_OBJECT(sd->pe->vsink),"synchronous",TRUE,NULL);
    //gst_x_overlay_set_xwindow_id(GST_X_OVERLAY(sd->pe->vsink),0);
#endif
    
    sd->pe->tee1_src3 = gst_element_get_request_pad(sd->pe->tee,"src%d");
    gst_bin_add (GST_BIN (sd->pe->vis_thread), sd->pe->queue);
    gst_bin_add (GST_BIN (sd->pe->vis_thread), sd->pe->s2m);
    gst_bin_add (GST_BIN (sd->pe->vis_thread), sd->pe->vis);
    
#ifdef GST_06
    gst_bin_add (GST_BIN (sd->pe->vis_thread), sd->pe->color);
#endif
    gst_bin_add (GST_BIN (sd->pe->vis_thread), sd->pe->vsink);
    
    
    gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->vis_thread);
    gst_pad_connect (sd->pe->tee1_src3, 
		     gst_element_get_pad (sd->pe->queue,"sink"));
    gst_pad_connect (gst_element_get_pad (sd->pe->queue,"src"),
		     gst_element_get_pad (sd->pe->s2m, "sink"));
    gst_pad_connect (gst_element_get_pad (sd->pe->s2m,"src"),
		     gst_element_get_pad (sd->pe->vis,"sink"));
    gst_pad_connect (gst_element_get_pad (sd->pe->vis,"src"),
		     
#ifdef GST_06
		     gst_element_get_pad (sd->pe->color,"sink"));
    
    
    gst_pad_connect (gst_element_get_pad (sd->pe->color,"src"),
#else
		     //gst_pad_connect (gst_element_get_pad (sd->pe->color,"src"),
#endif
		     gst_element_get_pad (sd->pe->vsink,"sink"));
    sd->sub_stream_status[3]=1;
    return 0;
  }
  
  return -1;
}

int add_listen_substream(struct stream_details* sd)
{
  if (!sd->sub_stream_status[5]) {
    g_print ("Add and connect listen Stream\n");
    sd->pe->listen_thread = gst_thread_new("listen_thread");
    if (!(sd->pe->listen_queue = element_create("listen_queue","queue"))) return 1;
    if (!(sd->pe->audiosink = element_create("audiosink","osssink"))) return 1;
    sd->pe->tee1_src5 = gst_element_get_request_pad (sd->pe->tee, "src%d");
    gst_bin_add (GST_BIN(sd->pe->listen_thread), sd->pe->listen_queue);
		gst_bin_add (GST_BIN(sd->pe->listen_thread), sd->pe->audiosink);
		gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->listen_thread);

		gst_pad_connect (sd->pe->tee1_src5, 
						gst_element_get_pad(sd->pe->listen_queue,"sink"));
		gst_pad_connect (gst_element_get_pad(sd->pe->listen_queue,"src"),
						gst_element_get_pad (sd->pe->audiosink, "sink"));
		sd->sub_stream_status[5]=1;
		return 0;
	}
	return -1;
}

int add_wav_substream1(struct stream_details* sd)
{

	if (!sd->sub_stream_status[4]) {
		g_print ("Add & Connect .wav Encoding and Recording Stream\n");
		sd->curcounter++;
  		sd->wavstream_fname=g_strdup_printf("%s/%s_%s_%d.wav",sd->dirname, sd->str,
						sd->datestr, sd->curcounter);
		if (!(sd->pe->enc3 = element_create ("enc3","wavenc"))) return 1;
		if (!(sd->pe->sink3 = element_create ("sink3", "filesink"))) return 1;
		g_object_set (G_OBJECT (sd->pe->sink3), "location", sd->wavstream_fname, NULL);
  		/* request one pad from tee */
		sd->pe->tee1_src4 = gst_element_get_request_pad (sd->pe->tee, "src%d");
		gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc3);
		gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->sink3);
		gst_pad_connect (sd->pe->tee1_src4, gst_element_get_pad (sd->pe->enc3, "sink"));
		gst_pad_connect (gst_element_get_pad(sd->pe->enc3,"src"), 
		   gst_element_get_pad(sd->pe->sink3,"sink"));
		sd->sub_stream_status[4]=1;
		return 0;
	}
	return -1;
}

int switch_file(struct stream_details* sd)
{
	GstElement *tsink1, *tsink2, *tsink3;

	if (sd->sub_stream_status[0]) {
		if (!(tsink1 = element_create ("sink1", "filesink"))) return 1;
		g_free(sd->recordstream_fname);
	}
	if (sd->sub_stream_status[1]) {
		if (!(tsink2 = element_create ("sink2","filesink"))) return 1;
		g_free(sd->webcaststream_fname);
	}

	if (sd->sub_stream_status[4]) {
		if (!(tsink3 = element_create ("sink3","filesink"))) return 1;
		g_free(sd->wavstream_fname);
	}

	sd->curcounter++;

	if (sd->sub_stream_status[1]) {
		sd->webcaststream_fname=g_strdup_printf("%s/%s_%s_%d_%d.%s", sd->dirname,
			sd->str,sd->datestr,sd->bitrate[1],sd->curcounter,
			g_strcasecmp(sd->webcasttype,"ogg")==0 ? "ogg" : "mp3");
		printf("New Broadcast Filename %s \n",sd->webcaststream_fname);
	}

	if (sd->sub_stream_status[4]) {
		sd->wavstream_fname=g_strdup_printf("%s/%s_%s_%d.wav", sd->dirname,
			sd->str,sd->datestr,sd->curcounter);
		printf("New Broadcast Filename %s \n",sd->wavstream_fname);
	}

	if (sd->sub_stream_status[1]) {
		g_object_set(G_OBJECT(tsink2),"location",sd->webcaststream_fname,NULL);
	}
	if (sd->sub_stream_status[4]) {
		g_object_set(G_OBJECT(tsink3),"location",sd->wavstream_fname,NULL);
	}

	if (sd->sub_stream_status[0]) {
	  stop_record_stream(sd);
	  add_record_stream(sd);
	}

	if (sd->sub_stream_status[1]) {
		remove_webcast_encoder(sd);
		add_webcast_encoder(sd,FALSE);

		gst_pad_disconnect (sd->pe->tee2_src1,
				    gst_element_get_pad(sd->pe->sink2,"sink"));
		gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sink2);
		gst_bin_add(GST_BIN(sd->pe->pipeline),tsink2);
		gst_pad_connect (sd->pe->tee2_src1,
			 gst_element_get_pad(tsink2,"sink"));
		// free sink2
		//gst_element_destroy(sink2);
		sd->pe->sink2=tsink2;
	}

	if (sd->sub_stream_status[4]) {
		gst_pad_disconnect (gst_element_get_pad(sd->pe->enc3,"src"),
	    					gst_element_get_pad(sd->pe->sink3,"sink"));
		gst_pad_disconnect (sd->pe->tee1_src4,
							gst_element_get_pad(sd->pe->enc3,"sink"));
		gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->sink3);
		gst_bin_remove(GST_BIN(sd->pe->pipeline),sd->pe->enc3);

		gst_element_release_request_pad(sd->pe->tee, sd->pe->tee1_src4);
		
		if (!(sd->pe->enc3 = element_create ("enc3","wavenc"))) return -1;
		
  		/* request one pad from tee */
		sd->pe->tee1_src4 = gst_element_get_request_pad (sd->pe->tee, "src%d");
		gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc3);
		gst_bin_add (GST_BIN (sd->pe->pipeline), tsink3);
		gst_pad_connect (sd->pe->tee1_src4, gst_element_get_pad (sd->pe->enc3, "sink"));
		gst_pad_connect(gst_element_get_pad(sd->pe->enc3,"src"), 
						gst_element_get_pad(tsink3,"sink"));
		sd->pe->sink3=tsink3;
	}
		   

}

gboolean
continue_pipeline(gpointer data)
{
  struct stream_details* sd=(struct stream_details*)data;
  if (sd->active==1) {
  	if (gst_bin_iterate(GST_BIN(sd->pe->pipeline))) return TRUE;
  }
  else {
  	return TRUE;
  }
  //if (sd->gui) gtk_main_quit();
  if (sd->gui) {
  	sd->active=0;
  	// pipeline stopped so remove
  	g_idle_remove_by_data(data);
  	return TRUE;	
  }
  else g_main_loop_quit(sd->mainloop);
  return FALSE;
}

int
do_live_stream (struct stream_details* sd)
{
  struct timeval tv;
  fd_set rfds;
  int fd;
  int fdr;
  char ch;
  GIOChannel* stdin_ioc;
  time_t ct;
  size_t n;
  int inpcmd;
  int i;
  struct gstsave_gui gsgui;
  struct pipeline_elements pe;
  GstStaticCaps tempcaps;
  int rateneeded;
  
  pe.tempas1=NULL;
  pe.tempas2=NULL;
  pe.tempac1=NULL;
  pe.tempac2=NULL;
  pe.tempas3=NULL;
  pe.tempas4=NULL;
  pe.tee2=NULL;
  //gsgui.pe=&pe;
  sd->pe=&pe;
  gsgui.sd=sd;
  sd->gsgui=&gsgui;
  fdr=open("blah",O_RDONLY|O_NONBLOCK,NULL);
  fd=open("blah",O_WRONLY|O_NONBLOCK,NULL);
  sd->ioc=g_io_channel_unix_new(fd);
  
	/* Create Filename suffix based on Date */
	ct = time(&ct);
	// strftime(datestr, 30, "%Y%m%d%a", localtime(&ct));
	strftime(sd->datestr, 30, "%Y%m%d", localtime(&ct));
  
  /* create */
  tv.tv_sec = 0;		/* Timeout in sec. */
  tv.tv_usec = 0;		/* Timeout in microseconds */
  
  sd->recordstream_fname=g_strdup_printf("%s/%s_%s_%d_%d.%s",sd->dirname, sd->str, sd->datestr,
				  sd->bitrate[0],sd->curcounter,
				  g_strcasecmp(sd->recordtype,"ogg")==0 ? "ogg" : "mp3");
  sd->webcaststream_fname=g_strdup_printf("%s/%s_%s_%d_%d.%s", sd->dirname, sd->str, sd->datestr,
				  sd->bitrate[1], sd->curcounter,
				  g_strcasecmp(sd->webcasttype,"ogg")==0 ? "ogg" : "mp3");
  sd->wavstream_fname=g_strdup_printf("%s/%s_%s_%d.wav", sd->dirname, sd->str, sd->datestr,
				  sd->curcounter);
  
  g_print ("Creating pipeline\n");
  /* threading issues */
  #if 0
  if (sd->gui) {
  	sd->pe->pipeline = gst_thread_new("pipeline");
  }
  else {
  	sd->pe->pipeline = gst_pipeline_new ("pipeline");
  }
  #else
  sd->pe->pipeline = gst_pipeline_new("pipeline");
  #endif
  
  sd->pe->vis_thread = gst_thread_new("visthread");
  sd->pe->webcast_encoder_thread=NULL;
  sd->pe->webcast_encoder_queue=NULL;
  sd->pe->tee2=NULL;
  // g_print ("Connecting signals to pipeline\n");
  // g_signal_connect (pipeline, "deep_notify", G_CALLBACK (property_change_callback), NULL);
    
  if (!(sd->pe->tee = element_create ("tee", "tee"))) return 1;
  if (!(sd->pe->src = element_create ("src", sd->audiosrc))) return 1;
  if (g_strcasecmp(sd->audiosrc,"filesrc")==0) {
  	g_object_set(G_OBJECT(sd->pe->src), "location", sd->audiodevice, NULL);
  	if (!(sd->pe->filedec = element_create("filedec","spider"))) return 1;
  }
  else {
  	g_object_set (G_OBJECT(sd->pe->src),"device",sd->audiodevice, NULL);
  }
  if (!(sd->pe->level = element_create("level","level"))) return 1;
  g_object_set (G_OBJECT(sd->pe->level),"interval",0.25,NULL);
  g_object_set (sd->pe->level, "signal", TRUE, NULL);
  g_signal_connect (sd->pe->level, "level", G_CALLBACK (level_callback), &gsgui);
  /*if (!(sd->pe->tee2 = element_create ("tee2", "tee"))) return 1;
  if (g_strcasecmp(sd->webcasttype,"ogg")==0) {
  	if (!(sd->pe->enc2 = element_create("enc2","vorbisenc"))) return 1;
  	g_print("bitrate: %d\n",sd->bitrate[1]);
	g_object_set (G_OBJECT(sd->pe->enc2), "max-bitrate",(int)(sd->bitrate[1]*1000),NULL);
	/* do ugly stuff * /
	rateneeded=44100;
	if (sd->bitrate[1]<64) {
		for(i=0;i<BITRATE_MAP_NUMBITRATES;i++) {
			if (sd->bitrate[i]>=bitrate_map[i][0]) {
				rateneeded=bitrate_map[i][1];
			}
		}
		switch (rateneeded) {
			case 11025:
				sd->pe->tempas1=element_create("wcas1","audioscale");
				sd->pe->tempas2=element_create("wcas2","audioscale");
				break;
			case 22050:
				sd->pe->tempas1=element_create("wcas1","audioscale");
				sd->pe->tempas2=NULL;
				break;
		}
	}
  }
  else {
  	if (!(sd->pe->enc2 = element_create ("enc2","lame"))) return 1;
  	g_object_set (G_OBJECT(sd->pe->enc2), "mode", sd->mode[1], NULL);
  	g_object_set (G_OBJECT(sd->pe->enc2), "bitrate", sd->bitrate[1], NULL);
  }*/
  /* add */
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->src);
  if (g_strcasecmp(sd->audiosrc,"filesrc")==0) {
  	gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->filedec);
  }
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->level);
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->tee);
  //if (sd->pe->tempas1) gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->tempas1);
  //if (sd->pe->tempas2) gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->tempas2);
  //gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc2);
  //gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->tee2);
  
  /* connect input part */
  if (g_strcasecmp(sd->audiosrc,"filesrc")==0) {
  	gst_pad_connect(gst_element_get_pad (sd->pe->src, "src"),
  					gst_element_get_pad (sd->pe->filedec, "sink"));
  	gst_pad_connect(gst_element_get_pad (sd->pe->filedec, "src%d"),
  					gst_element_get_pad (sd->pe->level,"sink"));
  }
  else {
  	tempcaps.caps.type=0;
  	tempcaps.string=g_strdup("audio/x-raw-int, rate=44100, channels=2");
  	gst_pad_link_filtered(gst_element_get_pad (sd->pe->src, "src"),
  					gst_element_get_pad (sd->pe->level,"sink"), gst_static_caps_get(&tempcaps));
	//gst_pad_connect(gst_element_get_pad (sd->pe->src, "src"),
  	//				gst_element_get_pad (sd->pe->level,"sink"));
  	g_free(tempcaps.string);
  }
  gst_pad_connect (gst_element_get_pad (sd->pe->level, "src"),
      		   gst_element_get_pad (sd->pe->tee, "sink"));
  
  if (sd->sub_stream_status[0]==1) {
    sd->sub_stream_status[0]=0;
    add_record_stream(sd); 
  }


	
  add_webcast_encoder(sd,TRUE);

  /* request one pad from tee */
  /*  sd->pe->tee1_src2 = gst_element_get_request_pad (sd->pe->tee, "src%d");
  if (sd->pe->tempas1) {
  	tempcaps.string=g_strdup_printf("audio/x-raw-int, rate=22050, channels=%d",sd->mode[1]==0 ? 2 : 1);
  	gst_pad_connect (sd->pe->tee1_src2, gst_element_get_pad (sd->pe->tempas1, "sink"));
  	if (sd->pe->tempas2) {
  		gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas1, "src"), gst_element_get_pad (sd->pe->tempas2, "sink"), gst_static_caps_get(&tempcaps));
  		g_free(tempcaps.string);
  		tempcaps.string=g_strdup("audio/x-raw-int, rate=11025");
  		gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas2, "src"), gst_element_get_pad (sd->pe->enc2, "sink"), gst_static_caps_get(&tempcaps));
  	}
  	else {
  		gst_pad_link_filtered (gst_element_get_pad(sd->pe->tempas1, "src"), gst_element_get_pad (sd->pe->enc2, "sink"), gst_static_caps_get(&tempcaps));
  	}
  	g_free(tempcaps.string);
  }
  else {
  	gst_pad_connect (sd->pe->tee1_src2, gst_element_get_pad (sd->pe->enc2, "sink"));
  }
  gst_pad_connect (gst_element_get_pad(sd->pe->enc2,"src"), 
  gst_element_get_pad(sd->pe->tee2,"sink"));*/

  if (sd->sub_stream_status[1]==1) {
  	sd->sub_stream_status[1]=0;

  	add_webcast_record_stream(sd,TRUE);
  }
  

  /* request second pad from tee */
  /*sd->pe->tee1_src2 = gst_element_get_request_pad (sd->pe->tee, "src%d");
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->enc2);
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->tee2);
  gst_pad_connect (sd->pe->tee1_src2, gst_element_get_pad (sd->pe->enc2, "sink"));
  gst_pad_connect (gst_element_get_pad(sd->pe->enc2,"src"), 
		   gst_element_get_pad(sd->pe->tee2,"sink"));

  g_print ("Add & Connect MP3 Stream 2 Bitrate:%d\n", sd->bitrate[1]);
  sd->pe->tee2_src1 = gst_element_get_request_pad(sd->pe->tee2, "src%d");
  gst_bin_add (GST_BIN (sd->pe->pipeline), sd->pe->sink2);
  gst_pad_connect (sd->pe->tee2_src1, gst_element_get_pad (sd->pe->sink2, "sink"));
  sd->sub_stream_status[1]=1;*/

  /*g_print ("Add & Connect Webcast Stream\n");
  sd->pe->tee2_src2 = gst_element_get_request_pad(sd->pe->tee2, "src%d");
  gst_bin_add (GST_BIN(sd->pe->pipeline), sd->pe->sinkweb);
  gst_pad_connect (sd->pe->tee2_src2, gst_element_get_pad (sd->pe->sinkweb, "sink"));
  sd->sub_stream_status[2]=1;*/

  if (sd->sub_stream_status[2]==1) {
  	sd->sub_stream_status[2]=0;
  	add_webcast_substream(sd,TRUE);
  }
  /* request third pad from tee */
  /*
  g_print ("Requesting third pad\n");
  tee2_src1 = gst_element_get_request_pad (tee2, "src%d");
  gst_bin_add (GST_BIN (pipeline), enc3);
  gst_bin_add (GST_BIN (pipeline), sink3);
  gst_pad_connect (tee2_src1, gst_element_get_pad (enc3, "sink"));
  gst_pad_connect (gst_element_get_pad(enc3,"src"), 
		   gst_element_get_pad(sink3,"sink"));
  */
  if (sd->sub_stream_status[3]==1) {
  	sd->sub_stream_status[3]=0;
  	add_visualisation_substream(sd);
  }
  
  if (sd->sub_stream_status[4]==1) {
  	sd->sub_stream_status[4]=0;
  	add_wav_substream1(sd);
  }


	/* set to play */
  if (sd->gui==FALSE || sd->active==1) {
	g_print ("Playing Pipeline\n");
	display_stream_status(sd);
  	g_idle_add(continue_pipeline,&gsgui);
  }
  stdin_ioc=g_io_channel_unix_new(0); // stdin fd = 0
  g_io_add_watch(stdin_ioc,G_IO_IN,keyboard_input,sd);
  if (sd->gui) {
	setup_gui(&gsgui);
	if (sd->active) {
		gst_element_set_state (sd->pe->pipeline, GST_STATE_PLAYING);
	}
	sd->mainloop=NULL;
	gtk_main();

  }
  else {
	gst_element_set_state (sd->pe->pipeline, GST_STATE_PLAYING);

  	sd->mainloop=g_main_loop_new(NULL,FALSE);
  	g_main_loop_run(sd->mainloop);
  }
  g_print ("Done !\n");
  close(fdr);
  close(fd);
  return 0;
}

void acast_init(struct stream_details* sd)
{
	int i;
	
	sd->audiodevice=NULL;
	sd->audiosrc=NULL;
	sd->iceip=NULL;
	sd->dirname=NULL;
	sd->icepass=NULL;
	sd->recordstream_fname=NULL;
	sd->webcaststream_fname=NULL;
	sd->wavstream_fname=NULL;
	sd->str=NULL;
	sd->webcastserver=NULL;
	sd->recordtype=NULL;
	sd->webcasttype=NULL;
	sd->config_fname=NULL;
	sd->curcounter=0;
	sd->relays = g_hash_table_new(g_str_hash, g_str_equal);
	for(i=0;i<6;i++) {
  	  sd->sub_stream_status[i]=0;
    }
    for(i=0;i<2;i++) {
      sd->quality[i]=5;
    }
    sd->active=1;
}

int main(int argc, char* argv[])
{
  struct stream_details sd;
  
  /* init */
  
  acast_init(&sd);
  	  	
    
  
  if (getenv("DISPLAY")) {
      sd.gui=TRUE;
      #if 0
      g_thread_init (NULL);
	  gdk_threads_init ();
	  #endif
      gtk_init(&argc,&argv);
		
  }
  else sd.gui=FALSE;
  gst_init (&argc, &argv);
  
  if (argc==2) {
  	sd.config_fname=g_strdup(argv[1]);
	acast_parse_configfile(&sd);
  	return do_live_stream(&sd);
  }
  else {
    printf("Syntax: %s configfile.xml\n",argv[0]);
  }
  return -1;
  
}
