/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <glib.h>

#include "console.h"
#include "relay.h"
#include "gststuff.h"

//extern struct stream_details sd;

static void display_relay_status(gconstpointer key, gconstpointer value, 
				gpointer user_data)
{
	struct stream_details* sd=(struct stream_details*)user_data;
	const struct acast_relay* ar=(const struct acast_relay*)value;
	
	fprintf(stdout,"Relay: %s (%s)\n",(gchar*)key,ar->status ? "Active" : "Inactive");
}
	
int display_stream_status(struct stream_details* sd)
{
	gchar *p;

	fprintf(stdout, "\n\nCurrent Pipeline Status\n\n");
	p=g_strdup(sd->recordstream_fname);
	fprintf(stdout, "  1) %s Recording %dkbs      (%s)  File:%s\n", 
		g_strcasecmp(sd->recordtype,"ogg")==0 ? "ogg" : "mp3", sd->bitrate[0],
		(sd->sub_stream_status[0]>0 ? "Active" : "Inactive"),
		(sd->sub_stream_status[0]>0 ? (char *)basename(p) : ""));
	free(p);
	p=g_strdup(sd->webcaststream_fname);
	fprintf(stdout, "  2) %s Recording %dkbs       (%s)  File:%s\n", 
		g_strcasecmp(sd->webcasttype,"ogg")==0 ? "ogg" : "mp3", sd->bitrate[1],
		(sd->sub_stream_status[1]>0 ? "Active" : "Inactive"),
		(sd->sub_stream_status[1]>0 ? (char *) basename(p) : ""));
	free(p);
	fprintf(stdout, "  3) Webcast Stream            (%s)  IP:%s Channel:%s\n",
		(sd->sub_stream_status[2]>0 ? "Active" : "Inactive"), 
		(sd->sub_stream_status[2]>0 ? sd->iceip : ""),
		(sd->sub_stream_status[2]>0 ? sd->icemount : ""));
	fprintf(stdout, "  4) Sound Level Visualisation (%s)\n",
		(sd->sub_stream_status[3]>0 ? "Active" : "Inactive"));
	p=g_strdup(sd->wavstream_fname);
	fprintf(stdout, "  5) .wav Format Recording     (%s)  File:%s\n",
		(sd->sub_stream_status[4]>0 ? "Active" : "Inactive"),
		(sd->sub_stream_status[4]>0 ? (char *) basename(p) : ""));
	free(p);
	g_hash_table_foreach(sd->relays,display_relay_status,sd);
	fprintf(stdout, "\nCommands:  'a'ctivate <stream_no>    'd'eactivate <stream_no>\n           'r'elay toggle <relay_name>\n           'c'hange [<filename>]     'e'xit  (e.g. 'd 1' or 'a 5' or 'r test') :");
	fflush(stdout);

}

int stop_stream(char *inp, struct stream_details* sd)
{
	switch (inp[2]) {
		case '1':
			return(stop_record_stream(sd));
			break;
		case '2':
			return(stop_webcast_record_stream(sd));
			break;
		case '3':
			return(stop_webcast_substream(sd));
			break;
		case '4':
			//return(stop_visualisation_substream(sd));
			return 1;
			break;
		case '5':
			return(stop_wav_substream1(sd));
			break;
		default:
			return(1);
			break;
		}
}

int start_stream(char *inp, struct stream_details* sd)
{
	switch (inp[2]) {
		case '1':
			return(add_record_stream(sd));
			break;
		case '2':
			return(add_webcast_record_stream(sd,FALSE));
			break;
		case '3':
			return(add_webcast_substream(sd,FALSE));
			break;
		case '4':
			//return(add_visualisation_substream(sd));
			return 1;
			break;
		case '5':
			return(add_wav_substream1(sd));
			break;
		default:
			return(1);
			break;
	}
}
/* TODO: fix console \n at end */
int acast_console_relay_toggle(char* inp, struct stream_details* sd)
{
	struct acast_relay* ar;
	gchar* key;	
	key=g_strdup(inp+2);
	key[strlen(key)-1]='\0';

	ar=(struct acast_relay*)g_hash_table_lookup(sd->relays,key);
	if (ar) {
		if (ar->status) {
			g_print("Stopping relay %s\n",key);
			acast_stop_relay(sd,key);
		}
		else {
			g_print("Starting relay %s\n",key);
			acast_start_relay(sd,key);
		}
		if (sd->gui) update_stream_checkboxes(sd->gsgui);
	}
}

gboolean keyboard_input(GIOChannel* source, GIOCondition condition, gpointer pipeline)
{
	struct stream_details* sd=(struct stream_details*)pipeline;
	gchar* inp;
	if (condition==G_IO_IN) {
		if (g_io_channel_read_line(source,&inp,NULL,NULL,NULL)==G_IO_STATUS_NORMAL) {
		gst_element_set_state(GST_ELEMENT(sd->pe->pipeline),GST_STATE_PAUSED);
		switch (inp[0]) {
                case 'd':
                	if (inp[2] > '0' || inp[2] < '6') {
                        	g_print("Stopping Stream\n");
                                stop_stream(inp,sd);
				if (sd->gui) update_stream_checkboxes(sd->gsgui);
                        } else
                                g_print("Invalid Command\n");
                        break;
                 case 'a':
                        if (inp[2] > '0' || inp[2] < '6') {
                                g_print("Start/Restart Stream\n");
                                start_stream(inp, sd);
				if (sd->gui) update_stream_checkboxes(sd->gsgui);
                         } else
                                g_print("Invalid Command\n");
                         break;
		 case 'r':
		 	acast_console_relay_toggle(inp,sd);
			break;
                 case 'c':
                         g_print("Switch Filename\n");
                         if ((strlen(inp)) > 2) {
                         	g_free(sd->str);

                            sd->str=g_strdup(&inp[2]);
			    sd->str[strlen(sd->str)-1]='\0';
                         }
                         switch_file(sd);
                         break;
                  case 'e':
                        gst_element_set_state(GST_ELEMENT(sd->pe->pipeline),GST_STATE_PAUSED);
			if (sd->gui) gtk_main_quit();
			else g_main_loop_quit(sd->mainloop); 
			break;
                  default:
                         g_print("Invalid Command - Command Ignored\n");
                         break;
                  }
                  gst_element_set_state (GST_ELEMENT(sd->pe->pipeline), GST_STATE_PLAYING);
		  display_stream_status(sd);
		  g_free(inp);
		  return TRUE;
            }
	    
      }
      return FALSE;
}
