/*
 * mailmgr  - Sendmail user management log
 * Nov/2000 - Pedro L Orso - orso@onda.com.br
 */

#include "./include/conf.h"
#include "./include/language.h"

int main(int argc, char **argv)
{

   bzero(logfile, 512);  
   debugflag=0;

   while((ch = getopt(argc, argv, "l:x")) != -1){
      switch(ch)
      {
         case 'x':
            debugflag=1;
            break;
         case 'l':
            strcpy(logfile,optarg);
            break;
      }
   }

   debug("Init","");

   strcpy(configfile,"/usr/local/etc/mailmgr.conf");
   strcpy(tempdir,"/tmp");
   strcpy(outdir,"/home/httpd/html/mailmgr");
   strcpy(cwfile,"/etc/sendmail.cw");
   strcpy(title,"MAILMGR - Sendmail Manager");
   strcpy(titlefontface,"Times New Roman");
   strcpy(headerfontface,"Times New Roman");
   strcpy(textfontface,"Times New Roman");
   strcpy(logofontface,"Times New Roman");
   strcpy(logofontsize,"+2");
   strcpy(titlefontsize,"+1");
   strcpy(headerfontsize,"-1");
   strcpy(textfontsize,"-1");
   strcpy(headertextcolor,"darkblue");
   strcpy(headerbgcolor,"blanchedalmond");
   strcpy(backgroundcolor,"white");
   strcpy(textcolor,"darkblue");
   strcpy(textbgcolor,"beige");
   strcpy(titlecolor,"green");
   strcpy(logotext,"");
   strcpy(logotextcolor,"black");
   strcpy(width,"80");
   strcpy(height,"45");
   strcpy(topusersortfield,"USER");
   strcpy(excludeusers,"none");
   strcpy(lastlog,"5");
   strcpy(overwritereport,"no");
   strcpy(relaycolor,"red");
   strcpy(dateformat,"mmddyy");
   strcpy(usecomma,"no");
   bzero(emaildomain,512);
   cwind=0;
   
   getconf();

   if(logfile[0] == '\0')
      strcpy(logfile,"/var/log/maillog");

   debug("Config logfile=",logfile);
   getmailcw();

   tt = time(NULL);
   t = localtime(&tt);
   strftime(ftime, 127, "%Y", t);
   strcpy(year,ftime);

   if(!cwind) {
      fprintf(stderr, "%s: %s\n",PGM,msg03);
      exit(1);
   }

   if(access(tempdir, R_OK) != 0) {
      sprintf(csort,"mkdir %s",tempdir);
      system(csort);
   }
 
   sprintf(logtemp,"%s/mailmgr.unsort",tempdir);
   sprintf(logsort,"%s/mailmgr.tmp",tempdir);
   sprintf(logrept,"%s/mailmgr.sort",tempdir);

   if((fin=fopen(logfile,"r"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logfile);
      exit(1);
   }

   if((fou=fopen(logtemp,"w"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logtemp);
      exit(1);
   }

   debug("Reading maillog file:",logfile);
   bzero(period, 50);
   while(fgets(buf,sizeof(buf),fin)!=NULL) {
      if(strstr(buf,"from=<") == 0 && strstr(buf,"to=<") == 0)
         continue;

      getword(month,buf,' ');
      getword(day,buf,' ');
      if(strlen(day) <1) {
         getword(day,buf,' ');
         sprintf(wbuf,"0%s",day);
         strcpy(day,wbuf);
      }

      if(period[0] == '\0')
         sprintf(period,"%s%s%s-",month,day,year);

      getword(logtime,buf,' ');
      getword(server,buf,' ');
      getword(warea,buf,' ');
      getword(recid,buf,':');
      getword(warea,buf,' ');
      getword(fromto,buf,'<');

      getword(user,buf,'>');
      if(strstr(buf,"size=") != 0) {
         getword(warea,buf,'=');
         getword(size,buf,',');
      } else strcpy(size,"0");

      fixmonth(day, month, date);
    
      sprintf(warea,"%s %s %s %s %s%s\n",date,logtime,recid,size,fromto,user);
      fputs(warea,fou);

      while(strstr(buf,",<") !=0) {
         getword(warea,buf,'<');
         getword(user,buf,'>');
         sprintf(warea,"%s %s %s %s %s%s\n",date,logtime,recid,size,fromto,user);
         fputs(warea,fou);
      }
   }

   fclose(fin);
   fclose(fou);

   debug("Sorting file:",logsort);
   sprintf(csort,"sort -k 3,3 -k 1,1 -k 2,2 -k 5,5 -k 6,6 -o %s %s",logsort,logtemp);
   system(csort);

   unlink(logtemp);

   if((fin=fopen(logsort,"r"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logsort);
      exit(1);
   }

   if((fou=fopen(logrept,"w"))==NULL) {
      fprintf(stderr, "%s: %s: %s\n",PGM,msg01,logrept);
      exit(1);
   }

   flag=0;
   bzero(orecid,15);
   bzero(ouser,1024);

   debug("parsing file:",logsort);
   while(fgets(buf,sizeof(buf),fin)!=NULL) {
      buf[strlen(buf)-1]='\0';
      if(strstr(buf," from=") != 0) {
         getword(date,buf,' ');
         getword(logtime,buf,' ');
         getword(orecid,buf,' ');
         getword(size,buf,' ');
         getword(warea,buf,'=');
         sprintf(wbuf,"%s %s %s %s %s ",date,logtime,orecid,size,buf);
         strcpy(zbuf,wbuf);
         flag++;
         continue;
      }
      if(strstr(buf," to=") != 0) {
         if(!flag)
            continue;
         getword(date,buf,' ');
         getword(logtime,buf,' ');
         getword(recid,buf,' ');
         getword(size,buf,' ');
         getword(fromto,buf,'=');
         strcpy(user,buf);
         if(strcmp(recid,orecid) == 0) {
            strcpy(wbuf,zbuf);
            strcat(wbuf,user);
            strcat(wbuf,"\n");
            while(strstr(wbuf,"\"") != 0) {
               str=subs(wbuf,"\"","");
               strcpy(wbuf,str);
            }
            while(strstr(wbuf,"/") != 0) {
               str=subs(wbuf,"/","_");
               strcpy(wbuf,str);
            }
            fputs(wbuf,fou);
            strcpy(ouser,user);
         }
      }
   }
   
   fclose(fin);
   fclose(fou);

   unlink(logsort);

   strcat(period,month);
   strcat(period,day);
   strcat(period,year);

   sprintf(logsort,"%s/mailmgr.log",tempdir);
   sprintf(csort,"sort -k 5,5 -o %s %s",logsort,logrept);
   system(csort);
 
   splitlog();  
   userlog();
   topuser();
   userrel();
   makeindex();

   unlink(logsort);

   debugflag=1;
   debug(msg05, outdir);

   exit(0);
}
