/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
#ifndef __TBL1622_H__
#define __TBL1622_H__

#include "share.h"

/***************************/
/* VT1622 TV Encoder Table*/
/***************************/

typedef struct _vt1622_func_table {
    int     tv_func_index;
    u16     *tv_underscan;
    u16     *tv_fitscan;
    u16     *tv_overscan;
} vt1622_func_table;

struct vt1622_table {
    int     tv_index;
    vt1622_func_table   *tv_mode_ntsc;
    vt1622_func_table   *tv_mode_pal;
};


/* Underscan table */
static u16 VT1622_N640x480_VN[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x0203, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x7E07, 0x9D08, 0x0D09,     // Tv.05-09
    0x600A, 0x170B, 0x520C, 0x450D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xD012, 0x3313,     // TV.0F-13
    0xBF14, 0x3A15, 0xF116, 0x9117, 0x2418,     // TV.14-18
    0x2519, 0xE91A, 0x031B, 0x001C, 0x801D,     // TV.19-1D
    0x001E, 0x051F, 0x1220, 0x0C21, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x2F26, 0x9727, 0x5028, 0x0029,     // TV.5-29
    0x002A, 0xAA2B, 0x2B2C, 0x7A2D, 0xD82E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xDC4A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x0F50, 0x8151, 0x2352, 0x5753, 0x0254,     // TV.50-54
    0x0F55, 0x2956, 0x7357, 0x2358, 0x8659,     // TV.55-59
    0xC45A, 0xEA5B, 0xDF5C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x925E, 0xA15F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0x7F63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    784, 640, 640, 144, 656, 56,  600, 480, 480, 120, 488, 7


};

#define NUM_TOTAL_VT1622_REG ARRAY_SIZE(VT1622_N640x480_VN) -NUM_CRTC_TIMING

static u16 VT1622_N800x600_VN[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x2403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0xDE07, 0xD408, 0x0E09,     // TV.05-09
    0x590A, 0x170B, 0x460C, 0x400D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEA12, 0x0D13,     // TV.0F-13
    0x9814, 0x1C15, 0x9616, 0x5017, 0x5E18,     // TV.14-18
    0x1B19, 0x3D1A, 0x031B, 0x011C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0D20, 0x0A21, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x4126, 0x9627, 0x6B28, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0xA62D, 0x1E2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x3F4F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x2750, 0x2151, 0x3452, 0xED53, 0x0254,     // TV.50-54
    0x2755, 0xF556, 0x9D57, 0x2458, 0xB759,     // TV.55-59
    0x0D5A, 0x405B, 0x005C, 0x585D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xB65E, 0x3B5F, 0x0560, 0x0061, 0x0162,     // TV.5E-62
    0xEF63, 0x0564,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1064,800, 800, 264, 840, 136, 750, 600, 600, 150, 606, 16
};

static u16 VT1622_N1024x768_VN[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x4403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x8007, 0x1508, 0x0A09,     // TV.05-09
    0x580A, 0x170B, 0x5B0C, 0x400D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE912, 0x1E13,     // TV.0F-13
    0x9D14, 0x1915, 0xD616, 0x6617, 0xEB18,     // TV.14-18
    0x1419, 0x9C1A, 0x031B, 0x051C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0A20, 0x0521, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x5626, 0x9627, 0x8B28, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0xDA2D, 0x792E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDA4A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x3F4F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x8750, 0xFF51, 0x3452, 0xB053, 0x0354,     // TV.50-54
    0x6F55, 0xDB56, 0xCD57, 0x3558, 0xF159,     // TV.55-59
    0x5E5A, 0xA55B, 0x7E5C, 0x5A5D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x335E, 0x265F, 0x0760, 0x0061, 0x0162,     // TV.5E-62
    0x2763, 0x0864,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1160,1024,1024,136, 1032,56,  945, 768, 768, 177, 789, 6

};

static u16 VT1622_N848x480_VN[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x2403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x4607, 0xCC08, 0x0E09,     // TV.05-09
    0x560A, 0x170B, 0x430C, 0x3E0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x2913,     // TV.0F-13
    0x6714, 0x1915, 0x6316, 0xA817, 0x3C18,     // TV.14-18
    0x1D19, 0x291A, 0x031B, 0x0B1C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0E20, 0x0821, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x3D26, 0x9627, 0x6428, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0x9C2D, 0x172E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDC4A, 0x504B, 0x004C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0x5151, 0x3452, 0x4453, 0x0254,     // TV.50-54
    0xE355, 0xC156, 0x9357, 0x2358, 0xAD59,     // TV.55-59
    0xFD5A, 0x2B5B, 0x7C5C, 0x175D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x6D5E, 0xCA5F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0x2F63, 0x0564,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,848, 848, 352, 872, 64,  581, 480, 480, 101, 496, 13
};

static u16 VT1622_N720x480_VN[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x2603, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x6D07, 0xC308, 0x0809,     // TV.05-09
    0x560A, 0x170B, 0x430C, 0x3E0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x0D12, 0x0713,     // TV.0F-13
    0x6014, 0x3415, 0x1816, 0x5517, 0x5518,     // TV.14-18
    0x1E19, 0x1E1A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0F20, 0x0821, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x3926, 0x9527, 0x5E28, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0x922D, 0xFF2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x4750, 0xD151, 0x2352, 0x5753, 0x0254,     // TV.50-54
    0xBF55, 0xAF56, 0x8D57, 0x2358, 0xA459,     // TV.55-59
    0xF35A, 0x205B, 0x365C, 0x175D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x925E, 0x335F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0xBF63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    840, 720, 720, 120, 728, 48,  600, 480, 480, 120, 512, 7
};

static u16 VT1622_P640x480_VN[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x8203, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x3E07, 0xA408, 0x3709,     // TV.05-09
    0x670A, 0x000B, 0x490C, 0x490D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEC12, 0x2A13,     // TV.0F-13
    0xB814, 0x2915, 0x2D16, 0x7717, 0x6618,     // TV.14-18
    0x2D19, 0xED1A, 0x031B, 0x0A1C, 0x801D,     // TV.19-1D
    0x001E, 0x041F, 0x1220, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x3026, 0x9327, 0x4928, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0x7A2D, 0xCC2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xF94A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x454F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x8151, 0x2352, 0x5753, 0x0254,     // TV.50-54
    0x1F55, 0x3156, 0x7557, 0x2358, 0x8A59,     // TV.55-59
    0xC85A, 0xF05B, 0xFF5C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xD75E, 0x8E5F, 0x0360, 0x7F61, 0xCF62,     // TV.5E-62
    0xBF63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,640, 640, 360, 680, 72,  600, 480, 480, 120, 521, 5
};

static u16 VT1622_P800x600_VN[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xA403, 0x0004,     // TV.00-04
    0x0005, 0x1906, 0x6607, 0xBF08, 0x1209,     // TV.05-09
    0x600A, 0x000B, 0x560C, 0x450D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEC12, 0x1513,     // TV.0F-13
    0xFD14, 0x2815, 0xE416, 0x7D17, 0x7A18,     // TV.14-18
    0x2719, 0x161A, 0x031B, 0x011C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x1020, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x3726, 0x9327, 0x5428, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0x8F2D, 0xF42E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x444F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x9750, 0x2151, 0x3352, 0xED53, 0x0254,     // TV.50-54
    0x9755, 0x8756, 0x8757, 0x2358, 0x9F59,     // TV.55-59
    0xE75A, 0x165B, 0xE75C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xCC5E, 0xF35F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0x4F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    920, 800, 800, 120, 816, 64,  750, 600, 600, 150, 606, 16
};

static u16 VT1622_P1024x768_VN[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x0C03, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0xA007, 0x2A08, 0x3809,     // TV.05-09
    0x700A, 0x000B, 0x4E0C, 0x500D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE412, 0x2313,     // TV.0F-13
    0xD114, 0x0C15, 0x7216, 0xC317, 0x8C18,     // TV.14-18
    0x1A19, 0x961A, 0x031B, 0x071C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0C20, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x5326, 0x9027, 0x7B28, 0x5B29,     // TV.25-29
    0x152A, 0xA02B, 0x222C, 0xD12D, 0x712E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDD4A, 0x604B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x454F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0xFF51, 0x3452, 0xB553, 0x0354,     // TV.50-54
    0x5755, 0xA856, 0xC857, 0x3558, 0xEC59,     // TV.55-59
    0x4C5A, 0xCC5B, 0x675C, 0x5A5D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x145E, 0x5C5F, 0x0660, 0x0061, 0x0162,     // TV.5E-62
    0x1F63, 0x0764,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,1024,1024,176, 1032,80,  950, 768, 768, 182, 802, 3
};

static u16 VT1622_P848x480_VN[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0xC203, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x4707, 0xE408, 0x0909,     // TV.05-09
    0x640A, 0x000B, 0x4F0C, 0x480D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE712, 0x0513,     // TV.0F-13
    0x2C14, 0x1C15, 0x1816, 0x2817, 0x8718,     // TV.14-18
    0x1F19, 0x5E1A, 0x031B, 0x091C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x0A20, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x4626, 0x9327, 0x6828, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0xB42D, 0x2A2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x434F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0x5151, 0x3452, 0x5753, 0x0254,     // TV.50-54
    0x7F55, 0x4F56, 0xA957, 0x3458, 0xD159,     // TV.55-59
    0x2B5A, 0x5D5B, 0xAA5C, 0x585D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xD75E, 0x015F, 0x0360, 0x0061, 0x0162,     // TV.5E-62
    0x7F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,848, 848, 352, 976, 56,  600, 480, 480, 120, 499, 11
};

static u16 VT1622_P720x576_VN[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0xA203, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x1E07, 0xAC08, 0x3809,     // TV.05-09
    0x670A, 0x000B, 0x570C, 0x490D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xF012, 0x0F13,     // TV.0F-13
    0xD114, 0x3815, 0x3216, 0x9817, 0x8318,     // TV.14-18
    0x2D19, 0xF21A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x1320, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x4824,                             // TV.23-24

						                        // 
    0x6425, 0x3026, 0x9327, 0x4928, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0x8B2D, 0xBD2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x454F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xF750, 0xD151, 0x2252, 0xED53, 0x0254,     // TV.50-54
    0x1D55, 0x2956, 0x7557, 0x2358, 0x8859,     // TV.55-59
    0xC65A, 0xF05B, 0xFA5C, 0x0F5D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xCC5E, 0x305F, 0x1460, 0x0061, 0x0062,     // TV.5E-62
    0x8F63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    760, 720, 720, 40,  728, 16,   750, 576, 576, 174, 643, 29
};


/* Fit Industry TV Screen Mode */

static u16 VT1622_N640x480_VF[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x0203, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0xA607, 0x8C08, 0x0709,     // TV.05-09
    0x600A, 0x170B, 0x520C, 0x450D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x8812, 0x0D13,     // TV.0F-13
    0x5C14, 0x1C15, 0x4216, 0x8517, 0x2C18,     // TV.14-18
    0x2419, 0xEF1A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x051F, 0x1220, 0x0C21, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5825, 0x2F26, 0x9227, 0x5228, 0x0029,     // TV.25-29
    0x002A, 0xA42B, 0x292C, 0x7A2D, 0xE02E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xC44A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x414F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x4750, 0x8151, 0x2352, 0x3E53, 0x0254,     // TV.50-54
    0x2455, 0x6556, 0x7757, 0x2358, 0x8859,     // TV.55-59
    0xCB5A, 0x025B, 0x155C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x625E, 0x2E5F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0x9763, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    840, 640, 640, 200, 672, 56,  575, 480, 480, 95,  499, 7
};

static u16 VT1622_N800x600_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x2403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x5007, 0xA108, 0xFE09,     // TV.05-09
    0x630A, 0x170B, 0x460C, 0x470D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xED12, 0x1913,     // TV.0F-13
    0x4014, 0x1D15, 0xBE16, 0xFF17, 0x7F18,     // TV.14-18
    0x2019, 0x0C1A, 0x031B, 0x091C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0D20, 0x0A21, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5825, 0x3726, 0x9227, 0x5B28, 0x0029,     // TV.25-29
    0x002A, 0xA42B, 0x292C, 0x8A2D, 0x032E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0x1F51, 0x3452, 0xD753, 0x0254,     // TV.50-54
    0x7F55, 0xA956, 0x8457, 0x2358, 0x9859,     // TV.55-59
    0xE35A, 0x1A5B, 0xB25C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x8C5E, 0xB25F, 0x0560, 0x0061, 0x0162,     // TV.5E-62
    0x7F63, 0x0664,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,800, 800, 400, 864, 200, 728, 600, 600, 128, 656, 9
};

static u16 VT1622_N1024x768_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x0403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x8E07, 0xE208, 0x0809,     // TV.05-09
    0x600A, 0x170B, 0x5C0C, 0x450D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x0D13,     // TV.0F-13
    0x9414, 0x1415, 0x3216, 0x8A17, 0x7C18,     // TV.14-18
    0x1619, 0x841A, 0x031B, 0x011C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0A20, 0x0521, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5825, 0x5026, 0x9227, 0x8128, 0x0029,     // TV.25-29
    0x002A, 0xA42B, 0x292C, 0xC52D, 0x682E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x9750, 0xFF51, 0x3452, 0x9C53, 0x0354,     // TV.50-54
    0x0E55, 0xDE56, 0xBF57, 0x3558, 0xDD59,     // TV.55-59
    0x495A, 0x995B, 0xCE5C, 0x595D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x0C5E, 0x235F, 0x0760, 0x0061, 0x0162,     // TV.5E-62
    0x1763, 0x0864,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1176,1024,1024,152, 1032,64,  925, 768, 768, 157, 779, 12
};

static u16 VT1622_N848x480_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x4403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x8F07, 0xBE08, 0x0509,     // TV.05-09
    0x600A, 0x170B, 0x5C0C, 0x460D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xA712, 0x0D13,     // TV.0F-13
    0x6C14, 0x1C15, 0x8416, 0x8417, 0xF618,     // TV.14-18
    0x1A19, 0x421A, 0x031B, 0x011C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0D20, 0x0821, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5825, 0x4226, 0x9227, 0x6C28, 0x0029,     // TV.25-29
    0x002A, 0xA42B, 0x292C, 0xA42D, 0x2D2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDC4A, 0x504B, 0x004C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xEF50, 0x5151, 0x3352, 0x3653, 0x0254,     // TV.50-54
    0x3755, 0x3956, 0x9F57, 0x3458, 0xB759,     // TV.55-59
    0x125A, 0x575B, 0x2C5C, 0x585D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x525E, 0x1A5F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0x3763, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,848, 848, 152, 856, 56,  567, 480, 480, 87,  485, 7
};

static u16 VT1622_N720x480_VF[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x0203, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x6E07, 0xA008, 0x0F09,     // TV.05-09
    0x630A, 0x170B, 0x520C, 0x4A0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x8712, 0x0D13,     // TV.0F-13
    0x5C14, 0x1C15, 0x9A16, 0xF417, 0xA618,     // TV.14-18
    0x1F19, 0x121A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x1120, 0x0821, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5825, 0x3826, 0x9227, 0x5D28, 0x0029,     // TV.25-29
    0x002A, 0xA42B, 0x292C, 0x8B2D, 0xFF2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x4750, 0xD151, 0x2352, 0x3E53, 0x0254,     // TV.50-54
    0x9755, 0xBF56, 0x8857, 0x2358, 0x9C59,     // TV.55-59
    0xE95A, 0x265B, 0xF55C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x625E, 0x175F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0x9763, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    840, 720, 720, 120, 728, 48,  575, 480, 480, 95,  484, 15
};

static u16 VT1622_P640x480_VF[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x8203, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x3E07, 0x9308, 0x3609,     // Tv.05-09
    0x740A, 0x000B, 0x480C, 0x540D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x2413,     // TV.0F-13
    0xFD14, 0x1C15, 0xBC16, 0x4617, 0x1E18,     // TV.14-18
    0x2D19, 0xEE1A, 0x031B, 0x0A1C, 0x801D,     // TV.19-1D
    0x001E, 0x051F, 0x1520, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x3026, 0x9027, 0x4B28, 0x5B29,     // TV.25-29
    0x152A, 0xA02B, 0x222C, 0x7A2D, 0xD82E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xF94A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x484F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x8151, 0x2352, 0x3E53, 0x0254,     // TV.50-54
    0x2455, 0x5E56, 0x7657, 0x2358, 0x8959,     // TV.55-59
    0xC25A, 0x145B, 0x1C5C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xAE5E, 0x3A5F, 0x0360, 0x0061, 0x0062,     // TV.5E-62
    0x9763, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,640, 640, 360, 680, 80,  575, 480, 480, 95,  501, 3
};

static u16 VT1622_P800x600_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xA003, 0x0004,     // TV.00-04
    0x0005, 0x1906, 0xA607, 0xBA08, 0x4709,     // TV.05-09
    0x720A, 0x000B, 0x570C, 0x510D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x2413,     // TV.0F-13
    0x3F14, 0x1D15, 0x6016, 0x9017, 0xC818,     // TV.14-18
    0x2319, 0x2C1A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x1020, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x3D26, 0x9027, 0x5C28, 0x5B29,     // TV.25-29
    0x152A, 0xA02B, 0x222C, 0x9B2D, 0xF42E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE94A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x474F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x2151, 0x3352, 0xD453, 0x0254,     // TV.50-54
    0xF655, 0xFC56, 0x9557, 0x2358, 0xAE59,     // TV.55-59
    0xF55A, 0x595B, 0xB65C, 0x175D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xA45E, 0x315F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0x8763, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,800, 800, 200, 832, 80,  725, 600, 600, 125, 602, 1
};

static u16 VT1622_P1024x768_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xC403, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x9E07, 0xF808, 0x4309,     // TV.05-09
    0x5F0A, 0x000B, 0x4D0C, 0x430D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x2313,     // TV.0F-13
    0x9714, 0x1915, 0xB416, 0x7517, 0x4418,     // TV.14-18
    0x1B19, 0x8A1A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0920, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
	0x6425, 0x5126, 0x9327, 0x7728, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0xD12D, 0x5A2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDD4A, 0x604B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x434F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0xFF51, 0x3452, 0x9C53, 0x0354,     // TV.50-54
    0x3355, 0xEA56, 0xC357, 0x3558, 0xE959,     // TV.55-59
    0x515A, 0x935B, 0x095C, 0x5A5D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xEB5E, 0x165F, 0x0560, 0x0061, 0x0162,     // TV.5E-62
    0xEF63, 0x0664,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,1024,1024,176, 1040,72,  925, 768, 768, 157, 782, 13
};

static u16 VT1622_P848x480_VF[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xC003, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x5707, 0xD108, 0x3E09,     // TV.05-09
    0x710A, 0x000B, 0x4E0C, 0x500D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE512, 0x2A13,     // TV.0F-13
    0xFD14, 0x1415, 0x9316, 0x1317, 0xE618,     // TV.14-18
    0x2019, 0x471A, 0x031B, 0x0B1C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x0F20, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x4326, 0x9027, 0x6428, 0x5B29,     // TV.25-29
    0x152A, 0xA02B, 0x222C, 0xA62D, 0x2A2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x464F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0x5151, 0x3452, 0x3E53, 0x0254,     // TV.50-54
    0x4F55, 0x3A56, 0xA257, 0x3458, 0xBE59,     // TV.55-59
    0x0B5A, 0x765B, 0x645C, 0x585D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xAE5E, 0x1A5F, 0x0360, 0x0061, 0x0162,     // TV.5E-62
    0x4F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,848, 848, 352, 856, 56,  575, 480, 480, 95,  495, 25
};

static u16 VT1622_P720x576_VF[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0xA603, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0xDE07, 0xA308, 0x3609,     // TV.05-09
    0x6D0A, 0x000B, 0x570C, 0x4F0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x0512, 0x0713,     // TV.0F-13
    0x2114, 0x1015, 0xCB16, 0x8A17, 0x0918,     // TV.14-18
    0x2A19, 0xFF1A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x1320, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x4824,                             // TV.23-24

						                        // 
    0x6425, 0x3426, 0x9027, 0x4F28, 0x5B29,     // TV.25-29
    0x152A, 0xA02B, 0x222C, 0x822D, 0xFF2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x474F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0xD151, 0x2352, 0xA253, 0x0254,     // TV.50-54
    0x5F55, 0x8556, 0x7E57, 0x2358, 0x9459,     // TV.55-59
    0xD05A, 0x275B, 0x8F5C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x525E, 0x7A5F, 0x0460, 0x0061, 0x0062,     // TV.5E-62
    0x3763, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,720, 720, 280, 776, 64,  675, 576, 576, 99,  602, 13
};

/* TV Overscan Table */

static u16 VT1622_N640x480_VO[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x0203, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x8F07, 0x6A08, 0x0009,     // TV.05-09
    0x6A0A, 0x170B, 0x520C, 0x500D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x6812, 0x0D13,     // TV.0F-13
    0x5014, 0x1C15, 0x4516, 0x9917, 0x9918,     // TV.14-18
    0x2919, 0xD01A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x051F, 0x1220, 0x0C21, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5725, 0x2B26, 0x9027, 0x4828, 0x0029,     // TV.25-29
    0x002A, 0xA32B, 0x292C, 0x6A2D, 0xC42E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xC44A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x414F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x1F50, 0x7F51, 0x2352, 0x0C53, 0x0254,     // TV.50-54
    0xBB55, 0x3256, 0x6757, 0x2258, 0x7659,     // TV.55-59
    0xB05A, 0xD25B, 0x2E5C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x005E, 0x8E5F, 0x0060, 0x0061, 0x0062,     // TV.5E-62
    0x1F63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    800, 640, 640, 160, 656, 96,  525, 480, 480, 45,  495, 11
};

static u16 VT1622_N800x600_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x2403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0xA907, 0x8808, 0x0409,     // TV.05-09
    0x650A, 0x170B, 0x460C, 0x4C0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xCA12, 0x0D13,     // TV.0F-13
    0x7C14, 0x1C15, 0xD116, 0x6217, 0x8C18,     // TV.14-18
    0x2119, 0x021A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x0D20, 0x0A21, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x3626, 0x9627, 0x5928, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0x862D, 0x982E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x444F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x1F51, 0x3352, 0x8A53, 0x0254,     // TV.50-54
    0x6355, 0xB956, 0x8057, 0x2358, 0x9359,     // TV.55-59
    0xDC5A, 0x0B5B, 0x7D5C, 0x165D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xF65E, 0x975F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0xD763, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,800, 800, 200, 832, 96,  651, 600, 600, 51,  608, 12
};

static u16 VT1622_N1024x768_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x4403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x5807, 0xC308, 0x0509,     // TV.05-09
    0x640A, 0x170B, 0x5C0C, 0x4D0D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEA12, 0x0D13,     // TV.0F-13
    0xB014, 0x1C15, 0x8A16, 0xE817, 0xA218,     // TV.14-18
    0x1719, 0x701A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0A20, 0x0521, 0x0422,     // TV.1E-22
    0x7423, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x4C26, 0x9627, 0x7B28, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0xBE2D, 0x582E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x434F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x5F50, 0xFF51, 0x3452, 0x3853, 0x0354,     // TV.50-54
    0xCF55, 0xDF56, 0xB657, 0x3458, 0xD259,     // TV.55-59
    0x395A, 0x815B, 0x405C, 0x595D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x495E, 0x225F, 0x0660, 0x0061, 0x0162,     // TV.5E-62
    0xDF63, 0x0664,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1120,1024,1024,96,  1032,40,  825, 768, 768, 57,  770, 6
};

static u16 VT1622_N848x480_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0x4403, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x9607, 0xA708, 0x0809,     // TV.05-09
    0x5B0A, 0x170B, 0x460C, 0x400D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xE812, 0x3C13,     // TV.0F-13
    0x2D14, 0x2215, 0xA116, 0x6417, 0x9318,     // TV.14-18
    0x1B19, 0x3D1A, 0x031B, 0x011C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0D20, 0x0821, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x4126, 0x9627, 0x6928, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0xA22D, 0x242E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDC4A, 0x504B, 0x004C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xEF50, 0x5151, 0x3352, 0x2553, 0x0254,     // TV.50-54
    0x1F55, 0x4D56, 0x9C57, 0x3458, 0xB559,     // TV.55-59
    0x0C5A, 0x3D5B, 0xF15C, 0x575D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x305E, 0x015F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0x1F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1008,848, 848, 160, 856, 72,  550, 480, 480, 70,  491, 5
};

static u16 VT1622_N720x480_VO[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x0203, 0x0304,     // TV.00-04
    0x0005, 0x1006, 0x1807, 0x2808, 0x0909,     // TV.05-09
    0x5B0A, 0x170B, 0x460C, 0x410D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEE12, 0x0D13,     // TV.0F-13
    0xA014, 0x3815, 0x1D16, 0x6617, 0x6618,     // TV.14-18
    0x2419, 0xEE1A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x1120, 0x0821, 0x0422,     // TV.1E-22
    0x7523, 0x0024,                             // TV.23-24

						                        // 
    0x5A25, 0x3126, 0x9527, 0x5128, 0x0029,     // TV.25-29
    0x002A, 0xAA2B, 0x2B2C, 0x7A2D, 0xDB2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE44A, 0x694B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x404F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0x1F50, 0xCF51, 0x2352, 0x0C53, 0x0254,     // TV.50-54
    0x1F55, 0xCE56, 0x7657, 0x2358, 0x8859,     // TV.55-59
    0xC95A, 0xEF5B, 0xFF5C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x005E, 0x005F, 0x0060, 0x0061, 0x0062,     // TV.5E-62
    0x1F63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    800, 720, 720, 80,  728, 32,  525, 480, 480, 45,  482, 1
};

static u16 VT1622_P640x480_VO[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0x8203, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0xCA07, 0x7D08, 0x3109,     // Tv.05-09
    0x7A0A, 0x000B, 0x480C, 0x580D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0x4A12, 0x0713,     // TV.0F-13
    0x3714, 0x2415, 0xC016, 0xD917, 0x7118,     // TV.14-18
    0x3219, 0xD51A, 0x031B, 0x021C, 0x801D,     // TV.19-1D
    0x001E, 0x051F, 0x1520, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x2B26, 0x9327, 0x4328, 0x5F29,     // TV.25-29
    0x152A, 0xA02B, 0x232C, 0x6C2D, 0xCC2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xF94A, 0x7F4B, 0x234C, 0xF34D, 0x014E,     // TV.4A-4E
    0xCF4F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x7F51, 0x2352, 0xF353, 0x0154,     // TV.50-54
    0xCF55, 0x3F56, 0x6957, 0x2258, 0x7A59,     // TV.55-59
    0xAD5A, 0xF85B, 0x765C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x335E, 0x705F, 0x0360, 0x0061, 0x0062,     // TV.5E-62
    0x1F63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,640, 640, 360, 800, 120, 500, 480, 480, 20,  485, 6
};

static u16 VT1622_P800x600_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xA003, 0x0004,     // TV.00-04
    0x0005, 0x1906, 0x8007, 0xA608, 0x3609,     // TV.05-09
    0x770A, 0x000B, 0x570C, 0x540D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xED12, 0x1513,     // TV.0F-13
    0x1E14, 0x3115, 0x5016, 0x6317, 0xD518,     // TV.14-18
    0x2519, 0x1D1A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x1020, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x3A26, 0x9327, 0x5728, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0x912D, 0xFF2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE94A, 0x504B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x474F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0x1F51, 0x3352, 0x8953, 0x0254,     // TV.50-54
    0xBF55, 0x0056, 0x8D57, 0x3358, 0xA559,     // TV.55-59
    0xE85A, 0x475B, 0x4B5C, 0x175D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x295E, 0x285F, 0x0460, 0x0061, 0x0162,     // TV.5E-62
    0x0F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,800, 800, 200, 872, 56,  650, 600, 600, 50,  608, 12
};

static u16 VT1622_P1024x768_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xC003, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x7107, 0xD108, 0x3809,     // TV.05-09
    0x770A, 0x000B, 0x4E0C, 0x520D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xC912, 0x0A13,     // TV.0F-13
    0x7914, 0x1C15, 0x3816, 0x0E17, 0x7B18,     // TV.14-18
    0x1D19, 0x6E1A, 0x031B, 0x031C, 0x801D,     // TV.19-1D
    0x001E, 0x851F, 0x0C20, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x4B26, 0x9327, 0x6F28, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0xBE2D, 0x5A2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xDD4A, 0x604B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x474F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0xFF51, 0x3452, 0x3853, 0x0354,     // TV.50-54
    0xCF55, 0xE356, 0xB457, 0x3458, 0xD459,     // TV.55-59
    0x2B5A, 0xA05B, 0x5E5C, 0x595D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x485E, 0x205F, 0x0560, 0x0061, 0x0162,     // TV.5E-62
    0x2F63, 0x0664,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,1024,1024,176, 1088,56,  825, 768, 768, 57,  771, 5
};

static u16 VT1622_P848x480_VO[] = {
						                        // 
    0x8400, 0x0001, 0x0002, 0xC003, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x4707, 0xA808, 0x3909,     // TV.05-09
    0x640A, 0x000B, 0x4E0C, 0x460D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEA12, 0x1513,     // TV.0F-13
    0xF214, 0x2815, 0xEC16, 0xE517, 0x6418,     // TV.14-18
    0x2219, 0x391A, 0x031B, 0x0B1C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x0F20, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x0024,                             // TV.23-24

						                        // 
    0x6425, 0x4026, 0x9327, 0x5F28, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0xA32D, 0x2A2E,     // TV.2A-2E
    0x102F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x434F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xAF50, 0x4F51, 0x3452, 0x2553, 0x0254,     // TV.50-54
    0x1F55, 0x4F56, 0x9B57, 0x3458, 0xB759,     // TV.55-59
    0x0A5A, 0x3F5B, 0xF05C, 0x575D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0x855E, 0x005F, 0x0360, 0x0061, 0x0162,     // TV.5E-62
    0x1F63, 0x0464,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1200,848, 848, 352, 872, 176, 550, 480, 480, 70,  491, 5
};

static u16 VT1622_P720x576_VO[] = {
						                        // 
    0x0400, 0x0001, 0x0002, 0xA603, 0x0004,     // TV.00-04
    0x0005, 0x1006, 0x1007, 0x7D08, 0x3209,     // TV.05-09
    0x600A, 0x000B, 0x570C, 0x460D, 0x0F0E,     // TV.0A-0E
    0x000F, 0x0010, 0x0011, 0xEC12, 0x1513,     // TV.0F-13
    0xDC14, 0x2815, 0x2D16, 0x7717, 0x6618,     // TV.14-18
    0x2D19, 0xEE1A, 0x031B, 0x0A1C, 0x801D,     // TV.19-1D
    0x001E, 0x841F, 0x1320, 0x0C21, 0x0422,     // TV.1E-22
    0x7B23, 0x4824,                             // TV.23-24

						                        // 
    0x6425, 0x3026, 0x9327, 0x4928, 0x5F29,     // TV.25-29
    0x152A, 0xA52B, 0x232C, 0x772D, 0xFF2E,     // TV.2A-2E
    0x002F,                                     // TV.2F

						                        // Filter registers
    0xE74A, 0x454B, 0x044C, 0x004D, 0x004E,     // TV.4A-4E
    0x454F,                                     // TV.4F

						                        // Set Video Timing (TV Timing Regsiter )
    0xE750, 0xCF51, 0x2352, 0x5753, 0x0254,     // TV.50-54
    0x1F55, 0x8056, 0x7557, 0x2358, 0x8959,     // TV.55-59
    0xC75A, 0xF15B, 0xFF5C, 0x055D,             // TV.5A-5D
						                        // Set Video Timing (TV CRTC Regsiter )
    0xD75E, 0x805F, 0x0360, 0x0061, 0x0062,     // TV.5E-62
    0xBF63, 0x0364,                             // TV.63-64

  //HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
    1000,720, 720, 280, 728, 48,  600, 576, 576, 24,  577, 3
};

/***********************************/
/* VT1622 output RGB Table        */
/***********************************/

//  NTSC

static u16 VT1622_N640x480_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_RGB_VO[] = {
	0xFFFF                      // End symbol
};



// PAL


static u16 VT1622_P640x480_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_RGB_VO[] = {
	0xFFFF                      // End symbol
};

/***********************************/
/* VT1622 output YPBPR Table      */
/***********************************/

// NTSC

static u16 VT1622_N640x480_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5065, 0x4B66, 0x4D67,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x4365, 0x4A66, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4B66, 0x4A67,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x4465, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol

};

static u16 VT1622_N720x480_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4966, 0x4867,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x4F65, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x5765, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x4D65, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x4B65, 0x4866, 0x4867,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x5765, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4566, 0x4567,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x4D65, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};


// PAL

static u16 VT1622_P640x480_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x5E66, 0x5E67,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5165, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5065, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_YPBPR_VN[] = {
	0x0302,                     // output YPBPR type
	0x5965, 0x4D66, 0x4A67,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4866, 0x4867,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x5065, 0x6966, 0x6967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x4E65, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_YPBPR_VF[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4866, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x4265, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4866, 0x4867,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x5165, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x4E65, 0x4966, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_YPBPR_VO[] = {
	0x0302,                     // output YPBPR type
	0x5865, 0x4866, 0x4967,     // adjust YPBPR Amplitude factor
	0xFFFF                      // End symbol
};

/***********************************/
/* VT1622 output SDTV_RGB Table   */
/***********************************/

// NTSC

static u16 VT1622_N640x480_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_RGB_VF[]={
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};


// PAL

static u16 VT1622_P640x480_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol

};

static u16 VT1622_P800x600_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol

};

static u16 VT1622_P1024x768_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_RGB_VN[] = {
	0xFFFF                      // End symbol

};

static u16 VT1622_P640x480_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol

};

static u16 VT1622_P848x480_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_RGB_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_RGB_VO[] = {
	0xFFFF                      // End symbol
};

/***********************************/
/* VT1622 output SDTV_YPBPR Table */
/***********************************/

// NTSC

static u16 VT1622_N640x480_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_YPBPR_VF[] = {
    0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};



// PAL


static u16 VT1622_P640x480_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_YPBPR_VN[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_YPBPR_VF[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P640x480_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P800x600_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P1024x768_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P848x480_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

static u16 VT1622_P720x576_SDTV_YPBPR_VO[] = {
	0xFFFF                      // End symbol
};

/***********************************/
/* VT1622 DeDotCrawl Table         */
/***********************************/

// NTSC

static u16 VT1622_N640x480_DeDotCrawl_VN[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xD516, 0x8D17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_DeDotCrawl_VN[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xA116, 0x5917,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_DeDotCrawl_VN[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x1116, 0xE217,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_DeDotCrawl_VN[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x5B16, 0xA017,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_DeDotCrawl_VN[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xC316, 0x4C17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_DeDotCrawl_VF[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x5016, 0x7B17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_DeDotCrawl_VF[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xD116, 0xF617,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_DeDotCrawl_VF[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x0616, 0x8417,             // adjust TV FSCI
    0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_DeDotCrawl_VF[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x1C16, 0x7D17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_DeDotCrawl_VF[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xE816, 0xEB17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N640x480_DeDotCrawl_VO[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0xD516, 0x8D17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N800x600_DeDotCrawl_VO[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x1416, 0xC717,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N1024x768_DeDotCrawl_VO[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x6316, 0x3D17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N848x480_DeDotCrawl_VO[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x6716, 0x3017,             // adjust TV FSCI
	0xFFFF                      // End symbol
};

static u16 VT1622_N720x480_DeDotCrawl_VO[] = {
    0x0811,                     // Enable DeDotCrawl (only update bit3 of TV.11h register)
	0x1E16, 0x5C17,             // adjust TV FSCI
	0xFFFF                      // End symbol
};


static vt1622_func_table vt1622_ntsc_640x480_tbl[] = {
    {TV_BASE_FUNC, 	       VT1622_N640x480_VN,            VT1622_N640x480_VF,            VT1622_N640x480_VO},
    {TV_RGB_FUNC,          VT1622_N640x480_RGB_VN,        VT1622_N640x480_RGB_VF,        VT1622_N640x480_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_N640x480_YPBPR_VN,      VT1622_N640x480_YPBPR_VF,      VT1622_N640x480_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_N640x480_SDTV_RGB_VN,   VT1622_N640x480_SDTV_RGB_VF,   VT1622_N640x480_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_N640x480_SDTV_YPBPR_VN, VT1622_N640x480_SDTV_YPBPR_VF, VT1622_N640x480_SDTV_YPBPR_VO},
    {TV_DeDotCrawl_FUNC,   VT1622_N640x480_DeDotCrawl_VN, VT1622_N640x480_DeDotCrawl_VF, VT1622_N640x480_DeDotCrawl_VO}
    
};

static vt1622_func_table vt1622_ntsc_800x600_tbl[] = {
    {TV_BASE_FUNC,         VT1622_N800x600_VN,            VT1622_N800x600_VF,            VT1622_N800x600_VO},
    {TV_RGB_FUNC,          VT1622_N800x600_RGB_VN,        VT1622_N800x600_RGB_VF,        VT1622_N800x600_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_N800x600_YPBPR_VN,      VT1622_N800x600_YPBPR_VF,      VT1622_N800x600_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_N800x600_SDTV_RGB_VN,   VT1622_N800x600_SDTV_RGB_VF,   VT1622_N800x600_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_N800x600_SDTV_YPBPR_VN, VT1622_N800x600_SDTV_YPBPR_VF, VT1622_N800x600_SDTV_YPBPR_VO},
    {TV_DeDotCrawl_FUNC,   VT1622_N800x600_DeDotCrawl_VN, VT1622_N800x600_DeDotCrawl_VF, VT1622_N800x600_DeDotCrawl_VO}
};

static vt1622_func_table vt1622_ntsc_1024x768_tbl[]= {
    {TV_BASE_FUNC,         VT1622_N1024x768_VN,            VT1622_N1024x768_VF,            VT1622_N1024x768_VO},
    {TV_RGB_FUNC,          VT1622_N1024x768_RGB_VN,        VT1622_N1024x768_RGB_VF,        VT1622_N1024x768_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_N1024x768_YPBPR_VN,      VT1622_N1024x768_YPBPR_VF,      VT1622_N1024x768_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_N1024x768_SDTV_RGB_VN,   VT1622_N1024x768_SDTV_RGB_VF,   VT1622_N1024x768_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_N1024x768_SDTV_YPBPR_VN, VT1622_N1024x768_SDTV_YPBPR_VF, VT1622_N1024x768_SDTV_YPBPR_VO},
    {TV_DeDotCrawl_FUNC,   VT1622_N1024x768_DeDotCrawl_VN, VT1622_N1024x768_DeDotCrawl_VF, VT1622_N1024x768_DeDotCrawl_VO}
};

static vt1622_func_table vt1622_ntsc_848x480_tbl[] = {
    {TV_BASE_FUNC,         VT1622_N848x480_VN,             VT1622_N848x480_VF,             VT1622_N848x480_VO},
    {TV_RGB_FUNC,          VT1622_N848x480_RGB_VN,         VT1622_N848x480_RGB_VF,         VT1622_N848x480_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_N848x480_YPBPR_VN,       VT1622_N848x480_YPBPR_VF,       VT1622_N848x480_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_N848x480_SDTV_RGB_VN,    VT1622_N848x480_SDTV_RGB_VF,    VT1622_N848x480_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_N848x480_SDTV_YPBPR_VN,  VT1622_N848x480_SDTV_YPBPR_VF,  VT1622_N848x480_SDTV_YPBPR_VO},
    {TV_DeDotCrawl_FUNC,   VT1622_N848x480_DeDotCrawl_VN,  VT1622_N848x480_DeDotCrawl_VF,  VT1622_N848x480_DeDotCrawl_VO}
};

static vt1622_func_table vt1622_ntsc_720x480_tbl[] = {
    {TV_BASE_FUNC,         VT1622_N720x480_VN,             VT1622_N720x480_VF,             VT1622_N720x480_VO},
    {TV_RGB_FUNC,          VT1622_N720x480_RGB_VN,         VT1622_N720x480_RGB_VF,         VT1622_N720x480_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_N720x480_YPBPR_VN,       VT1622_N720x480_YPBPR_VF,       VT1622_N720x480_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_N720x480_SDTV_RGB_VN,    VT1622_N720x480_SDTV_RGB_VF,    VT1622_N720x480_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_N720x480_SDTV_YPBPR_VN,  VT1622_N720x480_SDTV_YPBPR_VF,  VT1622_N720x480_SDTV_YPBPR_VO},
    {TV_DeDotCrawl_FUNC,   VT1622_N720x480_DeDotCrawl_VN,  VT1622_N720x480_DeDotCrawl_VF,  VT1622_N720x480_DeDotCrawl_VO}
};

static vt1622_func_table vt1622_pal_640x480_tbl[] = {
    {TV_BASE_FUNC,         VT1622_P640x480_VN,             VT1622_P640x480_VF,             VT1622_P640x480_VO},
    {TV_RGB_FUNC,          VT1622_P640x480_RGB_VN,         VT1622_P640x480_RGB_VF,         VT1622_P640x480_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_P640x480_YPBPR_VN,       VT1622_P640x480_YPBPR_VF,       VT1622_P640x480_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_P640x480_SDTV_RGB_VN,    VT1622_P640x480_SDTV_RGB_VF,    VT1622_P640x480_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_P640x480_SDTV_YPBPR_VN,  VT1622_P640x480_SDTV_YPBPR_VF,  VT1622_P640x480_SDTV_YPBPR_VO}
};

static vt1622_func_table vt1622_pal_800x600_tbl[] = {
    {TV_BASE_FUNC,         VT1622_P800x600_VN,             VT1622_P800x600_VF,             VT1622_P800x600_VO},
    {TV_RGB_FUNC,          VT1622_P800x600_RGB_VN,         VT1622_P800x600_RGB_VF,         VT1622_P800x600_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_P800x600_YPBPR_VN,       VT1622_P800x600_YPBPR_VF,       VT1622_P800x600_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_P800x600_SDTV_RGB_VN,    VT1622_P800x600_SDTV_RGB_VF,    VT1622_P800x600_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_P800x600_SDTV_YPBPR_VN,  VT1622_P800x600_SDTV_YPBPR_VF,  VT1622_P800x600_SDTV_YPBPR_VO}
};

static vt1622_func_table vt1622_pal_1024x768_tbl[] = {
    {TV_BASE_FUNC,         VT1622_P1024x768_VN,             VT1622_P1024x768_VF,             VT1622_P1024x768_VO},
    {TV_RGB_FUNC,          VT1622_P1024x768_RGB_VN,         VT1622_P1024x768_RGB_VF,         VT1622_P1024x768_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_P1024x768_YPBPR_VN,       VT1622_P1024x768_YPBPR_VF,       VT1622_P1024x768_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_P1024x768_SDTV_RGB_VN,    VT1622_P1024x768_SDTV_RGB_VF,    VT1622_P1024x768_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_P1024x768_SDTV_YPBPR_VN,  VT1622_P1024x768_SDTV_YPBPR_VF,  VT1622_P1024x768_SDTV_YPBPR_VO}
};

static vt1622_func_table vt1622_pal_848x480_tbl[] = {
    {TV_BASE_FUNC,         VT1622_P848x480_VN,             VT1622_P848x480_VF,             VT1622_P848x480_VO},
    {TV_RGB_FUNC,          VT1622_P848x480_RGB_VN,         VT1622_P848x480_RGB_VF,         VT1622_P848x480_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_P848x480_YPBPR_VN,       VT1622_P848x480_YPBPR_VF,       VT1622_P848x480_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_P848x480_SDTV_RGB_VN,    VT1622_P848x480_SDTV_RGB_VF,    VT1622_P848x480_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_P848x480_SDTV_YPBPR_VN,  VT1622_P848x480_SDTV_YPBPR_VF,  VT1622_P848x480_SDTV_YPBPR_VO}
};

static vt1622_func_table vt1622_pal_720x576_tbl[] = {
    {TV_BASE_FUNC,         VT1622_P720x576_VN,             VT1622_P720x576_VF,             VT1622_P720x576_VO},
    {TV_RGB_FUNC,          VT1622_P720x576_RGB_VN,         VT1622_P720x576_RGB_VF,         VT1622_P720x576_RGB_VO},
    {TV_YPBPR_FUNC,        VT1622_P720x576_YPBPR_VN,       VT1622_P720x576_YPBPR_VF,       VT1622_P720x576_YPBPR_VO},
    {TV_SDTV_RGB_FUNC,     VT1622_P720x576_SDTV_RGB_VN,    VT1622_P720x576_SDTV_RGB_VF,    VT1622_P720x576_SDTV_RGB_VO},
    {TV_SDTV_YPBPR_FUNC,   VT1622_P720x576_SDTV_YPBPR_VN,  VT1622_P720x576_SDTV_YPBPR_VF,  VT1622_P720x576_SDTV_YPBPR_VO}
};


static struct vt1622_table vt1622_tbl[] = {
    {VIA_RES_640X480,             vt1622_ntsc_640x480_tbl,    vt1622_pal_640x480_tbl},
    {VIA_RES_800X600,             vt1622_ntsc_800x600_tbl,    vt1622_pal_800x600_tbl},
    {VIA_RES_1024X768,            vt1622_ntsc_1024x768_tbl,   vt1622_pal_1024x768_tbl},
    {VIA_RES_848X480,             vt1622_ntsc_848x480_tbl,    vt1622_pal_848x480_tbl},
    {VIA_RES_720X480,             vt1622_ntsc_720x480_tbl,    vt1622_ntsc_720x480_tbl},
    {VIA_RES_720X576,             vt1622_pal_720x576_tbl,     vt1622_pal_720x576_tbl}
};

#define NUM_TOTAL_VT1622_TABLE ARRAY_SIZE(vt1622_tbl)
  
#endif /* __TBL1622_H__ */
    
