/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#include "debug.h"
#include "dvi.h"
#include "chip.h"
#include "share.h"

// extern function
extern int i2cWriteByte(u8 slave_addr, u8 index, u8 data);
extern int i2cReadByte(u8 slave_addr, u8 index, u8 *pData);
extern void set_output_path(int device, int set_iga, int output_interface);
extern void fill_crtc_timing(struct crt_mode_table *crt_table, int mode_index, int bpp_byte, int set_iga);
extern void write_reg_mask(u8 index, int io_port, u8 data, u8 mask);

extern struct chip_information  	chip_info;
extern struct tmds_setting_information	tmds_setting_info;

int tmds_register_read(int index);
void tmds_register_write(int index, u8 data);

int check_tmds_chip(int device_id_subaddr, int device_id)
{
    if (tmds_register_read(device_id_subaddr) == device_id)
        return(OK); 
    else
        return(FAIL);
}

void init_dvi_size(void)
{
    switch(tmds_setting_info.get_dvi_size_method) {
        case GET_DVI_SIZE_BY_SYSTEM_BIOS:
            break;
        case GET_DVI_SZIE_BY_HW_STRAPPING:
            break;
        case GET_DVI_SIZE_BY_VGA_BIOS:
            break;
        //default:
            // GET_DVI_SIZE_BY_VGA_BIOS              
    }
     
}

int tmds_trasmitter_identify(void)
{
    chip_info.tmds_chip_info.tmds_chip_name = VT1632_TMDS;
    chip_info.tmds_chip_info.tmds_chip_slave_addr = VT1632_TMDS_I2C_ADDR;
    
    // Turn on Pad 
    // because VT1632 Chip need clock when i2c function work normally  
    if (chip_info.tmds_chip_info.output_interface == INTERFACE_DVP1) 
    	write_reg_mask(SR1E, VIASR, 0x30, BIT4+BIT5);
    else
        write_reg_mask(SR1E, VIASR, 0xC0, BIT6+BIT7);    
	
    if (check_tmds_chip(VT1632_DEVICE_ID_REG, VT1632_DEVICE_ID)!= FAIL)
    {
        DEBUG_MSG(KERN_INFO "\n VT1632 TMDS ! \n");  	    
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tmds_chip_info.tmds_chip_name);
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tmds_chip_info.tmds_chip_name);
        return(OK);  
    }
        
    chip_info.tmds_chip_info.tmds_chip_name = NON_TMDS_TRANSMITTER;
    chip_info.tmds_chip_info.tmds_chip_slave_addr = VT1632_TMDS_I2C_ADDR;      
    return(FAIL);
} 

void tmds_register_write(int index, u8 data)
{
    u8  tmp;
    
    tmp = chip_info.tv_chip_info.tv_chip_on_slot;
    
    if (chip_info.gfx_chip_name == UNICHROME_CLE266)
        chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AMR;    
    else
        chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AGP;
            
    i2cWriteByte(chip_info.tmds_chip_info.tmds_chip_slave_addr, index, data);
    
    chip_info.tv_chip_info.tv_chip_on_slot = tmp;
    
}  

int tmds_register_read(int index)
{
    u8 data;
    int status;
    u8  tmp;
    
    tmp = chip_info.tv_chip_info.tv_chip_on_slot;
    if (chip_info.gfx_chip_name == UNICHROME_CLE266)
        chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AMR;    
    else
        chip_info.tv_chip_info.tv_chip_on_slot = TV_ON_AGP;
           
    status = i2cReadByte((u8)chip_info.tmds_chip_info.tmds_chip_slave_addr, (u8)index, &data);    
    chip_info.tv_chip_info.tv_chip_on_slot = tmp;
    return(data);
}

/* DVI Set Mode */
void dvi_set_mode(struct crt_mode_table *dvi_crt_timing, int video_index, int mode_bpp, int set_iga)
{
    fill_crtc_timing(dvi_crt_timing, video_index, mode_bpp/8, set_iga);
    set_output_path(DEVICE_DVI, set_iga, chip_info.tmds_chip_info.output_interface);  
}
