/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
#ifndef __CHIP_H__
#define __CHIP_H__

#include "tv.h"

/***************************************/
/* Definition Graphic Chip Information */
/***************************************/

/* Define VIA Graphic Chip Name */
#define		UNICHROME_CLE266        1
#define		UNICHROME_CLE266_VID    0x1106
#define		UNICHROME_CLE266_DID    0x3122
#define     CLE266_REVISION_AX      0x0A
#define     CLE266_REVISION_CX      0x0C

#define		UNICHROME_K400	        2
#define		UNICHROME_K400_VID	    0x1106
#define		UNICHROME_K400_DID	    0x7205

#define		UNICHROME_K800		    3
#define		UNICHROME_K800_VID      0x1106
#define		UNICHROME_K800_DID      0x3108


#define		UNICHROME_P880		    4
#define		UNICHROME_P880_VID      0x1106
#define		UNICHROME_P880_DID	    0x3118



	
 
/*************************************/
/* Definition TV Encoder Information */
/*************************************/

/* Definition TV Encoder Index */

#define     NON_TV_ENCODER      0x00
#define     VT1621              0x01
#define     VT1622              0x02     
#define     CH7009              0x03
#define     CH7019              0x04
#define     SAA7108A            0x05
#define     CH7005              0x06
#define     VT1622A             0x07
#define     VT1623              0x08
#define     FS453               0x09
#define     FS454               0x0A

/* Definition TV Encoder I2C Slave Address */
#define     VT1622_TV_I2C_ADDR      0x40
#define     VT1622A_TV_I2C_ADDR     0x40
#define     SAA7108A_TV_I2C_ADDR    0x88
#define     CH7009_TV_I2C_ADDR      0xEA
#define     CH7019_TV_I2C_ADDR      0xEA
#define     FS453_TV_I2C_ADDR       0xD4
#define     FS454_TV_I2C_ADDR       0xD4

#define     TV_ON_AMR       1
#define     TV_ON_AGP       2 

/**************************************************/
/* Definition TMDS Trasmitter Information         */
/**************************************************/

/* Definition TMDS Trasmitter Index */
#define     NON_TMDS_TRANSMITTER    0x00
#define     VT1632_TMDS             0x01
#define     SII164_TMDS             0x02


/* Definition TMDS Trasmitter I2C Slave Address */
#define     VT1632_TMDS_I2C_ADDR    0x10
#define     SII164_TMDS_I2C_ADDR    0x70

/**************************************************/
/* Definition LVDS Trasmitter Information         */
/**************************************************/

/* Definition LVDS Trasmitter Index */
#define     NON_LVDS_TRANSMITTER    0x00
#define     VT1631_LVDS             0x01
#define     CH7019_LVDS             0x02

/* Definition Digital Transmitter Mode */
#define     TX_DATA_12_BITS         0x01
#define     TX_DATA_24_BITS         0x02
#define     TX_DATA_DDR_MODE        0x04
#define     TX_DATA_SDR_MODE        0x08


/* Definition LVDS Trasmitter I2C Slave Address */
#define     VT1631_LVDS_I2C_ADDR    0x70
#define     CH7019_LVDS_I2C_ADDR    0xEA
#define     VT3271_LVDS_I2C_ADDR    0x80


/* GFX TV I/O Address */
#define     GFX_TV_IO_ADDR          0x31

struct tv_chip_information {
    int tv_chip_name;
    int tv_chip_slave_addr;
    int tv_chip_on_slot;        
    int output_interface;
};

struct tmds_chip_information {
    int tmds_chip_name;
    int tmds_chip_slave_addr;
    int dvi_panel_id;
    int data_mode;
    int output_interface;
    
};

struct lvds_chip_information {
    int lvds_chip_name;
    int lvds_chip_slave_addr;
    int lcd_panel_id;
    int data_mode;
};

struct chip_information  {
    int gfx_chip_name;
    int gfx_chip_revision;
    struct tv_chip_information tv_chip_info;
    struct tmds_chip_information tmds_chip_info;
    struct lvds_chip_information lvds_chip_info;
};

struct crt_setting_information {
    int iga_path;                               
    int h_active;
    int v_active;
    int bpp;
    int refresh_rate;
};

struct tv_setting_information {
    int iga_path;
    int h_active;
    int v_active;
    int bpp;                               
    int system;                                 
    int out_signal;                             
    int level;
    int dedotcrawl;    	                                 
};

struct tmds_setting_information {
    int iga_path;                               
    int h_active;
    int v_active;
    int bpp;
    int refresh_rate;
    int get_dvi_size_method;
};

struct lvds_setting_information {
    int iga_path;                               
    int h_active;
    int v_active;
    int bpp;
    int refresh_rate;
    int get_lcd_size_method;
};

#endif /* __CHIP_H__ */
  
