/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
*/ 
#ifndef _JFS_FS_SB
#define _JFS_FS_SB

struct jfs_sb_info {
	unsigned long	mntflag;	/* 4: aggregate attributes	*/
	struct inode	*ipbmap;	/* 4: block map inode		*/
	struct inode	*ipaimap;	/* 4: aggregate inode map inode	*/
	struct inode	*ipaimap2;	/* 4: secondary aimap inode	*/
	struct inode	*ipimap;	/* 4: aggregate inode map inode	*/
	struct jfs_log	*log;		/* 4: log			*/
	short		bsize;		/* 2: logical block size	*/
	short		l2bsize;	/* 2: log2 logical block size	*/
	short		nbperpage;	/* 2: blocks per page		*/
	short		l2nbperpage;	/* 2: log2 blocks per page	*/
	short		l2niperblk;	/* 2: log2 inodes per page	*/
	short		reserved;	/* 2: log2 inodes per page	*/
#ifdef _JFS
	pxd_t		logpxd;		/* 8: pxd describing log	*/
	pxd_t		ait2;		/* 8: pxd describing AIT copy	*/
#else
	long long	logpxd;		/* pxd_t not defined		*/
	long long	ait2;		/* pxd_t not defined		*/
#endif
	/* Formerly in ipimap */
	uint		gengen;		/* 4: inode generation generator*/
	uint		inostamp;	/* 4: shows inode belongs to fileset*/

        /* Formerly in ipbmap */
	struct bmap	*bmap;		/* 4: incore bmap descriptor	*/
	struct nls_table *nls_tab;	/* 4: current codepage		*/
	struct inode	*direct_inode;	/* 4: inode for physical I/O	*/
	struct address_space *direct_mapping; /* 4: mapping for physical I/O */
};					/* (72)				*/

#define s_jfs_mntflag		u.jfs_sb.mntflag
#define s_jfs_ipbmap		u.jfs_sb.ipbmap
#define s_jfs_ipaimap		u.jfs_sb.ipaimap
#define s_jfs_ipaimap2		u.jfs_sb.ipaimap2
#define s_jfs_ipimap		u.jfs_sb.ipimap
#define s_jfs_log		u.jfs_sb.log
#define s_jfs_bsize		u.jfs_sb.bsize
#define s_jfs_l2bsize		u.jfs_sb.l2bsize
#define s_jfs_nbperpage		u.jfs_sb.nbperpage
#define s_jfs_l2nbperpage	u.jfs_sb.l2nbperpage
#define s_jfs_l2niperblk	u.jfs_sb.l2niperblk
#define s_jfs_logpxd		u.jfs_sb.logpxd
#define s_jfs_ait2		u.jfs_sb.ait2
#define s_jfs_gengen		u.jfs_sb.gengen
#define s_jfs_inostamp		u.jfs_sb.inostamp
#define s_jfs_bmap		u.jfs_sb.bmap
#define s_jfs_nls_tab		u.jfs_sb.nls_tab
#define s_jfs_direct_inode	u.jfs_sb.direct_inode
#define s_jfs_direct_mapping	u.jfs_sb.direct_mapping

#define isReadOnly(ip) (((ip)->i_sb->s_jfs_log) ? 0 : 1)

#endif
