/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
*/ 
#ifndef _JFS_FS_I
#define _JFS_FS_I

#include <linux/version.h>

#ifdef _JFS
#include <linux/jfs/jfs_types.h>
#endif

/*
 * In the 2.2 kernels, struct pipe_info_info overlays the file system dependent
 * portions of the inode structure.  In order to support FIFO's, we need to
 * ensure that we leave this part of the inode alone when dealing with a FIFO.
 * The fields within the union u0 must not be used at all if the inode
 * represents a FIFO.
 */
struct jfs_inode_info {
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0))
	union {
		struct pipe_inode_info u00;
		struct {
#endif
			time_t	otime;		/* 4: time created	*/
			struct inomap *imap;	/* 4: inode map header	*/
			int	acltype;	/* 4: Type of ACL	*/
			void	*inode_ext;	/* 4: inode extension	*/
			short	btorder;	/* 2: access order	*/
			short	btindex;	/* 2: btpage entry index*/
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0))
		} u01;
	} u0;
#endif
#ifdef _JFS
        pxd_t   ixpxd;		/* 8: inode extent descriptor	*/
	dxd_t	acl;		/* 16: dxd describing acl	*/
	dxd_t	ea;		/* 16: dxd describing ea	*/
#else
	int	ixpxd[2];	/* pxd_t not defined		*/
	int	acl[4];		/* dxt_t not defined		*/
	int	ea[4];		/* dxt_t not defined		*/
#endif
	struct inode *ipimap;	/* 4: inode map			*/
	int	fileset;	/* 4: fileset number (always 16)*/
	uint	mode2;		/* 4: jfs-specific mode		*/
	ushort	flag;		/* 2: JFS in-memory flag*/
	unchar	cflag;		/* 1: commit flags		*/
	unchar	agno;		/* 1: ag number			*/
	ushort	bxflag;		/* 2: xflag of pseudo buffer?	*/
	short	blid;		/* 2: lid of pseudo buffer?	*/
	ushort	atlhead;	/* 2: anonymous tlock list head	*/
	ushort	atltail;	/* 2: anonymous tlock list tail	*/
	struct page *extent_page; /* 4: page containing extent  */
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))
#ifdef _JFS
	struct	jfs_rwlock rdwrlock; /* 12: read/write lock	*/
#else
	int	rdwrlock[3];	/* struct jfs_rwlock not defined */
#endif
#else
	struct	rw_semaphore rdwrlock; /* 16: read/write lock	*/
#endif
	
};

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0))
#define i_jfs_otime	u.jfs_i.u0.u01.otime
#define i_jfs_acltype	u.jfs_i.u0.u01.acltype
#define i_jfs_inode_ext	u.jfs_i.u0.u01.inode_ext
#define i_jfs_btorder	u.jfs_i.u0.u01.btorder
#define i_jfs_btindex	u.jfs_i.u0.u01.btindex
#define i_jfs_imap	u.jfs_i.u0.u01.imap
#else
#define i_jfs_otime	u.jfs_i.otime
#define i_jfs_acltype	u.jfs_i.acltype
#define i_jfs_inode_ext	u.jfs_i.inode_ext
#define i_jfs_btorder	u.jfs_i.btorder
#define i_jfs_btindex	u.jfs_i.btindex
#define i_jfs_imap	u.jfs_i.imap
#endif
#define i_jfs_ixpxd	u.jfs_i.ixpxd
#define i_jfs_acl	u.jfs_i.acl
#define i_jfs_ea	u.jfs_i.ea
#define i_jfs_ipimap	u.jfs_i.ipimap
#define i_jfs_fileset	u.jfs_i.fileset
#define i_jfs_mode2	u.jfs_i.mode2
#define i_jfs_flag	u.jfs_i.flag
#define i_jfs_cflag	u.jfs_i.cflag
#define i_jfs_agno	u.jfs_i.agno
#define i_jfs_bxflag	u.jfs_i.bxflag
#define i_jfs_blid	u.jfs_i.blid
#define i_jfs_atlhead	u.jfs_i.atlhead
#define i_jfs_atltail	u.jfs_i.atltail
#define i_jfs_extent_page	u.jfs_i.extent_page
#define i_jfs_rdwrlock	u.jfs_i.rdwrlock

#endif
