/*
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef H_DEVICES
#define H_DEVICES

#define GET	0
#define PUT	1
#define VRFY	2

/* Macros used for determining open mode */
#define READONLY	0
#define RDWR_EXCL	1

/* Handle used to access the device. */              
#define HFILE int
#define PHFILE int * 

/* Error codes */
#define NO_ERROR		  0
#define ERROR_INVALID_FUNCTION	  1
#define ERROR_FILE_NOT_FOUND	  2
#define ERROR_INVALID_HANDLE	  6
#define ERROR_NOT_ENOUGH_MEMORY   8 
#define ERROR_INVALID_ACCESS	 12
#define ERROR_SEEK		         25
#define ERROR_WRITE_FAULT	     29
#define ERROR_READ_FAULT	     30
#define ERROR_GEN_FAILURE	     31
#define ERROR_INVALID_PARAMETER	 87
#define ERROR_DISK_FULL         112

                               
int32 ujfs_get_dev_size( HFILE device, int64 * size, int64 * hidden);
int32 ujfs_open_device( char * Device, PHFILE FileHandle, int32 * SectorSize, int32 mode);
int32 ujfs_close( HFILE);
int32 ujfs_rw_diskblocks(HFILE, int64, int32, void *, int32);

#endif /* H_DEVICES */
