/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <linux/fs.h>
#include <linux/jfs/jfs_types.h>
#include <linux/jfs/jfs_filsys.h>
#include <linux/jfs/jfs_xtree.h>
#include <linux/jfs/jfs_debug.h>

/*
 * NAME:	fread()
 *
 * FUNCTION:	Read a block by relative block number within file
 *
 */
struct buffer_head *fread(
struct inode	*ip,
int64		block)
{
	int32	page_num;
	int32	rc;
	int64	xaddr;
	uint8	xflag;
	int32	xlen;

	jEVENT(0,("fread called, block number 0x%llx\n", block));
	rc = xtLookup(ip, block, ip->i_sb->s_jfs_nbperpage, &xflag, &xaddr,
		      &xlen, 0);
	if (rc)
	{
		jERROR(1,("fread: xtLookup failed with rc = %d\n", rc));
		return NULL;
	}
	if (xlen == 0)
	{
		jEVENT(1,("fread: xtLookup returned xlen = 0\n"));
		return NULL;
	}
	page_num = xaddr >> ip->i_sb->s_jfs_l2nbperpage;

	return bread(ip->i_dev, page_num, PSIZE);
}

/*
 * NAME:	fgetblk()
 *
 * FUNCTION:	Get block from buffer cache
 *
 */
struct buffer_head *fgetblk(
struct inode	*ip,
int64		block)
{
	int32	page_num;
	int32	rc;
	int64	xaddr;
	uint8	xflag;
	int32	xlen;

	rc = xtLookup(ip, block, ip->i_sb->s_jfs_nbperpage, &xflag, &xaddr,
		      &xlen, 1);
	if (rc)
	{
		jERROR(1,("fgetblk: xtLookup failed with rc = %d\n", rc));
		return NULL;
	}
	if (xlen == 0)
	{
		jEVENT(1,("fgetblk: xtLookup returned xlen = 0\n"));
		return NULL;
	}
	page_num = xaddr >> ip->i_sb->s_jfs_l2nbperpage;
	return getblk(ip->i_dev, page_num, PSIZE);
}
