/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <linux/fs.h>
#include <linux/jfs_fs.h>
#include <linux/jfs/jfs_types.h>
#include <linux/jfs/jfs_filsys.h>
#include <linux/jfs/jfs_debug.h>
#include <linux/string.h>
#include <linux/ctype.h>
#define __NO_VERSION__
#include <linux/module.h>
#include <linux/proc_fs.h>

void dump_mem(
char	*label,
void	*data,
int	length)
{
	int	i, j;
	int	*intptr = data;
	char	*charptr = data;	
	char	buf[10], line[80];

	printk("%s: dump of %d bytes of data at 0x%p\n\n", label, length, data);
	for (i = 0; i < length; i += 16)
	{
		line[0] = 0;
		for (j = 0; (j < 4) && (i+j*4 < length); j++)
		{
			sprintf(buf," %08x", intptr[i/4 + j]);
			strcat(line, buf);
		}
		buf[0] = ' ';
		buf[2] = 0;
		for (j = 0; (j < 16) && (i+j < length); j++)
		{
			buf[1] = isprint(charptr[i+j]) ? charptr[i+j] : '.';
			strcat(line, buf);
		}
		printk("%s\n", line);
	}
}

#ifndef kern22
#if CONFIG_PROC_FS
struct proc_dir_entry* proc_fs_jfs;
int jfs_txanchor_get_info(char *, char **, off_t, int);
int jfs_logmgr_get_info(char *, char **, off_t, int);

void jfs_proc_init(void)
{
	proc_fs_jfs = proc_mkdir("jfs", proc_root_fs);
	proc_fs_jfs->owner = THIS_MODULE;
	create_proc_info_entry("TxAnchor", 0, proc_fs_jfs,
				jfs_txanchor_get_info);
	create_proc_info_entry("logmgr", 0, proc_fs_jfs,
				jfs_logmgr_get_info);

}

void jfs_proc_clean(void)
{
	remove_proc_entry("logmgr", proc_fs_jfs);
	remove_proc_entry("TxAnchor", proc_fs_jfs);
	remove_proc_entry("jfs", proc_root_fs);
}
#endif
#endif
