/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "tds.h"
#include "tdsutil.h"
#include <stdlib.h>
#include <unistd.h>

static char  software_version[]   = "$Id: mem.c,v 1.12 1999/08/11 01:53:59 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};


TDSCOMPUTEINFO *tds_alloc_compute_results(int num_cols)
{
/*TDSCOLINFO *curcol;
 */
TDSCOMPUTEINFO *comp_info;
int col;

	comp_info = (TDSCOMPUTEINFO *) malloc(sizeof(TDSCOMPUTEINFO));
	memset(comp_info,'\0',sizeof(TDSCOMPUTEINFO));
	comp_info->columns = (TDSCOLINFO **) 
		malloc(sizeof(TDSCOLINFO *) * num_cols);
	for (col=0;col<num_cols;col++)  {
		comp_info->columns[col] = (TDSCOLINFO *) malloc(sizeof(TDSCOLINFO));
		memset(comp_info->columns[col],'\0',sizeof(TDSCOLINFO));
	}
	comp_info->num_cols = num_cols;
	return comp_info;
}

TDSRESULTINFO *tds_alloc_results(int num_cols)
{
/*TDSCOLINFO *curcol;
 */
TDSRESULTINFO *res_info;
int col;

	res_info = (TDSRESULTINFO *) malloc(sizeof(TDSRESULTINFO));
	memset(res_info,'\0',sizeof(TDSRESULTINFO));
	res_info->columns = (TDSCOLINFO **) 
		malloc(sizeof(TDSCOLINFO *) * num_cols);
	for (col=0;col<num_cols;col++)  {
		res_info->columns[col] = (TDSCOLINFO *) malloc(sizeof(TDSCOLINFO));
		memset(res_info->columns[col],'\0',sizeof(TDSCOLINFO));
	}
	res_info->num_cols = num_cols;
	res_info->null_info_size = (num_cols/8) + 1;
	/* set the initial row size to the size of the null info */
	res_info->row_size = res_info->null_info_size;
	return res_info;
}

void *tds_alloc_row(TDSRESULTINFO *res_info)
{
void *ptr;

	ptr = (void *) malloc(res_info->row_size);
	memset(ptr,'\0',res_info->row_size); 
	return ptr;
}

void tds_free_compute_results(TDSCOMPUTEINFO *comp_info)
{
int i;


	if(comp_info)
	{
		for (i=0;i<comp_info->num_cols;i++)
		{
			if(comp_info->columns[i])
			free(comp_info->columns[i]);
		}
		if (comp_info->num_cols) free(comp_info->columns);
		free(comp_info);
	}

}

void tds_free_results(TDSRESULTINFO *res_info)
{
int i;


	if(res_info)
	{
		if (res_info->current_row) free(res_info->current_row);
		for (i=0;i<res_info->num_cols;i++)
		{
			if(res_info->columns[i])
			free(res_info->columns[i]);
		}
		if (res_info->num_cols) free(res_info->columns);
		free(res_info);
	}

}
TDSLOGIN *tds_alloc_login()
{
TDSLOGIN *tds_login;
unsigned char defaultcaps[] = {0x01,0x07,0x03,109,127,0xFF,0xFF,0xFF,0xFE,0x02,0x07,0x00,0x00,0x0A,104,0x00,0x00,0x00};

	tds_login = (TDSLOGIN *) malloc(sizeof(TDSLOGIN));
	memset(tds_login, '\0', sizeof(TDSLOGIN));
#if TDS42
	tds_login->major_version=4;
	tds_login->minor_version=2;
#elif TDS46
	tds_login->major_version=4;
	tds_login->minor_version=6;
#else
	tds_login->major_version=5;
	tds_login->minor_version=0;
#endif
	memcpy(tds_login->capabilities,defaultcaps,TDS_MAX_CAPABILITY);
	return tds_login;
}
void tds_free_login(TDSLOGIN *login)
{
	if (login) free(login);
}
TDSSOCKET *tds_alloc_socket(int bufsize)
{
TDSSOCKET *tds_socket;

	tds_socket = (TDSSOCKET *) malloc(sizeof(TDSSOCKET));
	memset(tds_socket, '\0', sizeof(TDSSOCKET));
	tds_socket->in_buf_max=0;
	tds_socket->out_buf = (unsigned char *) malloc(bufsize);
	tds_socket->msg_info = (TDSMSGINFO *) malloc(sizeof(TDSMSGINFO));
	memset(tds_socket->msg_info,'\0',sizeof(TDSMSGINFO));
	tds_socket->parent = (char*)NULL;
	tds_init_write_buf(tds_socket);
	return tds_socket;
}
TDSSOCKET *tds_realloc_socket(int bufsize)
{
   return NULL; /* XXX */
}
void tds_free_socket(TDSSOCKET *tds)
{
	if (tds) {
		if (tds->msg_info) free(tds->msg_info);
		if (tds->in_buf) free(tds->in_buf);
		if (tds->out_buf) free(tds->out_buf);
		free(tds);
	}
}
void tds_free_msg(TDSMSGINFO *msg_info)
{
	if (msg_info) {
		if(msg_info->message) free(msg_info->message);
		if(msg_info->server) free(msg_info->server);
		if(msg_info->proc_name) free(msg_info->proc_name);
		if(msg_info->sql_state) free(msg_info->sql_state);
	}
}
