/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "tdsutil.h"
#include "tds.h"
#include "sybfront.h"
#include "sybdb.h"
#include "dblib.h"
#include "convert.h"
#include <stdlib.h>
#include <unistd.h>
#include <time.h>


static char  software_version[]   = "$Id: convert.c,v 1.6 1999/06/13 00:07:18 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};
typedef union dbany {
        DBTINYINT	ti;
        DBSMALLINT	si;
        DBINT		i;
	DBFLT8		f;
	DBREAL		r;
	DBCHAR		*c;
	DBMONEY         m;
	DBMONEY4	m4;
	DBDATETIME	dt;
	DBDATETIME4	dt4;
/*
	DBDECIMAL	d;
	DBNUMERIC	n;
*/
} DBANY; 

DBINT _convert_any(BYTE *dest, DBINT dtype, DBINT dlen, DBANY *any);


/* 
this needs to go... 
it won't handle binary or text/image when they are added
it's not thread safe
it works for the moment though til i decide how i really want to handle it
*/
static DBCHAR tmp_str[1024];  


int _get_conversion_type(int srctype, int colsize)
{
	if (srctype == SYBINTN) {
		if (colsize==4)
			 return SYBINT4;
		else if (colsize==2)
			 return SYBINT2;
		else if (colsize==1)
			 return SYBINT1;
	} else if (srctype == SYBFLTN) {
		if (colsize==8)
			return SYBFLT8;
		else if (colsize==4)
			return SYBREAL;
	}
	return srctype;
}
DBINT _convert_char(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
   DBANY any;
   
   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         any.c = src;
         break;
      case SYBTEXT:
         break;
      case SYBBINARY:
      case SYBIMAGE:
         break;
      case SYBINT1:
         any.ti = atoi(src);
         break;
      case SYBINT2:
         any.si = atoi(src);
         break;
      case SYBINT4:
         any.i = atol(src);
         break;
      case SYBFLT8:
         any.f = atof(src);
         break;
      case SYBREAL:
         any.r = atof(src);
         break;
      case SYBBIT:
         any.ti = (atoi(src)>0) ? 1 : 0;
         break;
      case SYBMONEY:
         break;
      case SYBMONEY4:
         break;
      case SYBDATETIME:
         break;
      case SYBDATETIME4:
         break;
      case SYBNUMERIC:
      case SYBDECIMAL:
         break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
      default:
         return FAIL;
   }
   return _convert_any(dest, desttype, destlen, &any);
}
DBINT _convert_bit(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
DBANY any;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%c",src[0] ? '1' : '0');
			any.c = tmp_str;
			break;
		case SYBTEXT:
			break;
		case SYBBINARY:
		case SYBIMAGE:
			break;
		case SYBINT1:
			any.ti = src[0] ? 1 : 0;
			break;
		case SYBINT2:
			any.si = src[0] ? 1 : 0;
			break;
		case SYBINT4:
			any.i = src[0] ? 1 : 0;
			break;
		case SYBFLT8:
			any.f = src[0] ? 1.0 : 0.0;
			break;
		case SYBREAL:
			any.r = src[0] ? 1.0 : 0.0;
			break;
		case SYBBIT:
			any.ti = src[0];
			break;
		case SYBMONEY:
			break;
		case SYBMONEY4:
			break;
		case SYBNUMERIC:
		case SYBDECIMAL:
			break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
	}
	return _convert_any(dest, desttype, destlen, &any);
}
DBINT _convert_int1(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
DBANY any;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%d",src[0]);
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((DBTINYINT *) src);
			break;
		case SYBINT2:
			any.si = *((DBTINYINT *) src);
			break;
		case SYBINT4:
			any.i = *((DBTINYINT *) src);
			break;
		default:
			return FAIL;
	}
	return _convert_any(dest, desttype, destlen, &any);
}
DBINT _convert_int2(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
DBANY any;
	
	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%d",*((DBSMALLINT *) src));
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((DBSMALLINT *) src);
			break;
		case SYBINT2:
			any.si = *((DBSMALLINT *) src);
			break;
		case SYBINT4:
			any.i = *((DBSMALLINT *) src);
			break;
	}
	return _convert_any(dest, desttype, destlen, &any);
}
DBINT _convert_int4(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
DBANY any;
	
	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%ld",*((DBINT *) src));
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((DBINT *) src);
			break;
		case SYBINT2:
			any.si = *((DBINT *) src);
			break;
		case SYBINT4:
			any.i = *((DBINT *) src);
			break;
		default:
			return FAIL;
	}
	return _convert_any(dest, desttype, destlen, &any);
}
DBINT _convert_money(int srctype,BYTE *src,
	int desttype,BYTE *dest,DBINT destlen)
{
unsigned long dollars, hundreths,bignum;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			/* FIX ME -- this will not handle really big money */
			bignum=(unsigned char) src[4]+
				(unsigned char) src[5]*256+
				(unsigned char) src[6]*256*256+
				(unsigned char) src[7]*256*256*256;
			dollars=bignum/10000;
			hundreths=bignum%10000;
			sprintf(dest,"%lu.%02lu",dollars,hundreths/100);
                        return strlen(dest);
			break;
               default:
                        return FAIL;
                        break;
	}
}
DBINT _convert_datetime(int srctype,BYTE *src,int desttype,BYTE *dest,DBINT destlen)
{
   DBDATETIME* in = (DBDATETIME*)src;
   long tmp_secs_from_epoch;
   
   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         tmp_secs_from_epoch = ((in->dtdays - 25567)*(24*60*60))
            +(in->dttime/300);
         if (strlen(src)>destlen) {
            strftime(dest, destlen-1, "%b %d %Y %I:%M%p",
                     (struct tm*)gmtime(&tmp_secs_from_epoch));
            return destlen;
         } else {
            strftime(dest, 20, "%b %d %Y %I:%M%p",
                     (struct tm*)gmtime(&tmp_secs_from_epoch));
            return (strlen(dest));
         }
         break;
      default:
         return FAIL;
         break;
   }
}
DBINT _convert_flt8(int srctype,BYTE *src,int desttype,BYTE *dest,DBINT destlen)
{
DBFLT8 the_value = *(double*)src;

   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         sprintf(dest,"%10.0f", the_value);
         return strlen(dest);
   }
   return FAIL;
}

DBINT _convert_any(BYTE *dest, DBINT dtype, DBINT dlen, DBANY *any)
{
	switch(dtype) {
		case SYBCHAR:
		case SYBVARCHAR:
			if (strlen(any->c)>dlen) {
				strncpy(dest,any->c,dlen-1);
				dest[dlen-1]='\0';
				return dlen;
			} else {
				strcpy(dest, any->c);
				return (strlen(dest));
			}
			break;
		case SYBTEXT:
			break;
		case SYBBINARY:
		case SYBIMAGE:
			break;
		case SYBINT1:
			memcpy(dest,&(any->ti),1);
			return 1;
			break;
		case SYBINT2:
			memcpy(dest,&(any->si),2);
			return 2;
			break;
		case SYBINT4:
			memcpy(dest,&(any->i),4);
			return 4;
			break;
		case SYBFLT8:
			memcpy(dest,&(any->f),8);
			return 8;	
			break;
		case SYBREAL:
			memcpy(dest,&(any->r),4);
			return 4;	
			break;
		case SYBBIT:
			memcpy(dest,&(any->ti),1);
			return 1;
			break;
		case SYBMONEY:
			break;
		case SYBMONEY4:
			break;
		case SYBDATETIME:
			break;
		case SYBDATETIME4:
			break;
		case SYBNUMERIC:
		case SYBDECIMAL:
			break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
	}
	return FAIL;
}
