/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <tds.h>


static char  software_version[]   = "$Id: tdstest.c,v 1.7 1999/08/22 02:19:31 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};


char *value_as_string(
   TDSSOCKET  *tds,
   int         col_idx)
{
   static char  result[256]; 
   const int    type    = tds->res_info->columns[col_idx]->column_type;
   const char  *row     = tds->res_info->current_row;
   const int    offset  = tds->res_info->columns[col_idx]->column_offset;
   const void  *value   = (row+offset);

   switch(type)
   {
      case SYBVARCHAR:
      {
         strncpy(result, (char *)value, sizeof(result)-1);
         result[sizeof(result)-1] = '\0';
         break;
      }
      case SYBINT4:
      {
         sprintf(result, "%d", *(int *)value);
         break;
      }
      default:
      {
         strcpy(result, "NotImp");
         break;
      }
   }
   return result;
} /* value_as_string()  */


int main()
{
TDSLOGIN *login;
TDSSOCKET *tds;
int rc;
int i;

 login = tds_alloc_login();
 tds_set_passwd(login,"sybase");
 tds_set_user(login,"guest");
 tds_set_app(login,"sqsh");
 tds_set_host(login,"JDBC");
 tds_set_library(login,"TDS-Library");
 tds_set_server(login,"JDBC");
 tds_set_charset(login,"iso_1");
 tds_set_language(login,"us_english");
 tds_set_packet(login,512);

 if (!(tds = tds_connect(login))) {
	fprintf(stderr, "Login Failed!\n");
	exit(1);
 }

 /* tds_submit_query(tds,"select db_name() dbname, user_name() username"); */
 /* tds_submit_query(tds,"select idx from groups"); */
 /* tds_submit_query(tds,"select au_id, au_lname, au_fname, phone, address from authors order by au_fname, au_lname"); */
 tds_submit_query(tds,"select au_id,copy from blurbs where au_id = '486-29-1786'");
 while ((rc=tds_process_result_tokens(tds))==TDS_SUCCEED) 
 {
    for (i=0; i<tds->res_info->num_cols; i++)
    {
       printf("col %d\n  Type:   %d\n  Name:   %s\n  Offset: %d\n", 
              i, 
              tds->res_info->columns[i]->column_type, 
              tds->res_info->columns[i]->column_name,
              tds->res_info->columns[i]->column_offset);
    }
    
    while ((rc=tds_process_row_tokens(tds))==TDS_SUCCEED) 
    {
       for (i=0; i<tds->res_info->num_cols; i++)
       {
          printf("col %i is %s\n", i, value_as_string(tds, i));
       }
    }
 }
 return 0;
}
