/*
 *		 Forward request'.
 * Patch by Yarick Rastrigin <Yarick.Rastrigin@f17.n5025.z2.fidonet.org>
 */

#include "limits.h"
#include "lib.h"
#include "readconf.h"
#include "readpasswd.h"
#include "uplink.h"
#include "areafix.h"

//   -1	-     !
int Uplink()
{
	FILE *f;
	int i=0;
	char str[CHAR_MAX];

	if( ( f = fopen( conf.UplinkFile, "r" ) ) == NULL )
	{
		log( 0, "UplinkFile \"%s\" don't exist!", conf.UplinkFile );
		return( -1 );
	}

	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		if( str[0] != '#' && strlen( str ) > 2 && i != MAXUPLINK+1 )
		{
			sscanf(str,"%[A-Za-z0-9.-]:%[A-Za-z0-9.-]:%[A-Za-z0-9.,@#%&*!-+=<>_]:%[A-Za-z0-9]",
			&uplink.Uplink[i],&uplink.Address[i],
			&uplink.Passwd[i],&uplink.Distr[i]);

#ifdef	SECURELOG
			log(5,"Read UplinkFile[%d]: \"%s\":\"%s\":\"%s\"",
			  i,uplink.Uplink[i],uplink.Address[i],uplink.Distr[i]);
#else
			log(5,"Read UplinkFile[%d]: \"%s\":\"%s\":\"%s\":\"%s\"",
			  i,uplink.Uplink[i],uplink.Address[i],
			  uplink.Passwd[i],uplink.Distr[i]);
#endif
			i++;
		}
	}
	uplink.n = i;
	fclose( f );
	return( 0 );
}

/*	   .				*/
/*	patched by Ruslan.Vodopyanov@f84.n5011.z2.fidonet.org		*/
int Forward(char *Echo)
{
	FILE *f;
	int i=-1, F, N;
	char filebbs[CHAR_MAX];
	char str[CHAR_MAX];

	strlwr( Echo );
	Echo++;

	while( ++i != uplink.n )
	{
		sscanf( uplink.Uplink[i], "f%d.n%d", &F, &N );

		log( 5, "Read Uplink[%d]: %d/%d", i, N, F );

		//        
		snprintf( filebbs, PATH_MAX, "%s/%04x%04x.bbs",
				conf.ForwardFile, N, F );

		log( 5, "Read \"%s\" file", filebbs );

		//   
		if( ( f = fopen( filebbs, "r" ) ) != NULL )
		{
			//   !
			while( fgets( str, CHAR_MAX, f ) != NULL )
			{
				//  
				strtok( str, " \t\n" );
				strlwr( str );	//    
				log( 5, "Uplink[%d]: Found area \"%s\"",
						i, str );
				if( strcmp( Echo, str ) == 0 &&
				   strstr( passwd.distr, uplink.Distr[i])!=0)
				{
					//  !
					fclose( f );
					return( 0 );
				}
			}
		fclose( f );
		}
	}
	return( -1 );
}

/*	     %AVAIL			*/
int AvailList(FILE *f)
{
	FILE *ff;
	int i=-1, n, F, N;
	char filebbs[CHAR_MAX];
	char str[CHAR_MAX];

	if( uplink.n == 0 ) return( -1 );

	while( ++i != uplink.n )
	{
		if( strstr( passwd.distr, uplink.Distr[i] ) !=0 )
		{
			sscanf( uplink.Uplink[i], "f%d.n%d", &F, &N );

			log( 5, "Read Uplink[%d]: %d/%d", i, N, F );

			//        
			snprintf( filebbs, PATH_MAX, "%s/%04x%04x.bbs",
					conf.ForwardFile, N, F );

			fprintf( f, "Uplink: %d/%d\n\n", N, F );

			// TODO -   ,   
			//   !
			if( ( ff = fopen( filebbs, "r" ) ) != NULL )
			{
				n=0;
				//   !
				while( fgets( str, CHAR_MAX, ff ) != NULL )
				{
					fputs( str, f );
					n++;
				}
				fclose( ff );
				fprintf( f, "\n\tRead %d areas.\n\n", n );
			}
			else
				return( -1 );
		}
	}
	return( -1 );
}
