/*			/  /		*/

#include <stdio.h>
#include <stdlib.h>
#include "limits.h"
#include "readconf.h"
#include "readareas.h"
#include "readpasswd.h"
#include "readnewsfeeds.h"
#include "sendmail.h"
#include "answer.h"
#include "uplink.h"
#include "subscribe.h"
#include "log.h"

char *ToFtn(char *addr);

/*				 %HELP				*/
int SendHelpMail()
{
	FILE *f, *ff;
	char str[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	StartMail( passwd.name, passwd.addr, HelpRequest, f );

	if( ( ff = fopen( conf.HelpFile, "r" ) ) == NULL )
	{
		log( 0, "HelpFile \"%s\" cannot be opened!", conf.HelpFile );
		fprintf( f, "%s\n", NoHelpFile );
	}
	else
	{
		//   HelpFile  TMPMAIL
		while( fgets( str, CHAR_MAX, ff ) != NULL )
			fputs( str, f );
		fclose( ff );
		//   .
		log( 2, "Processing %%HELP operation" );
	}

	//   
	EndMail( f );
	fclose( f );

	//   
	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*				 %LIST				*/
int SendListMail()
{
	FILE *f;
	int i=-1, n=0, nn=0, m;
	char str[CHAR_MAX];
	char buf[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpFile \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	//   .
	log( 2, "Processing %%LIST operation" );

	StartMail( passwd.name, passwd.addr, ListRequest, f );
	fprintf( f, "Your Distributions is \"%s\",", passwd.distr );

	if( FtnSite( passwd.addr ) != -1 )
		fprintf( f, " FTN link\n\n" );
	else
		fprintf( f, " no-FTN link\n\n" );

	//     %LIST
	while( ++i != areas.n )
	{
		if( strstr( passwd.distr, areas.distr[i] ) != 0 )
		{
			//      . 
			//   site FNT  ?
			if( FtnSite( passwd.addr ) != -1 )
				strcpy( buf, areas.echo[i] );
			else
				strcpy( buf, areas.ng[i] );

			//  .    !
			m = strlen( buf );
			if( m+2 < MAXLENECHO )
				buf[m++] = ' ';
			while( m < MAXLENECHO )
				buf[m++] = ListS;
			buf[m]=0;

			if( areas.s[i] == 1 )
			{
				fprintf( f, "* %s %s\n",
					buf, areas.desc[i] );
				nn++;	// ,  site .
				log( 5, "Write List(%d): \"%s\" (Substribed)",
						n,areas.ng[i]);
			}
			else
			{
				fprintf( f, "  %s %s\n",
					buf, areas.desc[i] );
				log( 5, "Write List(%d): \"%s\" (UnSubstribed)",
						n,areas.ng[i]);
			}

			n++;
		}
		else
			log( 5, "Don't write to List: \"%s\"", areas.ng[i] );
	}
	// End

	fprintf( f, "\n\n '*' = area active for %s\n", ToFtn( passwd.addr ) );
	fprintf( f, " %d areas available, %d areas active\n", n, nn );

	log( 3, "%d areas available, %d areas active", n, nn );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*				 %NEWSLIST			*/
int SendNewsListMail()
{
	FILE *f;
	int i=-1, n=0, nn=0, m;
	char str[CHAR_MAX];
	char buf[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpFile \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	//   .
	log( 2, "Processing %%NEWSLIST operation" );

	StartMail( passwd.name, passwd.addr, NewsListRequest, f );
	fprintf( f, "Your Distributions is \"%s\",", passwd.distr );
	if( FtnSite( passwd.addr ) != -1 )
		fprintf( f, " FTN link\n\n" );
	else
		fprintf( f, " no-FTN link\n\n" );

	//     %NEWSLIST
	while( ++i != areas.n )
	{
		if( strstr( passwd.distr, areas.distr[i] ) != 0 )
		{
			//      . 
			strcpy( buf, areas.ng[i] );

			m = strlen( buf );
			if( m+2 < MAXLENECHO )
				buf[m++] = ' ';
			while( m < MAXLENECHO )
				buf[m++] = ListS;
			buf[m]=0;

			if( areas.s[i-1] == 1 )
			{
				fprintf( f, "* %s %s\n",
					buf, areas.desc[i] );
				nn++;	// ,  site .
				log( 5, "Write List(%d): \"%s\" (Substribed)",
						n, areas.ng[i]);
			}
			else
			{
				fprintf( f, "  %s %s\n",
					buf, areas.desc[i] );
				log( 5, "Write List(%d): \"%s\" (UnSubstribed)",
						n, areas.ng[i]);
			}

			n++;
		}
		else
			log( 5, "Don't write to List: \"%s\"", areas.ng[i] );
	}
	// End

	fprintf( f, "\n\n '*' = area active for %s\n", ToFtn( passwd.addr ) );
	fprintf( f, " %d areas available, %d areas active\n", n, nn );

	log( 3, "%d areas available, %d areas active", n, nn );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*			 %INFO					*/
int SendInfoMail()
{
	FILE *f;
	char str[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	StartMail( passwd.name, passwd.addr, InfoRequest, f );

	//   .
	log( 2, "Processing %%INFO operation" );

	fprintf( f, "Here is some information about our link:\n\n" );
	fprintf( f, "    Your address:  %s\n", ToFtn( passwd.addr ) );
	fprintf( f, "   AKA used here:  %s\n", ToFtn( conf.Address ) );
	fprintf( f, "AreaFix passowrd:  %s\n\n", passwd.pass );

	//   ,    
	Query( f );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*			    		*/
int SendErrorPassword(char *Name, char *Addr, char *Pass)
{
	FILE *f;

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	StartMail( Name, Addr, IncorrectPassword, f );

	fprintf( f, "Dear \"%s\"!\n\n", Name );
	fprintf( f, "You gave incorrect password for Area Manager, so,\n" );
	fprintf( f, "your AreaFix query will be refused. Please repeat\n" );
	fprintf( f, "your request with correct password or contact\n" );
	fprintf( f, "with \"%s\", our system operator.\n\n", conf.SysOp );
	fprintf( f, "\t\t Yours, AreaFix of %s\n", ToFtn( conf.Address ) );

#ifdef	SECURELOG
	log( 1, "Remote \"%s\" gave incorrect password!", Name );
#else
	log( 1, "Remote \"%s\" gave incorrect password \"%s\"!", Name, Pass );
#endif

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*		      NewsFeeds	*/
int SendErrorNewsFeeds()
{
	FILE *f;

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	StartMail( passwd.name, passwd.addr, ErrorStr, f );

	fprintf( f, "\nDear \"%s\"!\n\n", passwd.name );
	fprintf( f, "I'm terribly sorry, but your site is not present\n" );
	fprintf( f, "in our newsfeeds file, so, you can not access\n" );
	fprintf( f, "Area Manager on this node. Please, contact with\n" );
	fprintf( f, "\"%s\", our system operator.\n\n", conf.SysOp );
	fprintf( f, "\t\t Yours, AreaFix of %s\n", ToFtn( conf.Address ) );

	log( 1, "Site \"%s\" was not found in newsfeeds", passwd.site );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*	       /newsgroup	*/
/*	    -    	*/
int SendSubScribeMail()
{
	FILE *f;
	char str[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	StartMail( passwd.name, passwd.addr, SubScribeRequest, f );

	/* ------------------------------------------------------------- */

	while( s.n-- != 0 )
	{
		fprintf( f, "%s", s.EchoNews[s.n] );	//  

		switch( s.EchoNews[s.n][0] )
		{
			case '%':	//   newsgroup'
				if( s.already[s.n] == 3 )
				{
					fprintf(f," - Bad mailing command!\n");
					log(1,"\"%s\" - bad mailing command.",
						s.EchoNews[s.n] );
				}
				if( s.already[s.n] == 4 )
				{
					fprintf(f," - Cannot [un]subscribe!\n");
					log(2,"\"%s\" - cannot subscribe.",
						s.EchoNews[s.n] );
				}
				else if( s.EchoNews[s.n][1] == '+' )
					SubScribeMail( f );
				else if( s.EchoNews[s.n][1] == '-' )
					UnSubScribeMail( f );
				else
					fprintf( f, " - unknown error!\n" );
				break;
			case '+':	//  
				SubScribeMail( f );
				break;
			case '-':	//  
				UnSubScribeMail( f );
				break;
		}
	}

	/* ------------------------------------------------------------- */

	//   
	EndMail( f );
	fclose( f );

	//   
	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

int SubScribeMail(FILE *f)
{
	switch( s.already[s.n] )
	{
		case 0:	//  
			fprintf( f, " - Subscribed\n" );
			log( 2,"Remote subscribed to \"%s\"",s.EchoNews[s.n] );
			break;
		case 1:	//   
			fprintf( f, " - Already subscribed!\n" );
			log( 2, "Remote already subscribe to \"%s\"",
					s.EchoNews[s.n] );
			break;
		case 2:	// Error!    !
			ForwardMail( f, s.EchoNews[s.n] );
			break;
		case 3: // Bad coomand
			fprintf( f, " - Bad mailing command!\n" );
			log(1,"\"%s\" - bad mailing command.",s.EchoNews[s.n]);
			break;
		case 4: // Cannot subscribe (RestEcho);
			fprintf( f, " - Cannot subscribe (RestEcho)!\n" );
			log(2, "\"%s\" - cannot subscribe (RestEcho).",
					s.EchoNews[s.n] );
			break;
	}
}

int UnSubScribeMail(FILE *f)
{
	switch( s.already[s.n] )
	{
		case 0:	//  
			fprintf( f, " - Unsubscribed\n" );
			log( 2, "Remote unsubscribed from \"%s\"",
					s.EchoNews[s.n] );
			break;
		case 1:	//  
			fprintf( f, " - No match in your subscription list\n" );
			log( 2, "Remote is not subscribed to \"%s\"",
					s.EchoNews[s.n] );
			break;
		case 2:	// Error!    !
			fprintf( f, " - No such echo(es) here.\n" );
			log( 2, "Remote cannot be unsubcribe from \"%s\"",
					s.EchoNews[s.n] );
			break;
		case 3: // Bad coomand
			fprintf( f, " - Bad mailing command!\n" );
			log(1,"\"%s\" - bad mailing command.",s.EchoNews[s.n]);
			break;
		case 4: // Cannot subscribe (RestEcho);
			fprintf( f, " - Cannot subscribe (RestEcho)!\n" );
			log(2, "\"%s\" - cannot subscribe (RestEcho).",
					s.EchoNews[s.n] );
	}
}

/*		    			*/
int ForwardMail(FILE *f, char *EchoNews)
{
	if( Uplink() == -1 )	//    
		//     !  .
		goto NoForward;
	//    
	if( Forward( EchoNews ) != -1 )
	{
		log( 2,"\"%s\" - This request will be forwarded to our uplink",
				EchoNews );
		fprintf(f," - Your request will be forwarded to our uplink. Try later.\n");
		SendForwardMail( EchoNews );	//   
		return( 0 );
	}

NoForward:
	log( 1, "Can not subscribe to \"%s\" - no such echo", EchoNews );
	fprintf( f, " - No such echo(es) here.\n" );
	return( -1 );
}

/*	 ,     Passive/Active		*/
int SendAlreadyPassiveActive(int i)
{
	FILE *f;

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	if( i == 0 )
	{
		StartMail( passwd.name, passwd.addr, PassiveRequest, f );
		fprintf( f, "Your newsfeeds already have passive status\n" );
		log( 2, "Processing %%PASSIVE operation" );
	}
	else
	{
		StartMail( passwd.name, passwd.addr, ActiveRequest, f );
		fprintf( f, "Your newsfeeds already have active status\n" );
		log( 2, "Processing %%ACTIVE operation" );
	}

	//   
	EndMail( f );
	fclose( f );

	//   
	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*	 -    Passive/Active	*/
int SendPassiveActiveStatus(int i)
{
	
	FILE *f;

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	if( i == 0 )
	{
		StartMail( passwd.name, passwd.addr, PassiveRequest, f );
		fprintf( f, "Your newsfeeds have passive status now\n" );
		log( 2, "Processing %%PASSIVE operation" );
	}
	else
	{
		StartMail( passwd.name, passwd.addr, ActiveRequest, f );
		fprintf( f, "Your newsfeeds have active status now\n" );
		log( 2, "Processing %%ACTIVE operation" );
	}

	//   
	EndMail( f );
	fclose( f );

	//   
	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

int SendForwardMail(char *Echo)
{
	FILE *f;

	if( ( f = fopen( TMPFORWARD, "w" ) ) == NULL )
	{
		log( 0,"TmpForward \"%s\" cannot be opened! Exit!",TMPFORWARD );
		exit( -1 );
	}

	fprintf( f, "From: %s@%s\n", strspace( conf.SysOp ), conf.Address );
	fprintf( f, "To: %s@%s\n", conf.UpLink_Robot, uplink.Address );
	//    
	fprintf( f, "Subject: %s\n\n", uplink.Passwd );
	fprintf( f, "%s\n\n", Echo );	//   

	//  
	fclose( f );

	//   
	SendMail( TMPFORWARD );

	remove( TMPFORWARD );

	return( 0 );
}

/*		   %AVAIL				*/
int SendAvailList()
{
	FILE *f;

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpMail \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	//   .
	log( 2, "Processing %%AVAIL operation" );

	//   
	StartMail( passwd.name, passwd.addr, AvailRequest, f );
	fprintf( f, "Your Distributions is \"%s\",", passwd.distr );
	if( FtnSite( passwd.addr ) != -1 )
		fprintf( f, " FTN link\n\n" );
	else
		fprintf( f, " no-FTN link\n\n" );

	if( Uplink() == -1 )	//    
	{
		//     !   
		// !
		fprintf( f, "\nUplinks file don't exist!\n" );
		goto Exit;
	}

	if( AvailList( f ) == -1 )	//     %AVAIL
		//    !
		fprintf( f, "\nUplinks EchoList not found!\n" );

Exit:	//  
	//   
	EndMail( f );
	fclose( f );

	//   
	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*				 %QUERY (  )	*/
int SendQueryMail()
{
	FILE *f;
	int n=0;
	char str[CHAR_MAX];
	char buf[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpFile \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	//   .
	log( 2, "Processing %%QUERY operation" );

	StartMail( passwd.name, passwd.addr, QueryRequest, f );
	fprintf( f, "Your Distributions is \"%s\",", passwd.distr );
	if( FtnSite( passwd.addr ) != -1 )
		fprintf( f, " FTN link\n\n" );
	else
		fprintf( f, " no-FTN link\n\n" );

	Query( f );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*				 %UNLINKED (  )	*/
int SendUnlinkedMail()
{
	FILE *f;
	int i=-1, n=0, nn=0, m;
	char str[CHAR_MAX];
	char buf[CHAR_MAX];

	if( ( f = fopen( TMPMAIL, "w" ) ) == NULL )
	{
		log( 0, "TmpFile \"%s\" cannot be opened! Exit!", TMPMAIL );
		exit( -1 );
	}

	//   .
	log( 2, "Processing %%UNLINKED operation" );

	StartMail( passwd.name, passwd.addr, UnlinkedRequest, f );
	fprintf( f, "Your Distributions is \"%s\",", passwd.distr );
	if( FtnSite( passwd.addr ) != -1 )
		fprintf( f, " FTN link\n\n" );
	else
		fprintf( f, " no-FTN link\n\n" );

	//     %QUERY
	while( ++i != areas.n )
	{
		if( strstr( passwd.distr, areas.distr[i] ) != 0 )
		{
			//      . 
			//   site FNT  ?
			if( FtnSite( passwd.addr ) != -1 )
				strcpy( buf, areas.echo[i] );
			else
				strcpy( buf, areas.ng[i] );

			//  .    !
			m = strlen( buf );
			if( m+2 < MAXLENECHO )
				buf[m++] = ' ';
			while( m < MAXLENECHO )
				buf[m++] = ListS;
			buf[m]=0;

			if( areas.s[i] != 1 )
			{
				fprintf( f, "  %s %s\n",
					buf, areas.desc[i] );
				nn++;	// ,  site .
				log( 5, "Write List(%d): \"%s\"",
						n, areas.ng[i] );
			}
			n++;
		}
	}
	// End

	fprintf( f, "\n\n %d areas unlinked\n", nn );

	log( 3, "%d areas unlinked", nn );

	EndMail( f );

	fclose( f );

	SendMail( TMPMAIL );

	remove( TMPMAIL );

	return( 0 );
}

/*  , ..    SendQueryMail,   	*
 * SendInfoMail								*/
Query(FILE *f)
{
	int i=-1, m, n=0, nn=0;
	char buf[CHAR_MAX];
	//     %QUERY

	fprintf( f, "Active areas on %s\n\n", ToFtn( passwd.addr ) );
	while( ++i != areas.n )
	{
		if( strstr( passwd.distr, areas.distr[i] ) != 0 )
		{
			//      . 
			//   site FNT  ?
			if( FtnSite( passwd.addr ) != -1 )
				strcpy( buf, areas.echo[i] );
			else
				strcpy( buf, areas.ng[i] );

			//  .    !
			m = strlen( buf );
			if( m+2 < MAXLENECHO )
				buf[m++] = ' ';
			while( m < MAXLENECHO )
				buf[m++] = ListS;
			buf[m]=0;

			if( areas.s[i] == 1 )
			{
				fprintf( f, "  %s %s\n",
					buf, areas.desc[i] );
				nn++;	// ,  site .
				log( 5,"Write List(%d): \"%s\"",
						n, areas.ng[i] );
			}
			n++;
		}
	}
	// End

	fprintf( f, "\n\n %d areas linked\n", nn );

	log( 3, "%d areas linked", nn );
}

/*		   				*/
int StartMail(char *Name, char *Addr, char *Subj, FILE *f)
{
	fprintf( f, "From: %s@%s\n", conf.Robot, conf.Address );
	log( 5, "From: %s@%s", conf.Robot, conf.Address );
	fprintf( f, "To: %s@%s\n", Name, Addr );
	log( 5, "To: %s@%s", Name, Addr );
	fprintf( f, "Subject: %s\n\n", Subj );
	log( 5, "Subject: %s", Subj );
}

/*		   				*/
int EndMail(FILE *f)
{
	fprintf(f,"\n\n--- AreaFix v.%s/%s %s (%s)\n\n",
			VER, DATE, conf.SysOp, ToFtn( conf.Address ) );
}

int SendMail(char *File)
{
	char comm[PATH_MAX];

	if( conf.MailCommand[0] == '>' || conf.MailCommand[0] == '|' )
	{
		snprintf( comm, PATH_MAX, "%s %s %s >/dev/null 2>/dev/null",
				CAT, File, conf.MailCommand );
		log( 5, "Exec: \"%s\"", comm );
		system( comm );
	}
	else
	{
		log( 0, "Error MailCommand \"%s\"", conf.MailCommand );
		return( -1 );
	}

	return( 0 );
}

//      '.f', '.n', '.z',   FtnAddress!
// 0	- FTN Address
// -1	- NoFTN Address
int FtnSite(char *addr)
{
	if( strstr( addr, ".f" ) == 0 && strstr( addr, ".n" ) == 0 &&
			strstr( addr, ".z" ) == 0 )
		return( -1 );
	return( 0 );
}

/*  Internet -  Ftn -.			*/
/* f763.n5030.z2.fidonet.org -> 2:5030/763.0				*/
/* Zone:Net/Node.Point							*/
char *ToFtn(char *addr)
{
	char tmp[CHAR_MAX], addr_tmp[CHAR_MAX], *addr_;

	log( 5, "Converting e-mail address -> netmail address..." );
	if( FtnSite( addr ) == -1 )
	{
		log( 5, "Returning address: \"%s\"", addr );
		return addr;
	}

	tmp[0] = 0;
	//  Zone
	if( (addr_ = (char*)strstr( addr, ".z" ) ) == 0 )
	{
		log( 5, "Returning address: \"%s\"", addr );
		return addr;
	}
	addr_ = addr_ + 2;
	strcpy( addr_tmp, addr_ );
	strtok( addr_tmp, "." );
	strcat( tmp, addr_tmp );
	log( 5, "Address: \"%s\"", tmp );

	strcat( tmp, ":" );
	//  Net
	if( (addr_ = (char*)strstr( addr, ".n" ) ) == 0 )
	{
		log( 5, "Returning address: \"%s\"", addr );
		return addr;
	}
	addr_ = addr_ + 2;
	strcpy( addr_tmp, addr_ );
	strtok( addr_tmp, "." );
	strcat( tmp, addr_tmp );
	log( 5, "Address: \"%s\"", tmp );

	strcat( tmp, "/" );
	//  Node
	if( (addr_ = (char*)strstr( addr, "f" ) ) == 0 )
	{
		log( 5, "Returning address: \"%s\"", addr );
		return addr;
	}
	addr_++;
	strcpy( addr_tmp, addr_ );
	strtok( addr_tmp, "." );
	strcat( tmp, addr_tmp );
	log( 5, "Address: \"%s\"", tmp );

	strcat( tmp, "." );
	//  Point (   !)
	if( (addr_ = (char*)strstr( addr, "p" ) ) != 0 )
	{
		addr_++;
		strcpy( addr_tmp, addr_ );
		strtok( addr_tmp, "." );
		strcat( tmp, addr_tmp );
		log( 5, "Address: \"%s\"", tmp );
	}
	else
		strcat( tmp, "0" );
	//  ,  .
	log( 5, "Address: \"%s\"", tmp );
	addr_ = tmp;
	return addr_;
}
