#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#ifdef SHOW_SPEED
#include <stdlib.h>
#endif
#include "lutil.h"
#include "ftn.h"
#include "nodelist.h"
#include "session.h"
#include "config.h"

extern int rawport(void);
extern void nolocalport(void);
extern int cookedport(void);
extern void rdoptions(node *);
#ifdef SHOW_SPEED
char *inconn = NULL;
int connect_speed = 0;
int cspeed(char *s)
{
	char *p;
	for( p = s; (*p < '0') || (*p > '9'); p++ );
	return atoi( p );
}
#endif

int answer(stype)
char *stype;
{
	int st,rc;
	node *nlent;
	char *p, *q;

	p = ttyname(0);

	if (p)
	{
	  q = strrchr(ttyname(0), '/');
	  if (q)
	    p = q + 1;

	  setnamesfx(p);
	}

	if ((nlent=getnlent(NULL)) == NULL)
	{
		logerr("could not get dummy nodelist entry");
		return 1;
	}

	localoptions = 0;
	rdoptions(nlent);

	inbound=norminbound; /* slave session is unsecure by default */

	if (stype == NULL)
		st=SESSION_UNKNOWN;
	else if (strcmp(stype,"tsync") == 0)
		st=SESSION_FTSC;
	else if (strcmp(stype,"yoohoo") == 0)
		st=SESSION_YOOHOO;
	else if (strncmp(stype,"**EMSI_",7) == 0)
		st=SESSION_EMSI;
	else
		st=SESSION_UNKNOWN;
	debug(10,"answer to \"%s\" (%d) call",stype?stype:"unknown type",st);

	if ((rc=rawport()) != 0)
		logerr("unable to set raw mode");
	else
	{
		nolocalport();
#ifdef SHOW_SPEED
		if( inconn == NULL ) inconn = getenv( "CONNECT" );
		if( inconn ) {
			connect_speed = cspeed(inconn);
			loginf( "connect \"%s\"", inconn );
		}
#endif
		rc=session(NULL,NULL,SESSION_SLAVE,st,stype);
	}

	cookedport();
	return rc;
}
