#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>

#include "xutil.h"
#include "lutil.h"
#include "directory.h"
#include "ftn.h"
#include "config.h"
#include "nodelist.h"
#include "nlindex.h"

#define NULLDOMAIN "nulldomain"

node *getnlent(faddr *addr)
{
  FILE *fp;
  static node nodebuf;
  static char buf[256], *p, *q;
  struct _ixentry xaddr;
  struct _loc *loc;
  off_t off;
  datum key;
  datum dat;
  int n, i, j, found=-1, maybe=-1;
  int ixflag, stdflag;
  char *dom, *mydomain;

  debug(DBG_NODELIST,"getnlent for %s",ascfnode(addr,0x1f));

  mydomain = whoami->addr->domain;
  if (mydomain == NULL)
    mydomain=NULLDOMAIN;

  key.dptr = (char *) &xaddr;
  key.dsize = sizeof (struct _ixentry);

  nodebuf.addr.domain = NULL;
  nodebuf.addr.zone = 0;
  nodebuf.addr.net = 0;
  nodebuf.addr.node = 0;
  nodebuf.addr.point = 0;
  nodebuf.addr.name = NULL;
  nodebuf.hub = 0;
  nodebuf.type = 0;
  nodebuf.pflag = 0;
  nodebuf.name = NULL;
  nodebuf.location = NULL;
  nodebuf.sysop = NULL;
  nodebuf.phone = NULL;
  nodebuf.speed = 0;
  nodebuf.flags = 0L;
  nodebuf.uflags[0] = NULL;

  if (addr == NULL) goto retdummy;

  if (addr->zone == 0)
    addr->zone = whoami->addr->zone;
  xaddr.zone = addr->zone;
  nodebuf.addr.zone = addr->zone;
  xaddr.net = addr->net;
  nodebuf.addr.net = addr->net;
  xaddr.node = addr->node;
  nodebuf.addr.node = addr->node;
  xaddr.point = addr->point;
  nodebuf.addr.point = addr->point;

  switch (initnl())
  {
   case 0:
    break;

   case 1:
    loginf("WARNING: nodelist index needs to be rebuilt with \"ifindex\"");
    break;

   default:
    goto retdummy;
  }

#ifdef HAS_NDBM_H
  dat = dbm_fetch(nldb,key);
#else
  dat = fetch(key);
#endif
  if (dat.dptr == NULL)
    goto retdummy;

  n = dat.dsize/sizeof(struct _loc);
  debug(DBG_NODELIST, "found %d entries", n);
  loc = (struct _loc *) dat.dptr;

  for (i = 0; (i < n) && (found == -1); i++)
  {
    dom = nodevector[loc[i].nlnum].domain;
    if (dom == NULL)
      dom = NULLDOMAIN;
    off = loc[i].off;

    if ((addr->domain != NULL) &&
	(strcasecmp(addr->domain, dom) == 0))
    {
      debug(DBG_NODELIST, "strict match for domain \"%s\"", dom);
      found = i;
    }
    else if ((addr->domain == NULL) &&
	     (strcasecmp(mydomain, dom) == 0))
    {
      debug(DBG_NODELIST, "match with home domain \"%s\"", dom);
      found = i;
      break;
    }
    else if (addr->domain == NULL)	
    {
      debug(DBG_NODELIST, "probable match with domain \"%s\"", dom);
      maybe = i;
      break;
    }
  }

  if (found == -1)
    found = maybe;
  if (found == -1) 
  {
    debug(DBG_NODELIST,"Match not found");
    goto retdummy;
  }

  /* get the nodelist line for the entry */
  fp = nodevector[loc[found].nlnum].fp;
  if (fseek(fp, loc[found].off, SEEK_SET) != 0)
  {
    logerr("$seek failed for nodelist entry %d", loc[found].nlnum);
  }
  if (fgets(buf, sizeof(buf) - 1, fp) == NULL)
  {
    logerr("$fgets failed for nodelist entry %d", loc[found].nlnum);
  }
  if (*(p = buf + strlen(buf)-1) == '\n')
    *p = '\0';
  if (*(p = buf + strlen(buf)-1) == '\r')
    *p = '\0';
  for (p = buf; *p; p++)
  {
    if (*p == '_')
      *p = ' ';
  }

  debug(DBG_NODELIST,"Nodelist line: \"%s\"", buf);

  /* get the first entry */
  p = buf;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* determine the type of this entry */
  nodebuf.type = NL_NONE;
  if (p[0] == '\0')
    nodebuf.type = NL_NODE;
  else
  {
    for (j = 0; pkey[j].key; j++)
      if (strcasecmp(p, pkey[j].key) == 0)
      {
	nodebuf.type = pkey[j].type;
	nodebuf.pflag = pkey[j].pflag;
	break;
      }
  }

  if (nodebuf.type == NL_NONE)
  {
    for (q = buf; *q; q++)
    {
      if (*q < ' ')
	*q = '.';
    }
    logerr("nodelist %d offset +%lu: unidentified entry \"%s\"",
	   loc[found].nlnum, (unsigned long) loc[found].off,buf);
    goto retdummy;
  }

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* ignore this entry - point/node number */

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* get system name */
  nodebuf.name = p;

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* get location */
  nodebuf.location = p;

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* get Sysop name */
  nodebuf.sysop = p;

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* get phone number */
  if (strcasecmp(p,"-Unpublished-") == 0)
    nodebuf.phone = NULL;
  else
    nodebuf.phone = p;

  /* get next entry */
  p = q;
  if (p == NULL)
    goto badsyntax;
  if ((q = strchr(p, ',')))
    *q++ = '\0';

  /* get speed */
  nodebuf.speed = atoi(p);

  ixflag = 0;

  /* parse nodelist flags */
  for (p = q; p; p = q)
  {
    if ((q = strchr(p, ',')))
      *q++ = '\0';
    stdflag = 0;

    for (j = 0; fkey[j].key; j++)
    {
      if (strcasecmp(p, fkey[j].key) == 0)
      {
	stdflag = 1;
	nodebuf.flags |= fkey[j].flag;
      }
    }

    if (!stdflag && (ixflag < MAXUFLAGS))
    {
      nodebuf.uflags[ixflag++] = p;
      if (ixflag < MAXUFLAGS)
	nodebuf.uflags[ixflag] = NULL;
    }
  }

  nodebuf.addr.name = nodebuf.sysop;
  nodebuf.addr.domain = nodevector[loc[found].nlnum].domain;
  nodebuf.hub = loc[found].hub;
  if (addr->domain == NULL)
    addr->domain = xstrcpy(nodebuf.addr.domain);

  debug(DBG_NODELIST, "getnlent: type     %d, pflag=%x", nodebuf.type, nodebuf.pflag);
  debug(DBG_NODELIST, "getnlent: name     %s", nodebuf.name);
  debug(DBG_NODELIST, "getnlent: location %s", nodebuf.location);
  debug(DBG_NODELIST, "getnlent: sysop    %s", nodebuf.sysop);
  debug(DBG_NODELIST, "getnlent: phone    %s", nodebuf.phone);
  debug(DBG_NODELIST, "getnlent: speed    %u", nodebuf.speed);
  debug(DBG_NODELIST, "getnlent: flags    0x%lx", nodebuf.flags);
  for (j = 0; (j < MAXUFLAGS) && (nodebuf.uflags[j]); j++)
  {
    debug(DBG_NODELIST, "getnlent: uflag    %s", nodebuf.uflags[j]);
  }

  return &nodebuf;

badsyntax:
  logerr("nodelist %d offset +%lu: bad syntax in line \"%s\"",
	 loc[found].nlnum, (unsigned long) loc[found].off,buf);
  /* fallthrough */
retdummy:
  debug(DBG_NODELIST,"getnlent returns dummy entry");
  nodebuf.type = 0;
  nodebuf.pflag = NL_DUMMY;
  nodebuf.name = "Unknown";
  nodebuf.location = "Nowhere";
  nodebuf.sysop = "Sysop";
  nodebuf.phone = NULL;
  nodebuf.speed = 2400;
  nodebuf.flags = 0L;
  nodebuf.uflags[0] = NULL;
	
  return &nodebuf;
}
