#ifndef _FIDO_H
#define _FIDO_H

typedef struct node
{
  int zone;
  int net;
  int node;
  int point;
  char *domain;
} node_t;

/* Parses [p* . ] f* [. n*] [. z*] addresses (e.g. f74.n463.z2) */

/* using address parser from ifqman */
#define ftntonode(a,b,c) strtonode(a,b,c)
int strtonode(node_t * node, const char *str, const node_t * base);

/* string is parsed and address is written to `node`, using `base` as
   node's base address ; if no error happen 0 is returned, otherwise
   character index, where error have occurred is returned ; -1 is returned,
   when unable to correctly complete given address */

char *nodetostr(char *str, const node_t * node);

/* Parses [[* :] * /] * [. *] addresses (e.g. 2:463/74) */
/*void ftntonode(node_t * node, char *str, const node_t * base);*/
char *nodetoftn(char *str, const node_t * node);

/* Copy one node_t to another node_t */
void nodecpy(node_t *dest,node_t *src);

/* Compare one node_t and another node_t (0 - match, 1 - not match) */
int nodecmp(node_t *one,node_t *two);

#endif /* _FIDO_H */
