#ifndef _CONFIG_H
#define _CONFIG_H

#include "myassert.h"

#define FTN_MAX_SIZE 50

#define SMALLBUFSIZE 128

#define DELIM " \t\r\n"

#define TRUE  1
#define FALSE 0

#include <limits.h>
#include "funcs.h"

#define BUFSIZE ((PATH_MAX*3)<8192?8192:(PATH_MAX*3))

#ifndef O_BINARY
  #define O_BINARY 0 /* for gnu-win32 */
#endif

extern node_t whoami;
extern char *inbound;
/* extern char *outbound; */
extern char *domains_file;
extern char *users_file;
extern char *areas_file;
/* extern char *default_desc; */
extern char *log_file;
extern char *lock_file;
extern char *desc_dir;
extern char *bad_dir;
extern char *help_file;
extern long wait_file;
extern int  file_mode;
extern int  log_file_mode;
extern int  bad_dir_mode;
extern char *response_exec;
extern char *announce_exec;
extern char *newarea_exec;
extern int  toss_badtic;
extern char *msg_from;
extern int  make_hardlinks;
extern char *default_newfile;
extern int  add_point_seenby;
extern int  outbound_mode;
extern char *newarea_group;
extern char *areagroups_config;
extern char *msg_to;
extern char *basepath;

extern char *hatcher_areaname;
extern char *hatcher_filename;
extern char *hatcher_replaces;
extern char *hatcher_desc;
extern int  hatcher_copy;
extern int  hatcher_koi8;
extern int  hatcher_desc_stdin;

extern int crc32_ignore;

extern list_t *users;
extern list_t *areas;

extern ilist_t *ticlist_list;
extern int ticlist_list_max;

extern list_t *newareas;

extern struct flag_tab user_flag_tab[];

extern char *pub_url;
extern char *pub_path;

#define ABORT_MSG "gtic ABORTED at %s:%d\n"

#define abort2() { fprintf(stderr,ABORT_MSG,__FILE__,__LINE__);\
		   l_printf(ABORT_MSG,__FILE__,__LINE__);\
		   abort(); }

#endif
