#!/bin/sh

TYPE=$1
OWNER=$2
GROUP=$3
BINDIR=$4
CONFIGDIR=$5

# check for parameters

if [ -z "$TYPE" -o -z "$OWNER" -o -z "$GROUP" -o -z "$BINDIR" \
	-o -z "$CONFIGDIR" ]
then
	echo
	echo "$0 must be called by \"make install\""
	exit
fi

# check for owner and group exist

if ! (cat /etc/passwd|awk -F: '{print $1}'|grep -w $OWNER >/dev/null)
then
	echo
	echo "User $OWNER not found in /etc/passwd. Read INSTALL please."
	exit
fi

if ! (cat /etc/group|awk -F: '{print $1}'|grep -w $GROUP >/dev/null)
then
	echo
	echo "Group $GROUP not found in /etc/group. Read INSTALL please."
	exit
fi

# make dirs

mkdir -p $BINDIR
mkdir -p $CONFIGDIR

chown root.root $BINDIR
chown $OWNER.$GROUP $CONFIGDIR

chmod 755 $BINDIR
chmod 755 $CONFIGDIR

# copy files

if [ "$TYPE" = all ]
then
	cp -i etc/* $CONFIGDIR/
	chown $OWNER.$GROUP $CONFIGDIR/*
	chmod 644 $CONFIGDIR/*
	chmod 600 $CONFIGDIR/users

	cp -i ext/gtic.* $BINDIR/
	chown root.root $BINDIR/gtic.*
	chmod 755 $BINDIR/gtic.*
fi

cp -f src/gtic $BINDIR/
chown $OWNER.$GROUP $BINDIR/gtic
chmod 4110 $BINDIR/gtic
