sub Sys::Syslog::hostname
{
    use Sys::Hostname;
    return hostname;
}

sub OpenLog {
	$_run_mode = $_[0];
	use Sys::Syslog;
	openlog('filefix-'.$_run_mode,'cons,pid',$FConfig{'LOGFACILITY'}) if( TestConfig( "LOGFACILITY" ));
	open( LOG, ">>".$FConfig{'LOGFILE'} ) if( TestConfig( "LOGFILE" ));
}

sub CloseLog {
	closelog() if( TestConfig( "LOGFACILITY" ));
	close( LOG ) if( TestConfig( "LOGFILE" ));
}

sub CheckExtUtils {
	if( ! &TestConfig( "ALTTOKOI" )) {
		&logger( 0, "AltToKoi not defined in config file.", "err" );
		return 0;
	}
	if( ! -x $FConfig{'ALTTOKOI'} ) {
		&logger( 0, "No such file ".$FConfig{'ALTTOKOI'}." or not executable.", "err" );
		return 0;
	}
	if( ! &TestConfig( "KOITOALT" )) {
		&logger( 0, "KoiToAlt not defined in config file.", "err" );
		return 0;
	}
	if( ! -x $FConfig{'KOITOALT'} ) {
		&logger( 0, "No such file ".$FConfig{'KOITOALT'}." or not executable.", "err" );
		return 0;
	}
	if( ! &TestConfig( "DOSTOUNIX" )) {
		&logger( 0, "DosToUnix not defined in config file.", "err" );
		return 0;
	}
	if( ! -x $FConfig{'DOSTOUNIX'} ) {
		&logger( 0, "No such file ".$FConfig{'DOSTOUNIX'}." or not executable.", "err" );
		return 0;
	}
	return 1;
}

sub SetLock {
	return 1 if( ! &TestConfig( 'LOCKFILE' ));
	require "errno.ph";
	open( LockFile, ">".$FConfig{'LOCKFILE'} );
	use Fcntl;
	fcntl( LockFile, F_GETLK, 0 );
	flock( LockFile, 2 );
	print LockFile $$;
}

sub UnsetLock {
	return 1 if( ! &TestConfig( 'LOCKFILE' ));
	close( LockFile );
	unlink $FConfig{'LOCKFILE'};
}


sub mklock {
	local( $lockfile ) = $_[0];
	local( $clrlock ) = 1;
	$lockfile = "./".$lockfile unless( $lockfile =~ /\// );
	local( $tmplock ) = substr( $lockfile, 0, rindex( $lockfile, "/" ))."/$$.lck";
	local( $tmp, $pid );

	$clrlock = $_[1] if( defined( $_[1] ));
	if( !open( tmp, ">".$tmplock )) {
		&logger( 0, "Cannot open tmp lock file $tmplock. $!", "err" );
		return 0;
	}
	print tmp $$."\n";
	close( tmp );

try:
	if( link( $tmplock, $lockfile )) {
		unlink $tmplock;
		return 1;
	} else {
		if( $! != &EEXIST ) {
			&logger( 0, "Cannot create lock file $lockfile. $!", "err" );
			unlink $tmplock;
			return 0;
		} else {
			if( !open( tmp, $lockfile )) {
				&logger( 0, "Cannot read existing lock file $lockfile. $!", "err" );
				unlink $tmplock;
				return 0;
			}
			$pid = <tmp>;
			close( tmp );
			$pid =~ s/[ \t\r\n]*//g;
			kill 0, $pid;
			if( $! == &ESRCH ) {
				&logger( 1, "Warning: found unused lock file $lockfile.", "warning" );
				if( $clrlock ) {
					&logger( 1, "Warning: delete unused lock file.", "warning" );
					unlink $lockfile;
					goto try;
				}
			}
		}
	}
	unlink $tmplock;
	return 0;
}

sub basename {
	local( $str ) = $_[0];
	return substr( $str, rindex( $str, "/" ) + 1 );
}

sub basepath {
	local( $str ) = $_[0];
	return substr( $str, 0, rindex( $str, "/" ) + 1 );
}

sub strtime {
	local( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst );
	local( $m, $l, $dstmin, $dsthour );
	local( $tm, $month, $week );
	local( $sw ) = @_;
	use Time::Local;
	$tm = time;
	( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst ) = localtime( $tm );
	@months = ( Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec );
	@week = ( Sun, Mon, Tue, Wed, Thu, Fri, Sat );
	if( $sw =~ /log/ ) {
		return sprintf( "%3s %2d %02d:%02d:%02d", $months[$mon], $mday, $hour, $min, $sec );
	} elsif( $sw =~ /tic/ ) {
		return sprintf( "%2d %3s %2d %02d:%02d:%02d", $mday, $months[$mon], $year, $hour, $min, $sec );
	} elsif( $sw =~ /path/ ) {
		$m = (timegm($sec, $min, $hour, $mday, $mon, $year) - timelocal($sec, $min, $hour, $mday, $mon, $year)) / 60;
		if( $m < 0 ) {
			$l = "-";
			$m = $m * -1;
		} else {
			$l = "+";
		}
		$dsthour = int( $m / 60 );
		$dstmin = $m % 60;
		return sprintf( "%d %3s %3s %2d %02d:%02d:%02d 19%d UTC%s%02d%02d", $tm, $week[$wday], $months[$mon], $mday, $hour, $min, $sec, $year, $l, $dsthour, $dstmin );
	}
	return "";
}

sub logger {
	local( $m ) = "notice";
	local( $secure ) = 0;
	$m = $_[2] if( defined( $_[2] ));
	$secure = $_[3] if( defined( $_[3] ));
	if( $FConfig{'LOGLEVEL'} >= $_[0] ) {
		print LOG &strtime( "log" )." filefix($_run_mode)[$$] ".$_[1]."\n"
			 if( TestConfig( "LOGFILE" ));
		&syslog( $m, $_[1] ) if(( $secure == 0 ) && TestConfig( "LOGFACILITY" ));
	}
}

sub tolower {
	local( $ret ) = $_[0];
	$ret =~ tr/[A-Z]/[a-z]/;
	return $ret;
}

sub toupper {
	local( $ret ) = $_[0];
	$ret =~ tr/[a-z]/[A-Z]/;
	return $ret;
}

sub ParseAddr {
	local( $fido ) = $_[0];
	local( $zone, $net, $node, $point );

	$zone = $fido;
	if( $zone =~ /^[0-9]+:/ ) {
		$zone =~ s/:.*//;
	} else {
		$zone = $my_zone;
	}

	$net = $fido;
	$net =~ s/^[0-9]+://;
	$node = $net;
	if( $net =~ /^[0-9]+\// ) {
		$net =~ s/\/.*//;
	} else {
		$net = $my_net;
	}

	$node =~ s/^[0-9]*\///;
	$point = $node;
	$node =~ s/\.[0-9]+$//;
	$node = $my_node if( $node eq "" );

	$point =~ s/^[0-9]+//;
	if( $point =~ /^\./ ) {
		$point =~ s/\.//;
	} else {
		$point = 0;
	}
	return( $zone, $net, $node, $point );
}

sub TestConfig {
	if( $FConfig{$_[0]} =~ /^.+$/ ) {
		return 1;
	} else {
		return 0;
	}
}

sub ReadConfig {
	local( $RunMode ) = $_[0];
	local( $Key, $Value );
	open( ConfigFile ) || die qq|Can't open "Config" file.|;
	while( <ConfigFile> ) {
		/^[ \t]*$/	&& next;
		/^[ \t]*#/	&& next;
		chop;
		( $Key, $Value ) = split( /[ \t]+/, $_, 2 );
		$Key =~ tr/a-z/A-Z/;
		$FConfig{$Key} = $Value;
	}
	close( ConfigFile );
	&OpenLog( $RunMode );
	return 0 if( CheckExtUtils != 1 );
	$FConfig{'DEFDESC'} = "Descriptor missing" if( ! &TestConfig( 'DEFDESC' ));
	if( ! &TestConfig( 'BINDIR' )) {
		&logger( 0, "Undefined 'BinDir' in config.", "err" );
		return 0;
	}
	if( ! &TestConfig( 'TICDIR' )) {
		&logger( 0, "Undefined 'TicDir' in config.", "err" );
		return 0;
	}
	$FConfig{'DESCDIR'} = "." if( !defined( $FConfig{'DESCDIR'} ));
	if( &TestConfig( 'IFCONFIG' )) {
		if( ! &ReadIfConfig() ) {
			&logger( 0, "Bad ifmail config file", "err" );
		}
		&logger( 7, "Read config ok.", "info" );
		return 1;
	} else {
		&logger( 0, "Undefined IfConfig in config.", "err" );
		return 0;
	}
}

sub ReadIfConfig {
	local( $ifconfig, $Key, $Value, $tmp );
	$ifconfig = $FConfig{'IFCONFIG'};
	if( ! open( ifconfig )) {
		&logger( 0, "Can't open ifmail config file.", "err" );
		exit( 1 );
	}
	while( <ifconfig> ) {
		/^[ \t]*$/	&& next;
		/^[ \t]*#/	&& next;
		chop;
		( $Key, $Value ) = split( /[ \t]+/, $_, 2 );
		$Key =~ tr/a-z/A-Z/;
		if( $Key =~ /^ADDRESS$/ ) {
			$FConfig{$Key} = $Value if( ! &TestConfig( 'ADDRESS' ));
		} elsif( $Key =~ /^MYFQDN$/ ) {
			$FConfig{$Key} = $Value;
		} elsif( $Key =~ /^PROTINBOUND$/ ) {
			$FConfig{$Key} = $Value;
		} elsif( $Key =~ /^OUTBOUND$/ ) {
			$FConfig{$Key} = $Value;
		} elsif( $Key =~ /^SYSOP$/ ) {
			$FConfig{'SYSOP'} = $Value;
		} else {
			next;
		}
	}
	close( ifconfig );
	return 0 unless( &TestConfig( 'ADDRESS' )
		&& &TestConfig( 'MYFQDN' )
		&& &TestConfig( 'PROTINBOUND' )
		&& &TestConfig( 'OUTBOUND' ));

	$FConfig{'ADDRESS'} =~ s/@.*$//;
	if( $FConfig{'ADDRESS'} =~ /^[0-9]+:[0-9]+\/[0-9]+\.*[0-9]*$/ ) {
		( $my_zone, $my_net, $my_node, $my_point ) = &ParseAddr( $FConfig{'ADDRESS'} );
	} else {
		&logger( 0, "Use full fido address in ifmail config.", "err" );
		return 0;
	}
	return 1;
}

sub find {
	local( $i, $expr, $list );
	$expr = $_[0];
	shift;
	@list = @_;
	for( $i = 0; $i <= $#list; $i++ ) {
		last if( $list[$i] eq $expr );
	}
	return -1 if( $i > $#list );
	return $i;
}

sub BadName {
	local( $name ) = $_[0];
	$name =~ s/\#/\\\#/g;
	$name =~ s/\$/\\\$/g;
	$name =~ s/\^/\\\^/g;
	$name =~ s/\&/\\\&/g;
	$name =~ s/\(/\\\(/g;
	$name =~ s/\)/\\\)/g;
	$name =~ s/\[/\\\[/g;
	$name =~ s/\]/\\\]/g;
	$name =~ s/\`/\\\`/g;
	$name =~ s/\'/\\\'/g;
	$name =~ s/\"/\\\"/g;
	return $name;
}
