
sub Tosser {
	local( $ls );
	if( ! open( ls, "cd $FConfig{'PROTINBOUND'}; ls -1 *.[tT][iI][cC] 2>/dev/null |" )) {
		&logger( 0, "Cannot search in protinbound.", "err" );
		return 0;
	}
	&ReadAreas() || return 0;
	&ReadUsers() || return 0;
	while( <ls> ) {
		chop;
		&ProcessTic( $_ );
	}
	close( ls );
	if( $FConfig{'SENDANNOUNCE'} =~ /^[yY]/ ) {
		&MessageOfNewFiles();
	}
	return 1;
}

sub MessageOfNewFiles {
	local( $i, $in, $out, $area );
	if( &TestConfig( 'ANEWSCOMMAND' ) && &TestConfig( 'ANEWSGROUPS' )) {
		for( $i; $i <= $#AreaName; $i++ ) {
			$area = $AreaName[$i];
			if( -e $AreaNewfile{$area} ) {
				if( ! open( in, $AreaNewfile{$area} )) {
					&logger( 0, "Cannot read announce file [$!].", "err" );
					return 0;
				}
				if( ! open( out, "| ".$FConfig{'ANEWSCOMMAND'} )) {
					&logger( 0, "Cannot send announce [$!].", "err" );
					close( in );
					return 0;
				}
				print out "From: FileFix <FileFix\@".$FConfig{'MYFQDN'}.">\n";
				print out "Newsgroups: $FConfig{'ANEWSGROUPS'}\n";
				print out "Subject: New file(s) announce\n";
				print out "\n";
				while( <in> ) {
					print out $_;
				}
				print out "\n--\n\t$Version of ".$FConfig{'ADDRESS'}."\n";
				close( out );
				close( in );
				unlink( $AreaNewfile{$area} );
			}
		}
	}
	return 1;
}
		
sub MoveToBad {
	if( $tic =~ /[0-9]+\.tic/i ) {
		if( &TestConfig( 'BADTIC' )) {
			if( ! -d $FConfig{'BADTIC'} ) {
				if( ! mkdir( $FConfig{'BADTIC'}, 0755 )) {
					&logger( 0, "Cannot create BadTic directory [$!], tic moved in to /tmp.", "warning" );
					system "mv $FConfig{'PROTINBOUND'}/$tic /tmp 2>/dev/null";
				}
			}
			system "mv $FConfig{'PROTINBOUND'}/$tic $FConfig{'BADTIC'} 2>/dev/null";
		} else {
			system "rm -f $FConfig{'PROTINBOUND'}/$tic";
		}
	}
	if( -f $FConfig{'PROTINBOUND'}."/".$Tic{'FILE'} ) {
		if( &TestConfig( 'BADFILE' )) {
			if( ! -d $FConfig{'BADFILE'} ) {
				if( ! mkdir( $FConfig{'BADFILE'}, 0755 )) {
					&logger( 0, "Cannot create BadFile directory [$!], tic moved in to /tmp.", "warning" );
					system "mv $FConfig{'PROTINBOUND'}/".BadName($Tic{'FILE'})." /tmp 2>/dev/null";
				}
			}
			system "mv $FConfig{'PROTINBOUND'}/".BadName($Tic{'FILE'})." $FConfig{'BADFILE'} 2>/dev/null";
		} else {
			system "rm -f $FConfig{'PROTINBOUND'}/".BadName($Tic{'FILE'});
		}
	}
}

sub ProcessTic {
	local( $arealinks, $idlink, $al, $From, $ticarea, $descarea, $uflags, $i, $t, $ticdir, $uf );
	local( $oldfile, $newfile, @infiles );
	local( $tic ) = $_[0];
	local( $badcrc, $badsize );

	&logger( 3, "Processing $tic ...", "info" );
	$badcrc = $badsize = 0;
	&ReadTic( $FConfig{'PROTINBOUND'}."/".$tic ) || return 0;
	#   - ?
	@infiles=<$FConfig{'PROTINBOUND'}/*>;
	for( $i = 0; $i <= $#infiles; $i++ ) {
		if( tolower( basename( $infiles[$i] )) eq $Tic{'FILE'} ) {
			rename( $infiles[$i], $FConfig{'PROTINBOUND'}."/".$Tic{'FILE'} );
			next;
		}
	}
	if( ! -r $FConfig{'PROTINBOUND'}."/".$Tic{'FILE'} ) {
		if( &TestConfig( 'WAITFILE' )) {
			$tdate = ( stat( $FConfig{'PROTINBOUND'}."/".$tic ))[9];
			if( $tdate + $FConfig{'WAITFILE'} * 3600 < time ) {
				&logger( 5, "No wait file ".BadName($Tic{'FILE'}).", tic removed.", "warning" );
				system "rm -f $FConfig{'PROTINBOUND'}/$tic";
				return 0;
			} else {
				&logger( 5, "File ".BadName($Tic{'FILE'})." not received, wait.", "warning" );
				return 0;
			}
		} else {
			&logger( 5, "File ".BadName($Tic{'FILE'})." not received, tic removed.", "warning" );
			system "rm -f $FConfig{'PROTINBOUND'}/$tic";
			return 0;
		}
	}

	#      ?
	$From = $Tic{'FROM'};
	if( &find( $From, @UserAddr ) == -1 ) {
		&logger( 3, "Unknown user $From", "warning" );
		&MoveToBad();
		return 0;
	}
	#    ?
	if( &tolower( $Tic{'PW'} ) !~ &tolower( $UserPasswd{$From} )) {
		&logger( 3, "Password error from $From: is \"$Tic{'PW'}\" should by \"$UserPasswd{$From}\".", "warning", 1 );
		&MoveToBad();
		return 0;
	}
	$size = (stat( $FConfig{'PROTINBOUND'}."/".$Tic{'FILE'}))[7];
	if( defined( $Tic{'SIZE'} )) {
		if( $Tic{'SIZE'} != $size ) {
			$badsize = 1;
		}
	} else {
		$Tic{'SIZE'} = $size;
	}
	if( defined( $Tic{'CRC'} )) {
		open( t, $FConfig{'BINDIR'}."/crc32 < ".$FConfig{'PROTINBOUND'}."/".BadName($Tic{'FILE'})." |" );
		while( <t> ) {
			chop;
			$Crc = $_;
		}
		close( t );
		if( &toupper( $Tic{'CRC'} ) ne &toupper( $Crc )) {
			$badcrc = 1;
		}
	}
	$ticarea = $Tic{'AREA'};

	#   ?
	if( !defined( $AreaPath{$ticarea} )) {
		# "     ?
		@uflags	= split( /[ \t]+/, $UserFlags{$From} );
		if( ! grep( /\+[aA]/, @uflags )) {
			&logger( 3, "Cannot create new area for user $From", "warning" );
			&MoveToBad();
			return 0;
		}
		# Create new area
		if( !( defined( $AreaPath{'default'} ) && defined( $AreaGroup{'default'} ))) {
			&logger( 0, "Cannot create new area: undefined in default area Path and/or Group.", "err" );
			&MoveToBad();
			return 0;
		}
		$AreaName[$#AreaName + 1] = $ticarea;
		$AreaPath{$ticarea} = $AreaPath{'default'}."/".$ticarea;
		if( defined( $Tic{'AREADESC'} )) {
			$AreaDesc{$ticarea} = $Tic{'AREADESC'};
		} elsif( defined( $AreaDesc{'default'} )) {
			$AreaDesc{$ticarea} = $AreaDesc{'default'};
		} else {
			$AreaDesc{$ticarea} = $FConfig{'DEFDESC'};
		}
		&SetNames();
		$AreaGroup{$ticarea} = $AreaGroup{'default'};
		$AreaExec{$ticarea} = $AreaExec{'default'} if( defined( $AreaExec{'default'} ));
		$AreaExclude{$ticarea} = $AreaExclude{'default'} if( defined( $AreaExclude{'default'} ));
		$AreaSave{$ticarea} = $AreaSave{'default'} if( defined( $AreaSave{'default'} ));
		$AreaNewfile{$ticarea} = $AreaNewfile{'default'} if( defined( $AreaNewfile{'default'} ));
		$AreaMode{$ticarea} = $AreaMode{'default'} if( defined( $AreaMode{'default'} ));
		$AreaAKA{$ticarea} = $AreaAKA{'default'} if( defined( $AreaAKA{'default'} ));
		$AreaRO{$ticarea} = $AreaRO{'default'} if( defined( $AreaRO{'default'} ));
		$AreaDupes{$ticarea} = $AreaDupes{'default'} if( defined( $AreaDupes{'default'} ));
		$AreaNocheck{$ticarea} = $AreaNocheck{'default'} if( defined( $AreaNocheck{'default'} ));

		if(( $AreaNocheck{$ticarea} !~ /size/i ) && ( $badsize > 0 )) {
			&logger( 3, "Error size of ".BadName($Tic{'FILE'})."[$tic].", "err" );
			&MoveToBad();
			return 0;
		}
		if(( $AreaNocheck{$ticarea} !~ /crc/i ) && ( $badcrc > 0 )) {
			&logger( 3, "Error Crc in ".BadName($Tic{'FILE'})."[$tic].", "err" );
			&MoveToBad();
			return 0;
		}

		$AreaLinks{$ticarea} = $From;
		for( $i = 0; $i <= $#UserAddr; $i++ ) {
			if( $From ne $UserAddr[$i] ) {
				$ag = $AreaGroup{$ticarea};
				if(( $UserFlags{$UserAddr[$i]} =~ /.*\+[cC]/ ) && ( $UserGroups{$UserAddr[$i]} =~ /$ag/ )) {
					if( $UserFlags{$UserAddr[$i]} =~ /.*\+\!/ ) {
						$AreaLinks{$ticarea} .= " !".$UserAddr[$i];
					} else {
						$AreaLinks{$ticarea} .= " ".$UserAddr[$i];
					}
				}
			}
		}
		if( ! mkdir( $AreaPath{$ticarea}, 0755 )) {
			&logger( 0, "Cannot create path for new area $ticarea, Error = $!", "err" );
			splice( @AreaName, $#AreaName );
			&MoveToBad();
			return 0;
		}
		if( ! &WriteAreas() ) {
			splice( @AreaName, $#AreaName );
			&MoveToBad();
			return 0;
		}
		if( TestConfig( "NEWAREAEXEC" )) {
			if( -x $FConfig{'NEWAREAEXEC'} ) {
				if( defined( $AreaSave{$ticarea} )) {
					$i = $AreaSave{$ticarea};
				} else {
					$i = -1;
				}
				system( $FConfig{'NEWAREAEXEC'}." ".$ticarea." ".$i." ".$AreaGroup{$ticarea}." ".$AreaPath{$ticarea}." ".$AreaDesc{$ticarea} );
			} else {
				&logger( 0, "No such file ".$FConfig{'NEWAREAEXEC'}." or not executable.", "warning" );
			}
		}
		if( &TestConfig( 'ANEWSCOMMAND' ) && &TestConfig( 'ANEWSGROUPS' )) {
			if( ! open( t, "| ".$FConfig{'ANEWSCOMMAND'} )) {
				&logger( 0, "Cannot send annonce of create area [$!].", "err" );
			}
			print t "From: FileFix <FileFix\@".$FConfig{'MYFQDN'}.">\n";
			print t "Newsgroups: $FConfig{'ANEWSGROUPS'}\n";
			print t "Subject: New filearea creation notification\n";
			print t "\nFile area $ticarea created at $FConfig{'ADDRESS'} by $Tic{'FROM'}\n";
			print t "\n$ticarea - $AreaDesc{$ticarea}\n";
			print t "\n--\n\t$Version\n";
			close( t );
		}
	} else {
		@arealinks = split( /[ \t]+/, $AreaLinks{$ticarea} );
		if( &find( $From, @arealinks ) == -1 ) {
			$tmpFrom = "!".$From;
			if( &find( $tmpFrom, @arealinks ) == -1 ) {
				&logger( 3, "Area $ticarea is not subscribed for $From", "warning" );
			} else {
				&logger( 3, "Area $ticarea is read only for $From", "warning" );
			}
			&MoveToBad();
			return 0;
		}
	}

	if(( $AreaNocheck{$ticarea} !~ /size/i ) && ( $badsize > 0 )) {
		&logger( 3, "Error size of ".BadName($Tic{'FILE'})."[$tic].", "err" );
		&MoveToBad();
		return 0;
	}
	if(( $AreaNocheck{$ticarea} !~ /crc/i ) && ( $badcrc > 0 )) {
		&logger( 3, "Error Crc in ".BadName($Tic{'FILE'})."[$tic].", "err" );
		&MoveToBad();
		return 0;
	}

	if( ! -d $AreaPath{$ticarea} ) {
		&logger( 0, "Hmm.. Directory not found for existing area $ticarea, created.", "warning" );
		if( ! mkdir( $AreaPath{$ticarea}, 0755 )) {
			&logger( 0, "Cannot create path for existing area $ticarea, Error = $!", "err" );
			&MoveToBad();
			return 0;
		}
	}
	if( $FConfig{'DESCDIR'} =~ /^\// ) {
		$descdir = $FConfig{'DESCDIR'};
	} else {
		$descdir = $AreaPath{$ticarea}."/".$FConfig{'DESCDIR'};
	}
	if( ! -d $descdir ) {
		if( ! mkdir( $descdir, 0755 )) {
			&logger( 0, "Cannot create path for .desc, use current directory. Error = $!", "err" );
			$descdir="";
		}
	}
	if( $FConfig{'TICDIR'} =~ /^\// ) {
		$ticdir = $FConfig{'TICDIR'};
	} else {
		$ticdir = $AreaPath{$ticarea}."/".$FConfig{'TICDIR'};
	}
	if( ! -d $ticdir ) {
		if( ! mkdir( $ticdir, 0755 )) {
			&logger( 0, "Cannot create path for saved tics, Error = $!", "err" );
			system "mv $FConfig{'PROTINBOUND'}/$tic /tmp";
		} else {
			system "mv $FConfig{'PROTINBOUND'}/$tic $ticdir";
		}
	} else {
		system "mv $FConfig{'PROTINBOUND'}/$tic $ticdir";
	}

	if( defined( $Tic{'REPLACES'} )) {
		$oldfile = &basename( $Tic{'REPLACES'} );
		$newfile = $Tic{'FILE'};
		$oldfile =~ s/\..*//;
		$newfile =~ s/\..*//;
		if( $oldfile eq $newfile ) {
			$oldfile = &basename( $Tic{'REPLACES'} );
			system "rm -f ".$AreaPath{$ticarea}."/".BadName($oldfile)." ".$descdir."/".BadName($oldfile).".desc";
		} else {
			&logger( 0, "Trying replace \"".$Tic{'REPLACES'}."\" - abort.", "warning" );
		}
	}
	if( $AreaDupes{$ticarea} =~ /name/i ) {
		if( -f $AreaPath{$ticarea}."/".$Tic{'FILE'} ) {
			&logger( 3, "File ".$AreaPath{$ticarea}."/".$Tic{'FILE'}." exist - dublicated.", "err" );
			system "mv $ticdir/$tic $FConfig{'PROTINBOUND'}";
			&MoveToBad();
			return 0;
		}
	}
	system "cp ".$FConfig{'PROTINBOUND'}."/".BadName($Tic{'FILE'})." ".$AreaPath{$ticarea};
	if( defined( $AreaMode{$ticarea} )) {
		system "chmod ".$AreaMode{$ticarea}." ".$AreaPath{$ticarea}."/".BadName($Tic{'FILE'});
	}
	if( !defined( $FConfig{'LASTSCAN'} )) {
		system "chmod o+t ".$AreaPath{$ticarea}."/".BadName($Tic{'FILE'});
	}
	system "rm -f ".$FConfig{'PROTINBOUND'}."/".BadName($Tic{'FILE'});
	if( ! open( t, ">".$descdir."/".$Tic{'FILE'}.".desc" )) {
		&logger( 0, "Cannot create ".$descdir."/".BadName($Tic{'FILE'}).".desc. Error: $!", "err" );
	} else {
		for( $i = 0; $i <= $#TicDesc; $i++ ) {
			print t $TicDesc[$i]."\n";
		}
		if( $#TicLDesc > -1 ) {
			print t "\n";
			for( $i = 0; $i <= $#TicLDesc; $i++ ) {
				print t $TicLDesc[$i]."\n";
			}
		}
		close( t );
		if( defined( $AreaMode{$ticarea} )) {
			system "chmod ".$AreaMode{$ticarea}." ".$descdir."/".BadName($Tic{'FILE'}).".desc";
		}
	}
	if( defined( $AreaExec{$ticarea} )) {
		if( defined( $Tic{'FULLNAME'} )) {
			system $AreaExec{$ticarea}." ".BadName($Tic{'FILE'})." ".$AreaPath{$ticarea}." ".$ticarea." ".$Tic{'FULLNAME'};
		} else {
			system $AreaExec{$ticarea}." ".BadName($Tic{'FILE'})." ".$AreaPath{$ticarea}." ".$ticarea;
		}
	}

	if( defined( $AreaNewfile{$ticarea} )) {
		if( ! -e $AreaNewfile{$ticarea} ) {	
			$crfile = ">";
		} else {
			$crfile = ">>";
		}
		if( ! open( t, $crfile.$AreaNewfile{$ticarea} )) {
			&logger( 0, "Cannot write annonce. Error: $!", "err" );
		} else {
			if( $crfile eq ">" ) {
				print t "File             Size         Area                 Origin\n";
				print t "---------------- ------------ -------------------- ----------------\n";
			}
			print t sprintf( "%-16s %-12d %-20s %-16s\n", $Tic{'FILE'}, $Tic{'SIZE'}, $ticarea, $Tic{'ORIGIN'} );
			print t "Fullname: ".$Tic{'FULLNAME'}."\n" if( defined( $Tic{'FULLNAME'} ));
			for( $i = 0; $i <= $#TicDesc; $i++ ) {
				print t $TicDesc[$i]."\n";
			}
			if( $#TicLDesc > -1 ) {
				print t "\n";
				for( $i = 0; $i <= $#TicLDesc; $i++ ) {
					print t $TicLDesc[$i]."\n";
				}
			}
			print t "-------------------------------------------------------------------\n";
			close( t );
		}
	}
	return 1;
}
